/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation ProductValuation}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductValuationField
 * ProductValuationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductValuationLink
 * ProductValuationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#VALUATION_TYPE
 * VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#VALUATION_CLASS
 * VALUATION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRICE_DETERMINATION_CONTROL
 * PRICE_DETERMINATION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#STANDARD_PRICE
 * STANDARD_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRICE_UNIT_QTY
 * PRICE_UNIT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#INVENTORY_VALUATION_PROCEDURE
 * INVENTORY_VALUATION_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#MOVING_AVERAGE_PRICE
 * MOVING_AVERAGE_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#VALUATION_CATEGORY
 * VALUATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRODUCT_USAGE_TYPE
 * PRODUCT_USAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRODUCT_ORIGIN_TYPE
 * PRODUCT_ORIGIN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#IS_PRODUCED_INHOUSE
 * IS_PRODUCED_INHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PROD_COST_EST_NUMBER
 * PROD_COST_EST_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PROJECT_STOCK_VALUATION_CLASS
 * PROJECT_STOCK_VALUATION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#VALUATION_CLASS_SALES_ORDER_STOCK
 * VALUATION_CLASS_SALES_ORDER_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PLANNED_PRICE1_IN_CO_CODE_CRCY
 * PLANNED_PRICE1_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PLANNED_PRICE2_IN_CO_CODE_CRCY
 * PLANNED_PRICE2_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PLANNED_PRICE3_IN_CO_CODE_CRCY
 * PLANNED_PRICE3_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#FUTURE_PLND_PRICE1_VALDTY_DATE
 * FUTURE_PLND_PRICE1_VALDTY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#FUTURE_PLND_PRICE2_VALDTY_DATE
 * FUTURE_PLND_PRICE2_VALDTY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#FUTURE_PLND_PRICE3_VALDTY_DATE
 * FUTURE_PLND_PRICE3_VALDTY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#TAX_BASED_PRICES_PRICE_UNIT_QTY
 * TAX_BASED_PRICES_PRICE_UNIT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PRICE_LAST_CHANGE_DATE
 * PRICE_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PLANNED_PRICE
 * PLANNED_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#PREV_INVTRY_PRICE_IN_CO_CODE_CRCY
 * PREV_INVTRY_PRICE_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#TO_ML_ACCOUNT
 * TO_ML_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#TO_ML_PRICES
 * TO_ML_PRICES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#TO_VALUATION_ACCOUNT
 * TO_VALUATION_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation#TO_VALUATION_COSTING
 * TO_VALUATION_COSTING}</li>
 * </ul>
 *
 */
public interface ProductValuationSelectable extends EntitySelectable<ProductValuation>
{

}
