/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
 * ProductWorkScheduling}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductWorkSchedulingField
 * ProductWorkSchedulingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.link.ProductWorkSchedulingLink
 * ProductWorkSchedulingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#MATERIAL_BASE_QUANTITY
 * MATERIAL_BASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#UNLIMITED_OVER_DELIV_IS_ALLOWED
 * UNLIMITED_OVER_DELIV_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#OVER_DELIV_TOLERANCE_LIMIT
 * OVER_DELIV_TOLERANCE_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#UNDER_DELIV_TOLERANCE_LIMIT
 * UNDER_DELIV_TOLERANCE_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCTION_INVTRY_MANAGED_LOC
 * PRODUCTION_INVTRY_MANAGED_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCT_PROCESSING_TIME
 * PRODUCT_PROCESSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCTION_SUPERVISOR
 * PRODUCTION_SUPERVISOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCT_PRODUCTION_QUANTITY_UNIT
 * PRODUCT_PRODUCTION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODN_ORDER_IS_BATCH_REQUIRED
 * PRODN_ORDER_IS_BATCH_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#TRANSITION_MATRIX_PRODUCTS_GROUP
 * TRANSITION_MATRIX_PRODUCTS_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#ORDER_CHANGE_MANAGEMENT_PROFILE
 * ORDER_CHANGE_MANAGEMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#MATL_COMP_IS_MARKED_FOR_BACKFLUSH
 * MATL_COMP_IS_MARKED_FOR_BACKFLUSH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#SETUP_AND_TEARDOWN_TIME
 * SETUP_AND_TEARDOWN_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#PRODUCTION_SCHEDULING_PROFILE
 * PRODUCTION_SCHEDULING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling#TRANSITION_TIME
 * TRANSITION_TIME}</li>
 * </ul>
 *
 */
public interface ProductWorkSchedulingSelectable extends EntitySelectable<ProductWorkScheduling>
{

}
