/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ClfnProductField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ClfnProductLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable.ClfnProductSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnProductType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnProduct extends VdmEntity<ClfnProduct>
{

    /**
     * Selector for all available fields of ClfnProduct.
     *
     */
    public final static ClfnProductSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT = new ClfnProductField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_TYPE = new ClfnProductField<String>("ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatus</b>
     * </p>
     *
     * @return Cross-Plant Product Status
     */
    @SerializedName( "CrossPlantStatus" )
    @JsonProperty( "CrossPlantStatus" )
    @Nullable
    @ODataField( odataName = "CrossPlantStatus" )
    private String crossPlantStatus;
    /**
     * Use with available fluent helpers to apply the <b>CrossPlantStatus</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> CROSS_PLANT_STATUS = new ClfnProductField<String>("CrossPlantStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatusValidityDate</b>
     * </p>
     *
     * @return Date from which the cross-plant material status is valid
     */
    @SerializedName( "CrossPlantStatusValidityDate" )
    @JsonProperty( "CrossPlantStatusValidityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CrossPlantStatusValidityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime crossPlantStatusValidityDate;
    /**
     * Use with available fluent helpers to apply the <b>CrossPlantStatusValidityDate</b> field to query operations.
     *
     */
    public final static ClfnProductField<LocalDateTime> CROSS_PLANT_STATUS_VALIDITY_DATE =
        new ClfnProductField<LocalDateTime>("CrossPlantStatusValidityDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ClfnProductField<LocalDateTime> CREATION_DATE =
        new ClfnProductField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> CREATED_BY_USER = new ClfnProductField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ClfnProductField<LocalDateTime> LAST_CHANGE_DATE =
        new ClfnProductField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> LAST_CHANGED_BY_USER =
        new ClfnProductField<String>("LastChangedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> IS_MARKED_FOR_DELETION =
        new ClfnProductField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductOldID</b>
     * </p>
     *
     * @return Old Product Number
     */
    @SerializedName( "ProductOldID" )
    @JsonProperty( "ProductOldID" )
    @Nullable
    @ODataField( odataName = "ProductOldID" )
    private String productOldID;
    /**
     * Use with available fluent helpers to apply the <b>ProductOldID</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_OLD_ID = new ClfnProductField<String>("ProductOldID");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "GrossWeight" )
    @JsonProperty( "GrossWeight" )
    @Nullable
    @ODataField( odataName = "GrossWeight" )
    private BigDecimal grossWeight;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeight</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> GROSS_WEIGHT = new ClfnProductField<BigDecimal>("GrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new ClfnProductField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupply</b>
     * </p>
     *
     * @return Source of Supply
     */
    @SerializedName( "SourceOfSupply" )
    @JsonProperty( "SourceOfSupply" )
    @Nullable
    @ODataField( odataName = "SourceOfSupply" )
    private String sourceOfSupply;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupply</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> SOURCE_OF_SUPPLY = new ClfnProductField<String>("SourceOfSupply");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "WeightUnit" )
    @JsonProperty( "WeightUnit" )
    @Nullable
    @ODataField( odataName = "WeightUnit" )
    private String weightUnit;
    /**
     * Use with available fluent helpers to apply the <b>WeightUnit</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> WEIGHT_UNIT = new ClfnProductField<String>("WeightUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "NetWeight" )
    @JsonProperty( "NetWeight" )
    @Nullable
    @ODataField( odataName = "NetWeight" )
    private BigDecimal netWeight;
    /**
     * Use with available fluent helpers to apply the <b>NetWeight</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> NET_WEIGHT = new ClfnProductField<BigDecimal>("NetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @return Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    @SerializedName( "CountryOfOrigin" )
    @JsonProperty( "CountryOfOrigin" )
    @Nullable
    @ODataField( odataName = "CountryOfOrigin" )
    private String countryOfOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CountryOfOrigin</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> COUNTRY_OF_ORIGIN = new ClfnProductField<String>("CountryOfOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompetitorID</b>
     * </p>
     *
     * @return Competitor
     */
    @SerializedName( "CompetitorID" )
    @JsonProperty( "CompetitorID" )
    @Nullable
    @ODataField( odataName = "CompetitorID" )
    private String competitorID;
    /**
     * Use with available fluent helpers to apply the <b>CompetitorID</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> COMPETITOR_ID = new ClfnProductField<String>("CompetitorID");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "ProductGroup" )
    @JsonProperty( "ProductGroup" )
    @Nullable
    @ODataField( odataName = "ProductGroup" )
    private String productGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_GROUP = new ClfnProductField<String>("ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> BASE_UNIT = new ClfnProductField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @return General item category group
     */
    @SerializedName( "ItemCategoryGroup" )
    @JsonProperty( "ItemCategoryGroup" )
    @Nullable
    @ODataField( odataName = "ItemCategoryGroup" )
    private String itemCategoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>ItemCategoryGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> ITEM_CATEGORY_GROUP =
        new ClfnProductField<String>("ItemCategoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @return Product Hierarchy
     */
    @SerializedName( "ProductHierarchy" )
    @JsonProperty( "ProductHierarchy" )
    @Nullable
    @ODataField( odataName = "ProductHierarchy" )
    private String productHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchy</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_HIERARCHY = new ClfnProductField<String>("ProductHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> DIVISION = new ClfnProductField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitIsActive</b>
     * </p>
     *
     * @return Variable Purchase Order Unit Active
     */
    @SerializedName( "VarblPurOrdUnitIsActive" )
    @JsonProperty( "VarblPurOrdUnitIsActive" )
    @Nullable
    @ODataField( odataName = "VarblPurOrdUnitIsActive" )
    private String varblPurOrdUnitIsActive;
    /**
     * Use with available fluent helpers to apply the <b>VarblPurOrdUnitIsActive</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> VARBL_PUR_ORD_UNIT_IS_ACTIVE =
        new ClfnProductField<String>("VarblPurOrdUnitIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> VOLUME_UNIT = new ClfnProductField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "MaterialVolume" )
    @JsonProperty( "MaterialVolume" )
    @Nullable
    @ODataField( odataName = "MaterialVolume" )
    private BigDecimal materialVolume;
    /**
     * Use with available fluent helpers to apply the <b>MaterialVolume</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> MATERIAL_VOLUME =
        new ClfnProductField<BigDecimal>("MaterialVolume");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ANPCode</b>
     * </p>
     *
     * @return ANP Code
     */
    @SerializedName( "ANPCode" )
    @JsonProperty( "ANPCode" )
    @Nullable
    @ODataField( odataName = "ANPCode" )
    private String aNPCode;
    /**
     * Use with available fluent helpers to apply the <b>ANPCode</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> ANP_CODE = new ClfnProductField<String>("ANPCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Brand</b>
     * </p>
     *
     * @return Brand
     */
    @SerializedName( "Brand" )
    @JsonProperty( "Brand" )
    @Nullable
    @ODataField( odataName = "Brand" )
    private String brand;
    /**
     * Use with available fluent helpers to apply the <b>Brand</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> BRAND = new ClfnProductField<String>("Brand");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementRule</b>
     * </p>
     *
     * @return Procurement rule
     */
    @SerializedName( "ProcurementRule" )
    @JsonProperty( "ProcurementRule" )
    @Nullable
    @ODataField( odataName = "ProcurementRule" )
    private String procurementRule;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementRule</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PROCUREMENT_RULE = new ClfnProductField<String>("ProcurementRule");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ClfnProductField<LocalDateTime> VALIDITY_START_DATE =
        new ClfnProductField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowLevelCode</b>
     * </p>
     *
     * @return Low-Level Code
     */
    @SerializedName( "LowLevelCode" )
    @JsonProperty( "LowLevelCode" )
    @Nullable
    @ODataField( odataName = "LowLevelCode" )
    private String lowLevelCode;
    /**
     * Use with available fluent helpers to apply the <b>LowLevelCode</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> LOW_LEVEL_CODE = new ClfnProductField<String>("LowLevelCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdNoInGenProdInPrepackProd</b>
     * </p>
     *
     * @return Material Number of the Generic Material in Prepack Materials
     */
    @SerializedName( "ProdNoInGenProdInPrepackProd" )
    @JsonProperty( "ProdNoInGenProdInPrepackProd" )
    @Nullable
    @ODataField( odataName = "ProdNoInGenProdInPrepackProd" )
    private String prodNoInGenProdInPrepackProd;
    /**
     * Use with available fluent helpers to apply the <b>ProdNoInGenProdInPrepackProd</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD =
        new ClfnProductField<String>("ProdNoInGenProdInPrepackProd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialIdentifierAssgmtProfile</b>
     * </p>
     *
     * @return Serial Number Profile
     */
    @SerializedName( "SerialIdentifierAssgmtProfile" )
    @JsonProperty( "SerialIdentifierAssgmtProfile" )
    @Nullable
    @ODataField( odataName = "SerialIdentifierAssgmtProfile" )
    private String serialIdentifierAssgmtProfile;
    /**
     * Use with available fluent helpers to apply the <b>SerialIdentifierAssgmtProfile</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> SERIAL_IDENTIFIER_ASSGMT_PROFILE =
        new ClfnProductField<String>("SerialIdentifierAssgmtProfile");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SizeOrDimensionText</b>
     * </p>
     *
     * @return Size/dimensions
     */
    @SerializedName( "SizeOrDimensionText" )
    @JsonProperty( "SizeOrDimensionText" )
    @Nullable
    @ODataField( odataName = "SizeOrDimensionText" )
    private String sizeOrDimensionText;
    /**
     * Use with available fluent helpers to apply the <b>SizeOrDimensionText</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> SIZE_OR_DIMENSION_TEXT =
        new ClfnProductField<String>("SizeOrDimensionText");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>IndustryStandardName</b>
     * </p>
     *
     * @return Industry Standard Description (such as ANSI or ISO)
     */
    @SerializedName( "IndustryStandardName" )
    @JsonProperty( "IndustryStandardName" )
    @Nullable
    @ODataField( odataName = "IndustryStandardName" )
    private String industryStandardName;
    /**
     * Use with available fluent helpers to apply the <b>IndustryStandardName</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> INDUSTRY_STANDARD_NAME =
        new ClfnProductField<String>("IndustryStandardName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductStandardID</b>
     * </p>
     *
     * @return Global Trade Item Number (EAN/UPC/GTIN)
     */
    @SerializedName( "ProductStandardID" )
    @JsonProperty( "ProductStandardID" )
    @Nullable
    @ODataField( odataName = "ProductStandardID" )
    private String productStandardID;
    /**
     * Use with available fluent helpers to apply the <b>ProductStandardID</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_STANDARD_ID =
        new ClfnProductField<String>("ProductStandardID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumberCat</b>
     * </p>
     *
     * @return Category of International Article Number (EAN)
     */
    @SerializedName( "InternationalArticleNumberCat" )
    @JsonProperty( "InternationalArticleNumberCat" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumberCat" )
    private String internationalArticleNumberCat;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumberCat</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> INTERNATIONAL_ARTICLE_NUMBER_CAT =
        new ClfnProductField<String>("InternationalArticleNumberCat");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsConfigurable</b>
     * </p>
     *
     * @return Product is Configurable
     */
    @SerializedName( "ProductIsConfigurable" )
    @JsonProperty( "ProductIsConfigurable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProductIsConfigurable" )
    private Boolean productIsConfigurable;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsConfigurable</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> PRODUCT_IS_CONFIGURABLE =
        new ClfnProductField<Boolean>("ProductIsConfigurable");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBatchManagementRequired</b>
     * </p>
     *
     * @return Batch Management Requirement Indicator
     */
    @SerializedName( "IsBatchManagementRequired" )
    @JsonProperty( "IsBatchManagementRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBatchManagementRequired" )
    private Boolean isBatchManagementRequired;
    /**
     * Use with available fluent helpers to apply the <b>IsBatchManagementRequired</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> IS_BATCH_MANAGEMENT_REQUIRED =
        new ClfnProductField<Boolean>("IsBatchManagementRequired");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExternalProductGroup</b>
     * </p>
     *
     * @return External Product Group
     */
    @SerializedName( "ExternalProductGroup" )
    @JsonProperty( "ExternalProductGroup" )
    @Nullable
    @ODataField( odataName = "ExternalProductGroup" )
    private String externalProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>ExternalProductGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> EXTERNAL_PRODUCT_GROUP =
        new ClfnProductField<String>("ExternalProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantConfigurableProduct</b>
     * </p>
     *
     * @return Cross-Plant Configurable Product
     */
    @SerializedName( "CrossPlantConfigurableProduct" )
    @JsonProperty( "CrossPlantConfigurableProduct" )
    @Nullable
    @ODataField( odataName = "CrossPlantConfigurableProduct" )
    private String crossPlantConfigurableProduct;
    /**
     * Use with available fluent helpers to apply the <b>CrossPlantConfigurableProduct</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> CROSS_PLANT_CONFIGURABLE_PRODUCT =
        new ClfnProductField<String>("CrossPlantConfigurableProduct");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNoExplicitnessLevel</b>
     * </p>
     *
     * @return Level of Explicitness for Serial Number
     */
    @SerializedName( "SerialNoExplicitnessLevel" )
    @JsonProperty( "SerialNoExplicitnessLevel" )
    @Nullable
    @ODataField( odataName = "SerialNoExplicitnessLevel" )
    private String serialNoExplicitnessLevel;
    /**
     * Use with available fluent helpers to apply the <b>SerialNoExplicitnessLevel</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> SERIAL_NO_EXPLICITNESS_LEVEL =
        new ClfnProductField<String>("SerialNoExplicitnessLevel");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductManufacturerNumber</b>
     * </p>
     *
     * @return Manufacturer Part Number
     */
    @SerializedName( "ProductManufacturerNumber" )
    @JsonProperty( "ProductManufacturerNumber" )
    @Nullable
    @ODataField( odataName = "ProductManufacturerNumber" )
    private String productManufacturerNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProductManufacturerNumber</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PRODUCT_MANUFACTURER_NUMBER =
        new ClfnProductField<String>("ProductManufacturerNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartProfile</b>
     * </p>
     *
     * @return Mfr part profile
     */
    @SerializedName( "ManufacturerPartProfile" )
    @JsonProperty( "ManufacturerPartProfile" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartProfile" )
    private String manufacturerPartProfile;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartProfile</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> MANUFACTURER_PART_PROFILE =
        new ClfnProductField<String>("ManufacturerPartProfile");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> CHANGE_NUMBER = new ClfnProductField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @return Revision Level
     */
    @SerializedName( "MaterialRevisionLevel" )
    @JsonProperty( "MaterialRevisionLevel" )
    @Nullable
    @ODataField( odataName = "MaterialRevisionLevel" )
    private String materialRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>MaterialRevisionLevel</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> MATERIAL_REVISION_LEVEL =
        new ClfnProductField<String>("MaterialRevisionLevel");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingIndicator</b>
     * </p>
     *
     * @return Handling Indicator
     */
    @SerializedName( "HandlingIndicator" )
    @JsonProperty( "HandlingIndicator" )
    @Nullable
    @ODataField( odataName = "HandlingIndicator" )
    private String handlingIndicator;
    /**
     * Use with available fluent helpers to apply the <b>HandlingIndicator</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> HANDLING_INDICATOR = new ClfnProductField<String>("HandlingIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProductGroup</b>
     * </p>
     *
     * @return Warehouse Material Group
     */
    @SerializedName( "WarehouseProductGroup" )
    @JsonProperty( "WarehouseProductGroup" )
    @Nullable
    @ODataField( odataName = "WarehouseProductGroup" )
    private String warehouseProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProductGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> WAREHOUSE_PRODUCT_GROUP =
        new ClfnProductField<String>("WarehouseProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageCondition</b>
     * </p>
     *
     * @return Warehouse Storage Condition
     */
    @SerializedName( "WarehouseStorageCondition" )
    @JsonProperty( "WarehouseStorageCondition" )
    @Nullable
    @ODataField( odataName = "WarehouseStorageCondition" )
    private String warehouseStorageCondition;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStorageCondition</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> WAREHOUSE_STORAGE_CONDITION =
        new ClfnProductField<String>("WarehouseStorageCondition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardHandlingUnitType</b>
     * </p>
     *
     * @return Standard HU Type
     */
    @SerializedName( "StandardHandlingUnitType" )
    @JsonProperty( "StandardHandlingUnitType" )
    @Nullable
    @ODataField( odataName = "StandardHandlingUnitType" )
    private String standardHandlingUnitType;
    /**
     * Use with available fluent helpers to apply the <b>StandardHandlingUnitType</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> STANDARD_HANDLING_UNIT_TYPE =
        new ClfnProductField<String>("StandardHandlingUnitType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @return Serial Number Profile
     */
    @SerializedName( "SerialNumberProfile" )
    @JsonProperty( "SerialNumberProfile" )
    @Nullable
    @ODataField( odataName = "SerialNumberProfile" )
    private String serialNumberProfile;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberProfile</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> SERIAL_NUMBER_PROFILE =
        new ClfnProductField<String>("SerialNumberProfile");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustmentProfile</b>
     * </p>
     *
     * @return Adjustment Profile
     */
    @SerializedName( "AdjustmentProfile" )
    @JsonProperty( "AdjustmentProfile" )
    @Nullable
    @ODataField( odataName = "AdjustmentProfile" )
    private String adjustmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>AdjustmentProfile</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> ADJUSTMENT_PROFILE = new ClfnProductField<String>("AdjustmentProfile");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PreferredUnitOfMeasure</b>
     * </p>
     *
     * @return Preferred Alternative UoM for Warehouse Operations
     */
    @SerializedName( "PreferredUnitOfMeasure" )
    @JsonProperty( "PreferredUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "PreferredUnitOfMeasure" )
    private String preferredUnitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>PreferredUnitOfMeasure</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> PREFERRED_UNIT_OF_MEASURE =
        new ClfnProductField<String>("PreferredUnitOfMeasure");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPilferable</b>
     * </p>
     *
     * @return Pilferable
     */
    @SerializedName( "IsPilferable" )
    @JsonProperty( "IsPilferable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPilferable" )
    private Boolean isPilferable;
    /**
     * Use with available fluent helpers to apply the <b>IsPilferable</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> IS_PILFERABLE = new ClfnProductField<Boolean>("IsPilferable");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForHzdsSubstances</b>
     * </p>
     *
     * @return Relevant for Hazardous Substances
     */
    @SerializedName( "IsRelevantForHzdsSubstances" )
    @JsonProperty( "IsRelevantForHzdsSubstances" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForHzdsSubstances" )
    private Boolean isRelevantForHzdsSubstances;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForHzdsSubstances</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> IS_RELEVANT_FOR_HZDS_SUBSTANCES =
        new ClfnProductField<Boolean>("IsRelevantForHzdsSubstances");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuarantinePeriod</b>
     * </p>
     *
     * @return Quarantine Period
     */
    @SerializedName( "QuarantinePeriod" )
    @JsonProperty( "QuarantinePeriod" )
    @Nullable
    @ODataField( odataName = "QuarantinePeriod" )
    private BigDecimal quarantinePeriod;
    /**
     * Use with available fluent helpers to apply the <b>QuarantinePeriod</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> QUARANTINE_PERIOD =
        new ClfnProductField<BigDecimal>("QuarantinePeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeUnitForQuarantinePeriod</b>
     * </p>
     *
     * @return Time Unit for Quarantine Period
     */
    @SerializedName( "TimeUnitForQuarantinePeriod" )
    @JsonProperty( "TimeUnitForQuarantinePeriod" )
    @Nullable
    @ODataField( odataName = "TimeUnitForQuarantinePeriod" )
    private String timeUnitForQuarantinePeriod;
    /**
     * Use with available fluent helpers to apply the <b>TimeUnitForQuarantinePeriod</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> TIME_UNIT_FOR_QUARANTINE_PERIOD =
        new ClfnProductField<String>("TimeUnitForQuarantinePeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionGroup</b>
     * </p>
     *
     * @return Quality Inspection Group
     */
    @SerializedName( "QualityInspectionGroup" )
    @JsonProperty( "QualityInspectionGroup" )
    @Nullable
    @ODataField( odataName = "QualityInspectionGroup" )
    private String qualityInspectionGroup;
    /**
     * Use with available fluent helpers to apply the <b>QualityInspectionGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> QUALITY_INSPECTION_GROUP =
        new ClfnProductField<String>("QualityInspectionGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> AUTHORIZATION_GROUP =
        new ClfnProductField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @return Handling Unit Type
     */
    @SerializedName( "HandlingUnitType" )
    @JsonProperty( "HandlingUnitType" )
    @Nullable
    @ODataField( odataName = "HandlingUnitType" )
    private String handlingUnitType;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitType</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> HANDLING_UNIT_TYPE = new ClfnProductField<String>("HandlingUnitType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasVariableTareWeight</b>
     * </p>
     *
     * @return Variable Tare Weight
     */
    @SerializedName( "HasVariableTareWeight" )
    @JsonProperty( "HasVariableTareWeight" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HasVariableTareWeight" )
    private Boolean hasVariableTareWeight;
    /**
     * Use with available fluent helpers to apply the <b>HasVariableTareWeight</b> field to query operations.
     *
     */
    public final static ClfnProductField<Boolean> HAS_VARIABLE_TARE_WEIGHT =
        new ClfnProductField<Boolean>("HasVariableTareWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingLength</b>
     * </p>
     *
     * @return Maximum Packing Length of Packaging Material
     */
    @SerializedName( "MaximumPackagingLength" )
    @JsonProperty( "MaximumPackagingLength" )
    @Nullable
    @ODataField( odataName = "MaximumPackagingLength" )
    private BigDecimal maximumPackagingLength;
    /**
     * Use with available fluent helpers to apply the <b>MaximumPackagingLength</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> MAXIMUM_PACKAGING_LENGTH =
        new ClfnProductField<BigDecimal>("MaximumPackagingLength");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingWidth</b>
     * </p>
     *
     * @return Maximum Packing Width of Packaging Material
     */
    @SerializedName( "MaximumPackagingWidth" )
    @JsonProperty( "MaximumPackagingWidth" )
    @Nullable
    @ODataField( odataName = "MaximumPackagingWidth" )
    private BigDecimal maximumPackagingWidth;
    /**
     * Use with available fluent helpers to apply the <b>MaximumPackagingWidth</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> MAXIMUM_PACKAGING_WIDTH =
        new ClfnProductField<BigDecimal>("MaximumPackagingWidth");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingHeight</b>
     * </p>
     *
     * @return Maximum Packing Height of Packaging Material
     */
    @SerializedName( "MaximumPackagingHeight" )
    @JsonProperty( "MaximumPackagingHeight" )
    @Nullable
    @ODataField( odataName = "MaximumPackagingHeight" )
    private BigDecimal maximumPackagingHeight;
    /**
     * Use with available fluent helpers to apply the <b>MaximumPackagingHeight</b> field to query operations.
     *
     */
    public final static ClfnProductField<BigDecimal> MAXIMUM_PACKAGING_HEIGHT =
        new ClfnProductField<BigDecimal>("MaximumPackagingHeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitForMaxPackagingDimensions</b>
     * </p>
     *
     * @return Unit of Measure for Maximum Packing Length/Width/Height
     */
    @SerializedName( "UnitForMaxPackagingDimensions" )
    @JsonProperty( "UnitForMaxPackagingDimensions" )
    @Nullable
    @ODataField( odataName = "UnitForMaxPackagingDimensions" )
    private String unitForMaxPackagingDimensions;
    /**
     * Use with available fluent helpers to apply the <b>UnitForMaxPackagingDimensions</b> field to query operations.
     *
     */
    public final static ClfnProductField<String> UNIT_FOR_MAX_PACKAGING_DIMENSIONS =
        new ClfnProductField<String>("UnitForMaxPackagingDimensions");
    /**
     * Navigation property <b>to_Description</b> for <b>ClfnProduct</b> to multiple <b>ProductDescription</b>.
     *
     */
    @SerializedName( "to_Description" )
    @JsonProperty( "to_Description" )
    @ODataField( odataName = "to_Description" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductDescription> toDescription;
    /**
     * Navigation property <b>to_Plant</b> for <b>ClfnProduct</b> to multiple <b>ProductPlant</b>.
     *
     */
    @SerializedName( "to_Plant" )
    @JsonProperty( "to_Plant" )
    @ODataField( odataName = "to_Plant" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductPlant> toPlant;
    /**
     * Navigation property <b>to_ProductCharc</b> for <b>ClfnProduct</b> to multiple <b>ProductCharc</b>.
     *
     */
    @SerializedName( "to_ProductCharc" )
    @JsonProperty( "to_ProductCharc" )
    @ODataField( odataName = "to_ProductCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductCharc> toProductCharc;
    /**
     * Navigation property <b>to_ProductClass</b> for <b>ClfnProduct</b> to multiple <b>ProductClass</b>.
     *
     */
    @SerializedName( "to_ProductClass" )
    @JsonProperty( "to_ProductClass" )
    @ODataField( odataName = "to_ProductClass" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductClass> toProductClass;
    /**
     * Navigation property <b>to_ProductSalesTax</b> for <b>ClfnProduct</b> to multiple <b>ProductSalesTax</b>.
     *
     */
    @SerializedName( "to_ProductSalesTax" )
    @JsonProperty( "to_ProductSalesTax" )
    @ODataField( odataName = "to_ProductSalesTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductSalesTax> toProductSalesTax;
    /**
     * Navigation property <b>to_SalesDelivery</b> for <b>ClfnProduct</b> to multiple <b>ProductSalesDelivery</b>.
     *
     */
    @SerializedName( "to_SalesDelivery" )
    @JsonProperty( "to_SalesDelivery" )
    @ODataField( odataName = "to_SalesDelivery" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductSalesDelivery> toSalesDelivery;
    /**
     * Use with available fluent helpers to apply the <b>to_Description</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductDescription> TO_DESCRIPTION =
        new ClfnProductLink<ProductDescription>("to_Description");
    /**
     * Use with available fluent helpers to apply the <b>to_Plant</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductPlant> TO_PLANT = new ClfnProductLink<ProductPlant>("to_Plant");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductCharc</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductCharc> TO_PRODUCT_CHARC =
        new ClfnProductLink<ProductCharc>("to_ProductCharc");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductClass</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductClass> TO_PRODUCT_CLASS =
        new ClfnProductLink<ProductClass>("to_ProductClass");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductSalesTax</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductSalesTax> TO_PRODUCT_SALES_TAX =
        new ClfnProductLink<ProductSalesTax>("to_ProductSalesTax");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesDelivery</b> navigation property to query operations.
     *
     */
    public final static ClfnProductLink<ProductSalesDelivery> TO_SALES_DELIVERY =
        new ClfnProductLink<ProductSalesDelivery>("to_SalesDelivery");

    @Nonnull
    @Override
    public Class<ClfnProduct> getType()
    {
        return ClfnProduct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatus</b>
     * </p>
     *
     * @param crossPlantStatus
     *            Cross-Plant Product Status
     */
    public void setCrossPlantStatus( @Nullable final String crossPlantStatus )
    {
        rememberChangedField("CrossPlantStatus", this.crossPlantStatus);
        this.crossPlantStatus = crossPlantStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantStatusValidityDate</b>
     * </p>
     *
     * @param crossPlantStatusValidityDate
     *            Date from which the cross-plant material status is valid
     */
    public void setCrossPlantStatusValidityDate( @Nullable final LocalDateTime crossPlantStatusValidityDate )
    {
        rememberChangedField("CrossPlantStatusValidityDate", this.crossPlantStatusValidityDate);
        this.crossPlantStatusValidityDate = crossPlantStatusValidityDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductOldID</b>
     * </p>
     *
     * @param productOldID
     *            Old Product Number
     */
    public void setProductOldID( @Nullable final String productOldID )
    {
        rememberChangedField("ProductOldID", this.productOldID);
        this.productOldID = productOldID;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @param grossWeight
     *            Gross Weight
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupply</b>
     * </p>
     *
     * @param sourceOfSupply
     *            Source of Supply
     */
    public void setSourceOfSupply( @Nullable final String sourceOfSupply )
    {
        rememberChangedField("SourceOfSupply", this.sourceOfSupply);
        this.sourceOfSupply = sourceOfSupply;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @param weightUnit
     *            Unit of Weight
     */
    public void setWeightUnit( @Nullable final String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @param netWeight
     *            Net Weight
     */
    public void setNetWeight( @Nullable final BigDecimal netWeight )
    {
        rememberChangedField("NetWeight", this.netWeight);
        this.netWeight = netWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryOfOrigin</b>
     * </p>
     *
     * @param countryOfOrigin
     *            Country/Region of Origin of Material (Non-Preferential Ori.)
     */
    public void setCountryOfOrigin( @Nullable final String countryOfOrigin )
    {
        rememberChangedField("CountryOfOrigin", this.countryOfOrigin);
        this.countryOfOrigin = countryOfOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompetitorID</b>
     * </p>
     *
     * @param competitorID
     *            Competitor
     */
    public void setCompetitorID( @Nullable final String competitorID )
    {
        rememberChangedField("CompetitorID", this.competitorID);
        this.competitorID = competitorID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @param itemCategoryGroup
     *            General item category group
     */
    public void setItemCategoryGroup( @Nullable final String itemCategoryGroup )
    {
        rememberChangedField("ItemCategoryGroup", this.itemCategoryGroup);
        this.itemCategoryGroup = itemCategoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @param productHierarchy
     *            Product Hierarchy
     */
    public void setProductHierarchy( @Nullable final String productHierarchy )
    {
        rememberChangedField("ProductHierarchy", this.productHierarchy);
        this.productHierarchy = productHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitIsActive</b>
     * </p>
     *
     * @param varblPurOrdUnitIsActive
     *            Variable Purchase Order Unit Active
     */
    public void setVarblPurOrdUnitIsActive( @Nullable final String varblPurOrdUnitIsActive )
    {
        rememberChangedField("VarblPurOrdUnitIsActive", this.varblPurOrdUnitIsActive);
        this.varblPurOrdUnitIsActive = varblPurOrdUnitIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialVolume</b>
     * </p>
     *
     * @param materialVolume
     *            Volume
     */
    public void setMaterialVolume( @Nullable final BigDecimal materialVolume )
    {
        rememberChangedField("MaterialVolume", this.materialVolume);
        this.materialVolume = materialVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ANPCode</b>
     * </p>
     *
     * @param aNPCode
     *            ANP Code
     */
    public void setANPCode( @Nullable final String aNPCode )
    {
        rememberChangedField("ANPCode", this.aNPCode);
        this.aNPCode = aNPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Brand</b>
     * </p>
     *
     * @param brand
     *            Brand
     */
    public void setBrand( @Nullable final String brand )
    {
        rememberChangedField("Brand", this.brand);
        this.brand = brand;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementRule</b>
     * </p>
     *
     * @param procurementRule
     *            Procurement rule
     */
    public void setProcurementRule( @Nullable final String procurementRule )
    {
        rememberChangedField("ProcurementRule", this.procurementRule);
        this.procurementRule = procurementRule;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LowLevelCode</b>
     * </p>
     *
     * @param lowLevelCode
     *            Low-Level Code
     */
    public void setLowLevelCode( @Nullable final String lowLevelCode )
    {
        rememberChangedField("LowLevelCode", this.lowLevelCode);
        this.lowLevelCode = lowLevelCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdNoInGenProdInPrepackProd</b>
     * </p>
     *
     * @param prodNoInGenProdInPrepackProd
     *            Material Number of the Generic Material in Prepack Materials
     */
    public void setProdNoInGenProdInPrepackProd( @Nullable final String prodNoInGenProdInPrepackProd )
    {
        rememberChangedField("ProdNoInGenProdInPrepackProd", this.prodNoInGenProdInPrepackProd);
        this.prodNoInGenProdInPrepackProd = prodNoInGenProdInPrepackProd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialIdentifierAssgmtProfile</b>
     * </p>
     *
     * @param serialIdentifierAssgmtProfile
     *            Serial Number Profile
     */
    public void setSerialIdentifierAssgmtProfile( @Nullable final String serialIdentifierAssgmtProfile )
    {
        rememberChangedField("SerialIdentifierAssgmtProfile", this.serialIdentifierAssgmtProfile);
        this.serialIdentifierAssgmtProfile = serialIdentifierAssgmtProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SizeOrDimensionText</b>
     * </p>
     *
     * @param sizeOrDimensionText
     *            Size/dimensions
     */
    public void setSizeOrDimensionText( @Nullable final String sizeOrDimensionText )
    {
        rememberChangedField("SizeOrDimensionText", this.sizeOrDimensionText);
        this.sizeOrDimensionText = sizeOrDimensionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>IndustryStandardName</b>
     * </p>
     *
     * @param industryStandardName
     *            Industry Standard Description (such as ANSI or ISO)
     */
    public void setIndustryStandardName( @Nullable final String industryStandardName )
    {
        rememberChangedField("IndustryStandardName", this.industryStandardName);
        this.industryStandardName = industryStandardName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductStandardID</b>
     * </p>
     *
     * @param productStandardID
     *            Global Trade Item Number (EAN/UPC/GTIN)
     */
    public void setProductStandardID( @Nullable final String productStandardID )
    {
        rememberChangedField("ProductStandardID", this.productStandardID);
        this.productStandardID = productStandardID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumberCat</b>
     * </p>
     *
     * @param internationalArticleNumberCat
     *            Category of International Article Number (EAN)
     */
    public void setInternationalArticleNumberCat( @Nullable final String internationalArticleNumberCat )
    {
        rememberChangedField("InternationalArticleNumberCat", this.internationalArticleNumberCat);
        this.internationalArticleNumberCat = internationalArticleNumberCat;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsConfigurable</b>
     * </p>
     *
     * @param productIsConfigurable
     *            Product is Configurable
     */
    public void setProductIsConfigurable( @Nullable final Boolean productIsConfigurable )
    {
        rememberChangedField("ProductIsConfigurable", this.productIsConfigurable);
        this.productIsConfigurable = productIsConfigurable;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBatchManagementRequired</b>
     * </p>
     *
     * @param isBatchManagementRequired
     *            Batch Management Requirement Indicator
     */
    public void setIsBatchManagementRequired( @Nullable final Boolean isBatchManagementRequired )
    {
        rememberChangedField("IsBatchManagementRequired", this.isBatchManagementRequired);
        this.isBatchManagementRequired = isBatchManagementRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExternalProductGroup</b>
     * </p>
     *
     * @param externalProductGroup
     *            External Product Group
     */
    public void setExternalProductGroup( @Nullable final String externalProductGroup )
    {
        rememberChangedField("ExternalProductGroup", this.externalProductGroup);
        this.externalProductGroup = externalProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CrossPlantConfigurableProduct</b>
     * </p>
     *
     * @param crossPlantConfigurableProduct
     *            Cross-Plant Configurable Product
     */
    public void setCrossPlantConfigurableProduct( @Nullable final String crossPlantConfigurableProduct )
    {
        rememberChangedField("CrossPlantConfigurableProduct", this.crossPlantConfigurableProduct);
        this.crossPlantConfigurableProduct = crossPlantConfigurableProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNoExplicitnessLevel</b>
     * </p>
     *
     * @param serialNoExplicitnessLevel
     *            Level of Explicitness for Serial Number
     */
    public void setSerialNoExplicitnessLevel( @Nullable final String serialNoExplicitnessLevel )
    {
        rememberChangedField("SerialNoExplicitnessLevel", this.serialNoExplicitnessLevel);
        this.serialNoExplicitnessLevel = serialNoExplicitnessLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductManufacturerNumber</b>
     * </p>
     *
     * @param productManufacturerNumber
     *            Manufacturer Part Number
     */
    public void setProductManufacturerNumber( @Nullable final String productManufacturerNumber )
    {
        rememberChangedField("ProductManufacturerNumber", this.productManufacturerNumber);
        this.productManufacturerNumber = productManufacturerNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartProfile</b>
     * </p>
     *
     * @param manufacturerPartProfile
     *            Mfr part profile
     */
    public void setManufacturerPartProfile( @Nullable final String manufacturerPartProfile )
    {
        rememberChangedField("ManufacturerPartProfile", this.manufacturerPartProfile);
        this.manufacturerPartProfile = manufacturerPartProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @param materialRevisionLevel
     *            Revision Level
     */
    public void setMaterialRevisionLevel( @Nullable final String materialRevisionLevel )
    {
        rememberChangedField("MaterialRevisionLevel", this.materialRevisionLevel);
        this.materialRevisionLevel = materialRevisionLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingIndicator</b>
     * </p>
     *
     * @param handlingIndicator
     *            Handling Indicator
     */
    public void setHandlingIndicator( @Nullable final String handlingIndicator )
    {
        rememberChangedField("HandlingIndicator", this.handlingIndicator);
        this.handlingIndicator = handlingIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProductGroup</b>
     * </p>
     *
     * @param warehouseProductGroup
     *            Warehouse Material Group
     */
    public void setWarehouseProductGroup( @Nullable final String warehouseProductGroup )
    {
        rememberChangedField("WarehouseProductGroup", this.warehouseProductGroup);
        this.warehouseProductGroup = warehouseProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageCondition</b>
     * </p>
     *
     * @param warehouseStorageCondition
     *            Warehouse Storage Condition
     */
    public void setWarehouseStorageCondition( @Nullable final String warehouseStorageCondition )
    {
        rememberChangedField("WarehouseStorageCondition", this.warehouseStorageCondition);
        this.warehouseStorageCondition = warehouseStorageCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardHandlingUnitType</b>
     * </p>
     *
     * @param standardHandlingUnitType
     *            Standard HU Type
     */
    public void setStandardHandlingUnitType( @Nullable final String standardHandlingUnitType )
    {
        rememberChangedField("StandardHandlingUnitType", this.standardHandlingUnitType);
        this.standardHandlingUnitType = standardHandlingUnitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @param serialNumberProfile
     *            Serial Number Profile
     */
    public void setSerialNumberProfile( @Nullable final String serialNumberProfile )
    {
        rememberChangedField("SerialNumberProfile", this.serialNumberProfile);
        this.serialNumberProfile = serialNumberProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustmentProfile</b>
     * </p>
     *
     * @param adjustmentProfile
     *            Adjustment Profile
     */
    public void setAdjustmentProfile( @Nullable final String adjustmentProfile )
    {
        rememberChangedField("AdjustmentProfile", this.adjustmentProfile);
        this.adjustmentProfile = adjustmentProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PreferredUnitOfMeasure</b>
     * </p>
     *
     * @param preferredUnitOfMeasure
     *            Preferred Alternative UoM for Warehouse Operations
     */
    public void setPreferredUnitOfMeasure( @Nullable final String preferredUnitOfMeasure )
    {
        rememberChangedField("PreferredUnitOfMeasure", this.preferredUnitOfMeasure);
        this.preferredUnitOfMeasure = preferredUnitOfMeasure;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPilferable</b>
     * </p>
     *
     * @param isPilferable
     *            Pilferable
     */
    public void setIsPilferable( @Nullable final Boolean isPilferable )
    {
        rememberChangedField("IsPilferable", this.isPilferable);
        this.isPilferable = isPilferable;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForHzdsSubstances</b>
     * </p>
     *
     * @param isRelevantForHzdsSubstances
     *            Relevant for Hazardous Substances
     */
    public void setIsRelevantForHzdsSubstances( @Nullable final Boolean isRelevantForHzdsSubstances )
    {
        rememberChangedField("IsRelevantForHzdsSubstances", this.isRelevantForHzdsSubstances);
        this.isRelevantForHzdsSubstances = isRelevantForHzdsSubstances;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuarantinePeriod</b>
     * </p>
     *
     * @param quarantinePeriod
     *            Quarantine Period
     */
    public void setQuarantinePeriod( @Nullable final BigDecimal quarantinePeriod )
    {
        rememberChangedField("QuarantinePeriod", this.quarantinePeriod);
        this.quarantinePeriod = quarantinePeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeUnitForQuarantinePeriod</b>
     * </p>
     *
     * @param timeUnitForQuarantinePeriod
     *            Time Unit for Quarantine Period
     */
    public void setTimeUnitForQuarantinePeriod( @Nullable final String timeUnitForQuarantinePeriod )
    {
        rememberChangedField("TimeUnitForQuarantinePeriod", this.timeUnitForQuarantinePeriod);
        this.timeUnitForQuarantinePeriod = timeUnitForQuarantinePeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QualityInspectionGroup</b>
     * </p>
     *
     * @param qualityInspectionGroup
     *            Quality Inspection Group
     */
    public void setQualityInspectionGroup( @Nullable final String qualityInspectionGroup )
    {
        rememberChangedField("QualityInspectionGroup", this.qualityInspectionGroup);
        this.qualityInspectionGroup = qualityInspectionGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @param handlingUnitType
     *            Handling Unit Type
     */
    public void setHandlingUnitType( @Nullable final String handlingUnitType )
    {
        rememberChangedField("HandlingUnitType", this.handlingUnitType);
        this.handlingUnitType = handlingUnitType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasVariableTareWeight</b>
     * </p>
     *
     * @param hasVariableTareWeight
     *            Variable Tare Weight
     */
    public void setHasVariableTareWeight( @Nullable final Boolean hasVariableTareWeight )
    {
        rememberChangedField("HasVariableTareWeight", this.hasVariableTareWeight);
        this.hasVariableTareWeight = hasVariableTareWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingLength</b>
     * </p>
     *
     * @param maximumPackagingLength
     *            Maximum Packing Length of Packaging Material
     */
    public void setMaximumPackagingLength( @Nullable final BigDecimal maximumPackagingLength )
    {
        rememberChangedField("MaximumPackagingLength", this.maximumPackagingLength);
        this.maximumPackagingLength = maximumPackagingLength;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingWidth</b>
     * </p>
     *
     * @param maximumPackagingWidth
     *            Maximum Packing Width of Packaging Material
     */
    public void setMaximumPackagingWidth( @Nullable final BigDecimal maximumPackagingWidth )
    {
        rememberChangedField("MaximumPackagingWidth", this.maximumPackagingWidth);
        this.maximumPackagingWidth = maximumPackagingWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumPackagingHeight</b>
     * </p>
     *
     * @param maximumPackagingHeight
     *            Maximum Packing Height of Packaging Material
     */
    public void setMaximumPackagingHeight( @Nullable final BigDecimal maximumPackagingHeight )
    {
        rememberChangedField("MaximumPackagingHeight", this.maximumPackagingHeight);
        this.maximumPackagingHeight = maximumPackagingHeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitForMaxPackagingDimensions</b>
     * </p>
     *
     * @param unitForMaxPackagingDimensions
     *            Unit of Measure for Maximum Packing Length/Width/Height
     */
    public void setUnitForMaxPackagingDimensions( @Nullable final String unitForMaxPackagingDimensions )
    {
        rememberChangedField("UnitForMaxPackagingDimensions", this.unitForMaxPackagingDimensions);
        this.unitForMaxPackagingDimensions = unitForMaxPackagingDimensions;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnProduct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ProductType", getProductType());
        values.put("CrossPlantStatus", getCrossPlantStatus());
        values.put("CrossPlantStatusValidityDate", getCrossPlantStatusValidityDate());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("ProductOldID", getProductOldID());
        values.put("GrossWeight", getGrossWeight());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("SourceOfSupply", getSourceOfSupply());
        values.put("WeightUnit", getWeightUnit());
        values.put("NetWeight", getNetWeight());
        values.put("CountryOfOrigin", getCountryOfOrigin());
        values.put("CompetitorID", getCompetitorID());
        values.put("ProductGroup", getProductGroup());
        values.put("BaseUnit", getBaseUnit());
        values.put("ItemCategoryGroup", getItemCategoryGroup());
        values.put("ProductHierarchy", getProductHierarchy());
        values.put("Division", getDivision());
        values.put("VarblPurOrdUnitIsActive", getVarblPurOrdUnitIsActive());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("MaterialVolume", getMaterialVolume());
        values.put("ANPCode", getANPCode());
        values.put("Brand", getBrand());
        values.put("ProcurementRule", getProcurementRule());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("LowLevelCode", getLowLevelCode());
        values.put("ProdNoInGenProdInPrepackProd", getProdNoInGenProdInPrepackProd());
        values.put("SerialIdentifierAssgmtProfile", getSerialIdentifierAssgmtProfile());
        values.put("SizeOrDimensionText", getSizeOrDimensionText());
        values.put("IndustryStandardName", getIndustryStandardName());
        values.put("ProductStandardID", getProductStandardID());
        values.put("InternationalArticleNumberCat", getInternationalArticleNumberCat());
        values.put("ProductIsConfigurable", getProductIsConfigurable());
        values.put("IsBatchManagementRequired", getIsBatchManagementRequired());
        values.put("ExternalProductGroup", getExternalProductGroup());
        values.put("CrossPlantConfigurableProduct", getCrossPlantConfigurableProduct());
        values.put("SerialNoExplicitnessLevel", getSerialNoExplicitnessLevel());
        values.put("ProductManufacturerNumber", getProductManufacturerNumber());
        values.put("ManufacturerPartProfile", getManufacturerPartProfile());
        values.put("ChangeNumber", getChangeNumber());
        values.put("MaterialRevisionLevel", getMaterialRevisionLevel());
        values.put("HandlingIndicator", getHandlingIndicator());
        values.put("WarehouseProductGroup", getWarehouseProductGroup());
        values.put("WarehouseStorageCondition", getWarehouseStorageCondition());
        values.put("StandardHandlingUnitType", getStandardHandlingUnitType());
        values.put("SerialNumberProfile", getSerialNumberProfile());
        values.put("AdjustmentProfile", getAdjustmentProfile());
        values.put("PreferredUnitOfMeasure", getPreferredUnitOfMeasure());
        values.put("IsPilferable", getIsPilferable());
        values.put("IsRelevantForHzdsSubstances", getIsRelevantForHzdsSubstances());
        values.put("QuarantinePeriod", getQuarantinePeriod());
        values.put("TimeUnitForQuarantinePeriod", getTimeUnitForQuarantinePeriod());
        values.put("QualityInspectionGroup", getQualityInspectionGroup());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("HandlingUnitType", getHandlingUnitType());
        values.put("HasVariableTareWeight", getHasVariableTareWeight());
        values.put("MaximumPackagingLength", getMaximumPackagingLength());
        values.put("MaximumPackagingWidth", getMaximumPackagingWidth());
        values.put("MaximumPackagingHeight", getMaximumPackagingHeight());
        values.put("UnitForMaxPackagingDimensions", getUnitForMaxPackagingDimensions());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("CrossPlantStatus") ) {
                final Object value = values.remove("CrossPlantStatus");
                if( (value == null) || (!value.equals(getCrossPlantStatus())) ) {
                    setCrossPlantStatus(((String) value));
                }
            }
            if( values.containsKey("CrossPlantStatusValidityDate") ) {
                final Object value = values.remove("CrossPlantStatusValidityDate");
                if( (value == null) || (!value.equals(getCrossPlantStatusValidityDate())) ) {
                    setCrossPlantStatusValidityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("ProductOldID") ) {
                final Object value = values.remove("ProductOldID");
                if( (value == null) || (!value.equals(getProductOldID())) ) {
                    setProductOldID(((String) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SourceOfSupply") ) {
                final Object value = values.remove("SourceOfSupply");
                if( (value == null) || (!value.equals(getSourceOfSupply())) ) {
                    setSourceOfSupply(((String) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((String) value));
                }
            }
            if( values.containsKey("NetWeight") ) {
                final Object value = values.remove("NetWeight");
                if( (value == null) || (!value.equals(getNetWeight())) ) {
                    setNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("CountryOfOrigin") ) {
                final Object value = values.remove("CountryOfOrigin");
                if( (value == null) || (!value.equals(getCountryOfOrigin())) ) {
                    setCountryOfOrigin(((String) value));
                }
            }
            if( values.containsKey("CompetitorID") ) {
                final Object value = values.remove("CompetitorID");
                if( (value == null) || (!value.equals(getCompetitorID())) ) {
                    setCompetitorID(((String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ItemCategoryGroup") ) {
                final Object value = values.remove("ItemCategoryGroup");
                if( (value == null) || (!value.equals(getItemCategoryGroup())) ) {
                    setItemCategoryGroup(((String) value));
                }
            }
            if( values.containsKey("ProductHierarchy") ) {
                final Object value = values.remove("ProductHierarchy");
                if( (value == null) || (!value.equals(getProductHierarchy())) ) {
                    setProductHierarchy(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("VarblPurOrdUnitIsActive") ) {
                final Object value = values.remove("VarblPurOrdUnitIsActive");
                if( (value == null) || (!value.equals(getVarblPurOrdUnitIsActive())) ) {
                    setVarblPurOrdUnitIsActive(((String) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("MaterialVolume") ) {
                final Object value = values.remove("MaterialVolume");
                if( (value == null) || (!value.equals(getMaterialVolume())) ) {
                    setMaterialVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ANPCode") ) {
                final Object value = values.remove("ANPCode");
                if( (value == null) || (!value.equals(getANPCode())) ) {
                    setANPCode(((String) value));
                }
            }
            if( values.containsKey("Brand") ) {
                final Object value = values.remove("Brand");
                if( (value == null) || (!value.equals(getBrand())) ) {
                    setBrand(((String) value));
                }
            }
            if( values.containsKey("ProcurementRule") ) {
                final Object value = values.remove("ProcurementRule");
                if( (value == null) || (!value.equals(getProcurementRule())) ) {
                    setProcurementRule(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LowLevelCode") ) {
                final Object value = values.remove("LowLevelCode");
                if( (value == null) || (!value.equals(getLowLevelCode())) ) {
                    setLowLevelCode(((String) value));
                }
            }
            if( values.containsKey("ProdNoInGenProdInPrepackProd") ) {
                final Object value = values.remove("ProdNoInGenProdInPrepackProd");
                if( (value == null) || (!value.equals(getProdNoInGenProdInPrepackProd())) ) {
                    setProdNoInGenProdInPrepackProd(((String) value));
                }
            }
            if( values.containsKey("SerialIdentifierAssgmtProfile") ) {
                final Object value = values.remove("SerialIdentifierAssgmtProfile");
                if( (value == null) || (!value.equals(getSerialIdentifierAssgmtProfile())) ) {
                    setSerialIdentifierAssgmtProfile(((String) value));
                }
            }
            if( values.containsKey("SizeOrDimensionText") ) {
                final Object value = values.remove("SizeOrDimensionText");
                if( (value == null) || (!value.equals(getSizeOrDimensionText())) ) {
                    setSizeOrDimensionText(((String) value));
                }
            }
            if( values.containsKey("IndustryStandardName") ) {
                final Object value = values.remove("IndustryStandardName");
                if( (value == null) || (!value.equals(getIndustryStandardName())) ) {
                    setIndustryStandardName(((String) value));
                }
            }
            if( values.containsKey("ProductStandardID") ) {
                final Object value = values.remove("ProductStandardID");
                if( (value == null) || (!value.equals(getProductStandardID())) ) {
                    setProductStandardID(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumberCat") ) {
                final Object value = values.remove("InternationalArticleNumberCat");
                if( (value == null) || (!value.equals(getInternationalArticleNumberCat())) ) {
                    setInternationalArticleNumberCat(((String) value));
                }
            }
            if( values.containsKey("ProductIsConfigurable") ) {
                final Object value = values.remove("ProductIsConfigurable");
                if( (value == null) || (!value.equals(getProductIsConfigurable())) ) {
                    setProductIsConfigurable(((Boolean) value));
                }
            }
            if( values.containsKey("IsBatchManagementRequired") ) {
                final Object value = values.remove("IsBatchManagementRequired");
                if( (value == null) || (!value.equals(getIsBatchManagementRequired())) ) {
                    setIsBatchManagementRequired(((Boolean) value));
                }
            }
            if( values.containsKey("ExternalProductGroup") ) {
                final Object value = values.remove("ExternalProductGroup");
                if( (value == null) || (!value.equals(getExternalProductGroup())) ) {
                    setExternalProductGroup(((String) value));
                }
            }
            if( values.containsKey("CrossPlantConfigurableProduct") ) {
                final Object value = values.remove("CrossPlantConfigurableProduct");
                if( (value == null) || (!value.equals(getCrossPlantConfigurableProduct())) ) {
                    setCrossPlantConfigurableProduct(((String) value));
                }
            }
            if( values.containsKey("SerialNoExplicitnessLevel") ) {
                final Object value = values.remove("SerialNoExplicitnessLevel");
                if( (value == null) || (!value.equals(getSerialNoExplicitnessLevel())) ) {
                    setSerialNoExplicitnessLevel(((String) value));
                }
            }
            if( values.containsKey("ProductManufacturerNumber") ) {
                final Object value = values.remove("ProductManufacturerNumber");
                if( (value == null) || (!value.equals(getProductManufacturerNumber())) ) {
                    setProductManufacturerNumber(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartProfile") ) {
                final Object value = values.remove("ManufacturerPartProfile");
                if( (value == null) || (!value.equals(getManufacturerPartProfile())) ) {
                    setManufacturerPartProfile(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("MaterialRevisionLevel") ) {
                final Object value = values.remove("MaterialRevisionLevel");
                if( (value == null) || (!value.equals(getMaterialRevisionLevel())) ) {
                    setMaterialRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("HandlingIndicator") ) {
                final Object value = values.remove("HandlingIndicator");
                if( (value == null) || (!value.equals(getHandlingIndicator())) ) {
                    setHandlingIndicator(((String) value));
                }
            }
            if( values.containsKey("WarehouseProductGroup") ) {
                final Object value = values.remove("WarehouseProductGroup");
                if( (value == null) || (!value.equals(getWarehouseProductGroup())) ) {
                    setWarehouseProductGroup(((String) value));
                }
            }
            if( values.containsKey("WarehouseStorageCondition") ) {
                final Object value = values.remove("WarehouseStorageCondition");
                if( (value == null) || (!value.equals(getWarehouseStorageCondition())) ) {
                    setWarehouseStorageCondition(((String) value));
                }
            }
            if( values.containsKey("StandardHandlingUnitType") ) {
                final Object value = values.remove("StandardHandlingUnitType");
                if( (value == null) || (!value.equals(getStandardHandlingUnitType())) ) {
                    setStandardHandlingUnitType(((String) value));
                }
            }
            if( values.containsKey("SerialNumberProfile") ) {
                final Object value = values.remove("SerialNumberProfile");
                if( (value == null) || (!value.equals(getSerialNumberProfile())) ) {
                    setSerialNumberProfile(((String) value));
                }
            }
            if( values.containsKey("AdjustmentProfile") ) {
                final Object value = values.remove("AdjustmentProfile");
                if( (value == null) || (!value.equals(getAdjustmentProfile())) ) {
                    setAdjustmentProfile(((String) value));
                }
            }
            if( values.containsKey("PreferredUnitOfMeasure") ) {
                final Object value = values.remove("PreferredUnitOfMeasure");
                if( (value == null) || (!value.equals(getPreferredUnitOfMeasure())) ) {
                    setPreferredUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("IsPilferable") ) {
                final Object value = values.remove("IsPilferable");
                if( (value == null) || (!value.equals(getIsPilferable())) ) {
                    setIsPilferable(((Boolean) value));
                }
            }
            if( values.containsKey("IsRelevantForHzdsSubstances") ) {
                final Object value = values.remove("IsRelevantForHzdsSubstances");
                if( (value == null) || (!value.equals(getIsRelevantForHzdsSubstances())) ) {
                    setIsRelevantForHzdsSubstances(((Boolean) value));
                }
            }
            if( values.containsKey("QuarantinePeriod") ) {
                final Object value = values.remove("QuarantinePeriod");
                if( (value == null) || (!value.equals(getQuarantinePeriod())) ) {
                    setQuarantinePeriod(((BigDecimal) value));
                }
            }
            if( values.containsKey("TimeUnitForQuarantinePeriod") ) {
                final Object value = values.remove("TimeUnitForQuarantinePeriod");
                if( (value == null) || (!value.equals(getTimeUnitForQuarantinePeriod())) ) {
                    setTimeUnitForQuarantinePeriod(((String) value));
                }
            }
            if( values.containsKey("QualityInspectionGroup") ) {
                final Object value = values.remove("QualityInspectionGroup");
                if( (value == null) || (!value.equals(getQualityInspectionGroup())) ) {
                    setQualityInspectionGroup(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitType") ) {
                final Object value = values.remove("HandlingUnitType");
                if( (value == null) || (!value.equals(getHandlingUnitType())) ) {
                    setHandlingUnitType(((String) value));
                }
            }
            if( values.containsKey("HasVariableTareWeight") ) {
                final Object value = values.remove("HasVariableTareWeight");
                if( (value == null) || (!value.equals(getHasVariableTareWeight())) ) {
                    setHasVariableTareWeight(((Boolean) value));
                }
            }
            if( values.containsKey("MaximumPackagingLength") ) {
                final Object value = values.remove("MaximumPackagingLength");
                if( (value == null) || (!value.equals(getMaximumPackagingLength())) ) {
                    setMaximumPackagingLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumPackagingWidth") ) {
                final Object value = values.remove("MaximumPackagingWidth");
                if( (value == null) || (!value.equals(getMaximumPackagingWidth())) ) {
                    setMaximumPackagingWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumPackagingHeight") ) {
                final Object value = values.remove("MaximumPackagingHeight");
                if( (value == null) || (!value.equals(getMaximumPackagingHeight())) ) {
                    setMaximumPackagingHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitForMaxPackagingDimensions") ) {
                final Object value = values.remove("UnitForMaxPackagingDimensions");
                if( (value == null) || (!value.equals(getUnitForMaxPackagingDimensions())) ) {
                    setUnitForMaxPackagingDimensions(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Description") ) {
                final Object value = (values).remove("to_Description");
                if( value instanceof Iterable ) {
                    if( toDescription == null ) {
                        toDescription = Lists.newArrayList();
                    } else {
                        toDescription = Lists.newArrayList(toDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductDescription entity;
                        if( toDescription.size() > i ) {
                            entity = toDescription.get(i);
                        } else {
                            entity = new ProductDescription();
                            toDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Plant") ) {
                final Object value = (values).remove("to_Plant");
                if( value instanceof Iterable ) {
                    if( toPlant == null ) {
                        toPlant = Lists.newArrayList();
                    } else {
                        toPlant = Lists.newArrayList(toPlant);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductPlant entity;
                        if( toPlant.size() > i ) {
                            entity = toPlant.get(i);
                        } else {
                            entity = new ProductPlant();
                            toPlant.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductCharc") ) {
                final Object value = (values).remove("to_ProductCharc");
                if( value instanceof Iterable ) {
                    if( toProductCharc == null ) {
                        toProductCharc = Lists.newArrayList();
                    } else {
                        toProductCharc = Lists.newArrayList(toProductCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductCharc entity;
                        if( toProductCharc.size() > i ) {
                            entity = toProductCharc.get(i);
                        } else {
                            entity = new ProductCharc();
                            toProductCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductClass") ) {
                final Object value = (values).remove("to_ProductClass");
                if( value instanceof Iterable ) {
                    if( toProductClass == null ) {
                        toProductClass = Lists.newArrayList();
                    } else {
                        toProductClass = Lists.newArrayList(toProductClass);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductClass entity;
                        if( toProductClass.size() > i ) {
                            entity = toProductClass.get(i);
                        } else {
                            entity = new ProductClass();
                            toProductClass.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductSalesTax") ) {
                final Object value = (values).remove("to_ProductSalesTax");
                if( value instanceof Iterable ) {
                    if( toProductSalesTax == null ) {
                        toProductSalesTax = Lists.newArrayList();
                    } else {
                        toProductSalesTax = Lists.newArrayList(toProductSalesTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductSalesTax entity;
                        if( toProductSalesTax.size() > i ) {
                            entity = toProductSalesTax.get(i);
                        } else {
                            entity = new ProductSalesTax();
                            toProductSalesTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesDelivery") ) {
                final Object value = (values).remove("to_SalesDelivery");
                if( value instanceof Iterable ) {
                    if( toSalesDelivery == null ) {
                        toSalesDelivery = Lists.newArrayList();
                    } else {
                        toSalesDelivery = Lists.newArrayList(toSalesDelivery);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductSalesDelivery entity;
                        if( toSalesDelivery.size() > i ) {
                            entity = toSalesDelivery.get(i);
                        } else {
                            entity = new ProductSalesDelivery();
                            toSalesDelivery.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ClfnProductField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ClfnProductField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnProductField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnProductField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDescription != null ) {
            (values).put("to_Description", toDescription);
        }
        if( toPlant != null ) {
            (values).put("to_Plant", toPlant);
        }
        if( toProductCharc != null ) {
            (values).put("to_ProductCharc", toProductCharc);
        }
        if( toProductClass != null ) {
            (values).put("to_ProductClass", toProductClass);
        }
        if( toProductSalesTax != null ) {
            (values).put("to_ProductSalesTax", toProductSalesTax);
        }
        if( toSalesDelivery != null ) {
            (values).put("to_SalesDelivery", toSalesDelivery);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductDescription</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Description</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductDescription</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductDescription> fetchDescription()
    {
        return fetchFieldAsList("to_Description", ProductDescription.class);
    }

    /**
     * Retrieval of associated <b>ProductDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductDescription</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductDescription> getDescriptionOrFetch()
    {
        if( toDescription == null ) {
            toDescription = fetchDescription();
        }
        return toDescription;
    }

    /**
     * Retrieval of associated <b>ProductDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Description</b> is already loaded, the result will
     *         contain the <b>ProductDescription</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductDescription>> getDescriptionIfPresent()
    {
        return Option.of(toDescription);
    }

    /**
     * Overwrites the list of associated <b>ProductDescription</b> entities for the loaded navigation property
     * <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductDescription</b> entities.
     */
    public void setDescription( @Nonnull final List<ProductDescription> value )
    {
        if( toDescription == null ) {
            toDescription = Lists.newArrayList();
        }
        toDescription.clear();
        toDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductDescription</b> entities. This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductDescription</b> entities.
     */
    public void addDescription( ProductDescription... entity )
    {
        if( toDescription == null ) {
            toDescription = Lists.newArrayList();
        }
        toDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductPlant</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Plant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductPlant</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductPlant> fetchPlant()
    {
        return fetchFieldAsList("to_Plant", ProductPlant.class);
    }

    /**
     * Retrieval of associated <b>ProductPlant</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Plant</b>.
     * <p>
     * If the navigation property <b>to_Plant</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductPlant</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductPlant> getPlantOrFetch()
    {
        if( toPlant == null ) {
            toPlant = fetchPlant();
        }
        return toPlant;
    }

    /**
     * Retrieval of associated <b>ProductPlant</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Plant</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Plant</b> is already loaded, the result will contain the
     *         <b>ProductPlant</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ProductPlant>> getPlantIfPresent()
    {
        return Option.of(toPlant);
    }

    /**
     * Overwrites the list of associated <b>ProductPlant</b> entities for the loaded navigation property
     * <b>to_Plant</b>.
     * <p>
     * If the navigation property <b>to_Plant</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductPlant</b> entities.
     */
    public void setPlant( @Nonnull final List<ProductPlant> value )
    {
        if( toPlant == null ) {
            toPlant = Lists.newArrayList();
        }
        toPlant.clear();
        toPlant.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductPlant</b> entities. This corresponds to the OData navigation
     * property <b>to_Plant</b>.
     * <p>
     * If the navigation property <b>to_Plant</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductPlant</b> entities.
     */
    public void addPlant( ProductPlant... entity )
    {
        if( toPlant == null ) {
            toPlant = Lists.newArrayList();
        }
        toPlant.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductCharc</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProductCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductCharc</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductCharc> fetchProductCharc()
    {
        return fetchFieldAsList("to_ProductCharc", ProductCharc.class);
    }

    /**
     * Retrieval of associated <b>ProductCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductCharc</b>.
     * <p>
     * If the navigation property <b>to_ProductCharc</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductCharc> getProductCharcOrFetch()
    {
        if( toProductCharc == null ) {
            toProductCharc = fetchProductCharc();
        }
        return toProductCharc;
    }

    /**
     * Retrieval of associated <b>ProductCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductCharc</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductCharc</b> is already loaded, the result will
     *         contain the <b>ProductCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductCharc>> getProductCharcIfPresent()
    {
        return Option.of(toProductCharc);
    }

    /**
     * Overwrites the list of associated <b>ProductCharc</b> entities for the loaded navigation property
     * <b>to_ProductCharc</b>.
     * <p>
     * If the navigation property <b>to_ProductCharc</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductCharc</b> entities.
     */
    public void setProductCharc( @Nonnull final List<ProductCharc> value )
    {
        if( toProductCharc == null ) {
            toProductCharc = Lists.newArrayList();
        }
        toProductCharc.clear();
        toProductCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductCharc</b> entities. This corresponds to the OData navigation
     * property <b>to_ProductCharc</b>.
     * <p>
     * If the navigation property <b>to_ProductCharc</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductCharc</b> entities.
     */
    public void addProductCharc( ProductCharc... entity )
    {
        if( toProductCharc == null ) {
            toProductCharc = Lists.newArrayList();
        }
        toProductCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductClass</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProductClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductClass</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductClass> fetchProductClass()
    {
        return fetchFieldAsList("to_ProductClass", ProductClass.class);
    }

    /**
     * Retrieval of associated <b>ProductClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductClass</b>.
     * <p>
     * If the navigation property <b>to_ProductClass</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductClass> getProductClassOrFetch()
    {
        if( toProductClass == null ) {
            toProductClass = fetchProductClass();
        }
        return toProductClass;
    }

    /**
     * Retrieval of associated <b>ProductClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductClass</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductClass</b> is already loaded, the result will
     *         contain the <b>ProductClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductClass>> getProductClassIfPresent()
    {
        return Option.of(toProductClass);
    }

    /**
     * Overwrites the list of associated <b>ProductClass</b> entities for the loaded navigation property
     * <b>to_ProductClass</b>.
     * <p>
     * If the navigation property <b>to_ProductClass</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductClass</b> entities.
     */
    public void setProductClass( @Nonnull final List<ProductClass> value )
    {
        if( toProductClass == null ) {
            toProductClass = Lists.newArrayList();
        }
        toProductClass.clear();
        toProductClass.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductClass</b> entities. This corresponds to the OData navigation
     * property <b>to_ProductClass</b>.
     * <p>
     * If the navigation property <b>to_ProductClass</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductClass</b> entities.
     */
    public void addProductClass( ProductClass... entity )
    {
        if( toProductClass == null ) {
            toProductClass = Lists.newArrayList();
        }
        toProductClass.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductSalesTax</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProductSalesTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductSalesTax</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesTax> fetchProductSalesTax()
    {
        return fetchFieldAsList("to_ProductSalesTax", ProductSalesTax.class);
    }

    /**
     * Retrieval of associated <b>ProductSalesTax</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductSalesTax</b>.
     * <p>
     * If the navigation property <b>to_ProductSalesTax</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductSalesTax</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesTax> getProductSalesTaxOrFetch()
    {
        if( toProductSalesTax == null ) {
            toProductSalesTax = fetchProductSalesTax();
        }
        return toProductSalesTax;
    }

    /**
     * Retrieval of associated <b>ProductSalesTax</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductSalesTax</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductSalesTax</b> is already loaded, the result will
     *         contain the <b>ProductSalesTax</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductSalesTax>> getProductSalesTaxIfPresent()
    {
        return Option.of(toProductSalesTax);
    }

    /**
     * Overwrites the list of associated <b>ProductSalesTax</b> entities for the loaded navigation property
     * <b>to_ProductSalesTax</b>.
     * <p>
     * If the navigation property <b>to_ProductSalesTax</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductSalesTax</b> entities.
     */
    public void setProductSalesTax( @Nonnull final List<ProductSalesTax> value )
    {
        if( toProductSalesTax == null ) {
            toProductSalesTax = Lists.newArrayList();
        }
        toProductSalesTax.clear();
        toProductSalesTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductSalesTax</b> entities. This corresponds to the OData navigation
     * property <b>to_ProductSalesTax</b>.
     * <p>
     * If the navigation property <b>to_ProductSalesTax</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductSalesTax</b> entities.
     */
    public void addProductSalesTax( ProductSalesTax... entity )
    {
        if( toProductSalesTax == null ) {
            toProductSalesTax = Lists.newArrayList();
        }
        toProductSalesTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProductSalesDelivery</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesDelivery</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductSalesDelivery</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesDelivery> fetchSalesDelivery()
    {
        return fetchFieldAsList("to_SalesDelivery", ProductSalesDelivery.class);
    }

    /**
     * Retrieval of associated <b>ProductSalesDelivery</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesDelivery</b>.
     * <p>
     * If the navigation property <b>to_SalesDelivery</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductSalesDelivery</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductSalesDelivery> getSalesDeliveryOrFetch()
    {
        if( toSalesDelivery == null ) {
            toSalesDelivery = fetchSalesDelivery();
        }
        return toSalesDelivery;
    }

    /**
     * Retrieval of associated <b>ProductSalesDelivery</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesDelivery</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesDelivery</b> is already loaded, the result will
     *         contain the <b>ProductSalesDelivery</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductSalesDelivery>> getSalesDeliveryIfPresent()
    {
        return Option.of(toSalesDelivery);
    }

    /**
     * Overwrites the list of associated <b>ProductSalesDelivery</b> entities for the loaded navigation property
     * <b>to_SalesDelivery</b>.
     * <p>
     * If the navigation property <b>to_SalesDelivery</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductSalesDelivery</b> entities.
     */
    public void setSalesDelivery( @Nonnull final List<ProductSalesDelivery> value )
    {
        if( toSalesDelivery == null ) {
            toSalesDelivery = Lists.newArrayList();
        }
        toSalesDelivery.clear();
        toSalesDelivery.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductSalesDelivery</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesDelivery</b>.
     * <p>
     * If the navigation property <b>to_SalesDelivery</b> of a queried <b>ClfnProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductSalesDelivery</b> entities.
     */
    public void addSalesDelivery( ProductSalesDelivery... entity )
    {
        if( toSalesDelivery == null ) {
            toSalesDelivery = Lists.newArrayList();
        }
        toSalesDelivery.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ClfnProduct instances.
     *
     */
    public final static class ClfnProductBuilder
    {

        private List<ProductDescription> toDescription = Lists.newArrayList();
        private List<ProductPlant> toPlant = Lists.newArrayList();
        private List<ProductCharc> toProductCharc = Lists.newArrayList();
        private List<ProductClass> toProductClass = Lists.newArrayList();
        private List<ProductSalesTax> toProductSalesTax = Lists.newArrayList();
        private List<ProductSalesDelivery> toSalesDelivery = Lists.newArrayList();

        private ClfnProduct.ClfnProductBuilder toDescription( final List<ProductDescription> value )
        {
            toDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Description</b> for <b>ClfnProduct</b> to multiple <b>ProductDescription</b>.
         *
         * @param value
         *            The ProductDescriptions to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder description( ProductDescription... value )
        {
            return toDescription(Lists.newArrayList(value));
        }

        private ClfnProduct.ClfnProductBuilder toPlant( final List<ProductPlant> value )
        {
            toPlant.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Plant</b> for <b>ClfnProduct</b> to multiple <b>ProductPlant</b>.
         *
         * @param value
         *            The ProductPlants to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder plant( ProductPlant... value )
        {
            return toPlant(Lists.newArrayList(value));
        }

        private ClfnProduct.ClfnProductBuilder toProductCharc( final List<ProductCharc> value )
        {
            toProductCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductCharc</b> for <b>ClfnProduct</b> to multiple <b>ProductCharc</b>.
         *
         * @param value
         *            The ProductCharcs to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder productCharc( ProductCharc... value )
        {
            return toProductCharc(Lists.newArrayList(value));
        }

        private ClfnProduct.ClfnProductBuilder toProductClass( final List<ProductClass> value )
        {
            toProductClass.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductClass</b> for <b>ClfnProduct</b> to multiple <b>ProductClass</b>.
         *
         * @param value
         *            The ProductClasss to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder productClass( ProductClass... value )
        {
            return toProductClass(Lists.newArrayList(value));
        }

        private ClfnProduct.ClfnProductBuilder toProductSalesTax( final List<ProductSalesTax> value )
        {
            toProductSalesTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductSalesTax</b> for <b>ClfnProduct</b> to multiple <b>ProductSalesTax</b>.
         *
         * @param value
         *            The ProductSalesTaxs to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder productSalesTax( ProductSalesTax... value )
        {
            return toProductSalesTax(Lists.newArrayList(value));
        }

        private ClfnProduct.ClfnProductBuilder toSalesDelivery( final List<ProductSalesDelivery> value )
        {
            toSalesDelivery.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesDelivery</b> for <b>ClfnProduct</b> to multiple <b>ProductSalesDelivery</b>.
         *
         * @param value
         *            The ProductSalesDeliverys to build this ClfnProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnProduct.ClfnProductBuilder salesDelivery( ProductSalesDelivery... value )
        {
            return toSalesDelivery(Lists.newArrayList(value));
        }

    }

}
