/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductClassLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductClassOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable.ProductClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Class Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductClassType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductClass extends VdmEntity<ProductClass>
{

    /**
     * Selector for all available fields of ProductClass.
     *
     */
    public final static ProductClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Key of Object to be Classified
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductClassField<String> PRODUCT = new ProductClassField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ProductClassField<String> CLASS_INTERNAL_ID = new ProductClassField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ProductClassField<LocalDateTime> KEY_DATE = new ProductClassField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ProductClassField<String> CHANGE_NUMBER = new ProductClassField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static ProductClassField<String> CLASS_TYPE = new ProductClassField<String>("ClassType");
    /**
     * Navigation property <b>to_Characteristics</b> for <b>ProductClass</b> to multiple <b>ProductClassCharc</b>.
     *
     */
    @SerializedName( "to_Characteristics" )
    @JsonProperty( "to_Characteristics" )
    @ODataField( odataName = "to_Characteristics" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductClassCharc> toCharacteristics;
    /**
     * Navigation property <b>to_ClassDetails</b> for <b>ProductClass</b> to single <b>ClfnClassForKeyDate</b>.
     *
     */
    @SerializedName( "to_ClassDetails" )
    @JsonProperty( "to_ClassDetails" )
    @ODataField( odataName = "to_ClassDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ClfnClassForKeyDate toClassDetails;
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristics</b> navigation property to query operations.
     *
     */
    public final static ProductClassLink<ProductClassCharc> TO_CHARACTERISTICS =
        new ProductClassLink<ProductClassCharc>("to_Characteristics");
    /**
     * Use with available fluent helpers to apply the <b>to_ClassDetails</b> navigation property to query operations.
     *
     */
    public final static ProductClassOneToOneLink<ClfnClassForKeyDate> TO_CLASS_DETAILS =
        new ProductClassOneToOneLink<ClfnClassForKeyDate>("to_ClassDetails");

    @Nonnull
    @Override
    public Class<ProductClass> getType()
    {
        return ProductClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Key of Object to be Classified
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ClassInternalID", getClassInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ClassInternalID", getClassInternalID());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClassType", getClassType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Characteristics") ) {
                final Object value = (values).remove("to_Characteristics");
                if( value instanceof Iterable ) {
                    if( toCharacteristics == null ) {
                        toCharacteristics = Lists.newArrayList();
                    } else {
                        toCharacteristics = Lists.newArrayList(toCharacteristics);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductClassCharc entity;
                        if( toCharacteristics.size() > i ) {
                            entity = toCharacteristics.get(i);
                        } else {
                            entity = new ProductClassCharc();
                            toCharacteristics.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ClassDetails") ) {
                final Object value = (values).remove("to_ClassDetails");
                if( value instanceof Map ) {
                    if( toClassDetails == null ) {
                        toClassDetails = new ClfnClassForKeyDate();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toClassDetails.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharacteristics != null ) {
            (values).put("to_Characteristics", toCharacteristics);
        }
        if( toClassDetails != null ) {
            (values).put("to_ClassDetails", toClassDetails);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductClassCharc</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Characteristics</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductClassCharc</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductClassCharc> fetchCharacteristics()
    {
        return fetchFieldAsList("to_Characteristics", ProductClassCharc.class);
    }

    /**
     * Retrieval of associated <b>ProductClassCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ProductClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductClassCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductClassCharc> getCharacteristicsOrFetch()
    {
        if( toCharacteristics == null ) {
            toCharacteristics = fetchCharacteristics();
        }
        return toCharacteristics;
    }

    /**
     * Retrieval of associated <b>ProductClassCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property for an entity <b>ProductClass</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristics</b> is already loaded, the result will
     *         contain the <b>ProductClassCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductClassCharc>> getCharacteristicsIfPresent()
    {
        return Option.of(toCharacteristics);
    }

    /**
     * Overwrites the list of associated <b>ProductClassCharc</b> entities for the loaded navigation property
     * <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ProductClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductClassCharc</b> entities.
     */
    public void setCharacteristics( @Nonnull final List<ProductClassCharc> value )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.clear();
        toCharacteristics.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductClassCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ProductClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductClassCharc</b> entities.
     */
    public void addCharacteristics( ProductClassCharc... entity )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnClassForKeyDate</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ClassDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ClfnClassForKeyDate</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate fetchClassDetails()
    {
        return fetchFieldAsSingle("to_ClassDetails", ClfnClassForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ClassDetails</b>.
     * <p>
     * If the navigation property <b>to_ClassDetails</b> of a queried <b>ProductClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassForKeyDate</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate getClassDetailsOrFetch()
    {
        if( toClassDetails == null ) {
            toClassDetails = fetchClassDetails();
        }
        return toClassDetails;
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ClassDetails</b>.
     * <p>
     * If the navigation property for an entity <b>ProductClass</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ClassDetails</b> is already loaded, the result will
     *         contain the <b>ClfnClassForKeyDate</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ClfnClassForKeyDate> getClassDetailsIfPresent()
    {
        return Option.of(toClassDetails);
    }

    /**
     * Overwrites the associated <b>ClfnClassForKeyDate</b> entity for the loaded navigation property
     * <b>to_ClassDetails</b>.
     *
     * @param value
     *            New <b>ClfnClassForKeyDate</b> entity.
     */
    public void setClassDetails( final ClfnClassForKeyDate value )
    {
        toClassDetails = value;
    }

    /**
     * Helper class to allow for fluent creation of ProductClass instances.
     *
     */
    public final static class ProductClassBuilder
    {

        private List<ProductClassCharc> toCharacteristics = Lists.newArrayList();
        private ClfnClassForKeyDate toClassDetails;

        private ProductClass.ProductClassBuilder toCharacteristics( final List<ProductClassCharc> value )
        {
            toCharacteristics.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristics</b> for <b>ProductClass</b> to multiple <b>ProductClassCharc</b>.
         *
         * @param value
         *            The ProductClassCharcs to build this ProductClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductClass.ProductClassBuilder characteristics( ProductClassCharc... value )
        {
            return toCharacteristics(Lists.newArrayList(value));
        }

        private ProductClass.ProductClassBuilder toClassDetails( final ClfnClassForKeyDate value )
        {
            toClassDetails = value;
            return this;
        }

        /**
         * Navigation property <b>to_ClassDetails</b> for <b>ProductClass</b> to single <b>ClfnClassForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassForKeyDate to build this ProductClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductClass.ProductClassBuilder classDetails( final ClfnClassForKeyDate value )
        {
            return toClassDetails(value);
        }

    }

}
