/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductSalesDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable.ProductSalesDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Organization Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductSalesDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductSalesDelivery extends VdmEntity<ProductSalesDelivery>
{

    /**
     * Selector for all available fields of ProductSalesDelivery.
     *
     */
    public final static ProductSalesDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT = new ProductSalesDeliveryField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesOrg</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "ProductSalesOrg" )
    @JsonProperty( "ProductSalesOrg" )
    @Nullable
    @ODataField( odataName = "ProductSalesOrg" )
    private String productSalesOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesOrg</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_SALES_ORG =
        new ProductSalesDeliveryField<String>("ProductSalesOrg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductDistributionChnl</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "ProductDistributionChnl" )
    @JsonProperty( "ProductDistributionChnl" )
    @Nullable
    @ODataField( odataName = "ProductDistributionChnl" )
    private String productDistributionChnl;
    /**
     * Use with available fluent helpers to apply the <b>ProductDistributionChnl</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_DISTRIBUTION_CHNL =
        new ProductSalesDeliveryField<String>("ProductDistributionChnl");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @return Minimum order quantity in base unit of measure
     */
    @SerializedName( "MinimumOrderQuantity" )
    @JsonProperty( "MinimumOrderQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumOrderQuantity" )
    private BigDecimal minimumOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumOrderQuantity</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> MINIMUM_ORDER_QUANTITY =
        new ProductSalesDeliveryField<BigDecimal>("MinimumOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Delivering Plant (Own or External)
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SUPPLYING_PLANT =
        new ProductSalesDeliveryField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceSpecificationProductGroup</b>
     * </p>
     *
     * @return Product Pricing Group
     */
    @SerializedName( "PriceSpecificationProductGroup" )
    @JsonProperty( "PriceSpecificationProductGroup" )
    @Nullable
    @ODataField( odataName = "PriceSpecificationProductGroup" )
    private String priceSpecificationProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>PriceSpecificationProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRICE_SPECIFICATION_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("PriceSpecificationProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountDetnProductGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "AccountDetnProductGroup" )
    @JsonProperty( "AccountDetnProductGroup" )
    @Nullable
    @ODataField( odataName = "AccountDetnProductGroup" )
    private String accountDetnProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>AccountDetnProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> ACCOUNT_DETN_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("AccountDetnProductGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryNoteProcMinDelivQty</b>
     * </p>
     *
     * @return Minimum Delivery Quantity in Delivery Note Processing
     */
    @SerializedName( "DeliveryNoteProcMinDelivQty" )
    @JsonProperty( "DeliveryNoteProcMinDelivQty" )
    @Nullable
    @ODataField( odataName = "DeliveryNoteProcMinDelivQty" )
    private BigDecimal deliveryNoteProcMinDelivQty;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryNoteProcMinDelivQty</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> DELIVERY_NOTE_PROC_MIN_DELIV_QTY =
        new ProductSalesDeliveryField<BigDecimal>("DeliveryNoteProcMinDelivQty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @return Item Category Group from Material Master
     */
    @SerializedName( "ItemCategoryGroup" )
    @JsonProperty( "ItemCategoryGroup" )
    @Nullable
    @ODataField( odataName = "ItemCategoryGroup" )
    private String itemCategoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>ItemCategoryGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> ITEM_CATEGORY_GROUP =
        new ProductSalesDeliveryField<String>("ItemCategoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @return Unit Of Measure Of Delivery Unit
     */
    @SerializedName( "DeliveryQuantityUnit" )
    @JsonProperty( "DeliveryQuantityUnit" )
    @Nullable
    @ODataField( odataName = "DeliveryQuantityUnit" )
    private String deliveryQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryQuantityUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> DELIVERY_QUANTITY_UNIT =
        new ProductSalesDeliveryField<String>("DeliveryQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantity</b>
     * </p>
     *
     * @return Delivery unit
     */
    @SerializedName( "DeliveryQuantity" )
    @JsonProperty( "DeliveryQuantity" )
    @Nullable
    @ODataField( odataName = "DeliveryQuantity" )
    private BigDecimal deliveryQuantity;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryQuantity</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> DELIVERY_QUANTITY =
        new ProductSalesDeliveryField<BigDecimal>("DeliveryQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatus</b>
     * </p>
     *
     * @return Distribution-chain-specific material status
     */
    @SerializedName( "ProductSalesStatus" )
    @JsonProperty( "ProductSalesStatus" )
    @Nullable
    @ODataField( odataName = "ProductSalesStatus" )
    private String productSalesStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesStatus</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_SALES_STATUS =
        new ProductSalesDeliveryField<String>("ProductSalesStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatusValidityDate</b>
     * </p>
     *
     * @return Date from which distr.-chain-spec. material status is valid
     */
    @SerializedName( "ProductSalesStatusValidityDate" )
    @JsonProperty( "ProductSalesStatusValidityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductSalesStatusValidityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productSalesStatusValidityDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductSalesStatusValidityDate</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<LocalDateTime> PRODUCT_SALES_STATUS_VALIDITY_DATE =
        new ProductSalesDeliveryField<LocalDateTime>("ProductSalesStatusValidityDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesMeasureUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "SalesMeasureUnit" )
    @JsonProperty( "SalesMeasureUnit" )
    @Nullable
    @ODataField( odataName = "SalesMeasureUnit" )
    private String salesMeasureUnit;
    /**
     * Use with available fluent helpers to apply the <b>SalesMeasureUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SALES_MEASURE_UNIT =
        new ProductSalesDeliveryField<String>("SalesMeasureUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Ind.: Flag material for deletion at distribution chain level
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductSalesDeliveryField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @return Product Hierarchy
     */
    @SerializedName( "ProductHierarchy" )
    @JsonProperty( "ProductHierarchy" )
    @Nullable
    @ODataField( odataName = "ProductHierarchy" )
    private String productHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ProductHierarchy</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> PRODUCT_HIERARCHY =
        new ProductSalesDeliveryField<String>("ProductHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FirstSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 1
     */
    @SerializedName( "FirstSalesSpecProductGroup" )
    @JsonProperty( "FirstSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FirstSalesSpecProductGroup" )
    private String firstSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FirstSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FIRST_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FirstSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SecondSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 2
     */
    @SerializedName( "SecondSalesSpecProductGroup" )
    @JsonProperty( "SecondSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "SecondSalesSpecProductGroup" )
    private String secondSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SecondSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> SECOND_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("SecondSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ThirdSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 3
     */
    @SerializedName( "ThirdSalesSpecProductGroup" )
    @JsonProperty( "ThirdSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "ThirdSalesSpecProductGroup" )
    private String thirdSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>ThirdSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> THIRD_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("ThirdSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FourthSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 4
     */
    @SerializedName( "FourthSalesSpecProductGroup" )
    @JsonProperty( "FourthSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FourthSalesSpecProductGroup" )
    private String fourthSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FourthSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FOURTH_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FourthSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FifthSalesSpecProductGroup</b>
     * </p>
     *
     * @return Product Group 5
     */
    @SerializedName( "FifthSalesSpecProductGroup" )
    @JsonProperty( "FifthSalesSpecProductGroup" )
    @Nullable
    @ODataField( odataName = "FifthSalesSpecProductGroup" )
    private String fifthSalesSpecProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FifthSalesSpecProductGroup</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> FIFTH_SALES_SPEC_PRODUCT_GROUP =
        new ProductSalesDeliveryField<String>("FifthSalesSpecProductGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumMakeToOrderOrderQty</b>
     * </p>
     *
     * @return Minimum make-to-order quantity
     */
    @SerializedName( "MinimumMakeToOrderOrderQty" )
    @JsonProperty( "MinimumMakeToOrderOrderQty" )
    @Nullable
    @ODataField( odataName = "MinimumMakeToOrderOrderQty" )
    private BigDecimal minimumMakeToOrderOrderQty;
    /**
     * Use with available fluent helpers to apply the <b>MinimumMakeToOrderOrderQty</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<BigDecimal> MINIMUM_MAKE_TO_ORDER_ORDER_QTY =
        new ProductSalesDeliveryField<BigDecimal>("MinimumMakeToOrderOrderQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductSalesDeliveryField<String> BASE_UNIT = new ProductSalesDeliveryField<String>("BaseUnit");

    @Nonnull
    @Override
    public Class<ProductSalesDelivery> getType()
    {
        return ProductSalesDelivery.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesOrg</b>
     * </p>
     *
     * @param productSalesOrg
     *            Sales Organization
     */
    public void setProductSalesOrg( @Nullable final String productSalesOrg )
    {
        rememberChangedField("ProductSalesOrg", this.productSalesOrg);
        this.productSalesOrg = productSalesOrg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductDistributionChnl</b>
     * </p>
     *
     * @param productDistributionChnl
     *            Distribution Channel
     */
    public void setProductDistributionChnl( @Nullable final String productDistributionChnl )
    {
        rememberChangedField("ProductDistributionChnl", this.productDistributionChnl);
        this.productDistributionChnl = productDistributionChnl;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @param minimumOrderQuantity
     *            Minimum order quantity in base unit of measure
     */
    public void setMinimumOrderQuantity( @Nullable final BigDecimal minimumOrderQuantity )
    {
        rememberChangedField("MinimumOrderQuantity", this.minimumOrderQuantity);
        this.minimumOrderQuantity = minimumOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Delivering Plant (Own or External)
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceSpecificationProductGroup</b>
     * </p>
     *
     * @param priceSpecificationProductGroup
     *            Product Pricing Group
     */
    public void setPriceSpecificationProductGroup( @Nullable final String priceSpecificationProductGroup )
    {
        rememberChangedField("PriceSpecificationProductGroup", this.priceSpecificationProductGroup);
        this.priceSpecificationProductGroup = priceSpecificationProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountDetnProductGroup</b>
     * </p>
     *
     * @param accountDetnProductGroup
     *            Account Assignment Group for Material
     */
    public void setAccountDetnProductGroup( @Nullable final String accountDetnProductGroup )
    {
        rememberChangedField("AccountDetnProductGroup", this.accountDetnProductGroup);
        this.accountDetnProductGroup = accountDetnProductGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryNoteProcMinDelivQty</b>
     * </p>
     *
     * @param deliveryNoteProcMinDelivQty
     *            Minimum Delivery Quantity in Delivery Note Processing
     */
    public void setDeliveryNoteProcMinDelivQty( @Nullable final BigDecimal deliveryNoteProcMinDelivQty )
    {
        rememberChangedField("DeliveryNoteProcMinDelivQty", this.deliveryNoteProcMinDelivQty);
        this.deliveryNoteProcMinDelivQty = deliveryNoteProcMinDelivQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ItemCategoryGroup</b>
     * </p>
     *
     * @param itemCategoryGroup
     *            Item Category Group from Material Master
     */
    public void setItemCategoryGroup( @Nullable final String itemCategoryGroup )
    {
        rememberChangedField("ItemCategoryGroup", this.itemCategoryGroup);
        this.itemCategoryGroup = itemCategoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     * </p>
     *
     * @param deliveryQuantityUnit
     *            Unit Of Measure Of Delivery Unit
     */
    public void setDeliveryQuantityUnit( @Nullable final String deliveryQuantityUnit )
    {
        rememberChangedField("DeliveryQuantityUnit", this.deliveryQuantityUnit);
        this.deliveryQuantityUnit = deliveryQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryQuantity</b>
     * </p>
     *
     * @param deliveryQuantity
     *            Delivery unit
     */
    public void setDeliveryQuantity( @Nullable final BigDecimal deliveryQuantity )
    {
        rememberChangedField("DeliveryQuantity", this.deliveryQuantity);
        this.deliveryQuantity = deliveryQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatus</b>
     * </p>
     *
     * @param productSalesStatus
     *            Distribution-chain-specific material status
     */
    public void setProductSalesStatus( @Nullable final String productSalesStatus )
    {
        rememberChangedField("ProductSalesStatus", this.productSalesStatus);
        this.productSalesStatus = productSalesStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductSalesStatusValidityDate</b>
     * </p>
     *
     * @param productSalesStatusValidityDate
     *            Date from which distr.-chain-spec. material status is valid
     */
    public void setProductSalesStatusValidityDate( @Nullable final LocalDateTime productSalesStatusValidityDate )
    {
        rememberChangedField("ProductSalesStatusValidityDate", this.productSalesStatusValidityDate);
        this.productSalesStatusValidityDate = productSalesStatusValidityDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesMeasureUnit</b>
     * </p>
     *
     * @param salesMeasureUnit
     *            Sales Unit
     */
    public void setSalesMeasureUnit( @Nullable final String salesMeasureUnit )
    {
        rememberChangedField("SalesMeasureUnit", this.salesMeasureUnit);
        this.salesMeasureUnit = salesMeasureUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Ind.: Flag material for deletion at distribution chain level
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     *
     * @param productHierarchy
     *            Product Hierarchy
     */
    public void setProductHierarchy( @Nullable final String productHierarchy )
    {
        rememberChangedField("ProductHierarchy", this.productHierarchy);
        this.productHierarchy = productHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FirstSalesSpecProductGroup</b>
     * </p>
     *
     * @param firstSalesSpecProductGroup
     *            Product Group 1
     */
    public void setFirstSalesSpecProductGroup( @Nullable final String firstSalesSpecProductGroup )
    {
        rememberChangedField("FirstSalesSpecProductGroup", this.firstSalesSpecProductGroup);
        this.firstSalesSpecProductGroup = firstSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SecondSalesSpecProductGroup</b>
     * </p>
     *
     * @param secondSalesSpecProductGroup
     *            Product Group 2
     */
    public void setSecondSalesSpecProductGroup( @Nullable final String secondSalesSpecProductGroup )
    {
        rememberChangedField("SecondSalesSpecProductGroup", this.secondSalesSpecProductGroup);
        this.secondSalesSpecProductGroup = secondSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ThirdSalesSpecProductGroup</b>
     * </p>
     *
     * @param thirdSalesSpecProductGroup
     *            Product Group 3
     */
    public void setThirdSalesSpecProductGroup( @Nullable final String thirdSalesSpecProductGroup )
    {
        rememberChangedField("ThirdSalesSpecProductGroup", this.thirdSalesSpecProductGroup);
        this.thirdSalesSpecProductGroup = thirdSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FourthSalesSpecProductGroup</b>
     * </p>
     *
     * @param fourthSalesSpecProductGroup
     *            Product Group 4
     */
    public void setFourthSalesSpecProductGroup( @Nullable final String fourthSalesSpecProductGroup )
    {
        rememberChangedField("FourthSalesSpecProductGroup", this.fourthSalesSpecProductGroup);
        this.fourthSalesSpecProductGroup = fourthSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FifthSalesSpecProductGroup</b>
     * </p>
     *
     * @param fifthSalesSpecProductGroup
     *            Product Group 5
     */
    public void setFifthSalesSpecProductGroup( @Nullable final String fifthSalesSpecProductGroup )
    {
        rememberChangedField("FifthSalesSpecProductGroup", this.fifthSalesSpecProductGroup);
        this.fifthSalesSpecProductGroup = fifthSalesSpecProductGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumMakeToOrderOrderQty</b>
     * </p>
     *
     * @param minimumMakeToOrderOrderQty
     *            Minimum make-to-order quantity
     */
    public void setMinimumMakeToOrderOrderQty( @Nullable final BigDecimal minimumMakeToOrderOrderQty )
    {
        rememberChangedField("MinimumMakeToOrderOrderQty", this.minimumMakeToOrderOrderQty);
        this.minimumMakeToOrderOrderQty = minimumMakeToOrderOrderQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductSalesDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("ProductSalesOrg", getProductSalesOrg());
        result.put("ProductDistributionChnl", getProductDistributionChnl());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("ProductSalesOrg", getProductSalesOrg());
        values.put("ProductDistributionChnl", getProductDistributionChnl());
        values.put("MinimumOrderQuantity", getMinimumOrderQuantity());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("PriceSpecificationProductGroup", getPriceSpecificationProductGroup());
        values.put("AccountDetnProductGroup", getAccountDetnProductGroup());
        values.put("DeliveryNoteProcMinDelivQty", getDeliveryNoteProcMinDelivQty());
        values.put("ItemCategoryGroup", getItemCategoryGroup());
        values.put("DeliveryQuantityUnit", getDeliveryQuantityUnit());
        values.put("DeliveryQuantity", getDeliveryQuantity());
        values.put("ProductSalesStatus", getProductSalesStatus());
        values.put("ProductSalesStatusValidityDate", getProductSalesStatusValidityDate());
        values.put("SalesMeasureUnit", getSalesMeasureUnit());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("ProductHierarchy", getProductHierarchy());
        values.put("FirstSalesSpecProductGroup", getFirstSalesSpecProductGroup());
        values.put("SecondSalesSpecProductGroup", getSecondSalesSpecProductGroup());
        values.put("ThirdSalesSpecProductGroup", getThirdSalesSpecProductGroup());
        values.put("FourthSalesSpecProductGroup", getFourthSalesSpecProductGroup());
        values.put("FifthSalesSpecProductGroup", getFifthSalesSpecProductGroup());
        values.put("MinimumMakeToOrderOrderQty", getMinimumMakeToOrderOrderQty());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("ProductSalesOrg") ) {
                final Object value = values.remove("ProductSalesOrg");
                if( (value == null) || (!value.equals(getProductSalesOrg())) ) {
                    setProductSalesOrg(((String) value));
                }
            }
            if( values.containsKey("ProductDistributionChnl") ) {
                final Object value = values.remove("ProductDistributionChnl");
                if( (value == null) || (!value.equals(getProductDistributionChnl())) ) {
                    setProductDistributionChnl(((String) value));
                }
            }
            if( values.containsKey("MinimumOrderQuantity") ) {
                final Object value = values.remove("MinimumOrderQuantity");
                if( (value == null) || (!value.equals(getMinimumOrderQuantity())) ) {
                    setMinimumOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("PriceSpecificationProductGroup") ) {
                final Object value = values.remove("PriceSpecificationProductGroup");
                if( (value == null) || (!value.equals(getPriceSpecificationProductGroup())) ) {
                    setPriceSpecificationProductGroup(((String) value));
                }
            }
            if( values.containsKey("AccountDetnProductGroup") ) {
                final Object value = values.remove("AccountDetnProductGroup");
                if( (value == null) || (!value.equals(getAccountDetnProductGroup())) ) {
                    setAccountDetnProductGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryNoteProcMinDelivQty") ) {
                final Object value = values.remove("DeliveryNoteProcMinDelivQty");
                if( (value == null) || (!value.equals(getDeliveryNoteProcMinDelivQty())) ) {
                    setDeliveryNoteProcMinDelivQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemCategoryGroup") ) {
                final Object value = values.remove("ItemCategoryGroup");
                if( (value == null) || (!value.equals(getItemCategoryGroup())) ) {
                    setItemCategoryGroup(((String) value));
                }
            }
            if( values.containsKey("DeliveryQuantityUnit") ) {
                final Object value = values.remove("DeliveryQuantityUnit");
                if( (value == null) || (!value.equals(getDeliveryQuantityUnit())) ) {
                    setDeliveryQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("DeliveryQuantity") ) {
                final Object value = values.remove("DeliveryQuantity");
                if( (value == null) || (!value.equals(getDeliveryQuantity())) ) {
                    setDeliveryQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductSalesStatus") ) {
                final Object value = values.remove("ProductSalesStatus");
                if( (value == null) || (!value.equals(getProductSalesStatus())) ) {
                    setProductSalesStatus(((String) value));
                }
            }
            if( values.containsKey("ProductSalesStatusValidityDate") ) {
                final Object value = values.remove("ProductSalesStatusValidityDate");
                if( (value == null) || (!value.equals(getProductSalesStatusValidityDate())) ) {
                    setProductSalesStatusValidityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesMeasureUnit") ) {
                final Object value = values.remove("SalesMeasureUnit");
                if( (value == null) || (!value.equals(getSalesMeasureUnit())) ) {
                    setSalesMeasureUnit(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("ProductHierarchy") ) {
                final Object value = values.remove("ProductHierarchy");
                if( (value == null) || (!value.equals(getProductHierarchy())) ) {
                    setProductHierarchy(((String) value));
                }
            }
            if( values.containsKey("FirstSalesSpecProductGroup") ) {
                final Object value = values.remove("FirstSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFirstSalesSpecProductGroup())) ) {
                    setFirstSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("SecondSalesSpecProductGroup") ) {
                final Object value = values.remove("SecondSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getSecondSalesSpecProductGroup())) ) {
                    setSecondSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("ThirdSalesSpecProductGroup") ) {
                final Object value = values.remove("ThirdSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getThirdSalesSpecProductGroup())) ) {
                    setThirdSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("FourthSalesSpecProductGroup") ) {
                final Object value = values.remove("FourthSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFourthSalesSpecProductGroup())) ) {
                    setFourthSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("FifthSalesSpecProductGroup") ) {
                final Object value = values.remove("FifthSalesSpecProductGroup");
                if( (value == null) || (!value.equals(getFifthSalesSpecProductGroup())) ) {
                    setFifthSalesSpecProductGroup(((String) value));
                }
            }
            if( values.containsKey("MinimumMakeToOrderOrderQty") ) {
                final Object value = values.remove("MinimumMakeToOrderOrderQty");
                if( (value == null) || (!value.equals(getMinimumMakeToOrderOrderQty())) ) {
                    setMinimumMakeToOrderOrderQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductSalesDeliveryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductSalesDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductSalesDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductSalesDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH);
    }

}
