/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductSupplyPlanningField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable.ProductSupplyPlanningSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supply Planning Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductSupplyPlanningType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductSupplyPlanning extends VdmEntity<ProductSupplyPlanning>
{

    /**
     * Selector for all available fields of ProductSupplyPlanning.
     *
     */
    public final static ProductSupplyPlanningSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PRODUCT = new ProductSupplyPlanningField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANT = new ProductSupplyPlanningField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @return Fixed lot size
     */
    @SerializedName( "FixedLotSizeQuantity" )
    @JsonProperty( "FixedLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "FixedLotSizeQuantity" )
    private BigDecimal fixedLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> FIXED_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("FixedLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size
     */
    @SerializedName( "MaximumLotSizeQuantity" )
    @JsonProperty( "MaximumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumLotSizeQuantity" )
    private BigDecimal maximumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MAXIMUM_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MaximumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size
     */
    @SerializedName( "MinimumLotSizeQuantity" )
    @JsonProperty( "MinimumLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumLotSizeQuantity" )
    private BigDecimal minimumLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumLotSizeQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MINIMUM_LOT_SIZE_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MinimumLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @return Rounding value for purchase order quantity
     */
    @SerializedName( "LotSizeRoundingQuantity" )
    @JsonProperty( "LotSizeRoundingQuantity" )
    @Nullable
    @ODataField( odataName = "LotSizeRoundingQuantity" )
    private BigDecimal lotSizeRoundingQuantity;
    /**
     * Use with available fluent helpers to apply the <b>LotSizeRoundingQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> LOT_SIZE_ROUNDING_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("LotSizeRoundingQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @return Lot Sizing Procedure in Materials Planning
     */
    @SerializedName( "LotSizingProcedure" )
    @JsonProperty( "LotSizingProcedure" )
    @Nullable
    @ODataField( odataName = "LotSizingProcedure" )
    private String lotSizingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>LotSizingProcedure</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> LOT_SIZING_PROCEDURE =
        new ProductSupplyPlanningField<String>("LotSizingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @return MRP Type
     */
    @SerializedName( "MRPType" )
    @JsonProperty( "MRPType" )
    @Nullable
    @ODataField( odataName = "MRPType" )
    private String mRPType;
    /**
     * Use with available fluent helpers to apply the <b>MRPType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_TYPE = new ProductSupplyPlanningField<String>("MRPType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPResponsible" )
    @JsonProperty( "MRPResponsible" )
    @Nullable
    @ODataField( odataName = "MRPResponsible" )
    private String mRPResponsible;
    /**
     * Use with available fluent helpers to apply the <b>MRPResponsible</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_RESPONSIBLE =
        new ProductSupplyPlanningField<String>("MRPResponsible");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @return Safety Stock
     */
    @SerializedName( "SafetyStockQuantity" )
    @JsonProperty( "SafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "SafetyStockQuantity" )
    private BigDecimal safetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SafetyStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> SAFETY_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("SafetyStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumSafetyStockQuantity</b>
     * </p>
     *
     * @return Minimum Safety Stock
     */
    @SerializedName( "MinimumSafetyStockQuantity" )
    @JsonProperty( "MinimumSafetyStockQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumSafetyStockQuantity" )
    private BigDecimal minimumSafetyStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumSafetyStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MINIMUM_SAFETY_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MinimumSafetyStockQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @return Planning time fence
     */
    @SerializedName( "PlanningTimeFence" )
    @JsonProperty( "PlanningTimeFence" )
    @Nullable
    @ODataField( odataName = "PlanningTimeFence" )
    private String planningTimeFence;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTimeFence</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANNING_TIME_FENCE =
        new ProductSupplyPlanningField<String>("PlanningTimeFence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> ABC_INDICATOR =
        new ProductSupplyPlanningField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @return Maximum Stock Level
     */
    @SerializedName( "MaximumStockQuantity" )
    @JsonProperty( "MaximumStockQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumStockQuantity" )
    private BigDecimal maximumStockQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumStockQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> MAXIMUM_STOCK_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("MaximumStockQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @return Reorder Point
     */
    @SerializedName( "ReorderThresholdQuantity" )
    @JsonProperty( "ReorderThresholdQuantity" )
    @Nullable
    @ODataField( odataName = "ReorderThresholdQuantity" )
    private BigDecimal reorderThresholdQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReorderThresholdQuantity</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> REORDER_THRESHOLD_QUANTITY =
        new ProductSupplyPlanningField<BigDecimal>("ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDurationInDays" )
    @JsonProperty( "PlannedDeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDurationInDays" )
    private BigDecimal plannedDeliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> PLANNED_DELIVERY_DURATION_IN_DAYS =
        new ProductSupplyPlanningField<BigDecimal>("PlannedDeliveryDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @return Safety Time (in Workdays)
     */
    @SerializedName( "SafetyDuration" )
    @JsonProperty( "SafetyDuration" )
    @Nullable
    @ODataField( odataName = "SafetyDuration" )
    private String safetyDuration;
    /**
     * Use with available fluent helpers to apply the <b>SafetyDuration</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> SAFETY_DURATION =
        new ProductSupplyPlanningField<String>("SafetyDuration");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @return Planning Strategy Group
     */
    @SerializedName( "PlanningStrategyGroup" )
    @JsonProperty( "PlanningStrategyGroup" )
    @Nullable
    @ODataField( odataName = "PlanningStrategyGroup" )
    private String planningStrategyGroup;
    /**
     * Use with available fluent helpers to apply the <b>PlanningStrategyGroup</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PLANNING_STRATEGY_GROUP =
        new ProductSupplyPlanningField<String>("PlanningStrategyGroup");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadTime</b>
     * </p>
     *
     * @return Total replenishment lead time (in workdays)
     */
    @SerializedName( "TotalReplenishmentLeadTime" )
    @JsonProperty( "TotalReplenishmentLeadTime" )
    @Nullable
    @ODataField( odataName = "TotalReplenishmentLeadTime" )
    private BigDecimal totalReplenishmentLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>TotalReplenishmentLeadTime</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> TOTAL_REPLENISHMENT_LEAD_TIME =
        new ProductSupplyPlanningField<BigDecimal>("TotalReplenishmentLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "ProcurementType" )
    @JsonProperty( "ProcurementType" )
    @Nullable
    @ODataField( odataName = "ProcurementType" )
    private String procurementType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROCUREMENT_TYPE =
        new ProductSupplyPlanningField<String>("ProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @return Special Procurement Type
     */
    @SerializedName( "ProcurementSubType" )
    @JsonProperty( "ProcurementSubType" )
    @Nullable
    @ODataField( odataName = "ProcurementSubType" )
    private String procurementSubType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementSubType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> PROCUREMENT_SUB_TYPE =
        new ProductSupplyPlanningField<String>("ProcurementSubType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @return Assembly scrap in percent
     */
    @SerializedName( "AssemblyScrapPercent" )
    @JsonProperty( "AssemblyScrapPercent" )
    @Nullable
    @ODataField( odataName = "AssemblyScrapPercent" )
    private BigDecimal assemblyScrapPercent;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyScrapPercent</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> ASSEMBLY_SCRAP_PERCENT =
        new ProductSupplyPlanningField<BigDecimal>("AssemblyScrapPercent");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @return Checking Group for Availability Check
     */
    @SerializedName( "AvailabilityCheckType" )
    @JsonProperty( "AvailabilityCheckType" )
    @Nullable
    @ODataField( odataName = "AvailabilityCheckType" )
    private String availabilityCheckType;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityCheckType</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> AVAILABILITY_CHECK_TYPE =
        new ProductSupplyPlanningField<String>("AvailabilityCheckType");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<BigDecimal> GOODS_RECEIPT_DURATION =
        new ProductSupplyPlanningField<BigDecimal>("GoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @return MRP Group
     */
    @SerializedName( "MRPGroup" )
    @JsonProperty( "MRPGroup" )
    @Nullable
    @ODataField( odataName = "MRPGroup" )
    private String mRPGroup;
    /**
     * Use with available fluent helpers to apply the <b>MRPGroup</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> MRP_GROUP =
        new ProductSupplyPlanningField<String>("MRPGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductSupplyPlanningField<String> BASE_UNIT =
        new ProductSupplyPlanningField<String>("BaseUnit");

    @Nonnull
    @Override
    public Class<ProductSupplyPlanning> getType()
    {
        return ProductSupplyPlanning.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedLotSizeQuantity</b>
     * </p>
     *
     * @param fixedLotSizeQuantity
     *            Fixed lot size
     */
    public void setFixedLotSizeQuantity( @Nullable final BigDecimal fixedLotSizeQuantity )
    {
        rememberChangedField("FixedLotSizeQuantity", this.fixedLotSizeQuantity);
        this.fixedLotSizeQuantity = fixedLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumLotSizeQuantity</b>
     * </p>
     *
     * @param maximumLotSizeQuantity
     *            Maximum Lot Size
     */
    public void setMaximumLotSizeQuantity( @Nullable final BigDecimal maximumLotSizeQuantity )
    {
        rememberChangedField("MaximumLotSizeQuantity", this.maximumLotSizeQuantity);
        this.maximumLotSizeQuantity = maximumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumLotSizeQuantity</b>
     * </p>
     *
     * @param minimumLotSizeQuantity
     *            Minimum Lot Size
     */
    public void setMinimumLotSizeQuantity( @Nullable final BigDecimal minimumLotSizeQuantity )
    {
        rememberChangedField("MinimumLotSizeQuantity", this.minimumLotSizeQuantity);
        this.minimumLotSizeQuantity = minimumLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LotSizeRoundingQuantity</b>
     * </p>
     *
     * @param lotSizeRoundingQuantity
     *            Rounding value for purchase order quantity
     */
    public void setLotSizeRoundingQuantity( @Nullable final BigDecimal lotSizeRoundingQuantity )
    {
        rememberChangedField("LotSizeRoundingQuantity", this.lotSizeRoundingQuantity);
        this.lotSizeRoundingQuantity = lotSizeRoundingQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LotSizingProcedure</b>
     * </p>
     *
     * @param lotSizingProcedure
     *            Lot Sizing Procedure in Materials Planning
     */
    public void setLotSizingProcedure( @Nullable final String lotSizingProcedure )
    {
        rememberChangedField("LotSizingProcedure", this.lotSizingProcedure);
        this.lotSizingProcedure = lotSizingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MRPType</b>
     * </p>
     *
     * @param mRPType
     *            MRP Type
     */
    public void setMRPType( @Nullable final String mRPType )
    {
        rememberChangedField("MRPType", this.mRPType);
        this.mRPType = mRPType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPResponsible</b>
     * </p>
     *
     * @param mRPResponsible
     *            MRP Controller
     */
    public void setMRPResponsible( @Nullable final String mRPResponsible )
    {
        rememberChangedField("MRPResponsible", this.mRPResponsible);
        this.mRPResponsible = mRPResponsible;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SafetyStockQuantity</b>
     * </p>
     *
     * @param safetyStockQuantity
     *            Safety Stock
     */
    public void setSafetyStockQuantity( @Nullable final BigDecimal safetyStockQuantity )
    {
        rememberChangedField("SafetyStockQuantity", this.safetyStockQuantity);
        this.safetyStockQuantity = safetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumSafetyStockQuantity</b>
     * </p>
     *
     * @param minimumSafetyStockQuantity
     *            Minimum Safety Stock
     */
    public void setMinimumSafetyStockQuantity( @Nullable final BigDecimal minimumSafetyStockQuantity )
    {
        rememberChangedField("MinimumSafetyStockQuantity", this.minimumSafetyStockQuantity);
        this.minimumSafetyStockQuantity = minimumSafetyStockQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTimeFence</b>
     * </p>
     *
     * @param planningTimeFence
     *            Planning time fence
     */
    public void setPlanningTimeFence( @Nullable final String planningTimeFence )
    {
        rememberChangedField("PlanningTimeFence", this.planningTimeFence);
        this.planningTimeFence = planningTimeFence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumStockQuantity</b>
     * </p>
     *
     * @param maximumStockQuantity
     *            Maximum Stock Level
     */
    public void setMaximumStockQuantity( @Nullable final BigDecimal maximumStockQuantity )
    {
        rememberChangedField("MaximumStockQuantity", this.maximumStockQuantity);
        this.maximumStockQuantity = maximumStockQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @param reorderThresholdQuantity
     *            Reorder Point
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @param plannedDeliveryDurationInDays
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDurationInDays( @Nullable final BigDecimal plannedDeliveryDurationInDays )
    {
        rememberChangedField("PlannedDeliveryDurationInDays", this.plannedDeliveryDurationInDays);
        this.plannedDeliveryDurationInDays = plannedDeliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetyDuration</b>
     * </p>
     *
     * @param safetyDuration
     *            Safety Time (in Workdays)
     */
    public void setSafetyDuration( @Nullable final String safetyDuration )
    {
        rememberChangedField("SafetyDuration", this.safetyDuration);
        this.safetyDuration = safetyDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningStrategyGroup</b>
     * </p>
     *
     * @param planningStrategyGroup
     *            Planning Strategy Group
     */
    public void setPlanningStrategyGroup( @Nullable final String planningStrategyGroup )
    {
        rememberChangedField("PlanningStrategyGroup", this.planningStrategyGroup);
        this.planningStrategyGroup = planningStrategyGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReplenishmentLeadTime</b>
     * </p>
     *
     * @param totalReplenishmentLeadTime
     *            Total replenishment lead time (in workdays)
     */
    public void setTotalReplenishmentLeadTime( @Nullable final BigDecimal totalReplenishmentLeadTime )
    {
        rememberChangedField("TotalReplenishmentLeadTime", this.totalReplenishmentLeadTime);
        this.totalReplenishmentLeadTime = totalReplenishmentLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @param procurementType
     *            Procurement Type
     */
    public void setProcurementType( @Nullable final String procurementType )
    {
        rememberChangedField("ProcurementType", this.procurementType);
        this.procurementType = procurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementSubType</b>
     * </p>
     *
     * @param procurementSubType
     *            Special Procurement Type
     */
    public void setProcurementSubType( @Nullable final String procurementSubType )
    {
        rememberChangedField("ProcurementSubType", this.procurementSubType);
        this.procurementSubType = procurementSubType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyScrapPercent</b>
     * </p>
     *
     * @param assemblyScrapPercent
     *            Assembly scrap in percent
     */
    public void setAssemblyScrapPercent( @Nullable final BigDecimal assemblyScrapPercent )
    {
        rememberChangedField("AssemblyScrapPercent", this.assemblyScrapPercent);
        this.assemblyScrapPercent = assemblyScrapPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityCheckType</b>
     * </p>
     *
     * @param availabilityCheckType
     *            Checking Group for Availability Check
     */
    public void setAvailabilityCheckType( @Nullable final String availabilityCheckType )
    {
        rememberChangedField("AvailabilityCheckType", this.availabilityCheckType);
        this.availabilityCheckType = availabilityCheckType;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPGroup</b>
     * </p>
     *
     * @param mRPGroup
     *            MRP Group
     */
    public void setMRPGroup( @Nullable final String mRPGroup )
    {
        rememberChangedField("MRPGroup", this.mRPGroup);
        this.mRPGroup = mRPGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductSupplyPlanning";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("FixedLotSizeQuantity", getFixedLotSizeQuantity());
        values.put("MaximumLotSizeQuantity", getMaximumLotSizeQuantity());
        values.put("MinimumLotSizeQuantity", getMinimumLotSizeQuantity());
        values.put("LotSizeRoundingQuantity", getLotSizeRoundingQuantity());
        values.put("LotSizingProcedure", getLotSizingProcedure());
        values.put("MRPType", getMRPType());
        values.put("MRPResponsible", getMRPResponsible());
        values.put("SafetyStockQuantity", getSafetyStockQuantity());
        values.put("MinimumSafetyStockQuantity", getMinimumSafetyStockQuantity());
        values.put("PlanningTimeFence", getPlanningTimeFence());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MaximumStockQuantity", getMaximumStockQuantity());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("PlannedDeliveryDurationInDays", getPlannedDeliveryDurationInDays());
        values.put("SafetyDuration", getSafetyDuration());
        values.put("PlanningStrategyGroup", getPlanningStrategyGroup());
        values.put("TotalReplenishmentLeadTime", getTotalReplenishmentLeadTime());
        values.put("ProcurementType", getProcurementType());
        values.put("ProcurementSubType", getProcurementSubType());
        values.put("AssemblyScrapPercent", getAssemblyScrapPercent());
        values.put("AvailabilityCheckType", getAvailabilityCheckType());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("MRPGroup", getMRPGroup());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("FixedLotSizeQuantity") ) {
                final Object value = values.remove("FixedLotSizeQuantity");
                if( (value == null) || (!value.equals(getFixedLotSizeQuantity())) ) {
                    setFixedLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumLotSizeQuantity") ) {
                final Object value = values.remove("MaximumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaximumLotSizeQuantity())) ) {
                    setMaximumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinimumLotSizeQuantity") ) {
                final Object value = values.remove("MinimumLotSizeQuantity");
                if( (value == null) || (!value.equals(getMinimumLotSizeQuantity())) ) {
                    setMinimumLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizeRoundingQuantity") ) {
                final Object value = values.remove("LotSizeRoundingQuantity");
                if( (value == null) || (!value.equals(getLotSizeRoundingQuantity())) ) {
                    setLotSizeRoundingQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("LotSizingProcedure") ) {
                final Object value = values.remove("LotSizingProcedure");
                if( (value == null) || (!value.equals(getLotSizingProcedure())) ) {
                    setLotSizingProcedure(((String) value));
                }
            }
            if( values.containsKey("MRPType") ) {
                final Object value = values.remove("MRPType");
                if( (value == null) || (!value.equals(getMRPType())) ) {
                    setMRPType(((String) value));
                }
            }
            if( values.containsKey("MRPResponsible") ) {
                final Object value = values.remove("MRPResponsible");
                if( (value == null) || (!value.equals(getMRPResponsible())) ) {
                    setMRPResponsible(((String) value));
                }
            }
            if( values.containsKey("SafetyStockQuantity") ) {
                final Object value = values.remove("SafetyStockQuantity");
                if( (value == null) || (!value.equals(getSafetyStockQuantity())) ) {
                    setSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinimumSafetyStockQuantity") ) {
                final Object value = values.remove("MinimumSafetyStockQuantity");
                if( (value == null) || (!value.equals(getMinimumSafetyStockQuantity())) ) {
                    setMinimumSafetyStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlanningTimeFence") ) {
                final Object value = values.remove("PlanningTimeFence");
                if( (value == null) || (!value.equals(getPlanningTimeFence())) ) {
                    setPlanningTimeFence(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MaximumStockQuantity") ) {
                final Object value = values.remove("MaximumStockQuantity");
                if( (value == null) || (!value.equals(getMaximumStockQuantity())) ) {
                    setMaximumStockQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDurationInDays") ) {
                final Object value = values.remove("PlannedDeliveryDurationInDays");
                if( (value == null) || (!value.equals(getPlannedDeliveryDurationInDays())) ) {
                    setPlannedDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SafetyDuration") ) {
                final Object value = values.remove("SafetyDuration");
                if( (value == null) || (!value.equals(getSafetyDuration())) ) {
                    setSafetyDuration(((String) value));
                }
            }
            if( values.containsKey("PlanningStrategyGroup") ) {
                final Object value = values.remove("PlanningStrategyGroup");
                if( (value == null) || (!value.equals(getPlanningStrategyGroup())) ) {
                    setPlanningStrategyGroup(((String) value));
                }
            }
            if( values.containsKey("TotalReplenishmentLeadTime") ) {
                final Object value = values.remove("TotalReplenishmentLeadTime");
                if( (value == null) || (!value.equals(getTotalReplenishmentLeadTime())) ) {
                    setTotalReplenishmentLeadTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProcurementType") ) {
                final Object value = values.remove("ProcurementType");
                if( (value == null) || (!value.equals(getProcurementType())) ) {
                    setProcurementType(((String) value));
                }
            }
            if( values.containsKey("ProcurementSubType") ) {
                final Object value = values.remove("ProcurementSubType");
                if( (value == null) || (!value.equals(getProcurementSubType())) ) {
                    setProcurementSubType(((String) value));
                }
            }
            if( values.containsKey("AssemblyScrapPercent") ) {
                final Object value = values.remove("AssemblyScrapPercent");
                if( (value == null) || (!value.equals(getAssemblyScrapPercent())) ) {
                    setAssemblyScrapPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("AvailabilityCheckType") ) {
                final Object value = values.remove("AvailabilityCheckType");
                if( (value == null) || (!value.equals(getAvailabilityCheckType())) ) {
                    setAvailabilityCheckType(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("MRPGroup") ) {
                final Object value = values.remove("MRPGroup");
                if( (value == null) || (!value.equals(getMRPGroup())) ) {
                    setMRPGroup(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductSupplyPlanningField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductSupplyPlanningField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductSupplyPlanningField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductSupplyPlanningField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH);
    }

}
