/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductWorkSchedulingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable.ProductWorkSchedulingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Work Scheduling Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductWorkSchedulingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductWorkScheduling extends VdmEntity<ProductWorkScheduling>
{

    /**
     * Selector for all available fields of ProductWorkScheduling.
     *
     */
    public final static ProductWorkSchedulingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<String> PRODUCT = new ProductWorkSchedulingField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<String> PLANT = new ProductWorkSchedulingField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseQuantity</b>
     * </p>
     *
     * @return Base quantity
     */
    @SerializedName( "MaterialBaseQuantity" )
    @JsonProperty( "MaterialBaseQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialBaseQuantity" )
    private BigDecimal materialBaseQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseQuantity</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<BigDecimal> MATERIAL_BASE_QUANTITY =
        new ProductWorkSchedulingField<BigDecimal>("MaterialBaseQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverDelivIsAllowed</b>
     * </p>
     *
     * @return Indicator: Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverDelivIsAllowed" )
    @JsonProperty( "UnlimitedOverDelivIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverDelivIsAllowed" )
    private Boolean unlimitedOverDelivIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverDelivIsAllowed</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<Boolean> UNLIMITED_OVER_DELIV_IS_ALLOWED =
        new ProductWorkSchedulingField<Boolean>("UnlimitedOverDelivIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverDelivToleranceLimit</b>
     * </p>
     *
     * @return Overdelivery tolerance limit
     */
    @SerializedName( "OverDelivToleranceLimit" )
    @JsonProperty( "OverDelivToleranceLimit" )
    @Nullable
    @ODataField( odataName = "OverDelivToleranceLimit" )
    private BigDecimal overDelivToleranceLimit;
    /**
     * Use with available fluent helpers to apply the <b>OverDelivToleranceLimit</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<BigDecimal> OVER_DELIV_TOLERANCE_LIMIT =
        new ProductWorkSchedulingField<BigDecimal>("OverDelivToleranceLimit");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderDelivToleranceLimit</b>
     * </p>
     *
     * @return Underdelivery tolerance limit
     */
    @SerializedName( "UnderDelivToleranceLimit" )
    @JsonProperty( "UnderDelivToleranceLimit" )
    @Nullable
    @ODataField( odataName = "UnderDelivToleranceLimit" )
    private BigDecimal underDelivToleranceLimit;
    /**
     * Use with available fluent helpers to apply the <b>UnderDelivToleranceLimit</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<BigDecimal> UNDER_DELIV_TOLERANCE_LIMIT =
        new ProductWorkSchedulingField<BigDecimal>("UnderDelivToleranceLimit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @return Issue Storage Location
     */
    @SerializedName( "ProductionInvtryManagedLoc" )
    @JsonProperty( "ProductionInvtryManagedLoc" )
    @Nullable
    @ODataField( odataName = "ProductionInvtryManagedLoc" )
    private String productionInvtryManagedLoc;
    /**
     * Use with available fluent helpers to apply the <b>ProductionInvtryManagedLoc</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<String> PRODUCTION_INVTRY_MANAGED_LOC =
        new ProductWorkSchedulingField<String>("ProductionInvtryManagedLoc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductWorkSchedulingField<String> BASE_UNIT =
        new ProductWorkSchedulingField<String>("BaseUnit");

    @Nonnull
    @Override
    public Class<ProductWorkScheduling> getType()
    {
        return ProductWorkScheduling.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseQuantity</b>
     * </p>
     *
     * @param materialBaseQuantity
     *            Base quantity
     */
    public void setMaterialBaseQuantity( @Nullable final BigDecimal materialBaseQuantity )
    {
        rememberChangedField("MaterialBaseQuantity", this.materialBaseQuantity);
        this.materialBaseQuantity = materialBaseQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverDelivIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverDelivIsAllowed
     *            Indicator: Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverDelivIsAllowed( @Nullable final Boolean unlimitedOverDelivIsAllowed )
    {
        rememberChangedField("UnlimitedOverDelivIsAllowed", this.unlimitedOverDelivIsAllowed);
        this.unlimitedOverDelivIsAllowed = unlimitedOverDelivIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverDelivToleranceLimit</b>
     * </p>
     *
     * @param overDelivToleranceLimit
     *            Overdelivery tolerance limit
     */
    public void setOverDelivToleranceLimit( @Nullable final BigDecimal overDelivToleranceLimit )
    {
        rememberChangedField("OverDelivToleranceLimit", this.overDelivToleranceLimit);
        this.overDelivToleranceLimit = overDelivToleranceLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderDelivToleranceLimit</b>
     * </p>
     *
     * @param underDelivToleranceLimit
     *            Underdelivery tolerance limit
     */
    public void setUnderDelivToleranceLimit( @Nullable final BigDecimal underDelivToleranceLimit )
    {
        rememberChangedField("UnderDelivToleranceLimit", this.underDelivToleranceLimit);
        this.underDelivToleranceLimit = underDelivToleranceLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionInvtryManagedLoc</b>
     * </p>
     *
     * @param productionInvtryManagedLoc
     *            Issue Storage Location
     */
    public void setProductionInvtryManagedLoc( @Nullable final String productionInvtryManagedLoc )
    {
        rememberChangedField("ProductionInvtryManagedLoc", this.productionInvtryManagedLoc);
        this.productionInvtryManagedLoc = productionInvtryManagedLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductWorkScheduling";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MaterialBaseQuantity", getMaterialBaseQuantity());
        values.put("UnlimitedOverDelivIsAllowed", getUnlimitedOverDelivIsAllowed());
        values.put("OverDelivToleranceLimit", getOverDelivToleranceLimit());
        values.put("UnderDelivToleranceLimit", getUnderDelivToleranceLimit());
        values.put("ProductionInvtryManagedLoc", getProductionInvtryManagedLoc());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseQuantity") ) {
                final Object value = values.remove("MaterialBaseQuantity");
                if( (value == null) || (!value.equals(getMaterialBaseQuantity())) ) {
                    setMaterialBaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverDelivIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverDelivIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverDelivIsAllowed())) ) {
                    setUnlimitedOverDelivIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("OverDelivToleranceLimit") ) {
                final Object value = values.remove("OverDelivToleranceLimit");
                if( (value == null) || (!value.equals(getOverDelivToleranceLimit())) ) {
                    setOverDelivToleranceLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnderDelivToleranceLimit") ) {
                final Object value = values.remove("UnderDelivToleranceLimit");
                if( (value == null) || (!value.equals(getUnderDelivToleranceLimit())) ) {
                    setUnderDelivToleranceLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionInvtryManagedLoc") ) {
                final Object value = values.remove("ProductionInvtryManagedLoc");
                if( (value == null) || (!value.equals(getProductionInvtryManagedLoc())) ) {
                    setProductionInvtryManagedLoc(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductWorkSchedulingField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductWorkSchedulingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductWorkSchedulingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductWorkSchedulingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH);
    }

}
