/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ProductMasterDataIncludingClassificationServiceBatchChangeSet} interface, enabling you
 * to combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService
 * ProductMasterDataIncludingClassificationService}.
 *
 */
public class DefaultProductMasterDataIncludingClassificationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductMasterDataIncludingClassificationServiceBatch, ProductMasterDataIncludingClassificationServiceBatchChangeSet>
    implements
    ProductMasterDataIncludingClassificationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductMasterDataIncludingClassificationServiceBatchChangeSet(
        @Nonnull final DefaultProductMasterDataIncludingClassificationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductMasterDataIncludingClassificationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductMasterDataIncludingClassificationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
