/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct
 * ClfnProduct}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ClfnProductField
 * ClfnProductField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ClfnProductLink
 * ClfnProductLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_TYPE
 * PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CROSS_PLANT_STATUS
 * CROSS_PLANT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CROSS_PLANT_STATUS_VALIDITY_DATE
 * CROSS_PLANT_STATUS_VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_OLD_ID
 * PRODUCT_OLD_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#GROSS_WEIGHT
 * GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PURCHASE_ORDER_QUANTITY_UNIT
 * PURCHASE_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#SOURCE_OF_SUPPLY
 * SOURCE_OF_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#WEIGHT_UNIT
 * WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#NET_WEIGHT
 * NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#COMPETITOR_ID
 * COMPETITOR_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_GROUP
 * PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#ITEM_CATEGORY_GROUP
 * ITEM_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_HIERARCHY
 * PRODUCT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#VARBL_PUR_ORD_UNIT_IS_ACTIVE
 * VARBL_PUR_ORD_UNIT_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MATERIAL_VOLUME
 * MATERIAL_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#ANP_CODE
 * ANP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#BRAND
 * BRAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PROCUREMENT_RULE
 * PROCUREMENT_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#LOW_LEVEL_CODE
 * LOW_LEVEL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD
 * PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#SERIAL_IDENTIFIER_ASSGMT_PROFILE
 * SERIAL_IDENTIFIER_ASSGMT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#SIZE_OR_DIMENSION_TEXT
 * SIZE_OR_DIMENSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#INDUSTRY_STANDARD_NAME
 * INDUSTRY_STANDARD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_STANDARD_ID
 * PRODUCT_STANDARD_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#INTERNATIONAL_ARTICLE_NUMBER_CAT
 * INTERNATIONAL_ARTICLE_NUMBER_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_IS_CONFIGURABLE
 * PRODUCT_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#IS_BATCH_MANAGEMENT_REQUIRED
 * IS_BATCH_MANAGEMENT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#EXTERNAL_PRODUCT_GROUP
 * EXTERNAL_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CROSS_PLANT_CONFIGURABLE_PRODUCT
 * CROSS_PLANT_CONFIGURABLE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#SERIAL_NO_EXPLICITNESS_LEVEL
 * SERIAL_NO_EXPLICITNESS_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PRODUCT_MANUFACTURER_NUMBER
 * PRODUCT_MANUFACTURER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MANUFACTURER_PART_PROFILE
 * MANUFACTURER_PART_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MATERIAL_REVISION_LEVEL
 * MATERIAL_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#HANDLING_INDICATOR
 * HANDLING_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#WAREHOUSE_PRODUCT_GROUP
 * WAREHOUSE_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#WAREHOUSE_STORAGE_CONDITION
 * WAREHOUSE_STORAGE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#STANDARD_HANDLING_UNIT_TYPE
 * STANDARD_HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#ADJUSTMENT_PROFILE
 * ADJUSTMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#PREFERRED_UNIT_OF_MEASURE
 * PREFERRED_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#IS_PILFERABLE
 * IS_PILFERABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#IS_RELEVANT_FOR_HZDS_SUBSTANCES
 * IS_RELEVANT_FOR_HZDS_SUBSTANCES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#QUARANTINE_PERIOD
 * QUARANTINE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TIME_UNIT_FOR_QUARANTINE_PERIOD
 * TIME_UNIT_FOR_QUARANTINE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#QUALITY_INSPECTION_GROUP
 * QUALITY_INSPECTION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#HANDLING_UNIT_TYPE
 * HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#HAS_VARIABLE_TARE_WEIGHT
 * HAS_VARIABLE_TARE_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MAXIMUM_PACKAGING_LENGTH
 * MAXIMUM_PACKAGING_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MAXIMUM_PACKAGING_WIDTH
 * MAXIMUM_PACKAGING_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#MAXIMUM_PACKAGING_HEIGHT
 * MAXIMUM_PACKAGING_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#UNIT_FOR_MAX_PACKAGING_DIMENSIONS
 * UNIT_FOR_MAX_PACKAGING_DIMENSIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_DESCRIPTION
 * TO_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_PLANT
 * TO_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_PRODUCT_CHARC
 * TO_PRODUCT_CHARC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_PRODUCT_CLASS
 * TO_PRODUCT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_PRODUCT_SALES_TAX
 * TO_PRODUCT_SALES_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProduct#TO_SALES_DELIVERY
 * TO_SALES_DELIVERY}</li>
 * </ul>
 *
 */
public interface ClfnProductSelectable extends EntitySelectable<ClfnProduct>
{

}
