/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc
 * ProductCharc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductCharcField
 * ProductCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductCharcLink
 * ProductCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharc#TO_VALUATION
 * TO_VALUATION}</li>
 * </ul>
 *
 */
public interface ProductCharcSelectable extends EntitySelectable<ProductCharc>
{

}
