/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant
 * ProductPlant}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductPlantField
 * ProductPlantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductPlantLink
 * ProductPlantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#REGION_OF_ORIGIN
 * REGION_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PRODUCTION_INVTRY_MANAGED_LOC
 * PRODUCTION_INVTRY_MANAGED_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PROFILE_CODE
 * PROFILE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PROFILE_VALIDITY_START_DATE
 * PROFILE_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#AVAILABILITY_CHECK_TYPE
 * AVAILABILITY_CHECK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PERIOD_TYPE
 * PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#COMMODITY
 * COMMODITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#GOODS_RECEIPT_DURATION
 * GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#MAINTENANCE_STATUS_NAME
 * MAINTENANCE_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#MRP_TYPE
 * MRP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#MRP_RESPONSIBLE
 * MRP_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#FIXED_LOT_SIZE_QUANTITY
 * FIXED_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#CONSUMPTION_TAX_CTRL_CODE
 * CONSUMPTION_TAX_CTRL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#IS_CO_PRODUCT
 * IS_CO_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PRODUCT_IS_CONFIGURABLE
 * PRODUCT_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#STOCK_DETERMINATION_GROUP
 * STOCK_DETERMINATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#STOCK_IN_TRANSFER_QUANTITY
 * STOCK_IN_TRANSFER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#STOCK_IN_TRANSIT_QUANTITY
 * STOCK_IN_TRANSIT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#HAS_POST_TO_INSPECTION_STOCK
 * HAS_POST_TO_INSPECTION_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#IS_BATCH_MANAGEMENT_REQUIRED
 * IS_BATCH_MANAGEMENT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#IS_NEGATIVE_STOCK_ALLOWED
 * IS_NEGATIVE_STOCK_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#GOODS_RECEIPT_BLOCKED_STOCK_QTY
 * GOODS_RECEIPT_BLOCKED_STOCK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#HAS_CONSIGNMENT_CTRL
 * HAS_CONSIGNMENT_CTRL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#FISCAL_YEAR_CURRENT_PERIOD
 * FISCAL_YEAR_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#FISCAL_MONTH_CURRENT_PERIOD
 * FISCAL_MONTH_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PROCUREMENT_TYPE
 * PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#IS_INTERNAL_BATCH_MANAGED
 * IS_INTERNAL_BATCH_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PRODUCT_CFOP_CATEGORY
 * PRODUCT_CFOP_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#PRODUCT_IS_EXCISE_TAX_RELEVANT
 * PRODUCT_IS_EXCISE_TAX_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#TO_PRODUCT_PLANT_PROCUREMENT
 * TO_PRODUCT_PLANT_PROCUREMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#TO_PRODUCT_SUPPLY_PLANNING
 * TO_PRODUCT_SUPPLY_PLANNING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#TO_PRODUCT_WORK_SCHEDULING
 * TO_PRODUCT_WORK_SCHEDULING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlant#TO_STORAGE_LOCATION
 * TO_STORAGE_LOCATION}</li>
 * </ul>
 *
 */
public interface ProductPlantSelectable extends EntitySelectable<ProductPlant>
{

}
