/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery
 * ProductSalesDelivery}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductSalesDeliveryField
 * ProductSalesDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductSalesDeliveryLink
 * ProductSalesDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT_SALES_ORG
 * PRODUCT_SALES_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT_DISTRIBUTION_CHNL
 * PRODUCT_DISTRIBUTION_CHNL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#MINIMUM_ORDER_QUANTITY
 * MINIMUM_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#SUPPLYING_PLANT
 * SUPPLYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRICE_SPECIFICATION_PRODUCT_GROUP
 * PRICE_SPECIFICATION_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#ACCOUNT_DETN_PRODUCT_GROUP
 * ACCOUNT_DETN_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#DELIVERY_NOTE_PROC_MIN_DELIV_QTY
 * DELIVERY_NOTE_PROC_MIN_DELIV_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#ITEM_CATEGORY_GROUP
 * ITEM_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#DELIVERY_QUANTITY_UNIT
 * DELIVERY_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#DELIVERY_QUANTITY
 * DELIVERY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT_SALES_STATUS
 * PRODUCT_SALES_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT_SALES_STATUS_VALIDITY_DATE
 * PRODUCT_SALES_STATUS_VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#SALES_MEASURE_UNIT
 * SALES_MEASURE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#PRODUCT_HIERARCHY
 * PRODUCT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#FIRST_SALES_SPEC_PRODUCT_GROUP
 * FIRST_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#SECOND_SALES_SPEC_PRODUCT_GROUP
 * SECOND_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#THIRD_SALES_SPEC_PRODUCT_GROUP
 * THIRD_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#FOURTH_SALES_SPEC_PRODUCT_GROUP
 * FOURTH_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#FIFTH_SALES_SPEC_PRODUCT_GROUP
 * FIFTH_SALES_SPEC_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#MINIMUM_MAKE_TO_ORDER_ORDER_QTY
 * MINIMUM_MAKE_TO_ORDER_ORDER_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDelivery#BASE_UNIT
 * BASE_UNIT}</li>
 * </ul>
 *
 */
public interface ProductSalesDeliverySelectable extends EntitySelectable<ProductSalesDelivery>
{

}
