/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling
 * ProductWorkScheduling}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.field.ProductWorkSchedulingField
 * ProductWorkSchedulingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.link.ProductWorkSchedulingLink
 * ProductWorkSchedulingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#MATERIAL_BASE_QUANTITY
 * MATERIAL_BASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#UNLIMITED_OVER_DELIV_IS_ALLOWED
 * UNLIMITED_OVER_DELIV_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#OVER_DELIV_TOLERANCE_LIMIT
 * OVER_DELIV_TOLERANCE_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#UNDER_DELIV_TOLERANCE_LIMIT
 * UNDER_DELIV_TOLERANCE_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#PRODUCTION_INVTRY_MANAGED_LOC
 * PRODUCTION_INVTRY_MANAGED_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkScheduling#BASE_UNIT
 * BASE_UNIT}</li>
 * </ul>
 *
 */
public interface ProductWorkSchedulingSelectable extends EntitySelectable<ProductWorkScheduling>
{

}
