/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.field.ProductStructureNodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable.ProductStructureNodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Structure Node (API)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductStructureNodeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductStructureNode extends VdmEntity<ProductStructureNode>
{

    /**
     * Selector for all available fields of ProductStructureNode.
     *
     */
    public final static ProductStructureNodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeUUID</b>
     * </p>
     *
     * @return Internal Number of iPPE Node
     */
    @Key
    @SerializedName( "ProductStructureNodeUUID" )
    @JsonProperty( "ProductStructureNodeUUID" )
    @Nullable
    @ODataField( odataName = "ProductStructureNodeUUID" )
    private UUID productStructureNodeUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureNodeUUID</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<UUID> PRODUCT_STRUCTURE_NODE_UUID =
        new ProductStructureNodeField<UUID>("ProductStructureNodeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeName</b>
     * </p>
     *
     * @return iPPE Node Description
     */
    @SerializedName( "ProductStructureNodeName" )
    @JsonProperty( "ProductStructureNodeName" )
    @Nullable
    @ODataField( odataName = "ProductStructureNodeName" )
    private String productStructureNodeName;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureNodeName</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> PRODUCT_STRUCTURE_NODE_NAME =
        new ProductStructureNodeField<String>("ProductStructureNodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> CLASS_INTERNAL_ID =
        new ProductStructureNodeField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeType</b>
     * </p>
     *
     * @return iPPE Node Type
     */
    @SerializedName( "ProductStructureNodeType" )
    @JsonProperty( "ProductStructureNodeType" )
    @Nullable
    @ODataField( odataName = "ProductStructureNodeType" )
    private String productStructureNodeType;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureNodeType</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> PRODUCT_STRUCTURE_NODE_TYPE =
        new ProductStructureNodeField<String>("ProductStructureNodeType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreationDate</b>
     * </p>
     *
     * @return Date of Application
     */
    @SerializedName( "ProductStructureCreationDate" )
    @JsonProperty( "ProductStructureCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductStructureCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productStructureCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureCreationDate</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<LocalDateTime> PRODUCT_STRUCTURE_CREATION_DATE =
        new ProductStructureNodeField<LocalDateTime>("ProductStructureCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreatedByUser</b>
     * </p>
     *
     * @return User who created record
     */
    @SerializedName( "ProductStructureCreatedByUser" )
    @JsonProperty( "ProductStructureCreatedByUser" )
    @Nullable
    @ODataField( odataName = "ProductStructureCreatedByUser" )
    private String productStructureCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureCreatedByUser</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> PRODUCT_STRUCTURE_CREATED_BY_USER =
        new ProductStructureNodeField<String>("ProductStructureCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "ProductStrucLastChangedDate" )
    @JsonProperty( "ProductStrucLastChangedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductStrucLastChangedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productStrucLastChangedDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductStrucLastChangedDate</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<LocalDateTime> PRODUCT_STRUC_LAST_CHANGED_DATE =
        new ProductStructureNodeField<LocalDateTime>("ProductStrucLastChangedDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "ProductStrucLastChangedByUser" )
    @JsonProperty( "ProductStrucLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "ProductStrucLastChangedByUser" )
    private String productStrucLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProductStrucLastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> PRODUCT_STRUC_LAST_CHANGED_BY_USER =
        new ProductStructureNodeField<String>("ProductStrucLastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static ProductStructureNodeField<String> CLASS_PROPERTY =
        new ProductStructureNodeField<String>("Class");

    @Nonnull
    @Override
    public Class<ProductStructureNode> getType()
    {
        return ProductStructureNode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeUUID</b>
     * </p>
     *
     * @param productStructureNodeUUID
     *            Internal Number of iPPE Node
     */
    public void setProductStructureNodeUUID( @Nullable final UUID productStructureNodeUUID )
    {
        rememberChangedField("ProductStructureNodeUUID", this.productStructureNodeUUID);
        this.productStructureNodeUUID = productStructureNodeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeName</b>
     * </p>
     *
     * @param productStructureNodeName
     *            iPPE Node Description
     */
    public void setProductStructureNodeName( @Nullable final String productStructureNodeName )
    {
        rememberChangedField("ProductStructureNodeName", this.productStructureNodeName);
        this.productStructureNodeName = productStructureNodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureNodeType</b>
     * </p>
     *
     * @param productStructureNodeType
     *            iPPE Node Type
     */
    public void setProductStructureNodeType( @Nullable final String productStructureNodeType )
    {
        rememberChangedField("ProductStructureNodeType", this.productStructureNodeType);
        this.productStructureNodeType = productStructureNodeType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreationDate</b>
     * </p>
     *
     * @param productStructureCreationDate
     *            Date of Application
     */
    public void setProductStructureCreationDate( @Nullable final LocalDateTime productStructureCreationDate )
    {
        rememberChangedField("ProductStructureCreationDate", this.productStructureCreationDate);
        this.productStructureCreationDate = productStructureCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreatedByUser</b>
     * </p>
     *
     * @param productStructureCreatedByUser
     *            User who created record
     */
    public void setProductStructureCreatedByUser( @Nullable final String productStructureCreatedByUser )
    {
        rememberChangedField("ProductStructureCreatedByUser", this.productStructureCreatedByUser);
        this.productStructureCreatedByUser = productStructureCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedDate</b>
     * </p>
     *
     * @param productStrucLastChangedDate
     *            Date of Last Change
     */
    public void setProductStrucLastChangedDate( @Nullable final LocalDateTime productStrucLastChangedDate )
    {
        rememberChangedField("ProductStrucLastChangedDate", this.productStrucLastChangedDate);
        this.productStrucLastChangedDate = productStrucLastChangedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedByUser</b>
     * </p>
     *
     * @param productStrucLastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setProductStrucLastChangedByUser( @Nullable final String productStrucLastChangedByUser )
    {
        rememberChangedField("ProductStrucLastChangedByUser", this.productStrucLastChangedByUser);
        this.productStrucLastChangedByUser = productStrucLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductStructureNode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductStructureNodeUUID", getProductStructureNodeUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductStructureNodeUUID", getProductStructureNodeUUID());
        values.put("ProductStructureNodeName", getProductStructureNodeName());
        values.put("ClassInternalID", getClassInternalID());
        values.put("ProductStructureNodeType", getProductStructureNodeType());
        values.put("ProductStructureCreationDate", getProductStructureCreationDate());
        values.put("ProductStructureCreatedByUser", getProductStructureCreatedByUser());
        values.put("ProductStrucLastChangedDate", getProductStrucLastChangedDate());
        values.put("ProductStrucLastChangedByUser", getProductStrucLastChangedByUser());
        values.put("Class", getClassProperty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductStructureNodeUUID") ) {
                final Object value = values.remove("ProductStructureNodeUUID");
                if( (value == null) || (!value.equals(getProductStructureNodeUUID())) ) {
                    setProductStructureNodeUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductStructureNodeName") ) {
                final Object value = values.remove("ProductStructureNodeName");
                if( (value == null) || (!value.equals(getProductStructureNodeName())) ) {
                    setProductStructureNodeName(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("ProductStructureNodeType") ) {
                final Object value = values.remove("ProductStructureNodeType");
                if( (value == null) || (!value.equals(getProductStructureNodeType())) ) {
                    setProductStructureNodeType(((String) value));
                }
            }
            if( values.containsKey("ProductStructureCreationDate") ) {
                final Object value = values.remove("ProductStructureCreationDate");
                if( (value == null) || (!value.equals(getProductStructureCreationDate())) ) {
                    setProductStructureCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductStructureCreatedByUser") ) {
                final Object value = values.remove("ProductStructureCreatedByUser");
                if( (value == null) || (!value.equals(getProductStructureCreatedByUser())) ) {
                    setProductStructureCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ProductStrucLastChangedDate") ) {
                final Object value = values.remove("ProductStrucLastChangedDate");
                if( (value == null) || (!value.equals(getProductStrucLastChangedDate())) ) {
                    setProductStrucLastChangedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductStrucLastChangedByUser") ) {
                final Object value = values.remove("ProductStrucLastChangedByUser");
                if( (value == null) || (!value.equals(getProductStrucLastChangedByUser())) ) {
                    setProductStrucLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductStructureNodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductStructureNodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductStructureNodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductStructureNodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService.DEFAULT_SERVICE_PATH);
    }

}
