/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable.ProductStructureNodeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
 * ProductStructureNode} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ProductStructureNodeByKeyFluentHelper
    extends
    FluentHelperByKey<ProductStructureNodeByKeyFluentHelper, ProductStructureNode, ProductStructureNodeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
     * ProductStructureNode} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductStructureNode}
     * @param productStructureNodeUUID
     *            Internal Number of iPPE Node
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductStructureNode}
     */
    public ProductStructureNodeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID productStructureNodeUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductStructureNodeUUID", productStructureNodeUUID);
    }

    @Override
    @Nonnull
    protected Class<ProductStructureNode> getEntityClass()
    {
        return ProductStructureNode.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
