/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.field.ProductStructureVariantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable.ProductStructureVariantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Structure Variant (API)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductStructureVariantType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductStructureVariant extends VdmEntity<ProductStructureVariant>
{

    /**
     * Selector for all available fields of ProductStructureVariant.
     *
     */
    public final static ProductStructureVariantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantUUID</b>
     * </p>
     *
     * @return Internal Number of the PVS Variant
     */
    @Key
    @SerializedName( "ProductStructureVariantUUID" )
    @JsonProperty( "ProductStructureVariantUUID" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantUUID" )
    private UUID productStructureVariantUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantUUID</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<UUID> PRODUCT_STRUCTURE_VARIANT_UUID =
        new ProductStructureVariantField<UUID>("ProductStructureVariantUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChgStateIntID</b>
     * </p>
     *
     * @return Internal Counter for iPPE Objects
     */
    @Key
    @SerializedName( "ProdStrucVariantChgStateIntID" )
    @JsonProperty( "ProdStrucVariantChgStateIntID" )
    @Nullable
    @ODataField( odataName = "ProdStrucVariantChgStateIntID" )
    private String prodStrucVariantChgStateIntID;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVariantChgStateIntID</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PROD_STRUC_VARIANT_CHG_STATE_INT_ID =
        new ProductStructureVariantField<String>("ProdStrucVariantChgStateIntID");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantUniqueID</b>
     * </p>
     *
     * @return The prodStrucVariantUniqueID contained in this entity.
     */
    @SerializedName( "ProdStrucVariantUniqueID" )
    @JsonProperty( "ProdStrucVariantUniqueID" )
    @Nullable
    @ODataField( odataName = "ProdStrucVariantUniqueID" )
    private String prodStrucVariantUniqueID;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVariantUniqueID</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PROD_STRUC_VARIANT_UNIQUE_ID =
        new ProductStructureVariantField<String>("ProdStrucVariantUniqueID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantName</b>
     * </p>
     *
     * @return Variant
     */
    @SerializedName( "ProductStructureVariantName" )
    @JsonProperty( "ProductStructureVariantName" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantName" )
    private String productStructureVariantName;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantName</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PRODUCT_STRUCTURE_VARIANT_NAME =
        new ProductStructureVariantField<String>("ProductStructureVariantName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdStructureVariantParentUUID</b>
     * </p>
     *
     * @return Internal Number of iPPE Node
     */
    @SerializedName( "ProdStructureVariantParentUUID" )
    @JsonProperty( "ProdStructureVariantParentUUID" )
    @Nullable
    @ODataField( odataName = "ProdStructureVariantParentUUID" )
    private UUID prodStructureVariantParentUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProdStructureVariantParentUUID</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<UUID> PROD_STRUCTURE_VARIANT_PARENT_UUID =
        new ProductStructureVariantField<UUID>("ProdStructureVariantParentUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreationDate</b>
     * </p>
     *
     * @return Date of Application
     */
    @SerializedName( "ProductStructureCreationDate" )
    @JsonProperty( "ProductStructureCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductStructureCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productStructureCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureCreationDate</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<LocalDateTime> PRODUCT_STRUCTURE_CREATION_DATE =
        new ProductStructureVariantField<LocalDateTime>("ProductStructureCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreatedByUser</b>
     * </p>
     *
     * @return User who created record
     */
    @SerializedName( "ProductStructureCreatedByUser" )
    @JsonProperty( "ProductStructureCreatedByUser" )
    @Nullable
    @ODataField( odataName = "ProductStructureCreatedByUser" )
    private String productStructureCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureCreatedByUser</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PRODUCT_STRUCTURE_CREATED_BY_USER =
        new ProductStructureVariantField<String>("ProductStructureCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "ProductStrucLastChangedDate" )
    @JsonProperty( "ProductStrucLastChangedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductStrucLastChangedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productStrucLastChangedDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductStrucLastChangedDate</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<LocalDateTime> PRODUCT_STRUC_LAST_CHANGED_DATE =
        new ProductStructureVariantField<LocalDateTime>("ProductStrucLastChangedDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "ProductStrucLastChangedByUser" )
    @JsonProperty( "ProductStrucLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "ProductStrucLastChangedByUser" )
    private String productStrucLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProductStrucLastChangedByUser</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PRODUCT_STRUC_LAST_CHANGED_BY_USER =
        new ProductStructureVariantField<String>("ProductStrucLastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChangeNumber</b>
     * </p>
     *
     * @return Change Number in iPPE
     */
    @SerializedName( "ProdStrucVariantChangeNumber" )
    @JsonProperty( "ProdStrucVariantChangeNumber" )
    @Nullable
    @ODataField( odataName = "ProdStrucVariantChangeNumber" )
    private String prodStrucVariantChangeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVariantChangeNumber</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PROD_STRUC_VARIANT_CHANGE_NUMBER =
        new ProductStructureVariantField<String>("ProdStrucVariantChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization group for change master record
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> AUTHORIZATION_GROUP =
        new ProductStructureVariantField<String>("AuthorizationGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVarIsMrkdForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "ProdStrucVarIsMrkdForDeletion" )
    @JsonProperty( "ProdStrucVarIsMrkdForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProdStrucVarIsMrkdForDeletion" )
    private Boolean prodStrucVarIsMrkdForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVarIsMrkdForDeletion</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<Boolean> PROD_STRUC_VAR_IS_MRKD_FOR_DELETION =
        new ProductStructureVariantField<Boolean>("ProdStrucVarIsMrkdForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVarChgNmbrDescription</b>
     * </p>
     *
     * @return Change number description
     */
    @SerializedName( "ProdStrucVarChgNmbrDescription" )
    @JsonProperty( "ProdStrucVarChgNmbrDescription" )
    @Nullable
    @ODataField( odataName = "ProdStrucVarChgNmbrDescription" )
    private String prodStrucVarChgNmbrDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProdStrucVarChgNmbrDescription</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PROD_STRUC_VAR_CHG_NMBR_DESCRIPTION =
        new ProductStructureVariantField<String>("ProdStrucVarChgNmbrDescription");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantQty</b>
     * </p>
     *
     * @return Fixed Quantity in Variant of iPPE Product Structure
     */
    @SerializedName( "ProductStructureVariantQty" )
    @JsonProperty( "ProductStructureVariantQty" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantQty" )
    private BigDecimal productStructureVariantQty;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantQty</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<BigDecimal> PRODUCT_STRUCTURE_VARIANT_QTY =
        new ProductStructureVariantField<BigDecimal>("ProductStructureVariantQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ProductStructureVariantUnit" )
    @JsonProperty( "ProductStructureVariantUnit" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantUnit" )
    private String productStructureVariantUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantUnit</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PRODUCT_STRUCTURE_VARIANT_UNIT =
        new ProductStructureVariantField<String>("ProductStructureVariantUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> MATERIAL =
        new ProductStructureVariantField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "MaterialAuthorizationGroup" )
    @JsonProperty( "MaterialAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "MaterialAuthorizationGroup" )
    private String materialAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialAuthorizationGroup</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> MATERIAL_AUTHORIZATION_GROUP =
        new ProductStructureVariantField<String>("MaterialAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantType</b>
     * </p>
     *
     * @return iPPE Variant Type
     */
    @SerializedName( "ProductStructureVariantType" )
    @JsonProperty( "ProductStructureVariantType" )
    @Nullable
    @ODataField( odataName = "ProductStructureVariantType" )
    private String productStructureVariantType;
    /**
     * Use with available fluent helpers to apply the <b>ProductStructureVariantType</b> field to query operations.
     *
     */
    public final static ProductStructureVariantField<String> PRODUCT_STRUCTURE_VARIANT_TYPE =
        new ProductStructureVariantField<String>("ProductStructureVariantType");

    @Nonnull
    @Override
    public Class<ProductStructureVariant> getType()
    {
        return ProductStructureVariant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantUUID</b>
     * </p>
     *
     * @param productStructureVariantUUID
     *            Internal Number of the PVS Variant
     */
    public void setProductStructureVariantUUID( @Nullable final UUID productStructureVariantUUID )
    {
        rememberChangedField("ProductStructureVariantUUID", this.productStructureVariantUUID);
        this.productStructureVariantUUID = productStructureVariantUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChgStateIntID</b>
     * </p>
     *
     * @param prodStrucVariantChgStateIntID
     *            Internal Counter for iPPE Objects
     */
    public void setProdStrucVariantChgStateIntID( @Nullable final String prodStrucVariantChgStateIntID )
    {
        rememberChangedField("ProdStrucVariantChgStateIntID", this.prodStrucVariantChgStateIntID);
        this.prodStrucVariantChgStateIntID = prodStrucVariantChgStateIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantUniqueID</b>
     * </p>
     *
     * @param prodStrucVariantUniqueID
     *            The prodStrucVariantUniqueID to set.
     */
    public void setProdStrucVariantUniqueID( @Nullable final String prodStrucVariantUniqueID )
    {
        rememberChangedField("ProdStrucVariantUniqueID", this.prodStrucVariantUniqueID);
        this.prodStrucVariantUniqueID = prodStrucVariantUniqueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantName</b>
     * </p>
     *
     * @param productStructureVariantName
     *            Variant
     */
    public void setProductStructureVariantName( @Nullable final String productStructureVariantName )
    {
        rememberChangedField("ProductStructureVariantName", this.productStructureVariantName);
        this.productStructureVariantName = productStructureVariantName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdStructureVariantParentUUID</b>
     * </p>
     *
     * @param prodStructureVariantParentUUID
     *            Internal Number of iPPE Node
     */
    public void setProdStructureVariantParentUUID( @Nullable final UUID prodStructureVariantParentUUID )
    {
        rememberChangedField("ProdStructureVariantParentUUID", this.prodStructureVariantParentUUID);
        this.prodStructureVariantParentUUID = prodStructureVariantParentUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreationDate</b>
     * </p>
     *
     * @param productStructureCreationDate
     *            Date of Application
     */
    public void setProductStructureCreationDate( @Nullable final LocalDateTime productStructureCreationDate )
    {
        rememberChangedField("ProductStructureCreationDate", this.productStructureCreationDate);
        this.productStructureCreationDate = productStructureCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureCreatedByUser</b>
     * </p>
     *
     * @param productStructureCreatedByUser
     *            User who created record
     */
    public void setProductStructureCreatedByUser( @Nullable final String productStructureCreatedByUser )
    {
        rememberChangedField("ProductStructureCreatedByUser", this.productStructureCreatedByUser);
        this.productStructureCreatedByUser = productStructureCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedDate</b>
     * </p>
     *
     * @param productStrucLastChangedDate
     *            Date of Last Change
     */
    public void setProductStrucLastChangedDate( @Nullable final LocalDateTime productStrucLastChangedDate )
    {
        rememberChangedField("ProductStrucLastChangedDate", this.productStrucLastChangedDate);
        this.productStrucLastChangedDate = productStrucLastChangedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductStrucLastChangedByUser</b>
     * </p>
     *
     * @param productStrucLastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setProductStrucLastChangedByUser( @Nullable final String productStrucLastChangedByUser )
    {
        rememberChangedField("ProductStrucLastChangedByUser", this.productStrucLastChangedByUser);
        this.productStrucLastChangedByUser = productStrucLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVariantChangeNumber</b>
     * </p>
     *
     * @param prodStrucVariantChangeNumber
     *            Change Number in iPPE
     */
    public void setProdStrucVariantChangeNumber( @Nullable final String prodStrucVariantChangeNumber )
    {
        rememberChangedField("ProdStrucVariantChangeNumber", this.prodStrucVariantChangeNumber);
        this.prodStrucVariantChangeNumber = prodStrucVariantChangeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization group for change master record
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVarIsMrkdForDeletion</b>
     * </p>
     *
     * @param prodStrucVarIsMrkdForDeletion
     *            Deletion Indicator
     */
    public void setProdStrucVarIsMrkdForDeletion( @Nullable final Boolean prodStrucVarIsMrkdForDeletion )
    {
        rememberChangedField("ProdStrucVarIsMrkdForDeletion", this.prodStrucVarIsMrkdForDeletion);
        this.prodStrucVarIsMrkdForDeletion = prodStrucVarIsMrkdForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdStrucVarChgNmbrDescription</b>
     * </p>
     *
     * @param prodStrucVarChgNmbrDescription
     *            Change number description
     */
    public void setProdStrucVarChgNmbrDescription( @Nullable final String prodStrucVarChgNmbrDescription )
    {
        rememberChangedField("ProdStrucVarChgNmbrDescription", this.prodStrucVarChgNmbrDescription);
        this.prodStrucVarChgNmbrDescription = prodStrucVarChgNmbrDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantQty</b>
     * </p>
     *
     * @param productStructureVariantQty
     *            Fixed Quantity in Variant of iPPE Product Structure
     */
    public void setProductStructureVariantQty( @Nullable final BigDecimal productStructureVariantQty )
    {
        rememberChangedField("ProductStructureVariantQty", this.productStructureVariantQty);
        this.productStructureVariantQty = productStructureVariantQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantUnit</b>
     * </p>
     *
     * @param productStructureVariantUnit
     *            Unit of Measure
     */
    public void setProductStructureVariantUnit( @Nullable final String productStructureVariantUnit )
    {
        rememberChangedField("ProductStructureVariantUnit", this.productStructureVariantUnit);
        this.productStructureVariantUnit = productStructureVariantUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAuthorizationGroup</b>
     * </p>
     *
     * @param materialAuthorizationGroup
     *            Authorization Group
     */
    public void setMaterialAuthorizationGroup( @Nullable final String materialAuthorizationGroup )
    {
        rememberChangedField("MaterialAuthorizationGroup", this.materialAuthorizationGroup);
        this.materialAuthorizationGroup = materialAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductStructureVariantType</b>
     * </p>
     *
     * @param productStructureVariantType
     *            iPPE Variant Type
     */
    public void setProductStructureVariantType( @Nullable final String productStructureVariantType )
    {
        rememberChangedField("ProductStructureVariantType", this.productStructureVariantType);
        this.productStructureVariantType = productStructureVariantType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductStructureVariant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductStructureVariantUUID", getProductStructureVariantUUID());
        result.put("ProdStrucVariantChgStateIntID", getProdStrucVariantChgStateIntID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductStructureVariantUUID", getProductStructureVariantUUID());
        values.put("ProdStrucVariantChgStateIntID", getProdStrucVariantChgStateIntID());
        values.put("ProdStrucVariantUniqueID", getProdStrucVariantUniqueID());
        values.put("ProductStructureVariantName", getProductStructureVariantName());
        values.put("ProdStructureVariantParentUUID", getProdStructureVariantParentUUID());
        values.put("ProductStructureCreationDate", getProductStructureCreationDate());
        values.put("ProductStructureCreatedByUser", getProductStructureCreatedByUser());
        values.put("ProductStrucLastChangedDate", getProductStrucLastChangedDate());
        values.put("ProductStrucLastChangedByUser", getProductStrucLastChangedByUser());
        values.put("ProdStrucVariantChangeNumber", getProdStrucVariantChangeNumber());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("ProdStrucVarIsMrkdForDeletion", getProdStrucVarIsMrkdForDeletion());
        values.put("ProdStrucVarChgNmbrDescription", getProdStrucVarChgNmbrDescription());
        values.put("ProductStructureVariantQty", getProductStructureVariantQty());
        values.put("ProductStructureVariantUnit", getProductStructureVariantUnit());
        values.put("Material", getMaterial());
        values.put("MaterialAuthorizationGroup", getMaterialAuthorizationGroup());
        values.put("ProductStructureVariantType", getProductStructureVariantType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductStructureVariantUUID") ) {
                final Object value = values.remove("ProductStructureVariantUUID");
                if( (value == null) || (!value.equals(getProductStructureVariantUUID())) ) {
                    setProductStructureVariantUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProdStrucVariantChgStateIntID") ) {
                final Object value = values.remove("ProdStrucVariantChgStateIntID");
                if( (value == null) || (!value.equals(getProdStrucVariantChgStateIntID())) ) {
                    setProdStrucVariantChgStateIntID(((String) value));
                }
            }
            if( values.containsKey("ProdStrucVariantUniqueID") ) {
                final Object value = values.remove("ProdStrucVariantUniqueID");
                if( (value == null) || (!value.equals(getProdStrucVariantUniqueID())) ) {
                    setProdStrucVariantUniqueID(((String) value));
                }
            }
            if( values.containsKey("ProductStructureVariantName") ) {
                final Object value = values.remove("ProductStructureVariantName");
                if( (value == null) || (!value.equals(getProductStructureVariantName())) ) {
                    setProductStructureVariantName(((String) value));
                }
            }
            if( values.containsKey("ProdStructureVariantParentUUID") ) {
                final Object value = values.remove("ProdStructureVariantParentUUID");
                if( (value == null) || (!value.equals(getProdStructureVariantParentUUID())) ) {
                    setProdStructureVariantParentUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductStructureCreationDate") ) {
                final Object value = values.remove("ProductStructureCreationDate");
                if( (value == null) || (!value.equals(getProductStructureCreationDate())) ) {
                    setProductStructureCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductStructureCreatedByUser") ) {
                final Object value = values.remove("ProductStructureCreatedByUser");
                if( (value == null) || (!value.equals(getProductStructureCreatedByUser())) ) {
                    setProductStructureCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ProductStrucLastChangedDate") ) {
                final Object value = values.remove("ProductStrucLastChangedDate");
                if( (value == null) || (!value.equals(getProductStrucLastChangedDate())) ) {
                    setProductStrucLastChangedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductStrucLastChangedByUser") ) {
                final Object value = values.remove("ProductStrucLastChangedByUser");
                if( (value == null) || (!value.equals(getProductStrucLastChangedByUser())) ) {
                    setProductStrucLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ProdStrucVariantChangeNumber") ) {
                final Object value = values.remove("ProdStrucVariantChangeNumber");
                if( (value == null) || (!value.equals(getProdStrucVariantChangeNumber())) ) {
                    setProdStrucVariantChangeNumber(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("ProdStrucVarIsMrkdForDeletion") ) {
                final Object value = values.remove("ProdStrucVarIsMrkdForDeletion");
                if( (value == null) || (!value.equals(getProdStrucVarIsMrkdForDeletion())) ) {
                    setProdStrucVarIsMrkdForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("ProdStrucVarChgNmbrDescription") ) {
                final Object value = values.remove("ProdStrucVarChgNmbrDescription");
                if( (value == null) || (!value.equals(getProdStrucVarChgNmbrDescription())) ) {
                    setProdStrucVarChgNmbrDescription(((String) value));
                }
            }
            if( values.containsKey("ProductStructureVariantQty") ) {
                final Object value = values.remove("ProductStructureVariantQty");
                if( (value == null) || (!value.equals(getProductStructureVariantQty())) ) {
                    setProductStructureVariantQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductStructureVariantUnit") ) {
                final Object value = values.remove("ProductStructureVariantUnit");
                if( (value == null) || (!value.equals(getProductStructureVariantUnit())) ) {
                    setProductStructureVariantUnit(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialAuthorizationGroup") ) {
                final Object value = values.remove("MaterialAuthorizationGroup");
                if( (value == null) || (!value.equals(getMaterialAuthorizationGroup())) ) {
                    setMaterialAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("ProductStructureVariantType") ) {
                final Object value = values.remove("ProductStructureVariantType");
                if( (value == null) || (!value.equals(getProductStructureVariantType())) ) {
                    setProductStructureVariantType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductStructureVariantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductStructureVariantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductStructureVariantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductStructureVariantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService.DEFAULT_SERVICE_PATH);
    }

}
