/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductStructureServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService ProductStructureService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductStructureServiceBatch
    extends
    BatchFluentHelperBasic<ProductStructureServiceBatch, ProductStructureServiceBatchChangeSet>
    implements
    ProductStructureServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductStructureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductStructureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductStructureServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductStructureServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductStructureServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductStructureServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductStructureServiceBatchChangeSet(this, service);
    }

}
