/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ProductStructureServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService ProductStructureService}.
 *
 */
public class DefaultProductStructureServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductStructureServiceBatch, ProductStructureServiceBatchChangeSet>
    implements
    ProductStructureServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductStructureServiceBatchChangeSet(
        @Nonnull final DefaultProductStructureServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductStructureService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductStructureServiceBatchChangeSet getThis()
    {
        return this;
    }

}
