/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable.ProductStructureVariantSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
 * ProductStructureVariant} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProductStructureVariantLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProductStructureVariantLink<ObjectT>, ProductStructureVariant, ObjectT>
    implements
    ProductStructureVariantSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProductStructureVariantLink( final String fieldName )
    {
        super(fieldName);
    }

    private ProductStructureVariantLink(
        final EntityLink<ProductStructureVariantLink<ObjectT>, ProductStructureVariant, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProductStructureVariantLink<ObjectT> translateLinkType(
        final EntityLink<ProductStructureVariantLink<ObjectT>, ProductStructureVariant, ObjectT> link )
    {
        return new ProductStructureVariantLink<ObjectT>(link);
    }

}
