/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
 * ProductStructureNode}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.field.ProductStructureNodeField
 * ProductStructureNodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.link.ProductStructureNodeLink
 * ProductStructureNodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUCTURE_NODE_UUID
 * PRODUCT_STRUCTURE_NODE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUCTURE_NODE_NAME
 * PRODUCT_STRUCTURE_NODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUCTURE_NODE_TYPE
 * PRODUCT_STRUCTURE_NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUCTURE_CREATION_DATE
 * PRODUCT_STRUCTURE_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUCTURE_CREATED_BY_USER
 * PRODUCT_STRUCTURE_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUC_LAST_CHANGED_DATE
 * PRODUCT_STRUC_LAST_CHANGED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#PRODUCT_STRUC_LAST_CHANGED_BY_USER
 * PRODUCT_STRUC_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode#CLASS_PROPERTY
 * CLASS_PROPERTY}</li>
 * </ul>
 *
 */
public interface ProductStructureNodeSelectable extends EntitySelectable<ProductStructureNode>
{

}
