/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
 * ProductStructureVariant}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.field.ProductStructureVariantField
 * ProductStructureVariantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.link.ProductStructureVariantLink
 * ProductStructureVariantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_VARIANT_UUID
 * PRODUCT_STRUCTURE_VARIANT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUC_VARIANT_CHG_STATE_INT_ID
 * PROD_STRUC_VARIANT_CHG_STATE_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUC_VARIANT_UNIQUE_ID
 * PROD_STRUC_VARIANT_UNIQUE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_VARIANT_NAME
 * PRODUCT_STRUCTURE_VARIANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUCTURE_VARIANT_PARENT_UUID
 * PROD_STRUCTURE_VARIANT_PARENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_CREATION_DATE
 * PRODUCT_STRUCTURE_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_CREATED_BY_USER
 * PRODUCT_STRUCTURE_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUC_LAST_CHANGED_DATE
 * PRODUCT_STRUC_LAST_CHANGED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUC_LAST_CHANGED_BY_USER
 * PRODUCT_STRUC_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUC_VARIANT_CHANGE_NUMBER
 * PROD_STRUC_VARIANT_CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUC_VAR_IS_MRKD_FOR_DELETION
 * PROD_STRUC_VAR_IS_MRKD_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PROD_STRUC_VAR_CHG_NMBR_DESCRIPTION
 * PROD_STRUC_VAR_CHG_NMBR_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_VARIANT_QTY
 * PRODUCT_STRUCTURE_VARIANT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_VARIANT_UNIT
 * PRODUCT_STRUCTURE_VARIANT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#MATERIAL_AUTHORIZATION_GROUP
 * MATERIAL_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant#PRODUCT_STRUCTURE_VARIANT_TYPE
 * PRODUCT_STRUCTURE_VARIANT_TYPE}</li>
 * </ul>
 *
 */
public interface ProductStructureVariantSelectable extends EntitySelectable<ProductStructureVariant>
{

}
