/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.field.ProfitCenterTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.link.ProfitCenterTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.selectable.ProfitCenterTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Profit Center Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProfitCenterTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfitCenterText extends VdmEntity<ProfitCenterText>
{

    /**
     * Selector for all available fields of ProfitCenterText.
     *
     */
    public final static ProfitCenterTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<String> LANGUAGE = new ProfitCenterTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<String> CONTROLLING_AREA =
        new ProfitCenterTextField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<String> PROFIT_CENTER = new ProfitCenterTextField<String>("ProfitCenter");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<LocalDateTime> VALIDITY_END_DATE =
        new ProfitCenterTextField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<LocalDateTime> VALIDITY_START_DATE =
        new ProfitCenterTextField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @return Description of Profit Center
     */
    @SerializedName( "ProfitCenterName" )
    @JsonProperty( "ProfitCenterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterName" )
    private String profitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterName</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<String> PROFIT_CENTER_NAME =
        new ProfitCenterTextField<String>("ProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterLongName</b>
     * </p>
     *
     * @return Description of Profit Center
     */
    @SerializedName( "ProfitCenterLongName" )
    @JsonProperty( "ProfitCenterLongName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterLongName" )
    private String profitCenterLongName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterLongName</b> field to query operations.
     *
     */
    public final static ProfitCenterTextField<String> PROFIT_CENTER_LONG_NAME =
        new ProfitCenterTextField<String>("ProfitCenterLongName");
    /**
     * Navigation property <b>to_ProfitCenter</b> for <b>ProfitCenterText</b> to single <b>ProfitCenter</b>.
     *
     */
    @SerializedName( "to_ProfitCenter" )
    @JsonProperty( "to_ProfitCenter" )
    @ODataField( odataName = "to_ProfitCenter" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProfitCenter toProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>to_ProfitCenter</b> navigation property to query operations.
     *
     */
    public final static ProfitCenterTextOneToOneLink<ProfitCenter> TO_PROFIT_CENTER =
        new ProfitCenterTextOneToOneLink<ProfitCenter>("to_ProfitCenter");

    @Nonnull
    @Override
    public Class<ProfitCenterText> getType()
    {
        return ProfitCenterText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @param profitCenterName
     *            Description of Profit Center
     */
    public void setProfitCenterName( @Nullable final String profitCenterName )
    {
        rememberChangedField("ProfitCenterName", this.profitCenterName);
        this.profitCenterName = profitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterLongName</b>
     * </p>
     *
     * @param profitCenterLongName
     *            Description of Profit Center
     */
    public void setProfitCenterLongName( @Nullable final String profitCenterLongName )
    {
        rememberChangedField("ProfitCenterLongName", this.profitCenterLongName);
        this.profitCenterLongName = profitCenterLongName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProfitCenterText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ControllingArea", getControllingArea());
        result.put("ProfitCenter", getProfitCenter());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ControllingArea", getControllingArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ProfitCenterName", getProfitCenterName());
        values.put("ProfitCenterLongName", getProfitCenterLongName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProfitCenterName") ) {
                final Object value = values.remove("ProfitCenterName");
                if( (value == null) || (!value.equals(getProfitCenterName())) ) {
                    setProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterLongName") ) {
                final Object value = values.remove("ProfitCenterLongName");
                if( (value == null) || (!value.equals(getProfitCenterLongName())) ) {
                    setProfitCenterLongName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProfitCenter") ) {
                final Object value = (values).remove("to_ProfitCenter");
                if( value instanceof Map ) {
                    if( toProfitCenter == null ) {
                        toProfitCenter = new ProfitCenter();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProfitCenter.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProfitCenterTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProfitCenterTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfitCenterTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfitCenterTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProfitCenterService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProfitCenter != null ) {
            (values).put("to_ProfitCenter", toProfitCenter);
        }
        return values;
    }

    /**
     * Fetches the <b>ProfitCenter</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProfitCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProfitCenter</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProfitCenter fetchProfitCenter()
    {
        return fetchFieldAsSingle("to_ProfitCenter", ProfitCenter.class);
    }

    /**
     * Retrieval of associated <b>ProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProfitCenter</b>.
     * <p>
     * If the navigation property <b>to_ProfitCenter</b> of a queried <b>ProfitCenterText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfitCenter</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProfitCenter getProfitCenterOrFetch()
    {
        if( toProfitCenter == null ) {
            toProfitCenter = fetchProfitCenter();
        }
        return toProfitCenter;
    }

    /**
     * Retrieval of associated <b>ProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProfitCenter</b>.
     * <p>
     * If the navigation property for an entity <b>ProfitCenterText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProfitCenter</b> is already loaded, the result will
     *         contain the <b>ProfitCenter</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProfitCenter> getProfitCenterIfPresent()
    {
        return Option.of(toProfitCenter);
    }

    /**
     * Overwrites the associated <b>ProfitCenter</b> entity for the loaded navigation property <b>to_ProfitCenter</b>.
     *
     * @param value
     *            New <b>ProfitCenter</b> entity.
     */
    public void setProfitCenter( final ProfitCenter value )
    {
        toProfitCenter = value;
    }

    /**
     * Helper class to allow for fluent creation of ProfitCenterText instances.
     *
     */
    public final static class ProfitCenterTextBuilder
    {

        private ProfitCenter toProfitCenter;
        private String profitCenter = null;

        private ProfitCenterText.ProfitCenterTextBuilder toProfitCenter( final ProfitCenter value )
        {
            toProfitCenter = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProfitCenter</b> for <b>ProfitCenterText</b> to single <b>ProfitCenter</b>.
         *
         * @param value
         *            The ProfitCenter to build this ProfitCenterText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenterText.ProfitCenterTextBuilder profitCenter( final ProfitCenter value )
        {
            return toProfitCenter(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ProfitCenter</b>
         * </p>
         *
         * @param value
         *            The profitCenter to build this ProfitCenterText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenterText.ProfitCenterTextBuilder profitCenter( final String value )
        {
            profitCenter = value;
            return this;
        }

    }

}
