/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ProfitCenterServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProfitCenterService ProfitCenterService}.
 *
 */
public class DefaultProfitCenterServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProfitCenterServiceBatch, ProfitCenterServiceBatchChangeSet>
    implements
    ProfitCenterServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProfitCenterService service;

    @SuppressWarnings( "deprecation" )
    DefaultProfitCenterServiceBatchChangeSet(
        @Nonnull final DefaultProfitCenterServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProfitCenterService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProfitCenterServiceBatchChangeSet getThis()
    {
        return this;
    }

}
