/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment
 * PrftCtrCompanyCodeAssignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.field.PrftCtrCompanyCodeAssignmentField
 * PrftCtrCompanyCodeAssignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.link.PrftCtrCompanyCodeAssignmentLink
 * PrftCtrCompanyCodeAssignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment#COMPANY_CODE
 * COMPANY_CODE}</li>
 * </ul>
 *
 */
public interface PrftCtrCompanyCodeAssignmentSelectable extends EntitySelectable<PrftCtrCompanyCodeAssignment>
{

}
