/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter ProfitCenter}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.field.ProfitCenterField
 * ProfitCenterField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.link.ProfitCenterLink
 * ProfitCenterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CTR_RESPONSIBLE_PERSON_NAME
 * PROFIT_CTR_RESPONSIBLE_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CTR_RESPONSIBLE_USER
 * PROFIT_CTR_RESPONSIBLE_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#DEPARTMENT DEPARTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_STANDARD_HIERARCHY
 * PROFIT_CENTER_STANDARD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#SEGMENT SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_IS_BLOCKED
 * PROFIT_CENTER_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#FORMULA_PLANNING_TEMPLATE
 * FORMULA_PLANNING_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#ADDRESS_NAME
 * ADDRESS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#ADDITIONAL_NAME
 * ADDITIONAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_ADDR_NAME3
 * PROFIT_CENTER_ADDR_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_ADDR_NAME4
 * PROFIT_CENTER_ADDR_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#STREET_ADDRESS_NAME
 * STREET_ADDRESS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PO_BOX PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#CITY_NAME CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#DISTRICT DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PHONE_NUMBER1
 * PHONE_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PHONE_NUMBER2
 * PHONE_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#TELEBOX_NUMBER
 * TELEBOX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#TELEX_NUMBER
 * TELEX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#FAX_NUMBER FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#DATA_COMMUNICATION_PHONE_NUMBER
 * DATA_COMMUNICATION_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_PRINTER_NAME
 * PROFIT_CENTER_PRINTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_CREATED_BY_USER
 * PROFIT_CENTER_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#PROFIT_CENTER_CREATION_DATE
 * PROFIT_CENTER_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#TO_PRFT_CTR_COMPANY_CODE_ASSIGNMENT
 * TO_PRFT_CTR_COMPANY_CODE_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface ProfitCenterSelectable extends EntitySelectable<ProfitCenter>
{

}
