/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndExpenseDistrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndExpenseDistrOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjDmndExpenseDistrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Demand Distribution for Expense
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjDmndExpenseDistr_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjDmndExpenseDistr extends VdmEntity<ProjDmndExpenseDistr>
{

    /**
     * Selector for all available fields of ProjDmndExpenseDistr.
     *
     */
    public final static ProjDmndExpenseDistrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistributionUUID</b>
     * </p>
     *
     * @return Global ID for the Distribution of a Demand for Expense
     */
    @Key
    @SerializedName( "ProjDmndExpnDistributionUUID" )
    @JsonProperty( "ProjDmndExpnDistributionUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistributionUUID" )
    private UUID projDmndExpnDistributionUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistributionUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> PROJ_DMND_EXPN_DISTRIBUTION_UUID =
        new ProjDmndExpenseDistrField<UUID>("ProjDmndExpnDistributionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseUUID</b>
     * </p>
     *
     * @return Global Identification of a Demand for Expense
     */
    @SerializedName( "ProjectDemandExpenseUUID" )
    @JsonProperty( "ProjectDemandExpenseUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandExpenseUUID" )
    private UUID projectDemandExpenseUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandExpenseUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> PROJECT_DEMAND_EXPENSE_UUID =
        new ProjDmndExpenseDistrField<UUID>("ProjectDemandExpenseUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> PROJECT_DEMAND_UUID =
        new ProjDmndExpenseDistrField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReferencedPlanDataUUID</b>
     * </p>
     *
     * @return Corresponding Line Item in Project Plan
     */
    @SerializedName( "ProjDmndReferencedPlanDataUUID" )
    @JsonProperty( "ProjDmndReferencedPlanDataUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndReferencedPlanDataUUID" )
    private UUID projDmndReferencedPlanDataUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndReferencedPlanDataUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> PROJ_DMND_REFERENCED_PLAN_DATA_UUID =
        new ProjDmndExpenseDistrField<UUID>("ProjDmndReferencedPlanDataUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrPeriodVal</b>
     * </p>
     *
     * @return Period to Which a Quantity is Distibuted
     */
    @SerializedName( "ProjDmndExpnDistrPeriodVal" )
    @JsonProperty( "ProjDmndExpnDistrPeriodVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrPeriodVal" )
    private String projDmndExpnDistrPeriodVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrPeriodVal</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> PROJ_DMND_EXPN_DISTR_PERIOD_VAL =
        new ProjDmndExpenseDistrField<String>("ProjDmndExpnDistrPeriodVal");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrYearVal</b>
     * </p>
     *
     * @return Year of a Distribution Period
     */
    @SerializedName( "ProjDmndExpnDistrYearVal" )
    @JsonProperty( "ProjDmndExpnDistrYearVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrYearVal" )
    private String projDmndExpnDistrYearVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrYearVal</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> PROJ_DMND_EXPN_DISTR_YEAR_VAL =
        new ProjDmndExpenseDistrField<String>("ProjDmndExpnDistrYearVal");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrAmount</b>
     * </p>
     *
     * @return Plannend Cost
     */
    @SerializedName( "ProjDmndExpnDistrAmount" )
    @JsonProperty( "ProjDmndExpnDistrAmount" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrAmount" )
    private BigDecimal projDmndExpnDistrAmount;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrAmount</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<BigDecimal> PROJ_DMND_EXPN_DISTR_AMOUNT =
        new ProjDmndExpenseDistrField<BigDecimal>("ProjDmndExpnDistrAmount");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrRevenueAmt</b>
     * </p>
     *
     * @return Planned Revenue
     */
    @SerializedName( "ProjDmndExpnDistrRevenueAmt" )
    @JsonProperty( "ProjDmndExpnDistrRevenueAmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrRevenueAmt" )
    private BigDecimal projDmndExpnDistrRevenueAmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrRevenueAmt</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<BigDecimal> PROJ_DMND_EXPN_DISTR_REVENUE_AMT =
        new ProjDmndExpenseDistrField<BigDecimal>("ProjDmndExpnDistrRevenueAmt");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Global ID of the Project to Which a Demand is Related
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> PROJECT_UUID =
        new ProjDmndExpenseDistrField<UUID>("ProjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @return UUID of the Object to Which a Demand Is Related
     */
    @SerializedName( "ReferencedObjectUUID" )
    @JsonProperty( "ReferencedObjectUUID" )
    @Nullable
    @ODataField( odataName = "ReferencedObjectUUID" )
    private UUID referencedObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ReferencedObjectUUID</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<UUID> REFERENCED_OBJECT_UUID =
        new ProjDmndExpenseDistrField<UUID>("ReferencedObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrAmountCrcy</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndExpnDistrAmountCrcy" )
    @JsonProperty( "ProjDmndExpnDistrAmountCrcy" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrAmountCrcy" )
    private String projDmndExpnDistrAmountCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrAmountCrcy</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> PROJ_DMND_EXPN_DISTR_AMOUNT_CRCY =
        new ProjDmndExpenseDistrField<String>("ProjDmndExpnDistrAmountCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrRevnAmtCrcy</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndExpnDistrRevnAmtCrcy" )
    @JsonProperty( "ProjDmndExpnDistrRevnAmtCrcy" )
    @Nullable
    @ODataField( odataName = "ProjDmndExpnDistrRevnAmtCrcy" )
    private String projDmndExpnDistrRevnAmtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExpnDistrRevnAmtCrcy</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> PROJ_DMND_EXPN_DISTR_REVN_AMT_CRCY =
        new ProjDmndExpenseDistrField<String>("ProjDmndExpnDistrRevnAmtCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> CREATED_BY_USER =
        new ProjDmndExpenseDistrField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjDmndExpenseDistrField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<String> LAST_CHANGED_BY_USER =
        new ProjDmndExpenseDistrField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndExpenseDistrField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjDmndExpenseDistrField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Root</b> for <b>ProjDmndExpenseDistr</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Navigation property <b>to_ProjectDemandExpense</b> for <b>ProjDmndExpenseDistr</b> to single
     * <b>ProjectDemandExpense</b>.
     *
     */
    @SerializedName( "to_ProjectDemandExpense" )
    @JsonProperty( "to_ProjectDemandExpense" )
    @ODataField( odataName = "to_ProjectDemandExpense" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandExpense toProjectDemandExpense;
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjDmndExpenseDistrOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjDmndExpenseDistrOneToOneLink<ProjectDemand>("to_Root");
    /**
     * Use with available fluent helpers to apply the <b>to_ProjectDemandExpense</b> navigation property to query
     * operations.
     *
     */
    public final static ProjDmndExpenseDistrOneToOneLink<ProjectDemandExpense> TO_PROJECT_DEMAND_EXPENSE =
        new ProjDmndExpenseDistrOneToOneLink<ProjectDemandExpense>("to_ProjectDemandExpense");

    @Nonnull
    @Override
    public Class<ProjDmndExpenseDistr> getType()
    {
        return ProjDmndExpenseDistr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistributionUUID</b>
     * </p>
     *
     * @param projDmndExpnDistributionUUID
     *            Global ID for the Distribution of a Demand for Expense
     */
    public void setProjDmndExpnDistributionUUID( @Nullable final UUID projDmndExpnDistributionUUID )
    {
        rememberChangedField("ProjDmndExpnDistributionUUID", this.projDmndExpnDistributionUUID);
        this.projDmndExpnDistributionUUID = projDmndExpnDistributionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseUUID</b>
     * </p>
     *
     * @param projectDemandExpenseUUID
     *            Global Identification of a Demand for Expense
     */
    public void setProjectDemandExpenseUUID( @Nullable final UUID projectDemandExpenseUUID )
    {
        rememberChangedField("ProjectDemandExpenseUUID", this.projectDemandExpenseUUID);
        this.projectDemandExpenseUUID = projectDemandExpenseUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReferencedPlanDataUUID</b>
     * </p>
     *
     * @param projDmndReferencedPlanDataUUID
     *            Corresponding Line Item in Project Plan
     */
    public void setProjDmndReferencedPlanDataUUID( @Nullable final UUID projDmndReferencedPlanDataUUID )
    {
        rememberChangedField("ProjDmndReferencedPlanDataUUID", this.projDmndReferencedPlanDataUUID);
        this.projDmndReferencedPlanDataUUID = projDmndReferencedPlanDataUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrPeriodVal</b>
     * </p>
     *
     * @param projDmndExpnDistrPeriodVal
     *            Period to Which a Quantity is Distibuted
     */
    public void setProjDmndExpnDistrPeriodVal( @Nullable final String projDmndExpnDistrPeriodVal )
    {
        rememberChangedField("ProjDmndExpnDistrPeriodVal", this.projDmndExpnDistrPeriodVal);
        this.projDmndExpnDistrPeriodVal = projDmndExpnDistrPeriodVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrYearVal</b>
     * </p>
     *
     * @param projDmndExpnDistrYearVal
     *            Year of a Distribution Period
     */
    public void setProjDmndExpnDistrYearVal( @Nullable final String projDmndExpnDistrYearVal )
    {
        rememberChangedField("ProjDmndExpnDistrYearVal", this.projDmndExpnDistrYearVal);
        this.projDmndExpnDistrYearVal = projDmndExpnDistrYearVal;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrAmount</b>
     * </p>
     *
     * @param projDmndExpnDistrAmount
     *            Plannend Cost
     */
    public void setProjDmndExpnDistrAmount( @Nullable final BigDecimal projDmndExpnDistrAmount )
    {
        rememberChangedField("ProjDmndExpnDistrAmount", this.projDmndExpnDistrAmount);
        this.projDmndExpnDistrAmount = projDmndExpnDistrAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrRevenueAmt</b>
     * </p>
     *
     * @param projDmndExpnDistrRevenueAmt
     *            Planned Revenue
     */
    public void setProjDmndExpnDistrRevenueAmt( @Nullable final BigDecimal projDmndExpnDistrRevenueAmt )
    {
        rememberChangedField("ProjDmndExpnDistrRevenueAmt", this.projDmndExpnDistrRevenueAmt);
        this.projDmndExpnDistrRevenueAmt = projDmndExpnDistrRevenueAmt;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Global ID of the Project to Which a Demand is Related
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @param referencedObjectUUID
     *            UUID of the Object to Which a Demand Is Related
     */
    public void setReferencedObjectUUID( @Nullable final UUID referencedObjectUUID )
    {
        rememberChangedField("ReferencedObjectUUID", this.referencedObjectUUID);
        this.referencedObjectUUID = referencedObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrAmountCrcy</b>
     * </p>
     *
     * @param projDmndExpnDistrAmountCrcy
     *            Currency
     */
    public void setProjDmndExpnDistrAmountCrcy( @Nullable final String projDmndExpnDistrAmountCrcy )
    {
        rememberChangedField("ProjDmndExpnDistrAmountCrcy", this.projDmndExpnDistrAmountCrcy);
        this.projDmndExpnDistrAmountCrcy = projDmndExpnDistrAmountCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExpnDistrRevnAmtCrcy</b>
     * </p>
     *
     * @param projDmndExpnDistrRevnAmtCrcy
     *            Currency
     */
    public void setProjDmndExpnDistrRevnAmtCrcy( @Nullable final String projDmndExpnDistrRevnAmtCrcy )
    {
        rememberChangedField("ProjDmndExpnDistrRevnAmtCrcy", this.projDmndExpnDistrRevnAmtCrcy);
        this.projDmndExpnDistrRevnAmtCrcy = projDmndExpnDistrRevnAmtCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjDmndExpenseDistr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDmndExpnDistributionUUID", getProjDmndExpnDistributionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDmndExpnDistributionUUID", getProjDmndExpnDistributionUUID());
        values.put("ProjectDemandExpenseUUID", getProjectDemandExpenseUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjDmndReferencedPlanDataUUID", getProjDmndReferencedPlanDataUUID());
        values.put("ProjDmndExpnDistrPeriodVal", getProjDmndExpnDistrPeriodVal());
        values.put("ProjDmndExpnDistrYearVal", getProjDmndExpnDistrYearVal());
        values.put("ProjDmndExpnDistrAmount", getProjDmndExpnDistrAmount());
        values.put("ProjDmndExpnDistrRevenueAmt", getProjDmndExpnDistrRevenueAmt());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ReferencedObjectUUID", getReferencedObjectUUID());
        values.put("ProjDmndExpnDistrAmountCrcy", getProjDmndExpnDistrAmountCrcy());
        values.put("ProjDmndExpnDistrRevnAmtCrcy", getProjDmndExpnDistrRevnAmtCrcy());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDmndExpnDistributionUUID") ) {
                final Object value = values.remove("ProjDmndExpnDistributionUUID");
                if( (value == null) || (!value.equals(getProjDmndExpnDistributionUUID())) ) {
                    setProjDmndExpnDistributionUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandExpenseUUID") ) {
                final Object value = values.remove("ProjectDemandExpenseUUID");
                if( (value == null) || (!value.equals(getProjectDemandExpenseUUID())) ) {
                    setProjectDemandExpenseUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndReferencedPlanDataUUID") ) {
                final Object value = values.remove("ProjDmndReferencedPlanDataUUID");
                if( (value == null) || (!value.equals(getProjDmndReferencedPlanDataUUID())) ) {
                    setProjDmndReferencedPlanDataUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrPeriodVal") ) {
                final Object value = values.remove("ProjDmndExpnDistrPeriodVal");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrPeriodVal())) ) {
                    setProjDmndExpnDistrPeriodVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrYearVal") ) {
                final Object value = values.remove("ProjDmndExpnDistrYearVal");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrYearVal())) ) {
                    setProjDmndExpnDistrYearVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrAmount") ) {
                final Object value = values.remove("ProjDmndExpnDistrAmount");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrAmount())) ) {
                    setProjDmndExpnDistrAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrRevenueAmt") ) {
                final Object value = values.remove("ProjDmndExpnDistrRevenueAmt");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrRevenueAmt())) ) {
                    setProjDmndExpnDistrRevenueAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ReferencedObjectUUID") ) {
                final Object value = values.remove("ReferencedObjectUUID");
                if( (value == null) || (!value.equals(getReferencedObjectUUID())) ) {
                    setReferencedObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrAmountCrcy") ) {
                final Object value = values.remove("ProjDmndExpnDistrAmountCrcy");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrAmountCrcy())) ) {
                    setProjDmndExpnDistrAmountCrcy(((String) value));
                }
            }
            if( values.containsKey("ProjDmndExpnDistrRevnAmtCrcy") ) {
                final Object value = values.remove("ProjDmndExpnDistrRevnAmtCrcy");
                if( (value == null) || (!value.equals(getProjDmndExpnDistrRevnAmtCrcy())) ) {
                    setProjDmndExpnDistrRevnAmtCrcy(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProjectDemandExpense") ) {
                final Object value = (values).remove("to_ProjectDemandExpense");
                if( value instanceof Map ) {
                    if( toProjectDemandExpense == null ) {
                        toProjectDemandExpense = new ProjectDemandExpense();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProjectDemandExpense.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjDmndExpenseDistrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjDmndExpenseDistrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjDmndExpenseDistrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjDmndExpenseDistrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        if( toProjectDemandExpense != null ) {
            (values).put("to_ProjectDemandExpense", toProjectDemandExpense);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjDmndExpenseDistr</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndExpenseDistr</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Fetches the <b>ProjectDemandExpense</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProjectDemandExpense</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandExpense</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandExpense fetchProjectDemandExpense()
    {
        return fetchFieldAsSingle("to_ProjectDemandExpense", ProjectDemandExpense.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandExpense</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProjectDemandExpense</b>.
     * <p>
     * If the navigation property <b>to_ProjectDemandExpense</b> of a queried <b>ProjDmndExpenseDistr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandExpense</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandExpense getProjectDemandExpenseOrFetch()
    {
        if( toProjectDemandExpense == null ) {
            toProjectDemandExpense = fetchProjectDemandExpense();
        }
        return toProjectDemandExpense;
    }

    /**
     * Retrieval of associated <b>ProjectDemandExpense</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProjectDemandExpense</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndExpenseDistr</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProjectDemandExpense</b> is already loaded, the result
     *         will contain the <b>ProjectDemandExpense</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandExpense> getProjectDemandExpenseIfPresent()
    {
        return Option.of(toProjectDemandExpense);
    }

    /**
     * Overwrites the associated <b>ProjectDemandExpense</b> entity for the loaded navigation property
     * <b>to_ProjectDemandExpense</b>.
     *
     * @param value
     *            New <b>ProjectDemandExpense</b> entity.
     */
    public void setProjectDemandExpense( final ProjectDemandExpense value )
    {
        toProjectDemandExpense = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjDmndExpenseDistr instances.
     *
     */
    public final static class ProjDmndExpenseDistrBuilder
    {

        private ProjectDemand toRoot;
        private ProjectDemandExpense toProjectDemandExpense;

        private ProjDmndExpenseDistr.ProjDmndExpenseDistrBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjDmndExpenseDistr</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjDmndExpenseDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndExpenseDistr.ProjDmndExpenseDistrBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

        private ProjDmndExpenseDistr.ProjDmndExpenseDistrBuilder toProjectDemandExpense(
            final ProjectDemandExpense value )
        {
            toProjectDemandExpense = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProjectDemandExpense</b> for <b>ProjDmndExpenseDistr</b> to single
         * <b>ProjectDemandExpense</b>.
         *
         * @param value
         *            The ProjectDemandExpense to build this ProjDmndExpenseDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndExpenseDistr.ProjDmndExpenseDistrBuilder projectDemandExpense( final ProjectDemandExpense value )
        {
            return toProjectDemandExpense(value);
        }

    }

}
