/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndResourceAssignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndResourceAssignmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndResourceAssignmentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjDmndResourceAssignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjDmndResourceAssignment_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjDmndResourceAssignment extends VdmEntity<ProjDmndResourceAssignment>
{

    /**
     * Selector for all available fields of ProjDmndResourceAssignment.
     *
     */
    public final static ProjDmndResourceAssignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Assignment to a Demand
     */
    @Key
    @SerializedName( "ProjDmndRsceAssgmtUUID" )
    @JsonProperty( "ProjDmndRsceAssgmtUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtUUID" )
    private UUID projDmndRsceAssgmtUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtUUID</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<UUID> PROJ_DMND_RSCE_ASSGMT_UUID =
        new ProjDmndResourceAssignmentField<UUID>("ProjDmndRsceAssgmtUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Demand
     */
    @SerializedName( "ProjectDemandWorkUUID" )
    @JsonProperty( "ProjectDemandWorkUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandWorkUUID" )
    private UUID projectDemandWorkUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandWorkUUID</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<UUID> PROJECT_DEMAND_WORK_UUID =
        new ProjDmndResourceAssignmentField<UUID>("ProjectDemandWorkUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<UUID> PROJECT_DEMAND_UUID =
        new ProjDmndResourceAssignmentField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmt</b>
     * </p>
     *
     * @return Personnel Number of a Resource
     */
    @SerializedName( "ProjDmndRsceAssgmt" )
    @JsonProperty( "ProjDmndRsceAssgmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmt" )
    private String projDmndRsceAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmt</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJ_DMND_RSCE_ASSGMT =
        new ProjDmndResourceAssignmentField<String>("ProjDmndRsceAssgmt");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtQuantity</b>
     * </p>
     *
     * @return Total Quantity of a Resource Assignment
     */
    @SerializedName( "ProjDmndRsceAssgmtQuantity" )
    @JsonProperty( "ProjDmndRsceAssgmtQuantity" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtQuantity" )
    private BigDecimal projDmndRsceAssgmtQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtQuantity</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<BigDecimal> PROJ_DMND_RSCE_ASSGMT_QUANTITY =
        new ProjDmndResourceAssignmentField<BigDecimal>("ProjDmndRsceAssgmtQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Assigned Quantity
     */
    @SerializedName( "ProjDmndRsceAssgmtQuantityUnit" )
    @JsonProperty( "ProjDmndRsceAssgmtQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtQuantityUnit" )
    private String projDmndRsceAssgmtQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtQuantityUnit</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJ_DMND_RSCE_ASSGMT_QUANTITY_UNIT =
        new ProjDmndResourceAssignmentField<String>("ProjDmndRsceAssgmtQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSupplyIdentifier</b>
     * </p>
     *
     * @return Resource Supply ID of a Project Demand
     */
    @SerializedName( "ProjectDemandSupplyIdentifier" )
    @JsonProperty( "ProjectDemandSupplyIdentifier" )
    @Nullable
    @ODataField( odataName = "ProjectDemandSupplyIdentifier" )
    private String projectDemandSupplyIdentifier;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandSupplyIdentifier</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJECT_DEMAND_SUPPLY_IDENTIFIER =
        new ProjDmndResourceAssignmentField<String>("ProjectDemandSupplyIdentifier");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSupplyDeliveryOrg</b>
     * </p>
     *
     * @return Delivery Organization of the Assigned Resource
     */
    @SerializedName( "ProjectDemandSupplyDeliveryOrg" )
    @JsonProperty( "ProjectDemandSupplyDeliveryOrg" )
    @Nullable
    @ODataField( odataName = "ProjectDemandSupplyDeliveryOrg" )
    private String projectDemandSupplyDeliveryOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandSupplyDeliveryOrg</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJECT_DEMAND_SUPPLY_DELIVERY_ORG =
        new ProjDmndResourceAssignmentField<String>("ProjectDemandSupplyDeliveryOrg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSourceOfSupply</b>
     * </p>
     *
     * @return Source of a Resource Assignment
     */
    @SerializedName( "ProjectDemandSourceOfSupply" )
    @JsonProperty( "ProjectDemandSourceOfSupply" )
    @Nullable
    @ODataField( odataName = "ProjectDemandSourceOfSupply" )
    private String projectDemandSourceOfSupply;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandSourceOfSupply</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJECT_DEMAND_SOURCE_OF_SUPPLY =
        new ProjDmndResourceAssignmentField<String>("ProjectDemandSourceOfSupply");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjAssgmtLastUpdateSource</b>
     * </p>
     *
     * @return Source of Last Update to a Resource Assignment
     */
    @SerializedName( "ProjAssgmtLastUpdateSource" )
    @JsonProperty( "ProjAssgmtLastUpdateSource" )
    @Nullable
    @ODataField( odataName = "ProjAssgmtLastUpdateSource" )
    private String projAssgmtLastUpdateSource;
    /**
     * Use with available fluent helpers to apply the <b>ProjAssgmtLastUpdateSource</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJ_ASSGMT_LAST_UPDATE_SOURCE =
        new ProjDmndResourceAssignmentField<String>("ProjAssgmtLastUpdateSource");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceWorkAssgmtOID</b>
     * </p>
     *
     * @return Work Assignment ID (SAP One Domain Model)
     */
    @SerializedName( "ProjDmndRsceWorkAssgmtOID" )
    @JsonProperty( "ProjDmndRsceWorkAssgmtOID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceWorkAssgmtOID" )
    private String projDmndRsceWorkAssgmtOID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceWorkAssgmtOID</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJ_DMND_RSCE_WORK_ASSGMT_OID =
        new ProjDmndResourceAssignmentField<String>("ProjDmndRsceWorkAssgmtOID");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceWrkfrcPersonOID</b>
     * </p>
     *
     * @return Workforce Person ID (SAP One Domain Model)
     */
    @SerializedName( "ProjDmndRsceWrkfrcPersonOID" )
    @JsonProperty( "ProjDmndRsceWrkfrcPersonOID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceWrkfrcPersonOID" )
    private String projDmndRsceWrkfrcPersonOID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceWrkfrcPersonOID</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> PROJ_DMND_RSCE_WRKFRC_PERSON_OID =
        new ProjDmndResourceAssignmentField<String>("ProjDmndRsceWrkfrcPersonOID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtStartDate</b>
     * </p>
     *
     * @return Start Date of the Demand
     */
    @SerializedName( "ProjDmndRsceAssgmtStartDate" )
    @JsonProperty( "ProjDmndRsceAssgmtStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceAssgmtStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceAssgmtStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtStartDate</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<LocalDateTime> PROJ_DMND_RSCE_ASSGMT_START_DATE =
        new ProjDmndResourceAssignmentField<LocalDateTime>("ProjDmndRsceAssgmtStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtEndDate</b>
     * </p>
     *
     * @return End Date of the Demand
     */
    @SerializedName( "ProjDmndRsceAssgmtEndDate" )
    @JsonProperty( "ProjDmndRsceAssgmtEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceAssgmtEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceAssgmtEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtEndDate</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<LocalDateTime> PROJ_DMND_RSCE_ASSGMT_END_DATE =
        new ProjDmndResourceAssignmentField<LocalDateTime>("ProjDmndRsceAssgmtEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> CREATED_BY_USER =
        new ProjDmndResourceAssignmentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjDmndResourceAssignmentField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<String> LAST_CHANGED_BY_USER =
        new ProjDmndResourceAssignmentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjDmndResourceAssignmentField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_AssgmtDistribution</b> for <b>ProjDmndResourceAssignment</b> to multiple
     * <b>ProjDmndRsceAssgmtDistr</b>.
     *
     */
    @SerializedName( "to_AssgmtDistribution" )
    @JsonProperty( "to_AssgmtDistribution" )
    @ODataField( odataName = "to_AssgmtDistribution" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjDmndRsceAssgmtDistr> toAssgmtDistribution;
    /**
     * Navigation property <b>to_Root</b> for <b>ProjDmndResourceAssignment</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Navigation property <b>to_Work</b> for <b>ProjDmndResourceAssignment</b> to single <b>ProjectDemandResource</b>.
     *
     */
    @SerializedName( "to_Work" )
    @JsonProperty( "to_Work" )
    @ODataField( odataName = "to_Work" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandResource toWork;
    /**
     * Use with available fluent helpers to apply the <b>to_AssgmtDistribution</b> navigation property to query
     * operations.
     *
     */
    public final static ProjDmndResourceAssignmentLink<ProjDmndRsceAssgmtDistr> TO_ASSGMT_DISTRIBUTION =
        new ProjDmndResourceAssignmentLink<ProjDmndRsceAssgmtDistr>("to_AssgmtDistribution");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjDmndResourceAssignmentOneToOneLink<ProjectDemand>("to_Root");
    /**
     * Use with available fluent helpers to apply the <b>to_Work</b> navigation property to query operations.
     *
     */
    public final static ProjDmndResourceAssignmentOneToOneLink<ProjectDemandResource> TO_WORK =
        new ProjDmndResourceAssignmentOneToOneLink<ProjectDemandResource>("to_Work");

    @Nonnull
    @Override
    public Class<ProjDmndResourceAssignment> getType()
    {
        return ProjDmndResourceAssignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtUUID</b>
     * </p>
     *
     * @param projDmndRsceAssgmtUUID
     *            Global Identification of a Resource Assignment to a Demand
     */
    public void setProjDmndRsceAssgmtUUID( @Nullable final UUID projDmndRsceAssgmtUUID )
    {
        rememberChangedField("ProjDmndRsceAssgmtUUID", this.projDmndRsceAssgmtUUID);
        this.projDmndRsceAssgmtUUID = projDmndRsceAssgmtUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @param projectDemandWorkUUID
     *            Global Identification of a Resource Demand
     */
    public void setProjectDemandWorkUUID( @Nullable final UUID projectDemandWorkUUID )
    {
        rememberChangedField("ProjectDemandWorkUUID", this.projectDemandWorkUUID);
        this.projectDemandWorkUUID = projectDemandWorkUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmt</b>
     * </p>
     *
     * @param projDmndRsceAssgmt
     *            Personnel Number of a Resource
     */
    public void setProjDmndRsceAssgmt( @Nullable final String projDmndRsceAssgmt )
    {
        rememberChangedField("ProjDmndRsceAssgmt", this.projDmndRsceAssgmt);
        this.projDmndRsceAssgmt = projDmndRsceAssgmt;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtQuantity</b>
     * </p>
     *
     * @param projDmndRsceAssgmtQuantity
     *            Total Quantity of a Resource Assignment
     */
    public void setProjDmndRsceAssgmtQuantity( @Nullable final BigDecimal projDmndRsceAssgmtQuantity )
    {
        rememberChangedField("ProjDmndRsceAssgmtQuantity", this.projDmndRsceAssgmtQuantity);
        this.projDmndRsceAssgmtQuantity = projDmndRsceAssgmtQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtQuantityUnit</b>
     * </p>
     *
     * @param projDmndRsceAssgmtQuantityUnit
     *            Unit of Measure for the Assigned Quantity
     */
    public void setProjDmndRsceAssgmtQuantityUnit( @Nullable final String projDmndRsceAssgmtQuantityUnit )
    {
        rememberChangedField("ProjDmndRsceAssgmtQuantityUnit", this.projDmndRsceAssgmtQuantityUnit);
        this.projDmndRsceAssgmtQuantityUnit = projDmndRsceAssgmtQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSupplyIdentifier</b>
     * </p>
     *
     * @param projectDemandSupplyIdentifier
     *            Resource Supply ID of a Project Demand
     */
    public void setProjectDemandSupplyIdentifier( @Nullable final String projectDemandSupplyIdentifier )
    {
        rememberChangedField("ProjectDemandSupplyIdentifier", this.projectDemandSupplyIdentifier);
        this.projectDemandSupplyIdentifier = projectDemandSupplyIdentifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSupplyDeliveryOrg</b>
     * </p>
     *
     * @param projectDemandSupplyDeliveryOrg
     *            Delivery Organization of the Assigned Resource
     */
    public void setProjectDemandSupplyDeliveryOrg( @Nullable final String projectDemandSupplyDeliveryOrg )
    {
        rememberChangedField("ProjectDemandSupplyDeliveryOrg", this.projectDemandSupplyDeliveryOrg);
        this.projectDemandSupplyDeliveryOrg = projectDemandSupplyDeliveryOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandSourceOfSupply</b>
     * </p>
     *
     * @param projectDemandSourceOfSupply
     *            Source of a Resource Assignment
     */
    public void setProjectDemandSourceOfSupply( @Nullable final String projectDemandSourceOfSupply )
    {
        rememberChangedField("ProjectDemandSourceOfSupply", this.projectDemandSourceOfSupply);
        this.projectDemandSourceOfSupply = projectDemandSourceOfSupply;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjAssgmtLastUpdateSource</b>
     * </p>
     *
     * @param projAssgmtLastUpdateSource
     *            Source of Last Update to a Resource Assignment
     */
    public void setProjAssgmtLastUpdateSource( @Nullable final String projAssgmtLastUpdateSource )
    {
        rememberChangedField("ProjAssgmtLastUpdateSource", this.projAssgmtLastUpdateSource);
        this.projAssgmtLastUpdateSource = projAssgmtLastUpdateSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceWorkAssgmtOID</b>
     * </p>
     *
     * @param projDmndRsceWorkAssgmtOID
     *            Work Assignment ID (SAP One Domain Model)
     */
    public void setProjDmndRsceWorkAssgmtOID( @Nullable final String projDmndRsceWorkAssgmtOID )
    {
        rememberChangedField("ProjDmndRsceWorkAssgmtOID", this.projDmndRsceWorkAssgmtOID);
        this.projDmndRsceWorkAssgmtOID = projDmndRsceWorkAssgmtOID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceWrkfrcPersonOID</b>
     * </p>
     *
     * @param projDmndRsceWrkfrcPersonOID
     *            Workforce Person ID (SAP One Domain Model)
     */
    public void setProjDmndRsceWrkfrcPersonOID( @Nullable final String projDmndRsceWrkfrcPersonOID )
    {
        rememberChangedField("ProjDmndRsceWrkfrcPersonOID", this.projDmndRsceWrkfrcPersonOID);
        this.projDmndRsceWrkfrcPersonOID = projDmndRsceWrkfrcPersonOID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtStartDate</b>
     * </p>
     *
     * @param projDmndRsceAssgmtStartDate
     *            Start Date of the Demand
     */
    public void setProjDmndRsceAssgmtStartDate( @Nullable final LocalDateTime projDmndRsceAssgmtStartDate )
    {
        rememberChangedField("ProjDmndRsceAssgmtStartDate", this.projDmndRsceAssgmtStartDate);
        this.projDmndRsceAssgmtStartDate = projDmndRsceAssgmtStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtEndDate</b>
     * </p>
     *
     * @param projDmndRsceAssgmtEndDate
     *            End Date of the Demand
     */
    public void setProjDmndRsceAssgmtEndDate( @Nullable final LocalDateTime projDmndRsceAssgmtEndDate )
    {
        rememberChangedField("ProjDmndRsceAssgmtEndDate", this.projDmndRsceAssgmtEndDate);
        this.projDmndRsceAssgmtEndDate = projDmndRsceAssgmtEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjDmndResourceAssignment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDmndRsceAssgmtUUID", getProjDmndRsceAssgmtUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDmndRsceAssgmtUUID", getProjDmndRsceAssgmtUUID());
        values.put("ProjectDemandWorkUUID", getProjectDemandWorkUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjDmndRsceAssgmt", getProjDmndRsceAssgmt());
        values.put("ProjDmndRsceAssgmtQuantity", getProjDmndRsceAssgmtQuantity());
        values.put("ProjDmndRsceAssgmtQuantityUnit", getProjDmndRsceAssgmtQuantityUnit());
        values.put("ProjectDemandSupplyIdentifier", getProjectDemandSupplyIdentifier());
        values.put("ProjectDemandSupplyDeliveryOrg", getProjectDemandSupplyDeliveryOrg());
        values.put("ProjectDemandSourceOfSupply", getProjectDemandSourceOfSupply());
        values.put("ProjAssgmtLastUpdateSource", getProjAssgmtLastUpdateSource());
        values.put("ProjDmndRsceWorkAssgmtOID", getProjDmndRsceWorkAssgmtOID());
        values.put("ProjDmndRsceWrkfrcPersonOID", getProjDmndRsceWrkfrcPersonOID());
        values.put("ProjDmndRsceAssgmtStartDate", getProjDmndRsceAssgmtStartDate());
        values.put("ProjDmndRsceAssgmtEndDate", getProjDmndRsceAssgmtEndDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDmndRsceAssgmtUUID") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtUUID");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtUUID())) ) {
                    setProjDmndRsceAssgmtUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandWorkUUID") ) {
                final Object value = values.remove("ProjectDemandWorkUUID");
                if( (value == null) || (!value.equals(getProjectDemandWorkUUID())) ) {
                    setProjectDemandWorkUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmt") ) {
                final Object value = values.remove("ProjDmndRsceAssgmt");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmt())) ) {
                    setProjDmndRsceAssgmt(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtQuantity") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtQuantity");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtQuantity())) ) {
                    setProjDmndRsceAssgmtQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtQuantityUnit") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtQuantityUnit");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtQuantityUnit())) ) {
                    setProjDmndRsceAssgmtQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandSupplyIdentifier") ) {
                final Object value = values.remove("ProjectDemandSupplyIdentifier");
                if( (value == null) || (!value.equals(getProjectDemandSupplyIdentifier())) ) {
                    setProjectDemandSupplyIdentifier(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandSupplyDeliveryOrg") ) {
                final Object value = values.remove("ProjectDemandSupplyDeliveryOrg");
                if( (value == null) || (!value.equals(getProjectDemandSupplyDeliveryOrg())) ) {
                    setProjectDemandSupplyDeliveryOrg(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandSourceOfSupply") ) {
                final Object value = values.remove("ProjectDemandSourceOfSupply");
                if( (value == null) || (!value.equals(getProjectDemandSourceOfSupply())) ) {
                    setProjectDemandSourceOfSupply(((String) value));
                }
            }
            if( values.containsKey("ProjAssgmtLastUpdateSource") ) {
                final Object value = values.remove("ProjAssgmtLastUpdateSource");
                if( (value == null) || (!value.equals(getProjAssgmtLastUpdateSource())) ) {
                    setProjAssgmtLastUpdateSource(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceWorkAssgmtOID") ) {
                final Object value = values.remove("ProjDmndRsceWorkAssgmtOID");
                if( (value == null) || (!value.equals(getProjDmndRsceWorkAssgmtOID())) ) {
                    setProjDmndRsceWorkAssgmtOID(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceWrkfrcPersonOID") ) {
                final Object value = values.remove("ProjDmndRsceWrkfrcPersonOID");
                if( (value == null) || (!value.equals(getProjDmndRsceWrkfrcPersonOID())) ) {
                    setProjDmndRsceWrkfrcPersonOID(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtStartDate") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtStartDate");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtStartDate())) ) {
                    setProjDmndRsceAssgmtStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtEndDate") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtEndDate");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtEndDate())) ) {
                    setProjDmndRsceAssgmtEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_AssgmtDistribution") ) {
                final Object value = (values).remove("to_AssgmtDistribution");
                if( value instanceof Iterable ) {
                    if( toAssgmtDistribution == null ) {
                        toAssgmtDistribution = Lists.newArrayList();
                    } else {
                        toAssgmtDistribution = Lists.newArrayList(toAssgmtDistribution);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjDmndRsceAssgmtDistr entity;
                        if( toAssgmtDistribution.size() > i ) {
                            entity = toAssgmtDistribution.get(i);
                        } else {
                            entity = new ProjDmndRsceAssgmtDistr();
                            toAssgmtDistribution.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Work") ) {
                final Object value = (values).remove("to_Work");
                if( value instanceof Map ) {
                    if( toWork == null ) {
                        toWork = new ProjectDemandResource();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWork.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjDmndResourceAssignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProjDmndResourceAssignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjDmndResourceAssignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjDmndResourceAssignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAssgmtDistribution != null ) {
            (values).put("to_AssgmtDistribution", toAssgmtDistribution);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        if( toWork != null ) {
            (values).put("to_Work", toWork);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjDmndRsceAssgmtDistr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_AssgmtDistribution</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjDmndRsceAssgmtDistr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndRsceAssgmtDistr> fetchAssgmtDistribution()
    {
        return fetchFieldAsList("to_AssgmtDistribution", ProjDmndRsceAssgmtDistr.class);
    }

    /**
     * Retrieval of associated <b>ProjDmndRsceAssgmtDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AssgmtDistribution</b>.
     * <p>
     * If the navigation property <b>to_AssgmtDistribution</b> of a queried <b>ProjDmndResourceAssignment</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjDmndRsceAssgmtDistr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndRsceAssgmtDistr> getAssgmtDistributionOrFetch()
    {
        if( toAssgmtDistribution == null ) {
            toAssgmtDistribution = fetchAssgmtDistribution();
        }
        return toAssgmtDistribution;
    }

    /**
     * Retrieval of associated <b>ProjDmndRsceAssgmtDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AssgmtDistribution</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndResourceAssignment</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_AssgmtDistribution</b> is already loaded, the result
     *         will contain the <b>ProjDmndRsceAssgmtDistr</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjDmndRsceAssgmtDistr>> getAssgmtDistributionIfPresent()
    {
        return Option.of(toAssgmtDistribution);
    }

    /**
     * Overwrites the list of associated <b>ProjDmndRsceAssgmtDistr</b> entities for the loaded navigation property
     * <b>to_AssgmtDistribution</b>.
     * <p>
     * If the navigation property <b>to_AssgmtDistribution</b> of a queried <b>ProjDmndResourceAssignment</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjDmndRsceAssgmtDistr</b> entities.
     */
    public void setAssgmtDistribution( @Nonnull final List<ProjDmndRsceAssgmtDistr> value )
    {
        if( toAssgmtDistribution == null ) {
            toAssgmtDistribution = Lists.newArrayList();
        }
        toAssgmtDistribution.clear();
        toAssgmtDistribution.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjDmndRsceAssgmtDistr</b> entities. This corresponds to the OData
     * navigation property <b>to_AssgmtDistribution</b>.
     * <p>
     * If the navigation property <b>to_AssgmtDistribution</b> of a queried <b>ProjDmndResourceAssignment</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjDmndRsceAssgmtDistr</b> entities.
     */
    public void addAssgmtDistribution( ProjDmndRsceAssgmtDistr... entity )
    {
        if( toAssgmtDistribution == null ) {
            toAssgmtDistribution = Lists.newArrayList();
        }
        toAssgmtDistribution.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjDmndResourceAssignment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndResourceAssignment</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Fetches the <b>ProjectDemandResource</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Work</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandResource</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource fetchWork()
    {
        return fetchFieldAsSingle("to_Work", ProjectDemandResource.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property <b>to_Work</b> of a queried <b>ProjDmndResourceAssignment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandResource</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource getWorkOrFetch()
    {
        if( toWork == null ) {
            toWork = fetchWork();
        }
        return toWork;
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndResourceAssignment</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Work</b> is already loaded, the result will contain the
     *         <b>ProjectDemandResource</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<ProjectDemandResource> getWorkIfPresent()
    {
        return Option.of(toWork);
    }

    /**
     * Overwrites the associated <b>ProjectDemandResource</b> entity for the loaded navigation property <b>to_Work</b>.
     *
     * @param value
     *            New <b>ProjectDemandResource</b> entity.
     */
    public void setWork( final ProjectDemandResource value )
    {
        toWork = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjDmndResourceAssignment instances.
     *
     */
    public final static class ProjDmndResourceAssignmentBuilder
    {

        private List<ProjDmndRsceAssgmtDistr> toAssgmtDistribution = Lists.newArrayList();
        private ProjectDemand toRoot;
        private ProjectDemandResource toWork;

        private ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder toAssgmtDistribution(
            final List<ProjDmndRsceAssgmtDistr> value )
        {
            toAssgmtDistribution.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_AssgmtDistribution</b> for <b>ProjDmndResourceAssignment</b> to multiple
         * <b>ProjDmndRsceAssgmtDistr</b>.
         *
         * @param value
         *            The ProjDmndRsceAssgmtDistrs to build this ProjDmndResourceAssignment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder assgmtDistribution(
            ProjDmndRsceAssgmtDistr... value )
        {
            return toAssgmtDistribution(Lists.newArrayList(value));
        }

        private ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjDmndResourceAssignment</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjDmndResourceAssignment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

        private ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder toWork( final ProjectDemandResource value )
        {
            toWork = value;
            return this;
        }

        /**
         * Navigation property <b>to_Work</b> for <b>ProjDmndResourceAssignment</b> to single
         * <b>ProjectDemandResource</b>.
         *
         * @param value
         *            The ProjectDemandResource to build this ProjDmndResourceAssignment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndResourceAssignment.ProjDmndResourceAssignmentBuilder work( final ProjectDemandResource value )
        {
            return toWork(value);
        }

    }

}
