/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjDmndResourceAssignmentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
 * ProjDmndResourceAssignment} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProjDmndResourceAssignmentByKeyFluentHelper
    extends
    FluentHelperByKey<ProjDmndResourceAssignmentByKeyFluentHelper, ProjDmndResourceAssignment, ProjDmndResourceAssignmentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProjDmndResourceAssignment}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProjDmndResourceAssignment}
     * @param projDmndRsceAssgmtUUID
     *            Global Identification of a Resource Assignment to a Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProjDmndResourceAssignmentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID projDmndRsceAssgmtUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjDmndRsceAssgmtUUID", projDmndRsceAssgmtUUID);
    }

    @Override
    @Nonnull
    protected Class<ProjDmndResourceAssignment> getEntityClass()
    {
        return ProjDmndResourceAssignment.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
