/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndRsceAssgmtDistrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndRsceAssgmtDistrOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjDmndRsceAssgmtDistrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Assignment Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjDmndRsceAssgmtDistr_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjDmndRsceAssgmtDistr extends VdmEntity<ProjDmndRsceAssgmtDistr>
{

    /**
     * Selector for all available fields of ProjDmndRsceAssgmtDistr.
     *
     */
    public final static ProjDmndRsceAssgmtDistrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Assignment Distribution
     */
    @Key
    @SerializedName( "ProjDmndRsceAssgmtDistrUUID" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtDistrUUID" )
    private UUID projDmndRsceAssgmtDistrUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<UUID> PROJ_DMND_RSCE_ASSGMT_DISTR_UUID =
        new ProjDmndRsceAssgmtDistrField<UUID>("ProjDmndRsceAssgmtDistrUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Assignment to a Demand
     */
    @SerializedName( "ProjDmndRsceAssgmtUUID" )
    @JsonProperty( "ProjDmndRsceAssgmtUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtUUID" )
    private UUID projDmndRsceAssgmtUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<UUID> PROJ_DMND_RSCE_ASSGMT_UUID =
        new ProjDmndRsceAssgmtDistrField<UUID>("ProjDmndRsceAssgmtUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<UUID> PROJECT_DEMAND_UUID =
        new ProjDmndRsceAssgmtDistrField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrYearVal</b>
     * </p>
     *
     * @return Year of a Distribution Period
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrYearVal" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrYearVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtDistrYearVal" )
    private String projDmndRsceAssgmtDistrYearVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrYearVal</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> PROJ_DMND_RSCE_ASSGMT_DISTR_YEAR_VAL =
        new ProjDmndRsceAssgmtDistrField<String>("ProjDmndRsceAssgmtDistrYearVal");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrPerdVal</b>
     * </p>
     *
     * @return Period to Which a Quantity is Distibuted
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrPerdVal" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrPerdVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtDistrPerdVal" )
    private String projDmndRsceAssgmtDistrPerdVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrPerdVal</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> PROJ_DMND_RSCE_ASSGMT_DISTR_PERD_VAL =
        new ProjDmndRsceAssgmtDistrField<String>("ProjDmndRsceAssgmtDistrPerdVal");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrQty</b>
     * </p>
     *
     * @return Resource Quantity Assigned for a Distribution Period
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrQty" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrQty" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtDistrQty" )
    private BigDecimal projDmndRsceAssgmtDistrQty;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrQty</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<BigDecimal> PROJ_DMND_RSCE_ASSGMT_DISTR_QTY =
        new ProjDmndRsceAssgmtDistrField<BigDecimal>("ProjDmndRsceAssgmtDistrQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrQtyUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Distributed Quantity
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrQtyUnit" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceAssgmtDistrQtyUnit" )
    private String projDmndRsceAssgmtDistrQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrQtyUnit</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> PROJ_DMND_RSCE_ASSGMT_DISTR_QTY_UNIT =
        new ProjDmndRsceAssgmtDistrField<String>("ProjDmndRsceAssgmtDistrQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrPerdAmt</b>
     * </p>
     *
     * @return Plannend Cost
     */
    @SerializedName( "ProjDmndRsceDistrPerdAmt" )
    @JsonProperty( "ProjDmndRsceDistrPerdAmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceDistrPerdAmt" )
    private BigDecimal projDmndRsceDistrPerdAmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceDistrPerdAmt</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<BigDecimal> PROJ_DMND_RSCE_DISTR_PERD_AMT =
        new ProjDmndRsceAssgmtDistrField<BigDecimal>("ProjDmndRsceDistrPerdAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrPerdAmtCur</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndRsceDistrPerdAmtCur" )
    @JsonProperty( "ProjDmndRsceDistrPerdAmtCur" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceDistrPerdAmtCur" )
    private String projDmndRsceDistrPerdAmtCur;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceDistrPerdAmtCur</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> PROJ_DMND_RSCE_DISTR_PERD_AMT_CUR =
        new ProjDmndRsceAssgmtDistrField<String>("ProjDmndRsceDistrPerdAmtCur");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrRevenueAmt</b>
     * </p>
     *
     * @return Planned Revenue
     */
    @SerializedName( "ProjDmndRsceDistrRevenueAmt" )
    @JsonProperty( "ProjDmndRsceDistrRevenueAmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceDistrRevenueAmt" )
    private BigDecimal projDmndRsceDistrRevenueAmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceDistrRevenueAmt</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<BigDecimal> PROJ_DMND_RSCE_DISTR_REVENUE_AMT =
        new ProjDmndRsceAssgmtDistrField<BigDecimal>("ProjDmndRsceDistrRevenueAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrRevenueAmtCur</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndRsceDistrRevenueAmtCur" )
    @JsonProperty( "ProjDmndRsceDistrRevenueAmtCur" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceDistrRevenueAmtCur" )
    private String projDmndRsceDistrRevenueAmtCur;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceDistrRevenueAmtCur</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> PROJ_DMND_RSCE_DISTR_REVENUE_AMT_CUR =
        new ProjDmndRsceAssgmtDistrField<String>("ProjDmndRsceDistrRevenueAmtCur");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrStrtDte</b>
     * </p>
     *
     * @return Start Date of the Distribution Period
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrStrtDte" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceAssgmtDistrStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceAssgmtDistrStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrStrtDte</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<LocalDateTime> PROJ_DMND_RSCE_ASSGMT_DISTR_STRT_DTE =
        new ProjDmndRsceAssgmtDistrField<LocalDateTime>("ProjDmndRsceAssgmtDistrStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrEndDte</b>
     * </p>
     *
     * @return End Date of the Distribution Period
     */
    @SerializedName( "ProjDmndRsceAssgmtDistrEndDte" )
    @JsonProperty( "ProjDmndRsceAssgmtDistrEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceAssgmtDistrEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceAssgmtDistrEndDte;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceAssgmtDistrEndDte</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<LocalDateTime> PROJ_DMND_RSCE_ASSGMT_DISTR_END_DTE =
        new ProjDmndRsceAssgmtDistrField<LocalDateTime>("ProjDmndRsceAssgmtDistrEndDte");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrIsNotSupplied</b>
     * </p>
     *
     * @return Resource Assignment Is Confirmed
     */
    @SerializedName( "ProjDmndRsceDistrIsNotSupplied" )
    @JsonProperty( "ProjDmndRsceDistrIsNotSupplied" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProjDmndRsceDistrIsNotSupplied" )
    private Boolean projDmndRsceDistrIsNotSupplied;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceDistrIsNotSupplied</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<Boolean> PROJ_DMND_RSCE_DISTR_IS_NOT_SUPPLIED =
        new ProjDmndRsceAssgmtDistrField<Boolean>("ProjDmndRsceDistrIsNotSupplied");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> CREATED_BY_USER =
        new ProjDmndRsceAssgmtDistrField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjDmndRsceAssgmtDistrField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<String> LAST_CHANGED_BY_USER =
        new ProjDmndRsceAssgmtDistrField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjDmndRsceAssgmtDistrField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Assignment</b> for <b>ProjDmndRsceAssgmtDistr</b> to single
     * <b>ProjDmndResourceAssignment</b>.
     *
     */
    @SerializedName( "to_Assignment" )
    @JsonProperty( "to_Assignment" )
    @ODataField( odataName = "to_Assignment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjDmndResourceAssignment toAssignment;
    /**
     * Navigation property <b>to_Root</b> for <b>ProjDmndRsceAssgmtDistr</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Use with available fluent helpers to apply the <b>to_Assignment</b> navigation property to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrOneToOneLink<ProjDmndResourceAssignment> TO_ASSIGNMENT =
        new ProjDmndRsceAssgmtDistrOneToOneLink<ProjDmndResourceAssignment>("to_Assignment");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjDmndRsceAssgmtDistrOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjDmndRsceAssgmtDistrOneToOneLink<ProjectDemand>("to_Root");

    @Nonnull
    @Override
    public Class<ProjDmndRsceAssgmtDistr> getType()
    {
        return ProjDmndRsceAssgmtDistr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrUUID</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrUUID
     *            Global Identification of a Resource Assignment Distribution
     */
    public void setProjDmndRsceAssgmtDistrUUID( @Nullable final UUID projDmndRsceAssgmtDistrUUID )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrUUID", this.projDmndRsceAssgmtDistrUUID);
        this.projDmndRsceAssgmtDistrUUID = projDmndRsceAssgmtDistrUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtUUID</b>
     * </p>
     *
     * @param projDmndRsceAssgmtUUID
     *            Global Identification of a Resource Assignment to a Demand
     */
    public void setProjDmndRsceAssgmtUUID( @Nullable final UUID projDmndRsceAssgmtUUID )
    {
        rememberChangedField("ProjDmndRsceAssgmtUUID", this.projDmndRsceAssgmtUUID);
        this.projDmndRsceAssgmtUUID = projDmndRsceAssgmtUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrYearVal</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrYearVal
     *            Year of a Distribution Period
     */
    public void setProjDmndRsceAssgmtDistrYearVal( @Nullable final String projDmndRsceAssgmtDistrYearVal )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrYearVal", this.projDmndRsceAssgmtDistrYearVal);
        this.projDmndRsceAssgmtDistrYearVal = projDmndRsceAssgmtDistrYearVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrPerdVal</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrPerdVal
     *            Period to Which a Quantity is Distibuted
     */
    public void setProjDmndRsceAssgmtDistrPerdVal( @Nullable final String projDmndRsceAssgmtDistrPerdVal )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrPerdVal", this.projDmndRsceAssgmtDistrPerdVal);
        this.projDmndRsceAssgmtDistrPerdVal = projDmndRsceAssgmtDistrPerdVal;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrQty</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrQty
     *            Resource Quantity Assigned for a Distribution Period
     */
    public void setProjDmndRsceAssgmtDistrQty( @Nullable final BigDecimal projDmndRsceAssgmtDistrQty )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrQty", this.projDmndRsceAssgmtDistrQty);
        this.projDmndRsceAssgmtDistrQty = projDmndRsceAssgmtDistrQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrQtyUnit</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrQtyUnit
     *            Unit of Measure for the Distributed Quantity
     */
    public void setProjDmndRsceAssgmtDistrQtyUnit( @Nullable final String projDmndRsceAssgmtDistrQtyUnit )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrQtyUnit", this.projDmndRsceAssgmtDistrQtyUnit);
        this.projDmndRsceAssgmtDistrQtyUnit = projDmndRsceAssgmtDistrQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrPerdAmt</b>
     * </p>
     *
     * @param projDmndRsceDistrPerdAmt
     *            Plannend Cost
     */
    public void setProjDmndRsceDistrPerdAmt( @Nullable final BigDecimal projDmndRsceDistrPerdAmt )
    {
        rememberChangedField("ProjDmndRsceDistrPerdAmt", this.projDmndRsceDistrPerdAmt);
        this.projDmndRsceDistrPerdAmt = projDmndRsceDistrPerdAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrPerdAmtCur</b>
     * </p>
     *
     * @param projDmndRsceDistrPerdAmtCur
     *            Currency
     */
    public void setProjDmndRsceDistrPerdAmtCur( @Nullable final String projDmndRsceDistrPerdAmtCur )
    {
        rememberChangedField("ProjDmndRsceDistrPerdAmtCur", this.projDmndRsceDistrPerdAmtCur);
        this.projDmndRsceDistrPerdAmtCur = projDmndRsceDistrPerdAmtCur;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrRevenueAmt</b>
     * </p>
     *
     * @param projDmndRsceDistrRevenueAmt
     *            Planned Revenue
     */
    public void setProjDmndRsceDistrRevenueAmt( @Nullable final BigDecimal projDmndRsceDistrRevenueAmt )
    {
        rememberChangedField("ProjDmndRsceDistrRevenueAmt", this.projDmndRsceDistrRevenueAmt);
        this.projDmndRsceDistrRevenueAmt = projDmndRsceDistrRevenueAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrRevenueAmtCur</b>
     * </p>
     *
     * @param projDmndRsceDistrRevenueAmtCur
     *            Currency
     */
    public void setProjDmndRsceDistrRevenueAmtCur( @Nullable final String projDmndRsceDistrRevenueAmtCur )
    {
        rememberChangedField("ProjDmndRsceDistrRevenueAmtCur", this.projDmndRsceDistrRevenueAmtCur);
        this.projDmndRsceDistrRevenueAmtCur = projDmndRsceDistrRevenueAmtCur;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrStrtDte</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrStrtDte
     *            Start Date of the Distribution Period
     */
    public void setProjDmndRsceAssgmtDistrStrtDte( @Nullable final LocalDateTime projDmndRsceAssgmtDistrStrtDte )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrStrtDte", this.projDmndRsceAssgmtDistrStrtDte);
        this.projDmndRsceAssgmtDistrStrtDte = projDmndRsceAssgmtDistrStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceAssgmtDistrEndDte</b>
     * </p>
     *
     * @param projDmndRsceAssgmtDistrEndDte
     *            End Date of the Distribution Period
     */
    public void setProjDmndRsceAssgmtDistrEndDte( @Nullable final LocalDateTime projDmndRsceAssgmtDistrEndDte )
    {
        rememberChangedField("ProjDmndRsceAssgmtDistrEndDte", this.projDmndRsceAssgmtDistrEndDte);
        this.projDmndRsceAssgmtDistrEndDte = projDmndRsceAssgmtDistrEndDte;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceDistrIsNotSupplied</b>
     * </p>
     *
     * @param projDmndRsceDistrIsNotSupplied
     *            Resource Assignment Is Confirmed
     */
    public void setProjDmndRsceDistrIsNotSupplied( @Nullable final Boolean projDmndRsceDistrIsNotSupplied )
    {
        rememberChangedField("ProjDmndRsceDistrIsNotSupplied", this.projDmndRsceDistrIsNotSupplied);
        this.projDmndRsceDistrIsNotSupplied = projDmndRsceDistrIsNotSupplied;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjDmndRsceAssgmtDistr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDmndRsceAssgmtDistrUUID", getProjDmndRsceAssgmtDistrUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDmndRsceAssgmtDistrUUID", getProjDmndRsceAssgmtDistrUUID());
        values.put("ProjDmndRsceAssgmtUUID", getProjDmndRsceAssgmtUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjDmndRsceAssgmtDistrYearVal", getProjDmndRsceAssgmtDistrYearVal());
        values.put("ProjDmndRsceAssgmtDistrPerdVal", getProjDmndRsceAssgmtDistrPerdVal());
        values.put("ProjDmndRsceAssgmtDistrQty", getProjDmndRsceAssgmtDistrQty());
        values.put("ProjDmndRsceAssgmtDistrQtyUnit", getProjDmndRsceAssgmtDistrQtyUnit());
        values.put("ProjDmndRsceDistrPerdAmt", getProjDmndRsceDistrPerdAmt());
        values.put("ProjDmndRsceDistrPerdAmtCur", getProjDmndRsceDistrPerdAmtCur());
        values.put("ProjDmndRsceDistrRevenueAmt", getProjDmndRsceDistrRevenueAmt());
        values.put("ProjDmndRsceDistrRevenueAmtCur", getProjDmndRsceDistrRevenueAmtCur());
        values.put("ProjDmndRsceAssgmtDistrStrtDte", getProjDmndRsceAssgmtDistrStrtDte());
        values.put("ProjDmndRsceAssgmtDistrEndDte", getProjDmndRsceAssgmtDistrEndDte());
        values.put("ProjDmndRsceDistrIsNotSupplied", getProjDmndRsceDistrIsNotSupplied());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDmndRsceAssgmtDistrUUID") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrUUID");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrUUID())) ) {
                    setProjDmndRsceAssgmtDistrUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtUUID") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtUUID");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtUUID())) ) {
                    setProjDmndRsceAssgmtUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrYearVal") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrYearVal");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrYearVal())) ) {
                    setProjDmndRsceAssgmtDistrYearVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrPerdVal") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrPerdVal");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrPerdVal())) ) {
                    setProjDmndRsceAssgmtDistrPerdVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrQty") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrQty");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrQty())) ) {
                    setProjDmndRsceAssgmtDistrQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrQtyUnit") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrQtyUnit");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrQtyUnit())) ) {
                    setProjDmndRsceAssgmtDistrQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceDistrPerdAmt") ) {
                final Object value = values.remove("ProjDmndRsceDistrPerdAmt");
                if( (value == null) || (!value.equals(getProjDmndRsceDistrPerdAmt())) ) {
                    setProjDmndRsceDistrPerdAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceDistrPerdAmtCur") ) {
                final Object value = values.remove("ProjDmndRsceDistrPerdAmtCur");
                if( (value == null) || (!value.equals(getProjDmndRsceDistrPerdAmtCur())) ) {
                    setProjDmndRsceDistrPerdAmtCur(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceDistrRevenueAmt") ) {
                final Object value = values.remove("ProjDmndRsceDistrRevenueAmt");
                if( (value == null) || (!value.equals(getProjDmndRsceDistrRevenueAmt())) ) {
                    setProjDmndRsceDistrRevenueAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceDistrRevenueAmtCur") ) {
                final Object value = values.remove("ProjDmndRsceDistrRevenueAmtCur");
                if( (value == null) || (!value.equals(getProjDmndRsceDistrRevenueAmtCur())) ) {
                    setProjDmndRsceDistrRevenueAmtCur(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrStrtDte") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrStrtDte");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrStrtDte())) ) {
                    setProjDmndRsceAssgmtDistrStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndRsceAssgmtDistrEndDte") ) {
                final Object value = values.remove("ProjDmndRsceAssgmtDistrEndDte");
                if( (value == null) || (!value.equals(getProjDmndRsceAssgmtDistrEndDte())) ) {
                    setProjDmndRsceAssgmtDistrEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndRsceDistrIsNotSupplied") ) {
                final Object value = values.remove("ProjDmndRsceDistrIsNotSupplied");
                if( (value == null) || (!value.equals(getProjDmndRsceDistrIsNotSupplied())) ) {
                    setProjDmndRsceDistrIsNotSupplied(((Boolean) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Assignment") ) {
                final Object value = (values).remove("to_Assignment");
                if( value instanceof Map ) {
                    if( toAssignment == null ) {
                        toAssignment = new ProjDmndResourceAssignment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toAssignment.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjDmndRsceAssgmtDistrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjDmndRsceAssgmtDistrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjDmndRsceAssgmtDistrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjDmndRsceAssgmtDistrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAssignment != null ) {
            (values).put("to_Assignment", toAssignment);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjDmndResourceAssignment</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Assignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjDmndResourceAssignment</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjDmndResourceAssignment fetchAssignment()
    {
        return fetchFieldAsSingle("to_Assignment", ProjDmndResourceAssignment.class);
    }

    /**
     * Retrieval of associated <b>ProjDmndResourceAssignment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Assignment</b>.
     * <p>
     * If the navigation property <b>to_Assignment</b> of a queried <b>ProjDmndRsceAssgmtDistr</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjDmndResourceAssignment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjDmndResourceAssignment getAssignmentOrFetch()
    {
        if( toAssignment == null ) {
            toAssignment = fetchAssignment();
        }
        return toAssignment;
    }

    /**
     * Retrieval of associated <b>ProjDmndResourceAssignment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Assignment</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndRsceAssgmtDistr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Assignment</b> is already loaded, the result will
     *         contain the <b>ProjDmndResourceAssignment</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjDmndResourceAssignment> getAssignmentIfPresent()
    {
        return Option.of(toAssignment);
    }

    /**
     * Overwrites the associated <b>ProjDmndResourceAssignment</b> entity for the loaded navigation property
     * <b>to_Assignment</b>.
     *
     * @param value
     *            New <b>ProjDmndResourceAssignment</b> entity.
     */
    public void setAssignment( final ProjDmndResourceAssignment value )
    {
        toAssignment = value;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjDmndRsceAssgmtDistr</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndRsceAssgmtDistr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjDmndRsceAssgmtDistr instances.
     *
     */
    public final static class ProjDmndRsceAssgmtDistrBuilder
    {

        private ProjDmndResourceAssignment toAssignment;
        private ProjectDemand toRoot;

        private ProjDmndRsceAssgmtDistr.ProjDmndRsceAssgmtDistrBuilder toAssignment(
            final ProjDmndResourceAssignment value )
        {
            toAssignment = value;
            return this;
        }

        /**
         * Navigation property <b>to_Assignment</b> for <b>ProjDmndRsceAssgmtDistr</b> to single
         * <b>ProjDmndResourceAssignment</b>.
         *
         * @param value
         *            The ProjDmndResourceAssignment to build this ProjDmndRsceAssgmtDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndRsceAssgmtDistr.ProjDmndRsceAssgmtDistrBuilder assignment(
            final ProjDmndResourceAssignment value )
        {
            return toAssignment(value);
        }

        private ProjDmndRsceAssgmtDistr.ProjDmndRsceAssgmtDistrBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjDmndRsceAssgmtDistr</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjDmndRsceAssgmtDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndRsceAssgmtDistr.ProjDmndRsceAssgmtDistrBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

    }

}
