/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndRsceReqDistributionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndRsceReqDistributionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjDmndRsceReqDistributionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Request Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjDmndRsceReqDistribution_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjDmndRsceReqDistribution extends VdmEntity<ProjDmndRsceReqDistribution>
{

    /**
     * Selector for all available fields of ProjDmndRsceReqDistribution.
     *
     */
    public final static ProjDmndRsceReqDistributionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Request Distribution
     */
    @Key
    @SerializedName( "ProjDmndRsceReqDistrUUID" )
    @JsonProperty( "ProjDmndRsceReqDistrUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrUUID" )
    private UUID projDmndRsceReqDistrUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<UUID> PROJ_DMND_RSCE_REQ_DISTR_UUID =
        new ProjDmndRsceReqDistributionField<UUID>("ProjDmndRsceReqDistrUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndResourceRequestUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Request
     */
    @SerializedName( "ProjDmndResourceRequestUUID" )
    @JsonProperty( "ProjDmndResourceRequestUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndResourceRequestUUID" )
    private UUID projDmndResourceRequestUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndResourceRequestUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<UUID> PROJ_DMND_RESOURCE_REQUEST_UUID =
        new ProjDmndRsceReqDistributionField<UUID>("ProjDmndResourceRequestUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<UUID> PROJECT_DEMAND_UUID =
        new ProjDmndRsceReqDistributionField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrYearVal</b>
     * </p>
     *
     * @return Year of a Distribution Period
     */
    @SerializedName( "ProjDmndRsceReqDistrYearVal" )
    @JsonProperty( "ProjDmndRsceReqDistrYearVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrYearVal" )
    private String projDmndRsceReqDistrYearVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrYearVal</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> PROJ_DMND_RSCE_REQ_DISTR_YEAR_VAL =
        new ProjDmndRsceReqDistributionField<String>("ProjDmndRsceReqDistrYearVal");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdVal</b>
     * </p>
     *
     * @return Period to Which a Quantity is Distibuted
     */
    @SerializedName( "ProjDmndRsceReqDistrPerdVal" )
    @JsonProperty( "ProjDmndRsceReqDistrPerdVal" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrPerdVal" )
    private String projDmndRsceReqDistrPerdVal;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrPerdVal</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> PROJ_DMND_RSCE_REQ_DISTR_PERD_VAL =
        new ProjDmndRsceReqDistributionField<String>("ProjDmndRsceReqDistrPerdVal");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrQuantity</b>
     * </p>
     *
     * @return Resource Quantity Requested for a Distribution Period
     */
    @SerializedName( "ProjDmndRsceReqDistrQuantity" )
    @JsonProperty( "ProjDmndRsceReqDistrQuantity" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrQuantity" )
    private BigDecimal projDmndRsceReqDistrQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrQuantity</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<BigDecimal> PROJ_DMND_RSCE_REQ_DISTR_QUANTITY =
        new ProjDmndRsceReqDistributionField<BigDecimal>("ProjDmndRsceReqDistrQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrQtyUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Distributed Quantity
     */
    @SerializedName( "ProjDmndRsceReqDistrQtyUnit" )
    @JsonProperty( "ProjDmndRsceReqDistrQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrQtyUnit" )
    private String projDmndRsceReqDistrQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrQtyUnit</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> PROJ_DMND_RSCE_REQ_DISTR_QTY_UNIT =
        new ProjDmndRsceReqDistributionField<String>("ProjDmndRsceReqDistrQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdAmt</b>
     * </p>
     *
     * @return Plannend Cost
     */
    @SerializedName( "ProjDmndRsceReqDistrPerdAmt" )
    @JsonProperty( "ProjDmndRsceReqDistrPerdAmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrPerdAmt" )
    private BigDecimal projDmndRsceReqDistrPerdAmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrPerdAmt</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<BigDecimal> PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT =
        new ProjDmndRsceReqDistributionField<BigDecimal>("ProjDmndRsceReqDistrPerdAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdAmtCur</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndRsceReqDistrPerdAmtCur" )
    @JsonProperty( "ProjDmndRsceReqDistrPerdAmtCur" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrPerdAmtCur" )
    private String projDmndRsceReqDistrPerdAmtCur;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrPerdAmtCur</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT_CUR =
        new ProjDmndRsceReqDistributionField<String>("ProjDmndRsceReqDistrPerdAmtCur");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrRevenueAmt</b>
     * </p>
     *
     * @return Planned Revenue
     */
    @SerializedName( "ProjDmndRsceReqDistrRevenueAmt" )
    @JsonProperty( "ProjDmndRsceReqDistrRevenueAmt" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrRevenueAmt" )
    private BigDecimal projDmndRsceReqDistrRevenueAmt;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrRevenueAmt</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<BigDecimal> PROJ_DMND_RSCE_REQ_DISTR_REVENUE_AMT =
        new ProjDmndRsceReqDistributionField<BigDecimal>("ProjDmndRsceReqDistrRevenueAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrRevnAmtCur</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ProjDmndRsceReqDistrRevnAmtCur" )
    @JsonProperty( "ProjDmndRsceReqDistrRevnAmtCur" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqDistrRevnAmtCur" )
    private String projDmndRsceReqDistrRevnAmtCur;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrRevnAmtCur</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> PROJ_DMND_RSCE_REQ_DISTR_REVN_AMT_CUR =
        new ProjDmndRsceReqDistributionField<String>("ProjDmndRsceReqDistrRevnAmtCur");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReferencedPlanDataUUID</b>
     * </p>
     *
     * @return Corresponding Line Item in Project Plan
     */
    @SerializedName( "ProjDmndReferencedPlanDataUUID" )
    @JsonProperty( "ProjDmndReferencedPlanDataUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndReferencedPlanDataUUID" )
    private UUID projDmndReferencedPlanDataUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndReferencedPlanDataUUID</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<UUID> PROJ_DMND_REFERENCED_PLAN_DATA_UUID =
        new ProjDmndRsceReqDistributionField<UUID>("ProjDmndReferencedPlanDataUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrStartDate</b>
     * </p>
     *
     * @return Start Date of the Distribution Period
     */
    @SerializedName( "ProjDmndRsceReqDistrStartDate" )
    @JsonProperty( "ProjDmndRsceReqDistrStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceReqDistrStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceReqDistrStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrStartDate</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<LocalDateTime> PROJ_DMND_RSCE_REQ_DISTR_START_DATE =
        new ProjDmndRsceReqDistributionField<LocalDateTime>("ProjDmndRsceReqDistrStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrEndDate</b>
     * </p>
     *
     * @return End Date of the Distribution Period
     */
    @SerializedName( "ProjDmndRsceReqDistrEndDate" )
    @JsonProperty( "ProjDmndRsceReqDistrEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceReqDistrEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceReqDistrEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqDistrEndDate</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<LocalDateTime> PROJ_DMND_RSCE_REQ_DISTR_END_DATE =
        new ProjDmndRsceReqDistributionField<LocalDateTime>("ProjDmndRsceReqDistrEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> CREATED_BY_USER =
        new ProjDmndRsceReqDistributionField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjDmndRsceReqDistributionField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<String> LAST_CHANGED_BY_USER =
        new ProjDmndRsceReqDistributionField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjDmndRsceReqDistributionField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Root</b> for <b>ProjDmndRsceReqDistribution</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Navigation property <b>to_ProjDmndRsceReq</b> for <b>ProjDmndRsceReqDistribution</b> to single
     * <b>ProjectDemandResourceRequest</b>.
     *
     */
    @SerializedName( "to_ProjDmndRsceReq" )
    @JsonProperty( "to_ProjDmndRsceReq" )
    @ODataField( odataName = "to_ProjDmndRsceReq" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandResourceRequest toProjDmndRsceReq;
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjDmndRsceReqDistributionOneToOneLink<ProjectDemand>("to_Root");
    /**
     * Use with available fluent helpers to apply the <b>to_ProjDmndRsceReq</b> navigation property to query operations.
     *
     */
    public final static ProjDmndRsceReqDistributionOneToOneLink<ProjectDemandResourceRequest> TO_PROJ_DMND_RSCE_REQ =
        new ProjDmndRsceReqDistributionOneToOneLink<ProjectDemandResourceRequest>("to_ProjDmndRsceReq");

    @Nonnull
    @Override
    public Class<ProjDmndRsceReqDistribution> getType()
    {
        return ProjDmndRsceReqDistribution.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrUUID</b>
     * </p>
     *
     * @param projDmndRsceReqDistrUUID
     *            Global Identification of a Resource Request Distribution
     */
    public void setProjDmndRsceReqDistrUUID( @Nullable final UUID projDmndRsceReqDistrUUID )
    {
        rememberChangedField("ProjDmndRsceReqDistrUUID", this.projDmndRsceReqDistrUUID);
        this.projDmndRsceReqDistrUUID = projDmndRsceReqDistrUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndResourceRequestUUID</b>
     * </p>
     *
     * @param projDmndResourceRequestUUID
     *            Global Identification of a Resource Request
     */
    public void setProjDmndResourceRequestUUID( @Nullable final UUID projDmndResourceRequestUUID )
    {
        rememberChangedField("ProjDmndResourceRequestUUID", this.projDmndResourceRequestUUID);
        this.projDmndResourceRequestUUID = projDmndResourceRequestUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrYearVal</b>
     * </p>
     *
     * @param projDmndRsceReqDistrYearVal
     *            Year of a Distribution Period
     */
    public void setProjDmndRsceReqDistrYearVal( @Nullable final String projDmndRsceReqDistrYearVal )
    {
        rememberChangedField("ProjDmndRsceReqDistrYearVal", this.projDmndRsceReqDistrYearVal);
        this.projDmndRsceReqDistrYearVal = projDmndRsceReqDistrYearVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdVal</b>
     * </p>
     *
     * @param projDmndRsceReqDistrPerdVal
     *            Period to Which a Quantity is Distibuted
     */
    public void setProjDmndRsceReqDistrPerdVal( @Nullable final String projDmndRsceReqDistrPerdVal )
    {
        rememberChangedField("ProjDmndRsceReqDistrPerdVal", this.projDmndRsceReqDistrPerdVal);
        this.projDmndRsceReqDistrPerdVal = projDmndRsceReqDistrPerdVal;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrQuantity</b>
     * </p>
     *
     * @param projDmndRsceReqDistrQuantity
     *            Resource Quantity Requested for a Distribution Period
     */
    public void setProjDmndRsceReqDistrQuantity( @Nullable final BigDecimal projDmndRsceReqDistrQuantity )
    {
        rememberChangedField("ProjDmndRsceReqDistrQuantity", this.projDmndRsceReqDistrQuantity);
        this.projDmndRsceReqDistrQuantity = projDmndRsceReqDistrQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrQtyUnit</b>
     * </p>
     *
     * @param projDmndRsceReqDistrQtyUnit
     *            Unit of Measure for the Distributed Quantity
     */
    public void setProjDmndRsceReqDistrQtyUnit( @Nullable final String projDmndRsceReqDistrQtyUnit )
    {
        rememberChangedField("ProjDmndRsceReqDistrQtyUnit", this.projDmndRsceReqDistrQtyUnit);
        this.projDmndRsceReqDistrQtyUnit = projDmndRsceReqDistrQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdAmt</b>
     * </p>
     *
     * @param projDmndRsceReqDistrPerdAmt
     *            Plannend Cost
     */
    public void setProjDmndRsceReqDistrPerdAmt( @Nullable final BigDecimal projDmndRsceReqDistrPerdAmt )
    {
        rememberChangedField("ProjDmndRsceReqDistrPerdAmt", this.projDmndRsceReqDistrPerdAmt);
        this.projDmndRsceReqDistrPerdAmt = projDmndRsceReqDistrPerdAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrPerdAmtCur</b>
     * </p>
     *
     * @param projDmndRsceReqDistrPerdAmtCur
     *            Currency
     */
    public void setProjDmndRsceReqDistrPerdAmtCur( @Nullable final String projDmndRsceReqDistrPerdAmtCur )
    {
        rememberChangedField("ProjDmndRsceReqDistrPerdAmtCur", this.projDmndRsceReqDistrPerdAmtCur);
        this.projDmndRsceReqDistrPerdAmtCur = projDmndRsceReqDistrPerdAmtCur;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrRevenueAmt</b>
     * </p>
     *
     * @param projDmndRsceReqDistrRevenueAmt
     *            Planned Revenue
     */
    public void setProjDmndRsceReqDistrRevenueAmt( @Nullable final BigDecimal projDmndRsceReqDistrRevenueAmt )
    {
        rememberChangedField("ProjDmndRsceReqDistrRevenueAmt", this.projDmndRsceReqDistrRevenueAmt);
        this.projDmndRsceReqDistrRevenueAmt = projDmndRsceReqDistrRevenueAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrRevnAmtCur</b>
     * </p>
     *
     * @param projDmndRsceReqDistrRevnAmtCur
     *            Currency
     */
    public void setProjDmndRsceReqDistrRevnAmtCur( @Nullable final String projDmndRsceReqDistrRevnAmtCur )
    {
        rememberChangedField("ProjDmndRsceReqDistrRevnAmtCur", this.projDmndRsceReqDistrRevnAmtCur);
        this.projDmndRsceReqDistrRevnAmtCur = projDmndRsceReqDistrRevnAmtCur;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReferencedPlanDataUUID</b>
     * </p>
     *
     * @param projDmndReferencedPlanDataUUID
     *            Corresponding Line Item in Project Plan
     */
    public void setProjDmndReferencedPlanDataUUID( @Nullable final UUID projDmndReferencedPlanDataUUID )
    {
        rememberChangedField("ProjDmndReferencedPlanDataUUID", this.projDmndReferencedPlanDataUUID);
        this.projDmndReferencedPlanDataUUID = projDmndReferencedPlanDataUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrStartDate</b>
     * </p>
     *
     * @param projDmndRsceReqDistrStartDate
     *            Start Date of the Distribution Period
     */
    public void setProjDmndRsceReqDistrStartDate( @Nullable final LocalDateTime projDmndRsceReqDistrStartDate )
    {
        rememberChangedField("ProjDmndRsceReqDistrStartDate", this.projDmndRsceReqDistrStartDate);
        this.projDmndRsceReqDistrStartDate = projDmndRsceReqDistrStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqDistrEndDate</b>
     * </p>
     *
     * @param projDmndRsceReqDistrEndDate
     *            End Date of the Distribution Period
     */
    public void setProjDmndRsceReqDistrEndDate( @Nullable final LocalDateTime projDmndRsceReqDistrEndDate )
    {
        rememberChangedField("ProjDmndRsceReqDistrEndDate", this.projDmndRsceReqDistrEndDate);
        this.projDmndRsceReqDistrEndDate = projDmndRsceReqDistrEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjDmndRsceReqDistribution";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDmndRsceReqDistrUUID", getProjDmndRsceReqDistrUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDmndRsceReqDistrUUID", getProjDmndRsceReqDistrUUID());
        values.put("ProjDmndResourceRequestUUID", getProjDmndResourceRequestUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjDmndRsceReqDistrYearVal", getProjDmndRsceReqDistrYearVal());
        values.put("ProjDmndRsceReqDistrPerdVal", getProjDmndRsceReqDistrPerdVal());
        values.put("ProjDmndRsceReqDistrQuantity", getProjDmndRsceReqDistrQuantity());
        values.put("ProjDmndRsceReqDistrQtyUnit", getProjDmndRsceReqDistrQtyUnit());
        values.put("ProjDmndRsceReqDistrPerdAmt", getProjDmndRsceReqDistrPerdAmt());
        values.put("ProjDmndRsceReqDistrPerdAmtCur", getProjDmndRsceReqDistrPerdAmtCur());
        values.put("ProjDmndRsceReqDistrRevenueAmt", getProjDmndRsceReqDistrRevenueAmt());
        values.put("ProjDmndRsceReqDistrRevnAmtCur", getProjDmndRsceReqDistrRevnAmtCur());
        values.put("ProjDmndReferencedPlanDataUUID", getProjDmndReferencedPlanDataUUID());
        values.put("ProjDmndRsceReqDistrStartDate", getProjDmndRsceReqDistrStartDate());
        values.put("ProjDmndRsceReqDistrEndDate", getProjDmndRsceReqDistrEndDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDmndRsceReqDistrUUID") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrUUID");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrUUID())) ) {
                    setProjDmndRsceReqDistrUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndResourceRequestUUID") ) {
                final Object value = values.remove("ProjDmndResourceRequestUUID");
                if( (value == null) || (!value.equals(getProjDmndResourceRequestUUID())) ) {
                    setProjDmndResourceRequestUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrYearVal") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrYearVal");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrYearVal())) ) {
                    setProjDmndRsceReqDistrYearVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrPerdVal") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrPerdVal");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrPerdVal())) ) {
                    setProjDmndRsceReqDistrPerdVal(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrQuantity") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrQuantity");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrQuantity())) ) {
                    setProjDmndRsceReqDistrQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrQtyUnit") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrQtyUnit");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrQtyUnit())) ) {
                    setProjDmndRsceReqDistrQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrPerdAmt") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrPerdAmt");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrPerdAmt())) ) {
                    setProjDmndRsceReqDistrPerdAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrPerdAmtCur") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrPerdAmtCur");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrPerdAmtCur())) ) {
                    setProjDmndRsceReqDistrPerdAmtCur(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrRevenueAmt") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrRevenueAmt");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrRevenueAmt())) ) {
                    setProjDmndRsceReqDistrRevenueAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrRevnAmtCur") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrRevnAmtCur");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrRevnAmtCur())) ) {
                    setProjDmndRsceReqDistrRevnAmtCur(((String) value));
                }
            }
            if( values.containsKey("ProjDmndReferencedPlanDataUUID") ) {
                final Object value = values.remove("ProjDmndReferencedPlanDataUUID");
                if( (value == null) || (!value.equals(getProjDmndReferencedPlanDataUUID())) ) {
                    setProjDmndReferencedPlanDataUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrStartDate") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrStartDate");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrStartDate())) ) {
                    setProjDmndRsceReqDistrStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqDistrEndDate") ) {
                final Object value = values.remove("ProjDmndRsceReqDistrEndDate");
                if( (value == null) || (!value.equals(getProjDmndRsceReqDistrEndDate())) ) {
                    setProjDmndRsceReqDistrEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProjDmndRsceReq") ) {
                final Object value = (values).remove("to_ProjDmndRsceReq");
                if( value instanceof Map ) {
                    if( toProjDmndRsceReq == null ) {
                        toProjDmndRsceReq = new ProjectDemandResourceRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProjDmndRsceReq.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjDmndRsceReqDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProjDmndRsceReqDistributionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjDmndRsceReqDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjDmndRsceReqDistributionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        if( toProjDmndRsceReq != null ) {
            (values).put("to_ProjDmndRsceReq", toProjDmndRsceReq);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjDmndRsceReqDistribution</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndRsceReqDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Fetches the <b>ProjectDemandResourceRequest</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProjDmndRsceReq</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandResourceRequest</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResourceRequest fetchProjDmndRsceReq()
    {
        return fetchFieldAsSingle("to_ProjDmndRsceReq", ProjectDemandResourceRequest.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandResourceRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProjDmndRsceReq</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndRsceReq</b> of a queried <b>ProjDmndRsceReqDistribution</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandResourceRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResourceRequest getProjDmndRsceReqOrFetch()
    {
        if( toProjDmndRsceReq == null ) {
            toProjDmndRsceReq = fetchProjDmndRsceReq();
        }
        return toProjDmndRsceReq;
    }

    /**
     * Retrieval of associated <b>ProjectDemandResourceRequest</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProjDmndRsceReq</b>.
     * <p>
     * If the navigation property for an entity <b>ProjDmndRsceReqDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProjDmndRsceReq</b> is already loaded, the result will
     *         contain the <b>ProjectDemandResourceRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandResourceRequest> getProjDmndRsceReqIfPresent()
    {
        return Option.of(toProjDmndRsceReq);
    }

    /**
     * Overwrites the associated <b>ProjectDemandResourceRequest</b> entity for the loaded navigation property
     * <b>to_ProjDmndRsceReq</b>.
     *
     * @param value
     *            New <b>ProjectDemandResourceRequest</b> entity.
     */
    public void setProjDmndRsceReq( final ProjectDemandResourceRequest value )
    {
        toProjDmndRsceReq = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjDmndRsceReqDistribution instances.
     *
     */
    public final static class ProjDmndRsceReqDistributionBuilder
    {

        private ProjectDemand toRoot;
        private ProjectDemandResourceRequest toProjDmndRsceReq;

        private ProjDmndRsceReqDistribution.ProjDmndRsceReqDistributionBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjDmndRsceReqDistribution</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjDmndRsceReqDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndRsceReqDistribution.ProjDmndRsceReqDistributionBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

        private ProjDmndRsceReqDistribution.ProjDmndRsceReqDistributionBuilder toProjDmndRsceReq(
            final ProjectDemandResourceRequest value )
        {
            toProjDmndRsceReq = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProjDmndRsceReq</b> for <b>ProjDmndRsceReqDistribution</b> to single
         * <b>ProjectDemandResourceRequest</b>.
         *
         * @param value
         *            The ProjectDemandResourceRequest to build this ProjDmndRsceReqDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjDmndRsceReqDistribution.ProjDmndRsceReqDistributionBuilder projDmndRsceReq(
            final ProjectDemandResourceRequest value )
        {
            return toProjDmndRsceReq(value);
        }

    }

}
