/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Demand
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemand_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemand extends VdmEntity<ProjectDemand>
{

    /**
     * Selector for all available fields of ProjectDemand.
     *
     */
    public final static ProjectDemandSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @Key
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemand</b>
     * </p>
     *
     * @return External ID of a Project Demand
     */
    @SerializedName( "ProjectDemand" )
    @JsonProperty( "ProjectDemand" )
    @Nullable
    @ODataField( odataName = "ProjectDemand" )
    private String projectDemand;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemand</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND = new ProjectDemandField<String>("ProjectDemand");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandName</b>
     * </p>
     *
     * @return Project Demand Name
     */
    @SerializedName( "ProjectDemandName" )
    @JsonProperty( "ProjectDemandName" )
    @Nullable
    @ODataField( odataName = "ProjectDemandName" )
    private String projectDemandName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandName</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_NAME =
        new ProjectDemandField<String>("ProjectDemandName");
    /**
     * Constraints: Not nullable, Maximum length: 1000
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandDescription</b>
     * </p>
     *
     * @return Description of a Project Demand
     */
    @SerializedName( "ProjectDemandDescription" )
    @JsonProperty( "ProjectDemandDescription" )
    @Nullable
    @ODataField( odataName = "ProjectDemandDescription" )
    private String projectDemandDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandDescription</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_DESCRIPTION =
        new ProjectDemandField<String>("ProjectDemandDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandCategory</b>
     * </p>
     *
     * @return Project Demand Category
     */
    @SerializedName( "ProjectDemandCategory" )
    @JsonProperty( "ProjectDemandCategory" )
    @Nullable
    @ODataField( odataName = "ProjectDemandCategory" )
    private String projectDemandCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandCategory</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_CATEGORY =
        new ProjectDemandField<String>("ProjectDemandCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandType</b>
     * </p>
     *
     * @return Project Demand Type
     */
    @SerializedName( "ProjectDemandType" )
    @JsonProperty( "ProjectDemandType" )
    @Nullable
    @ODataField( odataName = "ProjectDemandType" )
    private String projectDemandType;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandType</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_TYPE =
        new ProjectDemandField<String>("ProjectDemandType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @return UUID of the Object to Which a Demand Is Related
     */
    @SerializedName( "ReferencedObjectUUID" )
    @JsonProperty( "ReferencedObjectUUID" )
    @Nullable
    @ODataField( odataName = "ReferencedObjectUUID" )
    private UUID referencedObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ReferencedObjectUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandField<UUID> REFERENCED_OBJECT_UUID =
        new ProjectDemandField<UUID>("ReferencedObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandStatus</b>
     * </p>
     *
     * @return Project Demand Status
     */
    @SerializedName( "ProjectDemandStatus" )
    @JsonProperty( "ProjectDemandStatus" )
    @Nullable
    @ODataField( odataName = "ProjectDemandStatus" )
    private String projectDemandStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandStatus</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_STATUS =
        new ProjectDemandField<String>("ProjectDemandStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandDateMaintenance</b>
     * </p>
     *
     * @return Alignment of Project Demand Dates with WBS Element Dates
     */
    @SerializedName( "ProjectDemandDateMaintenance" )
    @JsonProperty( "ProjectDemandDateMaintenance" )
    @Nullable
    @ODataField( odataName = "ProjectDemandDateMaintenance" )
    private String projectDemandDateMaintenance;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandDateMaintenance</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_DATE_MAINTENANCE =
        new ProjectDemandField<String>("ProjectDemandDateMaintenance");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandStartDate</b>
     * </p>
     *
     * @return Start Date of the Demand
     */
    @SerializedName( "ProjectDemandStartDate" )
    @JsonProperty( "ProjectDemandStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectDemandStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectDemandStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandStartDate</b> field to query operations.
     *
     */
    public final static ProjectDemandField<LocalDateTime> PROJECT_DEMAND_START_DATE =
        new ProjectDemandField<LocalDateTime>("ProjectDemandStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandEndDate</b>
     * </p>
     *
     * @return End Date of the Demand
     */
    @SerializedName( "ProjectDemandEndDate" )
    @JsonProperty( "ProjectDemandEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectDemandEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectDemandEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandEndDate</b> field to query operations.
     *
     */
    public final static ProjectDemandField<LocalDateTime> PROJECT_DEMAND_END_DATE =
        new ProjectDemandField<LocalDateTime>("ProjectDemandEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandReleasedDateTime</b>
     * </p>
     *
     * @return Timestamp of Demand Status Change to "Requested"
     */
    @SerializedName( "ProjectDemandReleasedDateTime" )
    @JsonProperty( "ProjectDemandReleasedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectDemandReleasedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectDemandReleasedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandReleasedDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandField<ZonedDateTime> PROJECT_DEMAND_RELEASED_DATE_TIME =
        new ProjectDemandField<ZonedDateTime>("ProjectDemandReleasedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndActualSupplyDate</b>
     * </p>
     *
     * @return Delivery Date of the Demand
     */
    @SerializedName( "ProjDmndActualSupplyDate" )
    @JsonProperty( "ProjDmndActualSupplyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndActualSupplyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndActualSupplyDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndActualSupplyDate</b> field to query operations.
     *
     */
    public final static ProjectDemandField<LocalDateTime> PROJ_DMND_ACTUAL_SUPPLY_DATE =
        new ProjectDemandField<LocalDateTime>("ProjDmndActualSupplyDate");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandPerUnitAmount</b>
     * </p>
     *
     * @return Price per unit
     */
    @SerializedName( "ProjectDemandPerUnitAmount" )
    @JsonProperty( "ProjectDemandPerUnitAmount" )
    @Nullable
    @ODataField( odataName = "ProjectDemandPerUnitAmount" )
    private BigDecimal projectDemandPerUnitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandPerUnitAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PROJECT_DEMAND_PER_UNIT_AMOUNT =
        new ProjectDemandField<BigDecimal>("ProjectDemandPerUnitAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestCurrency</b>
     * </p>
     *
     * @return Project Demand Currency
     */
    @SerializedName( "ProjectDemandRequestCurrency" )
    @JsonProperty( "ProjectDemandRequestCurrency" )
    @Nullable
    @ODataField( odataName = "ProjectDemandRequestCurrency" )
    private String projectDemandRequestCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandRequestCurrency</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_REQUEST_CURRENCY =
        new ProjectDemandField<String>("ProjectDemandRequestCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Required Quantity
     */
    @SerializedName( "ProjDmndRequestedQuantityUnit" )
    @JsonProperty( "ProjDmndRequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProjDmndRequestedQuantityUnit" )
    private String projDmndRequestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJ_DMND_REQUESTED_QUANTITY_UNIT =
        new ProjectDemandField<String>("ProjDmndRequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "PriceUnitQty" )
    @JsonProperty( "PriceUnitQty" )
    @Nullable
    @ODataField( odataName = "PriceUnitQty" )
    private BigDecimal priceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>PriceUnitQty</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PRICE_UNIT_QTY =
        new ProjectDemandField<BigDecimal>("PriceUnitQty");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestNetAmount</b>
     * </p>
     *
     * @return Estimated Net Value of the Project Demand
     */
    @SerializedName( "ProjectDemandRequestNetAmount" )
    @JsonProperty( "ProjectDemandRequestNetAmount" )
    @Nullable
    @ODataField( odataName = "ProjectDemandRequestNetAmount" )
    private BigDecimal projectDemandRequestNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandRequestNetAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PROJECT_DEMAND_REQUEST_NET_AMOUNT =
        new ProjectDemandField<BigDecimal>("ProjectDemandRequestNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReqNetAmountCurrency</b>
     * </p>
     *
     * @return Project Demand Currency
     */
    @SerializedName( "ProjDmndReqNetAmountCurrency" )
    @JsonProperty( "ProjDmndReqNetAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ProjDmndReqNetAmountCurrency" )
    private String projDmndReqNetAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndReqNetAmountCurrency</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJ_DMND_REQ_NET_AMOUNT_CURRENCY =
        new ProjectDemandField<String>("ProjDmndReqNetAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandOverallAmount</b>
     * </p>
     *
     * @return Overall Limit
     */
    @SerializedName( "ProjectDemandOverallAmount" )
    @JsonProperty( "ProjectDemandOverallAmount" )
    @Nullable
    @ODataField( odataName = "ProjectDemandOverallAmount" )
    private BigDecimal projectDemandOverallAmount;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandOverallAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PROJECT_DEMAND_OVERALL_AMOUNT =
        new ProjectDemandField<BigDecimal>("ProjectDemandOverallAmount");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpectedAmount</b>
     * </p>
     *
     * @return Expected Value of Overall Limit
     */
    @SerializedName( "ProjectDemandExpectedAmount" )
    @JsonProperty( "ProjectDemandExpectedAmount" )
    @Nullable
    @ODataField( odataName = "ProjectDemandExpectedAmount" )
    private BigDecimal projectDemandExpectedAmount;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandExpectedAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PROJECT_DEMAND_EXPECTED_AMOUNT =
        new ProjectDemandField<BigDecimal>("ProjectDemandExpectedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedQuantity</b>
     * </p>
     *
     * @return Required Quantity
     */
    @SerializedName( "ProjDmndRequestedQuantity" )
    @JsonProperty( "ProjDmndRequestedQuantity" )
    @Nullable
    @ODataField( odataName = "ProjDmndRequestedQuantity" )
    private BigDecimal projDmndRequestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRequestedQuantity</b> field to query operations.
     *
     */
    public final static ProjectDemandField<BigDecimal> PROJ_DMND_REQUESTED_QUANTITY =
        new ProjectDemandField<BigDecimal>("ProjDmndRequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PLANT = new ProjectDemandField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PURCHASING_GROUP = new ProjectDemandField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PURCHASING_ORGANIZATION =
        new ProjectDemandField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of the Person Who Created the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> CREATED_BY_USER = new ProjectDemandField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjectDemandField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> LAST_CHANGED_BY_USER =
        new ProjectDemandField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjectDemandField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandLastChangedByUser</b>
     * </p>
     *
     * @return User Who Last Changed a Demand (Sub-Entities Included)
     */
    @SerializedName( "ProjectDemandLastChangedByUser" )
    @JsonProperty( "ProjectDemandLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "ProjectDemandLastChangedByUser" )
    private String projectDemandLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandLastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandField<String> PROJECT_DEMAND_LAST_CHANGED_BY_USER =
        new ProjectDemandField<String>("ProjectDemandLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjDemandLastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Change to a Demand (Sub-Entities Included)
     */
    @SerializedName( "ProjDemandLastChangeDateTime" )
    @JsonProperty( "ProjDemandLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDemandLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projDemandLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjDemandLastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandField<ZonedDateTime> PROJ_DEMAND_LAST_CHANGE_DATE_TIME =
        new ProjectDemandField<ZonedDateTime>("ProjDemandLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExternalReferenceUUID</b>
     * </p>
     *
     * @return External UUID related to a Demand
     */
    @SerializedName( "ProjDmndExternalReferenceUUID" )
    @JsonProperty( "ProjDmndExternalReferenceUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndExternalReferenceUUID" )
    private UUID projDmndExternalReferenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndExternalReferenceUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandField<UUID> PROJ_DMND_EXTERNAL_REFERENCE_UUID =
        new ProjectDemandField<UUID>("ProjDmndExternalReferenceUUID");
    /**
     * Navigation property <b>to_Expense</b> for <b>ProjectDemand</b> to single <b>ProjectDemandExpense</b>.
     *
     */
    @SerializedName( "to_Expense" )
    @JsonProperty( "to_Expense" )
    @ODataField( odataName = "to_Expense" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandExpense toExpense;
    /**
     * Navigation property <b>to_Material</b> for <b>ProjectDemand</b> to single <b>ProjectDemandMaterial</b>.
     *
     */
    @SerializedName( "to_Material" )
    @JsonProperty( "to_Material" )
    @ODataField( odataName = "to_Material" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandMaterial toMaterial;
    /**
     * Navigation property <b>to_Service</b> for <b>ProjectDemand</b> to single <b>ProjectDemandService</b>.
     *
     */
    @SerializedName( "to_Service" )
    @JsonProperty( "to_Service" )
    @ODataField( odataName = "to_Service" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandService toService;
    /**
     * Navigation property <b>to_Work</b> for <b>ProjectDemand</b> to single <b>ProjectDemandResource</b>.
     *
     */
    @SerializedName( "to_Work" )
    @JsonProperty( "to_Work" )
    @ODataField( odataName = "to_Work" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandResource toWork;
    /**
     * Use with available fluent helpers to apply the <b>to_Expense</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandOneToOneLink<ProjectDemandExpense> TO_EXPENSE =
        new ProjectDemandOneToOneLink<ProjectDemandExpense>("to_Expense");
    /**
     * Use with available fluent helpers to apply the <b>to_Material</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandOneToOneLink<ProjectDemandMaterial> TO_MATERIAL =
        new ProjectDemandOneToOneLink<ProjectDemandMaterial>("to_Material");
    /**
     * Use with available fluent helpers to apply the <b>to_Service</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandOneToOneLink<ProjectDemandService> TO_SERVICE =
        new ProjectDemandOneToOneLink<ProjectDemandService>("to_Service");
    /**
     * Use with available fluent helpers to apply the <b>to_Work</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandOneToOneLink<ProjectDemandResource> TO_WORK =
        new ProjectDemandOneToOneLink<ProjectDemandResource>("to_Work");

    @Nonnull
    @Override
    public Class<ProjectDemand> getType()
    {
        return ProjectDemand.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemand</b>
     * </p>
     *
     * @param projectDemand
     *            External ID of a Project Demand
     */
    public void setProjectDemand( @Nullable final String projectDemand )
    {
        rememberChangedField("ProjectDemand", this.projectDemand);
        this.projectDemand = projectDemand;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandName</b>
     * </p>
     *
     * @param projectDemandName
     *            Project Demand Name
     */
    public void setProjectDemandName( @Nullable final String projectDemandName )
    {
        rememberChangedField("ProjectDemandName", this.projectDemandName);
        this.projectDemandName = projectDemandName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1000
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandDescription</b>
     * </p>
     *
     * @param projectDemandDescription
     *            Description of a Project Demand
     */
    public void setProjectDemandDescription( @Nullable final String projectDemandDescription )
    {
        rememberChangedField("ProjectDemandDescription", this.projectDemandDescription);
        this.projectDemandDescription = projectDemandDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandCategory</b>
     * </p>
     *
     * @param projectDemandCategory
     *            Project Demand Category
     */
    public void setProjectDemandCategory( @Nullable final String projectDemandCategory )
    {
        rememberChangedField("ProjectDemandCategory", this.projectDemandCategory);
        this.projectDemandCategory = projectDemandCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandType</b>
     * </p>
     *
     * @param projectDemandType
     *            Project Demand Type
     */
    public void setProjectDemandType( @Nullable final String projectDemandType )
    {
        rememberChangedField("ProjectDemandType", this.projectDemandType);
        this.projectDemandType = projectDemandType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @param referencedObjectUUID
     *            UUID of the Object to Which a Demand Is Related
     */
    public void setReferencedObjectUUID( @Nullable final UUID referencedObjectUUID )
    {
        rememberChangedField("ReferencedObjectUUID", this.referencedObjectUUID);
        this.referencedObjectUUID = referencedObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandStatus</b>
     * </p>
     *
     * @param projectDemandStatus
     *            Project Demand Status
     */
    public void setProjectDemandStatus( @Nullable final String projectDemandStatus )
    {
        rememberChangedField("ProjectDemandStatus", this.projectDemandStatus);
        this.projectDemandStatus = projectDemandStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandDateMaintenance</b>
     * </p>
     *
     * @param projectDemandDateMaintenance
     *            Alignment of Project Demand Dates with WBS Element Dates
     */
    public void setProjectDemandDateMaintenance( @Nullable final String projectDemandDateMaintenance )
    {
        rememberChangedField("ProjectDemandDateMaintenance", this.projectDemandDateMaintenance);
        this.projectDemandDateMaintenance = projectDemandDateMaintenance;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandStartDate</b>
     * </p>
     *
     * @param projectDemandStartDate
     *            Start Date of the Demand
     */
    public void setProjectDemandStartDate( @Nullable final LocalDateTime projectDemandStartDate )
    {
        rememberChangedField("ProjectDemandStartDate", this.projectDemandStartDate);
        this.projectDemandStartDate = projectDemandStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandEndDate</b>
     * </p>
     *
     * @param projectDemandEndDate
     *            End Date of the Demand
     */
    public void setProjectDemandEndDate( @Nullable final LocalDateTime projectDemandEndDate )
    {
        rememberChangedField("ProjectDemandEndDate", this.projectDemandEndDate);
        this.projectDemandEndDate = projectDemandEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandReleasedDateTime</b>
     * </p>
     *
     * @param projectDemandReleasedDateTime
     *            Timestamp of Demand Status Change to "Requested"
     */
    public void setProjectDemandReleasedDateTime( @Nullable final ZonedDateTime projectDemandReleasedDateTime )
    {
        rememberChangedField("ProjectDemandReleasedDateTime", this.projectDemandReleasedDateTime);
        this.projectDemandReleasedDateTime = projectDemandReleasedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndActualSupplyDate</b>
     * </p>
     *
     * @param projDmndActualSupplyDate
     *            Delivery Date of the Demand
     */
    public void setProjDmndActualSupplyDate( @Nullable final LocalDateTime projDmndActualSupplyDate )
    {
        rememberChangedField("ProjDmndActualSupplyDate", this.projDmndActualSupplyDate);
        this.projDmndActualSupplyDate = projDmndActualSupplyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandPerUnitAmount</b>
     * </p>
     *
     * @param projectDemandPerUnitAmount
     *            Price per unit
     */
    public void setProjectDemandPerUnitAmount( @Nullable final BigDecimal projectDemandPerUnitAmount )
    {
        rememberChangedField("ProjectDemandPerUnitAmount", this.projectDemandPerUnitAmount);
        this.projectDemandPerUnitAmount = projectDemandPerUnitAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestCurrency</b>
     * </p>
     *
     * @param projectDemandRequestCurrency
     *            Project Demand Currency
     */
    public void setProjectDemandRequestCurrency( @Nullable final String projectDemandRequestCurrency )
    {
        rememberChangedField("ProjectDemandRequestCurrency", this.projectDemandRequestCurrency);
        this.projectDemandRequestCurrency = projectDemandRequestCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedQuantityUnit</b>
     * </p>
     *
     * @param projDmndRequestedQuantityUnit
     *            Unit of Measure for the Required Quantity
     */
    public void setProjDmndRequestedQuantityUnit( @Nullable final String projDmndRequestedQuantityUnit )
    {
        rememberChangedField("ProjDmndRequestedQuantityUnit", this.projDmndRequestedQuantityUnit);
        this.projDmndRequestedQuantityUnit = projDmndRequestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceUnitQty</b>
     * </p>
     *
     * @param priceUnitQty
     *            Price unit
     */
    public void setPriceUnitQty( @Nullable final BigDecimal priceUnitQty )
    {
        rememberChangedField("PriceUnitQty", this.priceUnitQty);
        this.priceUnitQty = priceUnitQty;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestNetAmount</b>
     * </p>
     *
     * @param projectDemandRequestNetAmount
     *            Estimated Net Value of the Project Demand
     */
    public void setProjectDemandRequestNetAmount( @Nullable final BigDecimal projectDemandRequestNetAmount )
    {
        rememberChangedField("ProjectDemandRequestNetAmount", this.projectDemandRequestNetAmount);
        this.projectDemandRequestNetAmount = projectDemandRequestNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndReqNetAmountCurrency</b>
     * </p>
     *
     * @param projDmndReqNetAmountCurrency
     *            Project Demand Currency
     */
    public void setProjDmndReqNetAmountCurrency( @Nullable final String projDmndReqNetAmountCurrency )
    {
        rememberChangedField("ProjDmndReqNetAmountCurrency", this.projDmndReqNetAmountCurrency);
        this.projDmndReqNetAmountCurrency = projDmndReqNetAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandOverallAmount</b>
     * </p>
     *
     * @param projectDemandOverallAmount
     *            Overall Limit
     */
    public void setProjectDemandOverallAmount( @Nullable final BigDecimal projectDemandOverallAmount )
    {
        rememberChangedField("ProjectDemandOverallAmount", this.projectDemandOverallAmount);
        this.projectDemandOverallAmount = projectDemandOverallAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpectedAmount</b>
     * </p>
     *
     * @param projectDemandExpectedAmount
     *            Expected Value of Overall Limit
     */
    public void setProjectDemandExpectedAmount( @Nullable final BigDecimal projectDemandExpectedAmount )
    {
        rememberChangedField("ProjectDemandExpectedAmount", this.projectDemandExpectedAmount);
        this.projectDemandExpectedAmount = projectDemandExpectedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedQuantity</b>
     * </p>
     *
     * @param projDmndRequestedQuantity
     *            Required Quantity
     */
    public void setProjDmndRequestedQuantity( @Nullable final BigDecimal projDmndRequestedQuantity )
    {
        rememberChangedField("ProjDmndRequestedQuantity", this.projDmndRequestedQuantity);
        this.projDmndRequestedQuantity = projDmndRequestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of the Person Who Created the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandLastChangedByUser</b>
     * </p>
     *
     * @param projectDemandLastChangedByUser
     *            User Who Last Changed a Demand (Sub-Entities Included)
     */
    public void setProjectDemandLastChangedByUser( @Nullable final String projectDemandLastChangedByUser )
    {
        rememberChangedField("ProjectDemandLastChangedByUser", this.projectDemandLastChangedByUser);
        this.projectDemandLastChangedByUser = projectDemandLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjDemandLastChangeDateTime</b>
     * </p>
     *
     * @param projDemandLastChangeDateTime
     *            Timestamp of Last Change to a Demand (Sub-Entities Included)
     */
    public void setProjDemandLastChangeDateTime( @Nullable final ZonedDateTime projDemandLastChangeDateTime )
    {
        rememberChangedField("ProjDemandLastChangeDateTime", this.projDemandLastChangeDateTime);
        this.projDemandLastChangeDateTime = projDemandLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndExternalReferenceUUID</b>
     * </p>
     *
     * @param projDmndExternalReferenceUUID
     *            External UUID related to a Demand
     */
    public void setProjDmndExternalReferenceUUID( @Nullable final UUID projDmndExternalReferenceUUID )
    {
        rememberChangedField("ProjDmndExternalReferenceUUID", this.projDmndExternalReferenceUUID);
        this.projDmndExternalReferenceUUID = projDmndExternalReferenceUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemand";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectDemandUUID", getProjectDemandUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjectDemand", getProjectDemand());
        values.put("ProjectDemandName", getProjectDemandName());
        values.put("ProjectDemandDescription", getProjectDemandDescription());
        values.put("ProjectDemandCategory", getProjectDemandCategory());
        values.put("ProjectDemandType", getProjectDemandType());
        values.put("ReferencedObjectUUID", getReferencedObjectUUID());
        values.put("ProjectDemandStatus", getProjectDemandStatus());
        values.put("ProjectDemandDateMaintenance", getProjectDemandDateMaintenance());
        values.put("ProjectDemandStartDate", getProjectDemandStartDate());
        values.put("ProjectDemandEndDate", getProjectDemandEndDate());
        values.put("ProjectDemandReleasedDateTime", getProjectDemandReleasedDateTime());
        values.put("ProjDmndActualSupplyDate", getProjDmndActualSupplyDate());
        values.put("ProjectDemandPerUnitAmount", getProjectDemandPerUnitAmount());
        values.put("ProjectDemandRequestCurrency", getProjectDemandRequestCurrency());
        values.put("ProjDmndRequestedQuantityUnit", getProjDmndRequestedQuantityUnit());
        values.put("PriceUnitQty", getPriceUnitQty());
        values.put("ProjectDemandRequestNetAmount", getProjectDemandRequestNetAmount());
        values.put("ProjDmndReqNetAmountCurrency", getProjDmndReqNetAmountCurrency());
        values.put("ProjectDemandOverallAmount", getProjectDemandOverallAmount());
        values.put("ProjectDemandExpectedAmount", getProjectDemandExpectedAmount());
        values.put("ProjDmndRequestedQuantity", getProjDmndRequestedQuantity());
        values.put("Plant", getPlant());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ProjectDemandLastChangedByUser", getProjectDemandLastChangedByUser());
        values.put("ProjDemandLastChangeDateTime", getProjDemandLastChangeDateTime());
        values.put("ProjDmndExternalReferenceUUID", getProjDmndExternalReferenceUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemand") ) {
                final Object value = values.remove("ProjectDemand");
                if( (value == null) || (!value.equals(getProjectDemand())) ) {
                    setProjectDemand(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandName") ) {
                final Object value = values.remove("ProjectDemandName");
                if( (value == null) || (!value.equals(getProjectDemandName())) ) {
                    setProjectDemandName(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandDescription") ) {
                final Object value = values.remove("ProjectDemandDescription");
                if( (value == null) || (!value.equals(getProjectDemandDescription())) ) {
                    setProjectDemandDescription(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandCategory") ) {
                final Object value = values.remove("ProjectDemandCategory");
                if( (value == null) || (!value.equals(getProjectDemandCategory())) ) {
                    setProjectDemandCategory(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandType") ) {
                final Object value = values.remove("ProjectDemandType");
                if( (value == null) || (!value.equals(getProjectDemandType())) ) {
                    setProjectDemandType(((String) value));
                }
            }
            if( values.containsKey("ReferencedObjectUUID") ) {
                final Object value = values.remove("ReferencedObjectUUID");
                if( (value == null) || (!value.equals(getReferencedObjectUUID())) ) {
                    setReferencedObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandStatus") ) {
                final Object value = values.remove("ProjectDemandStatus");
                if( (value == null) || (!value.equals(getProjectDemandStatus())) ) {
                    setProjectDemandStatus(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandDateMaintenance") ) {
                final Object value = values.remove("ProjectDemandDateMaintenance");
                if( (value == null) || (!value.equals(getProjectDemandDateMaintenance())) ) {
                    setProjectDemandDateMaintenance(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandStartDate") ) {
                final Object value = values.remove("ProjectDemandStartDate");
                if( (value == null) || (!value.equals(getProjectDemandStartDate())) ) {
                    setProjectDemandStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectDemandEndDate") ) {
                final Object value = values.remove("ProjectDemandEndDate");
                if( (value == null) || (!value.equals(getProjectDemandEndDate())) ) {
                    setProjectDemandEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectDemandReleasedDateTime") ) {
                final Object value = values.remove("ProjectDemandReleasedDateTime");
                if( (value == null) || (!value.equals(getProjectDemandReleasedDateTime())) ) {
                    setProjectDemandReleasedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndActualSupplyDate") ) {
                final Object value = values.remove("ProjDmndActualSupplyDate");
                if( (value == null) || (!value.equals(getProjDmndActualSupplyDate())) ) {
                    setProjDmndActualSupplyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectDemandPerUnitAmount") ) {
                final Object value = values.remove("ProjectDemandPerUnitAmount");
                if( (value == null) || (!value.equals(getProjectDemandPerUnitAmount())) ) {
                    setProjectDemandPerUnitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjectDemandRequestCurrency") ) {
                final Object value = values.remove("ProjectDemandRequestCurrency");
                if( (value == null) || (!value.equals(getProjectDemandRequestCurrency())) ) {
                    setProjectDemandRequestCurrency(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRequestedQuantityUnit") ) {
                final Object value = values.remove("ProjDmndRequestedQuantityUnit");
                if( (value == null) || (!value.equals(getProjDmndRequestedQuantityUnit())) ) {
                    setProjDmndRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PriceUnitQty") ) {
                final Object value = values.remove("PriceUnitQty");
                if( (value == null) || (!value.equals(getPriceUnitQty())) ) {
                    setPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjectDemandRequestNetAmount") ) {
                final Object value = values.remove("ProjectDemandRequestNetAmount");
                if( (value == null) || (!value.equals(getProjectDemandRequestNetAmount())) ) {
                    setProjectDemandRequestNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndReqNetAmountCurrency") ) {
                final Object value = values.remove("ProjDmndReqNetAmountCurrency");
                if( (value == null) || (!value.equals(getProjDmndReqNetAmountCurrency())) ) {
                    setProjDmndReqNetAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandOverallAmount") ) {
                final Object value = values.remove("ProjectDemandOverallAmount");
                if( (value == null) || (!value.equals(getProjectDemandOverallAmount())) ) {
                    setProjectDemandOverallAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjectDemandExpectedAmount") ) {
                final Object value = values.remove("ProjectDemandExpectedAmount");
                if( (value == null) || (!value.equals(getProjectDemandExpectedAmount())) ) {
                    setProjectDemandExpectedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProjDmndRequestedQuantity") ) {
                final Object value = values.remove("ProjDmndRequestedQuantity");
                if( (value == null) || (!value.equals(getProjDmndRequestedQuantity())) ) {
                    setProjDmndRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProjectDemandLastChangedByUser") ) {
                final Object value = values.remove("ProjectDemandLastChangedByUser");
                if( (value == null) || (!value.equals(getProjectDemandLastChangedByUser())) ) {
                    setProjectDemandLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ProjDemandLastChangeDateTime") ) {
                final Object value = values.remove("ProjDemandLastChangeDateTime");
                if( (value == null) || (!value.equals(getProjDemandLastChangeDateTime())) ) {
                    setProjDemandLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndExternalReferenceUUID") ) {
                final Object value = values.remove("ProjDmndExternalReferenceUUID");
                if( (value == null) || (!value.equals(getProjDmndExternalReferenceUUID())) ) {
                    setProjDmndExternalReferenceUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Expense") ) {
                final Object value = (values).remove("to_Expense");
                if( value instanceof Map ) {
                    if( toExpense == null ) {
                        toExpense = new ProjectDemandExpense();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toExpense.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Material") ) {
                final Object value = (values).remove("to_Material");
                if( value instanceof Map ) {
                    if( toMaterial == null ) {
                        toMaterial = new ProjectDemandMaterial();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterial.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Service") ) {
                final Object value = (values).remove("to_Service");
                if( value instanceof Map ) {
                    if( toService == null ) {
                        toService = new ProjectDemandService();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toService.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Work") ) {
                final Object value = (values).remove("to_Work");
                if( value instanceof Map ) {
                    if( toWork == null ) {
                        toWork = new ProjectDemandResource();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWork.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectDemandField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toExpense != null ) {
            (values).put("to_Expense", toExpense);
        }
        if( toMaterial != null ) {
            (values).put("to_Material", toMaterial);
        }
        if( toService != null ) {
            (values).put("to_Service", toService);
        }
        if( toWork != null ) {
            (values).put("to_Work", toWork);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemandExpense</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Expense</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandExpense</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandExpense fetchExpense()
    {
        return fetchFieldAsSingle("to_Expense", ProjectDemandExpense.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandExpense</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Expense</b>.
     * <p>
     * If the navigation property <b>to_Expense</b> of a queried <b>ProjectDemand</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandExpense</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandExpense getExpenseOrFetch()
    {
        if( toExpense == null ) {
            toExpense = fetchExpense();
        }
        return toExpense;
    }

    /**
     * Retrieval of associated <b>ProjectDemandExpense</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Expense</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemand</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Expense</b> is already loaded, the result will contain
     *         the <b>ProjectDemandExpense</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandExpense> getExpenseIfPresent()
    {
        return Option.of(toExpense);
    }

    /**
     * Overwrites the associated <b>ProjectDemandExpense</b> entity for the loaded navigation property
     * <b>to_Expense</b>.
     *
     * @param value
     *            New <b>ProjectDemandExpense</b> entity.
     */
    public void setExpense( final ProjectDemandExpense value )
    {
        toExpense = value;
    }

    /**
     * Fetches the <b>ProjectDemandMaterial</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Material</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandMaterial</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterial fetchMaterial()
    {
        return fetchFieldAsSingle("to_Material", ProjectDemandMaterial.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterial</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Material</b>.
     * <p>
     * If the navigation property <b>to_Material</b> of a queried <b>ProjectDemand</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandMaterial</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterial getMaterialOrFetch()
    {
        if( toMaterial == null ) {
            toMaterial = fetchMaterial();
        }
        return toMaterial;
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterial</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Material</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemand</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Material</b> is already loaded, the result will contain
     *         the <b>ProjectDemandMaterial</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandMaterial> getMaterialIfPresent()
    {
        return Option.of(toMaterial);
    }

    /**
     * Overwrites the associated <b>ProjectDemandMaterial</b> entity for the loaded navigation property
     * <b>to_Material</b>.
     *
     * @param value
     *            New <b>ProjectDemandMaterial</b> entity.
     */
    public void setMaterial( final ProjectDemandMaterial value )
    {
        toMaterial = value;
    }

    /**
     * Fetches the <b>ProjectDemandService</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Service</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandService</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandService fetchService()
    {
        return fetchFieldAsSingle("to_Service", ProjectDemandService.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandService</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Service</b>.
     * <p>
     * If the navigation property <b>to_Service</b> of a queried <b>ProjectDemand</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandService</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandService getServiceOrFetch()
    {
        if( toService == null ) {
            toService = fetchService();
        }
        return toService;
    }

    /**
     * Retrieval of associated <b>ProjectDemandService</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Service</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemand</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Service</b> is already loaded, the result will contain
     *         the <b>ProjectDemandService</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandService> getServiceIfPresent()
    {
        return Option.of(toService);
    }

    /**
     * Overwrites the associated <b>ProjectDemandService</b> entity for the loaded navigation property
     * <b>to_Service</b>.
     *
     * @param value
     *            New <b>ProjectDemandService</b> entity.
     */
    public void setService( final ProjectDemandService value )
    {
        toService = value;
    }

    /**
     * Fetches the <b>ProjectDemandResource</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Work</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandResource</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource fetchWork()
    {
        return fetchFieldAsSingle("to_Work", ProjectDemandResource.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property <b>to_Work</b> of a queried <b>ProjectDemand</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandResource</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource getWorkOrFetch()
    {
        if( toWork == null ) {
            toWork = fetchWork();
        }
        return toWork;
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemand</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Work</b> is already loaded, the result will contain the
     *         <b>ProjectDemandResource</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<ProjectDemandResource> getWorkIfPresent()
    {
        return Option.of(toWork);
    }

    /**
     * Overwrites the associated <b>ProjectDemandResource</b> entity for the loaded navigation property <b>to_Work</b>.
     *
     * @param value
     *            New <b>ProjectDemandResource</b> entity.
     */
    public void setWork( final ProjectDemandResource value )
    {
        toWork = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemand instances.
     *
     */
    public final static class ProjectDemandBuilder
    {

        private ProjectDemandExpense toExpense;
        private ProjectDemandMaterial toMaterial;
        private ProjectDemandService toService;
        private ProjectDemandResource toWork;

        private ProjectDemand.ProjectDemandBuilder toExpense( final ProjectDemandExpense value )
        {
            toExpense = value;
            return this;
        }

        /**
         * Navigation property <b>to_Expense</b> for <b>ProjectDemand</b> to single <b>ProjectDemandExpense</b>.
         *
         * @param value
         *            The ProjectDemandExpense to build this ProjectDemand with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemand.ProjectDemandBuilder expense( final ProjectDemandExpense value )
        {
            return toExpense(value);
        }

        private ProjectDemand.ProjectDemandBuilder toMaterial( final ProjectDemandMaterial value )
        {
            toMaterial = value;
            return this;
        }

        /**
         * Navigation property <b>to_Material</b> for <b>ProjectDemand</b> to single <b>ProjectDemandMaterial</b>.
         *
         * @param value
         *            The ProjectDemandMaterial to build this ProjectDemand with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemand.ProjectDemandBuilder material( final ProjectDemandMaterial value )
        {
            return toMaterial(value);
        }

        private ProjectDemand.ProjectDemandBuilder toService( final ProjectDemandService value )
        {
            toService = value;
            return this;
        }

        /**
         * Navigation property <b>to_Service</b> for <b>ProjectDemand</b> to single <b>ProjectDemandService</b>.
         *
         * @param value
         *            The ProjectDemandService to build this ProjectDemand with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemand.ProjectDemandBuilder service( final ProjectDemandService value )
        {
            return toService(value);
        }

        private ProjectDemand.ProjectDemandBuilder toWork( final ProjectDemandResource value )
        {
            toWork = value;
            return this;
        }

        /**
         * Navigation property <b>to_Work</b> for <b>ProjectDemand</b> to single <b>ProjectDemandResource</b>.
         *
         * @param value
         *            The ProjectDemandResource to build this ProjectDemand with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemand.ProjectDemandBuilder work( final ProjectDemandResource value )
        {
            return toWork(value);
        }

    }

}
