/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandExpenseField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandExpenseLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandExpenseOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandExpenseSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Demand for Expense
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectDemandExpense_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandExpense extends VdmEntity<ProjectDemandExpense>
{

    /**
     * Selector for all available fields of ProjectDemandExpense.
     *
     */
    public final static ProjectDemandExpenseSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseUUID</b>
     * </p>
     *
     * @return Global Identification of a Demand for Expense
     */
    @Key
    @SerializedName( "ProjectDemandExpenseUUID" )
    @JsonProperty( "ProjectDemandExpenseUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandExpenseUUID" )
    private UUID projectDemandExpenseUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandExpenseUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<UUID> PROJECT_DEMAND_EXPENSE_UUID =
        new ProjectDemandExpenseField<UUID>("ProjectDemandExpenseUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandExpenseField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseType</b>
     * </p>
     *
     * @return Expense Type
     */
    @SerializedName( "ProjectDemandExpenseType" )
    @JsonProperty( "ProjectDemandExpenseType" )
    @Nullable
    @ODataField( odataName = "ProjectDemandExpenseType" )
    private String projectDemandExpenseType;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandExpenseType</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<String> PROJECT_DEMAND_EXPENSE_TYPE =
        new ProjectDemandExpenseField<String>("ProjectDemandExpenseType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Global ID of the Project to Which a Demand is Related
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<UUID> PROJECT_UUID =
        new ProjectDemandExpenseField<UUID>("ProjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @return UUID of the Object to Which a Demand Is Related
     */
    @SerializedName( "ReferencedObjectUUID" )
    @JsonProperty( "ReferencedObjectUUID" )
    @Nullable
    @ODataField( odataName = "ReferencedObjectUUID" )
    private UUID referencedObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ReferencedObjectUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<UUID> REFERENCED_OBJECT_UUID =
        new ProjectDemandExpenseField<UUID>("ReferencedObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndBillingControlCategory</b>
     * </p>
     *
     * @return Billing Control Category
     */
    @SerializedName( "ProjDmndBillingControlCategory" )
    @JsonProperty( "ProjDmndBillingControlCategory" )
    @Nullable
    @ODataField( odataName = "ProjDmndBillingControlCategory" )
    private String projDmndBillingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndBillingControlCategory</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<String> PROJ_DMND_BILLING_CONTROL_CATEGORY =
        new ProjectDemandExpenseField<String>("ProjDmndBillingControlCategory");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<String> CREATED_BY_USER =
        new ProjectDemandExpenseField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjectDemandExpenseField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<String> LAST_CHANGED_BY_USER =
        new ProjectDemandExpenseField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandExpenseField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjectDemandExpenseField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Root</b> for <b>ProjectDemandExpense</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Navigation property <b>to_ProjDmndExpenseDistr</b> for <b>ProjectDemandExpense</b> to multiple
     * <b>ProjDmndExpenseDistr</b>.
     *
     */
    @SerializedName( "to_ProjDmndExpenseDistr" )
    @JsonProperty( "to_ProjDmndExpenseDistr" )
    @ODataField( odataName = "to_ProjDmndExpenseDistr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjDmndExpenseDistr> toProjDmndExpenseDistr;
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandExpenseOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjectDemandExpenseOneToOneLink<ProjectDemand>("to_Root");
    /**
     * Use with available fluent helpers to apply the <b>to_ProjDmndExpenseDistr</b> navigation property to query
     * operations.
     *
     */
    public final static ProjectDemandExpenseLink<ProjDmndExpenseDistr> TO_PROJ_DMND_EXPENSE_DISTR =
        new ProjectDemandExpenseLink<ProjDmndExpenseDistr>("to_ProjDmndExpenseDistr");

    @Nonnull
    @Override
    public Class<ProjectDemandExpense> getType()
    {
        return ProjectDemandExpense.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseUUID</b>
     * </p>
     *
     * @param projectDemandExpenseUUID
     *            Global Identification of a Demand for Expense
     */
    public void setProjectDemandExpenseUUID( @Nullable final UUID projectDemandExpenseUUID )
    {
        rememberChangedField("ProjectDemandExpenseUUID", this.projectDemandExpenseUUID);
        this.projectDemandExpenseUUID = projectDemandExpenseUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandExpenseType</b>
     * </p>
     *
     * @param projectDemandExpenseType
     *            Expense Type
     */
    public void setProjectDemandExpenseType( @Nullable final String projectDemandExpenseType )
    {
        rememberChangedField("ProjectDemandExpenseType", this.projectDemandExpenseType);
        this.projectDemandExpenseType = projectDemandExpenseType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Global ID of the Project to Which a Demand is Related
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedObjectUUID</b>
     * </p>
     *
     * @param referencedObjectUUID
     *            UUID of the Object to Which a Demand Is Related
     */
    public void setReferencedObjectUUID( @Nullable final UUID referencedObjectUUID )
    {
        rememberChangedField("ReferencedObjectUUID", this.referencedObjectUUID);
        this.referencedObjectUUID = referencedObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndBillingControlCategory</b>
     * </p>
     *
     * @param projDmndBillingControlCategory
     *            Billing Control Category
     */
    public void setProjDmndBillingControlCategory( @Nullable final String projDmndBillingControlCategory )
    {
        rememberChangedField("ProjDmndBillingControlCategory", this.projDmndBillingControlCategory);
        this.projDmndBillingControlCategory = projDmndBillingControlCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandExpense";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectDemandExpenseUUID", getProjectDemandExpenseUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectDemandExpenseUUID", getProjectDemandExpenseUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjectDemandExpenseType", getProjectDemandExpenseType());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ReferencedObjectUUID", getReferencedObjectUUID());
        values.put("ProjDmndBillingControlCategory", getProjDmndBillingControlCategory());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectDemandExpenseUUID") ) {
                final Object value = values.remove("ProjectDemandExpenseUUID");
                if( (value == null) || (!value.equals(getProjectDemandExpenseUUID())) ) {
                    setProjectDemandExpenseUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandExpenseType") ) {
                final Object value = values.remove("ProjectDemandExpenseType");
                if( (value == null) || (!value.equals(getProjectDemandExpenseType())) ) {
                    setProjectDemandExpenseType(((String) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ReferencedObjectUUID") ) {
                final Object value = values.remove("ReferencedObjectUUID");
                if( (value == null) || (!value.equals(getReferencedObjectUUID())) ) {
                    setReferencedObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjDmndBillingControlCategory") ) {
                final Object value = values.remove("ProjDmndBillingControlCategory");
                if( (value == null) || (!value.equals(getProjDmndBillingControlCategory())) ) {
                    setProjDmndBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProjDmndExpenseDistr") ) {
                final Object value = (values).remove("to_ProjDmndExpenseDistr");
                if( value instanceof Iterable ) {
                    if( toProjDmndExpenseDistr == null ) {
                        toProjDmndExpenseDistr = Lists.newArrayList();
                    } else {
                        toProjDmndExpenseDistr = Lists.newArrayList(toProjDmndExpenseDistr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjDmndExpenseDistr entity;
                        if( toProjDmndExpenseDistr.size() > i ) {
                            entity = toProjDmndExpenseDistr.get(i);
                        } else {
                            entity = new ProjDmndExpenseDistr();
                            toProjDmndExpenseDistr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjectDemandExpenseField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandExpenseField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandExpenseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandExpenseField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        if( toProjDmndExpenseDistr != null ) {
            (values).put("to_ProjDmndExpenseDistr", toProjDmndExpenseDistr);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjectDemandExpense</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandExpense</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Fetches the <b>ProjDmndExpenseDistr</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProjDmndExpenseDistr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjDmndExpenseDistr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndExpenseDistr> fetchProjDmndExpenseDistr()
    {
        return fetchFieldAsList("to_ProjDmndExpenseDistr", ProjDmndExpenseDistr.class);
    }

    /**
     * Retrieval of associated <b>ProjDmndExpenseDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProjDmndExpenseDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndExpenseDistr</b> of a queried <b>ProjectDemandExpense</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjDmndExpenseDistr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndExpenseDistr> getProjDmndExpenseDistrOrFetch()
    {
        if( toProjDmndExpenseDistr == null ) {
            toProjDmndExpenseDistr = fetchProjDmndExpenseDistr();
        }
        return toProjDmndExpenseDistr;
    }

    /**
     * Retrieval of associated <b>ProjDmndExpenseDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProjDmndExpenseDistr</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandExpense</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProjDmndExpenseDistr</b> is already loaded, the result
     *         will contain the <b>ProjDmndExpenseDistr</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjDmndExpenseDistr>> getProjDmndExpenseDistrIfPresent()
    {
        return Option.of(toProjDmndExpenseDistr);
    }

    /**
     * Overwrites the list of associated <b>ProjDmndExpenseDistr</b> entities for the loaded navigation property
     * <b>to_ProjDmndExpenseDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndExpenseDistr</b> of a queried <b>ProjectDemandExpense</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjDmndExpenseDistr</b> entities.
     */
    public void setProjDmndExpenseDistr( @Nonnull final List<ProjDmndExpenseDistr> value )
    {
        if( toProjDmndExpenseDistr == null ) {
            toProjDmndExpenseDistr = Lists.newArrayList();
        }
        toProjDmndExpenseDistr.clear();
        toProjDmndExpenseDistr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjDmndExpenseDistr</b> entities. This corresponds to the OData
     * navigation property <b>to_ProjDmndExpenseDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndExpenseDistr</b> of a queried <b>ProjectDemandExpense</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjDmndExpenseDistr</b> entities.
     */
    public void addProjDmndExpenseDistr( ProjDmndExpenseDistr... entity )
    {
        if( toProjDmndExpenseDistr == null ) {
            toProjDmndExpenseDistr = Lists.newArrayList();
        }
        toProjDmndExpenseDistr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandExpense instances.
     *
     */
    public final static class ProjectDemandExpenseBuilder
    {

        private ProjectDemand toRoot;
        private List<ProjDmndExpenseDistr> toProjDmndExpenseDistr = Lists.newArrayList();

        private ProjectDemandExpense.ProjectDemandExpenseBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjectDemandExpense</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandExpense with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandExpense.ProjectDemandExpenseBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

        private ProjectDemandExpense.ProjectDemandExpenseBuilder toProjDmndExpenseDistr(
            final List<ProjDmndExpenseDistr> value )
        {
            toProjDmndExpenseDistr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProjDmndExpenseDistr</b> for <b>ProjectDemandExpense</b> to multiple
         * <b>ProjDmndExpenseDistr</b>.
         *
         * @param value
         *            The ProjDmndExpenseDistrs to build this ProjectDemandExpense with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandExpense.ProjectDemandExpenseBuilder projDmndExpenseDistr( ProjDmndExpenseDistr... value )
        {
            return toProjDmndExpenseDistr(Lists.newArrayList(value));
        }

    }

}
