/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandMaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandMaterialOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandMaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Material Demand
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemandMaterial_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandMaterial extends VdmEntity<ProjectDemandMaterial>
{

    /**
     * Selector for all available fields of ProjectDemandMaterial.
     *
     */
    public final static ProjectDemandMaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandMaterialUUID</b>
     * </p>
     *
     * @return Global Identification for Material Demand
     */
    @Key
    @SerializedName( "ProjectDemandMaterialUUID" )
    @JsonProperty( "ProjectDemandMaterialUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandMaterialUUID" )
    private UUID projectDemandMaterialUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandMaterialUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<UUID> PROJECT_DEMAND_MATERIAL_UUID =
        new ProjectDemandMaterialField<UUID>("ProjectDemandMaterialUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandMaterialField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> MATERIAL =
        new ProjectDemandMaterialField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> STORAGE_LOCATION =
        new ProjectDemandMaterialField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> MATERIAL_GROUP =
        new ProjectDemandMaterialField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Desired Supplier for Project Demand
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> SUPPLIER =
        new ProjectDemandMaterialField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Info Record for Project Demand
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> PURCHASING_INFO_RECORD =
        new ProjectDemandMaterialField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> PURCHASE_CONTRACT =
        new ProjectDemandMaterialField<String>("PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> PURCHASE_CONTRACT_ITEM =
        new ProjectDemandMaterialField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "MaterialPlannedDeliveryDurn" )
    @JsonProperty( "MaterialPlannedDeliveryDurn" )
    @Nullable
    @ODataField( odataName = "MaterialPlannedDeliveryDurn" )
    private BigDecimal materialPlannedDeliveryDurn;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPlannedDeliveryDurn</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> MATERIAL_PLANNED_DELIVERY_DURN =
        new ProjectDemandMaterialField<BigDecimal>("MaterialPlannedDeliveryDurn");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> PURCHASE_REQUISITION =
        new ProjectDemandMaterialField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FormattedPurRequisitionItem</b>
     * </p>
     *
     * @return Formatted Purchase Requisition Item
     */
    @SerializedName( "FormattedPurRequisitionItem" )
    @JsonProperty( "FormattedPurRequisitionItem" )
    @Nullable
    @ODataField( odataName = "FormattedPurRequisitionItem" )
    private String formattedPurRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>FormattedPurRequisitionItem</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> FORMATTED_PUR_REQUISITION_ITEM =
        new ProjectDemandMaterialField<String>("FormattedPurRequisitionItem");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Purchase Requisition Item Number
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> PURCHASE_REQUISITION_ITEM =
        new ProjectDemandMaterialField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPurOrderAllwdForInbDeliv</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "IsPurOrderAllwdForInbDeliv" )
    @JsonProperty( "IsPurOrderAllwdForInbDeliv" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPurOrderAllwdForInbDeliv" )
    private Boolean isPurOrderAllwdForInbDeliv;
    /**
     * Use with available fluent helpers to apply the <b>IsPurOrderAllwdForInbDeliv</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<Boolean> IS_PUR_ORDER_ALLWD_FOR_INB_DELIV =
        new ProjectDemandMaterialField<Boolean>("IsPurOrderAllwdForInbDeliv");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderedQuantity</b>
     * </p>
     *
     * @return The orderedQuantity contained in this entity.
     */
    @SerializedName( "OrderedQuantity" )
    @JsonProperty( "OrderedQuantity" )
    @Nullable
    @ODataField( odataName = "OrderedQuantity" )
    private BigDecimal orderedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OrderedQuantity</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> ORDERED_QUANTITY =
        new ProjectDemandMaterialField<BigDecimal>("OrderedQuantity");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StillToBeDeliveredQuantity</b>
     * </p>
     *
     * @return The stillToBeDeliveredQuantity contained in this entity.
     */
    @SerializedName( "StillToBeDeliveredQuantity" )
    @JsonProperty( "StillToBeDeliveredQuantity" )
    @Nullable
    @ODataField( odataName = "StillToBeDeliveredQuantity" )
    private BigDecimal stillToBeDeliveredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>StillToBeDeliveredQuantity</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> STILL_TO_BE_DELIVERED_QUANTITY =
        new ProjectDemandMaterialField<BigDecimal>("StillToBeDeliveredQuantity");
    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptAmount</b>
     * </p>
     *
     * @return The invoiceReceiptAmount contained in this entity.
     */
    @SerializedName( "InvoiceReceiptAmount" )
    @JsonProperty( "InvoiceReceiptAmount" )
    @Nullable
    @ODataField( odataName = "InvoiceReceiptAmount" )
    private BigDecimal invoiceReceiptAmount;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReceiptAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> INVOICE_RECEIPT_AMOUNT =
        new ProjectDemandMaterialField<BigDecimal>("InvoiceReceiptAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return The requestedQuantity contained in this entity.
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> REQUESTED_QUANTITY =
        new ProjectDemandMaterialField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetValueAmountInDocCurrency</b>
     * </p>
     *
     * @return The netValueAmountInDocCurrency contained in this entity.
     */
    @SerializedName( "NetValueAmountInDocCurrency" )
    @JsonProperty( "NetValueAmountInDocCurrency" )
    @Nullable
    @ODataField( odataName = "NetValueAmountInDocCurrency" )
    private BigDecimal netValueAmountInDocCurrency;
    /**
     * Use with available fluent helpers to apply the <b>NetValueAmountInDocCurrency</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> NET_VALUE_AMOUNT_IN_DOC_CURRENCY =
        new ProjectDemandMaterialField<BigDecimal>("NetValueAmountInDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> DOCUMENT_CURRENCY =
        new ProjectDemandMaterialField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @return The scheduleLineDeliveryDate contained in this entity.
     */
    @SerializedName( "ScheduleLineDeliveryDate" )
    @JsonProperty( "ScheduleLineDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduleLineDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryDate</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<LocalDateTime> SCHEDULE_LINE_DELIVERY_DATE =
        new ProjectDemandMaterialField<LocalDateTime>("ScheduleLineDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @return The schedLineStscDeliveryDate contained in this entity.
     */
    @SerializedName( "SchedLineStscDeliveryDate" )
    @JsonProperty( "SchedLineStscDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedLineStscDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedLineStscDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedLineStscDeliveryDate</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<LocalDateTime> SCHED_LINE_STSC_DELIVERY_DATE =
        new ProjectDemandMaterialField<LocalDateTime>("SchedLineStscDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Purchase requisition unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<String> BASE_UNIT =
        new ProjectDemandMaterialField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptAmount</b>
     * </p>
     *
     * @return The goodsReceiptAmount contained in this entity.
     */
    @SerializedName( "GoodsReceiptAmount" )
    @JsonProperty( "GoodsReceiptAmount" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptAmount" )
    private BigDecimal goodsReceiptAmount;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptAmount</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialField<BigDecimal> GOODS_RECEIPT_AMOUNT =
        new ProjectDemandMaterialField<BigDecimal>("GoodsReceiptAmount");
    /**
     * Navigation property <b>to_RootTP</b> for <b>ProjectDemandMaterial</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_RootTP" )
    @JsonProperty( "to_RootTP" )
    @ODataField( odataName = "to_RootTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRootTP;
    /**
     * Navigation property <b>to_MaterialSupply</b> for <b>ProjectDemandMaterial</b> to single
     * <b>ProjectDemandMaterialSupply</b>.
     *
     */
    @SerializedName( "to_MaterialSupply" )
    @JsonProperty( "to_MaterialSupply" )
    @ODataField( odataName = "to_MaterialSupply" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandMaterialSupply toMaterialSupply;
    /**
     * Use with available fluent helpers to apply the <b>to_RootTP</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandMaterialOneToOneLink<ProjectDemand> TO_ROOT_TP =
        new ProjectDemandMaterialOneToOneLink<ProjectDemand>("to_RootTP");
    /**
     * Use with available fluent helpers to apply the <b>to_MaterialSupply</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandMaterialOneToOneLink<ProjectDemandMaterialSupply> TO_MATERIAL_SUPPLY =
        new ProjectDemandMaterialOneToOneLink<ProjectDemandMaterialSupply>("to_MaterialSupply");

    @Nonnull
    @Override
    public Class<ProjectDemandMaterial> getType()
    {
        return ProjectDemandMaterial.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandMaterialUUID</b>
     * </p>
     *
     * @param projectDemandMaterialUUID
     *            Global Identification for Material Demand
     */
    public void setProjectDemandMaterialUUID( @Nullable final UUID projectDemandMaterialUUID )
    {
        rememberChangedField("ProjectDemandMaterialUUID", this.projectDemandMaterialUUID);
        this.projectDemandMaterialUUID = projectDemandMaterialUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Desired Supplier for Project Demand
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Info Record for Project Demand
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @param materialPlannedDeliveryDurn
     *            Planned Delivery Time in Days
     */
    public void setMaterialPlannedDeliveryDurn( @Nullable final BigDecimal materialPlannedDeliveryDurn )
    {
        rememberChangedField("MaterialPlannedDeliveryDurn", this.materialPlannedDeliveryDurn);
        this.materialPlannedDeliveryDurn = materialPlannedDeliveryDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FormattedPurRequisitionItem</b>
     * </p>
     *
     * @param formattedPurRequisitionItem
     *            Formatted Purchase Requisition Item
     */
    public void setFormattedPurRequisitionItem( @Nullable final String formattedPurRequisitionItem )
    {
        rememberChangedField("FormattedPurRequisitionItem", this.formattedPurRequisitionItem);
        this.formattedPurRequisitionItem = formattedPurRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Purchase Requisition Item Number
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPurOrderAllwdForInbDeliv</b>
     * </p>
     *
     * @param isPurOrderAllwdForInbDeliv
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setIsPurOrderAllwdForInbDeliv( @Nullable final Boolean isPurOrderAllwdForInbDeliv )
    {
        rememberChangedField("IsPurOrderAllwdForInbDeliv", this.isPurOrderAllwdForInbDeliv);
        this.isPurOrderAllwdForInbDeliv = isPurOrderAllwdForInbDeliv;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderedQuantity</b>
     * </p>
     *
     * @param orderedQuantity
     *            The orderedQuantity to set.
     */
    public void setOrderedQuantity( @Nullable final BigDecimal orderedQuantity )
    {
        rememberChangedField("OrderedQuantity", this.orderedQuantity);
        this.orderedQuantity = orderedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StillToBeDeliveredQuantity</b>
     * </p>
     *
     * @param stillToBeDeliveredQuantity
     *            The stillToBeDeliveredQuantity to set.
     */
    public void setStillToBeDeliveredQuantity( @Nullable final BigDecimal stillToBeDeliveredQuantity )
    {
        rememberChangedField("StillToBeDeliveredQuantity", this.stillToBeDeliveredQuantity);
        this.stillToBeDeliveredQuantity = stillToBeDeliveredQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptAmount</b>
     * </p>
     *
     * @param invoiceReceiptAmount
     *            The invoiceReceiptAmount to set.
     */
    public void setInvoiceReceiptAmount( @Nullable final BigDecimal invoiceReceiptAmount )
    {
        rememberChangedField("InvoiceReceiptAmount", this.invoiceReceiptAmount);
        this.invoiceReceiptAmount = invoiceReceiptAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            The requestedQuantity to set.
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetValueAmountInDocCurrency</b>
     * </p>
     *
     * @param netValueAmountInDocCurrency
     *            The netValueAmountInDocCurrency to set.
     */
    public void setNetValueAmountInDocCurrency( @Nullable final BigDecimal netValueAmountInDocCurrency )
    {
        rememberChangedField("NetValueAmountInDocCurrency", this.netValueAmountInDocCurrency);
        this.netValueAmountInDocCurrency = netValueAmountInDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @param scheduleLineDeliveryDate
     *            The scheduleLineDeliveryDate to set.
     */
    public void setScheduleLineDeliveryDate( @Nullable final LocalDateTime scheduleLineDeliveryDate )
    {
        rememberChangedField("ScheduleLineDeliveryDate", this.scheduleLineDeliveryDate);
        this.scheduleLineDeliveryDate = scheduleLineDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @param schedLineStscDeliveryDate
     *            The schedLineStscDeliveryDate to set.
     */
    public void setSchedLineStscDeliveryDate( @Nullable final LocalDateTime schedLineStscDeliveryDate )
    {
        rememberChangedField("SchedLineStscDeliveryDate", this.schedLineStscDeliveryDate);
        this.schedLineStscDeliveryDate = schedLineStscDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Purchase requisition unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 21, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptAmount</b>
     * </p>
     *
     * @param goodsReceiptAmount
     *            The goodsReceiptAmount to set.
     */
    public void setGoodsReceiptAmount( @Nullable final BigDecimal goodsReceiptAmount )
    {
        rememberChangedField("GoodsReceiptAmount", this.goodsReceiptAmount);
        this.goodsReceiptAmount = goodsReceiptAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandMaterial";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectDemandMaterialUUID", getProjectDemandMaterialUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectDemandMaterialUUID", getProjectDemandMaterialUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("Material", getMaterial());
        values.put("StorageLocation", getStorageLocation());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Supplier", getSupplier());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("MaterialPlannedDeliveryDurn", getMaterialPlannedDeliveryDurn());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("FormattedPurRequisitionItem", getFormattedPurRequisitionItem());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("IsPurOrderAllwdForInbDeliv", getIsPurOrderAllwdForInbDeliv());
        values.put("OrderedQuantity", getOrderedQuantity());
        values.put("StillToBeDeliveredQuantity", getStillToBeDeliveredQuantity());
        values.put("InvoiceReceiptAmount", getInvoiceReceiptAmount());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("NetValueAmountInDocCurrency", getNetValueAmountInDocCurrency());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("ScheduleLineDeliveryDate", getScheduleLineDeliveryDate());
        values.put("SchedLineStscDeliveryDate", getSchedLineStscDeliveryDate());
        values.put("BaseUnit", getBaseUnit());
        values.put("GoodsReceiptAmount", getGoodsReceiptAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectDemandMaterialUUID") ) {
                final Object value = values.remove("ProjectDemandMaterialUUID");
                if( (value == null) || (!value.equals(getProjectDemandMaterialUUID())) ) {
                    setProjectDemandMaterialUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("MaterialPlannedDeliveryDurn") ) {
                final Object value = values.remove("MaterialPlannedDeliveryDurn");
                if( (value == null) || (!value.equals(getMaterialPlannedDeliveryDurn())) ) {
                    setMaterialPlannedDeliveryDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("FormattedPurRequisitionItem") ) {
                final Object value = values.remove("FormattedPurRequisitionItem");
                if( (value == null) || (!value.equals(getFormattedPurRequisitionItem())) ) {
                    setFormattedPurRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("IsPurOrderAllwdForInbDeliv") ) {
                final Object value = values.remove("IsPurOrderAllwdForInbDeliv");
                if( (value == null) || (!value.equals(getIsPurOrderAllwdForInbDeliv())) ) {
                    setIsPurOrderAllwdForInbDeliv(((Boolean) value));
                }
            }
            if( values.containsKey("OrderedQuantity") ) {
                final Object value = values.remove("OrderedQuantity");
                if( (value == null) || (!value.equals(getOrderedQuantity())) ) {
                    setOrderedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("StillToBeDeliveredQuantity") ) {
                final Object value = values.remove("StillToBeDeliveredQuantity");
                if( (value == null) || (!value.equals(getStillToBeDeliveredQuantity())) ) {
                    setStillToBeDeliveredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("InvoiceReceiptAmount") ) {
                final Object value = values.remove("InvoiceReceiptAmount");
                if( (value == null) || (!value.equals(getInvoiceReceiptAmount())) ) {
                    setInvoiceReceiptAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetValueAmountInDocCurrency") ) {
                final Object value = values.remove("NetValueAmountInDocCurrency");
                if( (value == null) || (!value.equals(getNetValueAmountInDocCurrency())) ) {
                    setNetValueAmountInDocCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryDate") ) {
                final Object value = values.remove("ScheduleLineDeliveryDate");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryDate())) ) {
                    setScheduleLineDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedLineStscDeliveryDate") ) {
                final Object value = values.remove("SchedLineStscDeliveryDate");
                if( (value == null) || (!value.equals(getSchedLineStscDeliveryDate())) ) {
                    setSchedLineStscDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptAmount") ) {
                final Object value = values.remove("GoodsReceiptAmount");
                if( (value == null) || (!value.equals(getGoodsReceiptAmount())) ) {
                    setGoodsReceiptAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RootTP") ) {
                final Object value = (values).remove("to_RootTP");
                if( value instanceof Map ) {
                    if( toRootTP == null ) {
                        toRootTP = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRootTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaterialSupply") ) {
                final Object value = (values).remove("to_MaterialSupply");
                if( value instanceof Map ) {
                    if( toMaterialSupply == null ) {
                        toMaterialSupply = new ProjectDemandMaterialSupply();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterialSupply.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjectDemandMaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandMaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandMaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandMaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRootTP != null ) {
            (values).put("to_RootTP", toRootTP);
        }
        if( toMaterialSupply != null ) {
            (values).put("to_MaterialSupply", toMaterialSupply);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_RootTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRootTP()
    {
        return fetchFieldAsSingle("to_RootTP", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RootTP</b>.
     * <p>
     * If the navigation property <b>to_RootTP</b> of a queried <b>ProjectDemandMaterial</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootTPOrFetch()
    {
        if( toRootTP == null ) {
            toRootTP = fetchRootTP();
        }
        return toRootTP;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RootTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandMaterial</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RootTP</b> is already loaded, the result will contain
     *         the <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootTPIfPresent()
    {
        return Option.of(toRootTP);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_RootTP</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRootTP( final ProjectDemand value )
    {
        toRootTP = value;
    }

    /**
     * Fetches the <b>ProjectDemandMaterialSupply</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaterialSupply</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandMaterialSupply</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterialSupply fetchMaterialSupply()
    {
        return fetchFieldAsSingle("to_MaterialSupply", ProjectDemandMaterialSupply.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterialSupply</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaterialSupply</b>.
     * <p>
     * If the navigation property <b>to_MaterialSupply</b> of a queried <b>ProjectDemandMaterial</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandMaterialSupply</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterialSupply getMaterialSupplyOrFetch()
    {
        if( toMaterialSupply == null ) {
            toMaterialSupply = fetchMaterialSupply();
        }
        return toMaterialSupply;
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterialSupply</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaterialSupply</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandMaterial</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaterialSupply</b> is already loaded, the result will
     *         contain the <b>ProjectDemandMaterialSupply</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandMaterialSupply> getMaterialSupplyIfPresent()
    {
        return Option.of(toMaterialSupply);
    }

    /**
     * Overwrites the associated <b>ProjectDemandMaterialSupply</b> entity for the loaded navigation property
     * <b>to_MaterialSupply</b>.
     *
     * @param value
     *            New <b>ProjectDemandMaterialSupply</b> entity.
     */
    public void setMaterialSupply( final ProjectDemandMaterialSupply value )
    {
        toMaterialSupply = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandMaterial instances.
     *
     */
    public final static class ProjectDemandMaterialBuilder
    {

        private ProjectDemand toRootTP;
        private ProjectDemandMaterialSupply toMaterialSupply;

        private ProjectDemandMaterial.ProjectDemandMaterialBuilder toRootTP( final ProjectDemand value )
        {
            toRootTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_RootTP</b> for <b>ProjectDemandMaterial</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandMaterial with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandMaterial.ProjectDemandMaterialBuilder rootTP( final ProjectDemand value )
        {
            return toRootTP(value);
        }

        private ProjectDemandMaterial.ProjectDemandMaterialBuilder toMaterialSupply(
            final ProjectDemandMaterialSupply value )
        {
            toMaterialSupply = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaterialSupply</b> for <b>ProjectDemandMaterial</b> to single
         * <b>ProjectDemandMaterialSupply</b>.
         *
         * @param value
         *            The ProjectDemandMaterialSupply to build this ProjectDemandMaterial with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandMaterial.ProjectDemandMaterialBuilder materialSupply(
            final ProjectDemandMaterialSupply value )
        {
            return toMaterialSupply(value);
        }

    }

}
