/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandMaterialSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial ProjectDemandMaterial}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ProjectDemandMaterialByKeyFluentHelper
    extends
    FluentHelperByKey<ProjectDemandMaterialByKeyFluentHelper, ProjectDemandMaterial, ProjectDemandMaterialSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     * ProjectDemandMaterial} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProjectDemandMaterial}
     * @param projectDemandMaterialUUID
     *            Global Identification for Material Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProjectDemandMaterial}
     */
    public ProjectDemandMaterialByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID projectDemandMaterialUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectDemandMaterialUUID", projectDemandMaterialUUID);
    }

    @Override
    @Nonnull
    protected Class<ProjectDemandMaterial> getEntityClass()
    {
        return ProjectDemandMaterial.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
