/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandMaterialSupplyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandMaterialSupplyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandMaterialSupplySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Material Supply Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemandMaterialSupply_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandMaterialSupply extends VdmEntity<ProjectDemandMaterialSupply>
{

    /**
     * Selector for all available fields of ProjectDemandMaterialSupply.
     *
     */
    public final static ProjectDemandMaterialSupplySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDemandMaterialSupplyUUID</b>
     * </p>
     *
     * @return UUID for the Material Demand Supply
     */
    @Key
    @SerializedName( "ProjDemandMaterialSupplyUUID" )
    @JsonProperty( "ProjDemandMaterialSupplyUUID" )
    @Nullable
    @ODataField( odataName = "ProjDemandMaterialSupplyUUID" )
    private UUID projDemandMaterialSupplyUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDemandMaterialSupplyUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<UUID> PROJ_DEMAND_MATERIAL_SUPPLY_UUID =
        new ProjectDemandMaterialSupplyField<UUID>("ProjDemandMaterialSupplyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandMaterialUUID</b>
     * </p>
     *
     * @return Global Identification for Material Demand
     */
    @SerializedName( "ProjectDemandMaterialUUID" )
    @JsonProperty( "ProjectDemandMaterialUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandMaterialUUID" )
    private UUID projectDemandMaterialUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandMaterialUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<UUID> PROJECT_DEMAND_MATERIAL_UUID =
        new ProjectDemandMaterialSupplyField<UUID>("ProjectDemandMaterialUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<String> PURCHASE_REQUISITION =
        new ProjectDemandMaterialSupplyField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Purchase Requisition Item Number
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<String> PURCHASE_REQUISITION_ITEM =
        new ProjectDemandMaterialSupplyField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequirementPlan</b>
     * </p>
     *
     * @return Project Demand Requirement Plan
     */
    @SerializedName( "ProjectDemandRequirementPlan" )
    @JsonProperty( "ProjectDemandRequirementPlan" )
    @Nullable
    @ODataField( odataName = "ProjectDemandRequirementPlan" )
    private String projectDemandRequirementPlan;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandRequirementPlan</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<String> PROJECT_DEMAND_REQUIREMENT_PLAN =
        new ProjectDemandMaterialSupplyField<String>("ProjectDemandRequirementPlan");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndPlndIndepRqmtItem</b>
     * </p>
     *
     * @return Project Demand Planned Independent Requirement Item
     */
    @SerializedName( "ProjDmndPlndIndepRqmtItem" )
    @JsonProperty( "ProjDmndPlndIndepRqmtItem" )
    @Nullable
    @ODataField( odataName = "ProjDmndPlndIndepRqmtItem" )
    private String projDmndPlndIndepRqmtItem;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndPlndIndepRqmtItem</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<String> PROJ_DMND_PLND_INDEP_RQMT_ITEM =
        new ProjectDemandMaterialSupplyField<String>("ProjDmndPlndIndepRqmtItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandMaterialSupplyField<UUID>("ProjectDemandUUID");
    /**
     * Navigation property <b>to_Material</b> for <b>ProjectDemandMaterialSupply</b> to single
     * <b>ProjectDemandMaterial</b>.
     *
     */
    @SerializedName( "to_Material" )
    @JsonProperty( "to_Material" )
    @ODataField( odataName = "to_Material" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandMaterial toMaterial;
    /**
     * Navigation property <b>to_Root</b> for <b>ProjectDemandMaterialSupply</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Use with available fluent helpers to apply the <b>to_Material</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyOneToOneLink<ProjectDemandMaterial> TO_MATERIAL =
        new ProjectDemandMaterialSupplyOneToOneLink<ProjectDemandMaterial>("to_Material");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandMaterialSupplyOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjectDemandMaterialSupplyOneToOneLink<ProjectDemand>("to_Root");

    @Nonnull
    @Override
    public Class<ProjectDemandMaterialSupply> getType()
    {
        return ProjectDemandMaterialSupply.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDemandMaterialSupplyUUID</b>
     * </p>
     *
     * @param projDemandMaterialSupplyUUID
     *            UUID for the Material Demand Supply
     */
    public void setProjDemandMaterialSupplyUUID( @Nullable final UUID projDemandMaterialSupplyUUID )
    {
        rememberChangedField("ProjDemandMaterialSupplyUUID", this.projDemandMaterialSupplyUUID);
        this.projDemandMaterialSupplyUUID = projDemandMaterialSupplyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandMaterialUUID</b>
     * </p>
     *
     * @param projectDemandMaterialUUID
     *            Global Identification for Material Demand
     */
    public void setProjectDemandMaterialUUID( @Nullable final UUID projectDemandMaterialUUID )
    {
        rememberChangedField("ProjectDemandMaterialUUID", this.projectDemandMaterialUUID);
        this.projectDemandMaterialUUID = projectDemandMaterialUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Purchase Requisition Item Number
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequirementPlan</b>
     * </p>
     *
     * @param projectDemandRequirementPlan
     *            Project Demand Requirement Plan
     */
    public void setProjectDemandRequirementPlan( @Nullable final String projectDemandRequirementPlan )
    {
        rememberChangedField("ProjectDemandRequirementPlan", this.projectDemandRequirementPlan);
        this.projectDemandRequirementPlan = projectDemandRequirementPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndPlndIndepRqmtItem</b>
     * </p>
     *
     * @param projDmndPlndIndepRqmtItem
     *            Project Demand Planned Independent Requirement Item
     */
    public void setProjDmndPlndIndepRqmtItem( @Nullable final String projDmndPlndIndepRqmtItem )
    {
        rememberChangedField("ProjDmndPlndIndepRqmtItem", this.projDmndPlndIndepRqmtItem);
        this.projDmndPlndIndepRqmtItem = projDmndPlndIndepRqmtItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandMaterialSupply";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDemandMaterialSupplyUUID", getProjDemandMaterialSupplyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDemandMaterialSupplyUUID", getProjDemandMaterialSupplyUUID());
        values.put("ProjectDemandMaterialUUID", getProjectDemandMaterialUUID());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("ProjectDemandRequirementPlan", getProjectDemandRequirementPlan());
        values.put("ProjDmndPlndIndepRqmtItem", getProjDmndPlndIndepRqmtItem());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDemandMaterialSupplyUUID") ) {
                final Object value = values.remove("ProjDemandMaterialSupplyUUID");
                if( (value == null) || (!value.equals(getProjDemandMaterialSupplyUUID())) ) {
                    setProjDemandMaterialSupplyUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandMaterialUUID") ) {
                final Object value = values.remove("ProjectDemandMaterialUUID");
                if( (value == null) || (!value.equals(getProjectDemandMaterialUUID())) ) {
                    setProjectDemandMaterialUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandRequirementPlan") ) {
                final Object value = values.remove("ProjectDemandRequirementPlan");
                if( (value == null) || (!value.equals(getProjectDemandRequirementPlan())) ) {
                    setProjectDemandRequirementPlan(((String) value));
                }
            }
            if( values.containsKey("ProjDmndPlndIndepRqmtItem") ) {
                final Object value = values.remove("ProjDmndPlndIndepRqmtItem");
                if( (value == null) || (!value.equals(getProjDmndPlndIndepRqmtItem())) ) {
                    setProjDmndPlndIndepRqmtItem(((String) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Material") ) {
                final Object value = (values).remove("to_Material");
                if( value instanceof Map ) {
                    if( toMaterial == null ) {
                        toMaterial = new ProjectDemandMaterial();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterial.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectDemandMaterialSupplyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandMaterialSupplyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandMaterialSupplyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandMaterialSupplyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaterial != null ) {
            (values).put("to_Material", toMaterial);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemandMaterial</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Material</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandMaterial</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterial fetchMaterial()
    {
        return fetchFieldAsSingle("to_Material", ProjectDemandMaterial.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterial</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Material</b>.
     * <p>
     * If the navigation property <b>to_Material</b> of a queried <b>ProjectDemandMaterialSupply</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandMaterial</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandMaterial getMaterialOrFetch()
    {
        if( toMaterial == null ) {
            toMaterial = fetchMaterial();
        }
        return toMaterial;
    }

    /**
     * Retrieval of associated <b>ProjectDemandMaterial</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Material</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandMaterialSupply</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Material</b> is already loaded, the result will contain
     *         the <b>ProjectDemandMaterial</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandMaterial> getMaterialIfPresent()
    {
        return Option.of(toMaterial);
    }

    /**
     * Overwrites the associated <b>ProjectDemandMaterial</b> entity for the loaded navigation property
     * <b>to_Material</b>.
     *
     * @param value
     *            New <b>ProjectDemandMaterial</b> entity.
     */
    public void setMaterial( final ProjectDemandMaterial value )
    {
        toMaterial = value;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjectDemandMaterialSupply</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandMaterialSupply</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandMaterialSupply instances.
     *
     */
    public final static class ProjectDemandMaterialSupplyBuilder
    {

        private ProjectDemandMaterial toMaterial;
        private ProjectDemand toRoot;

        private ProjectDemandMaterialSupply.ProjectDemandMaterialSupplyBuilder toMaterial(
            final ProjectDemandMaterial value )
        {
            toMaterial = value;
            return this;
        }

        /**
         * Navigation property <b>to_Material</b> for <b>ProjectDemandMaterialSupply</b> to single
         * <b>ProjectDemandMaterial</b>.
         *
         * @param value
         *            The ProjectDemandMaterial to build this ProjectDemandMaterialSupply with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandMaterialSupply.ProjectDemandMaterialSupplyBuilder material(
            final ProjectDemandMaterial value )
        {
            return toMaterial(value);
        }

        private ProjectDemandMaterialSupply.ProjectDemandMaterialSupplyBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjectDemandMaterialSupply</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandMaterialSupply with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandMaterialSupply.ProjectDemandMaterialSupplyBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

    }

}
