/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandResourceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandResourceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Demand
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemandResource_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandResource extends VdmEntity<ProjectDemandResource>
{

    /**
     * Selector for all available fields of ProjectDemandResource.
     *
     */
    public final static ProjectDemandResourceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Demand
     */
    @Key
    @SerializedName( "ProjectDemandWorkUUID" )
    @JsonProperty( "ProjectDemandWorkUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandWorkUUID" )
    private UUID projectDemandWorkUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandWorkUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<UUID> PROJECT_DEMAND_WORK_UUID =
        new ProjectDemandResourceField<UUID>("ProjectDemandWorkUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandResourceField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> COST_CENTER =
        new ProjectDemandResourceField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "ActivityType" )
    @JsonProperty( "ActivityType" )
    @Nullable
    @ODataField( odataName = "ActivityType" )
    private String activityType;
    /**
     * Use with available fluent helpers to apply the <b>ActivityType</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> ACTIVITY_TYPE =
        new ProjectDemandResourceField<String>("ActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndAssgmtStatus</b>
     * </p>
     *
     * @return Assignment Status of a Resource Demand
     */
    @SerializedName( "ProjDmndAssgmtStatus" )
    @JsonProperty( "ProjDmndAssgmtStatus" )
    @Nullable
    @ODataField( odataName = "ProjDmndAssgmtStatus" )
    private String projDmndAssgmtStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndAssgmtStatus</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> PROJ_DMND_ASSGMT_STATUS =
        new ProjectDemandResourceField<String>("ProjDmndAssgmtStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementWorkItem</b>
     * </p>
     *
     * @return ID of the Work Item to Which a Resource Demand is Related
     */
    @SerializedName( "ProjectElementWorkItem" )
    @JsonProperty( "ProjectElementWorkItem" )
    @Nullable
    @ODataField( odataName = "ProjectElementWorkItem" )
    private String projectElementWorkItem;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementWorkItem</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> PROJECT_ELEMENT_WORK_ITEM =
        new ProjectDemandResourceField<String>("ProjectElementWorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndBillingControlCategory</b>
     * </p>
     *
     * @return Billing Control Category
     */
    @SerializedName( "ProjDmndBillingControlCategory" )
    @JsonProperty( "ProjDmndBillingControlCategory" )
    @Nullable
    @ODataField( odataName = "ProjDmndBillingControlCategory" )
    private String projDmndBillingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndBillingControlCategory</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> PROJ_DMND_BILLING_CONTROL_CATEGORY =
        new ProjectDemandResourceField<String>("ProjDmndBillingControlCategory");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedDeliveryOrg</b>
     * </p>
     *
     * @return Delivery Organization from Which a Resource is Required
     */
    @SerializedName( "ProjDmndRequestedDeliveryOrg" )
    @JsonProperty( "ProjDmndRequestedDeliveryOrg" )
    @Nullable
    @ODataField( odataName = "ProjDmndRequestedDeliveryOrg" )
    private String projDmndRequestedDeliveryOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRequestedDeliveryOrg</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceField<String> PROJ_DMND_REQUESTED_DELIVERY_ORG =
        new ProjectDemandResourceField<String>("ProjDmndRequestedDeliveryOrg");
    /**
     * Navigation property <b>to_Root</b> for <b>ProjectDemandResource</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Navigation property <b>to_ResourceAssignment</b> for <b>ProjectDemandResource</b> to multiple
     * <b>ProjDmndResourceAssignment</b>.
     *
     */
    @SerializedName( "to_ResourceAssignment" )
    @JsonProperty( "to_ResourceAssignment" )
    @ODataField( odataName = "to_ResourceAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjDmndResourceAssignment> toResourceAssignment;
    /**
     * Navigation property <b>to_ResourceRequest</b> for <b>ProjectDemandResource</b> to multiple
     * <b>ProjectDemandResourceRequest</b>.
     *
     */
    @SerializedName( "to_ResourceRequest" )
    @JsonProperty( "to_ResourceRequest" )
    @ODataField( odataName = "to_ResourceRequest" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectDemandResourceRequest> toResourceRequest;
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandResourceOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjectDemandResourceOneToOneLink<ProjectDemand>("to_Root");
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static ProjectDemandResourceLink<ProjDmndResourceAssignment> TO_RESOURCE_ASSIGNMENT =
        new ProjectDemandResourceLink<ProjDmndResourceAssignment>("to_ResourceAssignment");
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceRequest</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandResourceLink<ProjectDemandResourceRequest> TO_RESOURCE_REQUEST =
        new ProjectDemandResourceLink<ProjectDemandResourceRequest>("to_ResourceRequest");

    @Nonnull
    @Override
    public Class<ProjectDemandResource> getType()
    {
        return ProjectDemandResource.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @param projectDemandWorkUUID
     *            Global Identification of a Resource Demand
     */
    public void setProjectDemandWorkUUID( @Nullable final UUID projectDemandWorkUUID )
    {
        rememberChangedField("ProjectDemandWorkUUID", this.projectDemandWorkUUID);
        this.projectDemandWorkUUID = projectDemandWorkUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *            Activity Type
     */
    public void setActivityType( @Nullable final String activityType )
    {
        rememberChangedField("ActivityType", this.activityType);
        this.activityType = activityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndAssgmtStatus</b>
     * </p>
     *
     * @param projDmndAssgmtStatus
     *            Assignment Status of a Resource Demand
     */
    public void setProjDmndAssgmtStatus( @Nullable final String projDmndAssgmtStatus )
    {
        rememberChangedField("ProjDmndAssgmtStatus", this.projDmndAssgmtStatus);
        this.projDmndAssgmtStatus = projDmndAssgmtStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementWorkItem</b>
     * </p>
     *
     * @param projectElementWorkItem
     *            ID of the Work Item to Which a Resource Demand is Related
     */
    public void setProjectElementWorkItem( @Nullable final String projectElementWorkItem )
    {
        rememberChangedField("ProjectElementWorkItem", this.projectElementWorkItem);
        this.projectElementWorkItem = projectElementWorkItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndBillingControlCategory</b>
     * </p>
     *
     * @param projDmndBillingControlCategory
     *            Billing Control Category
     */
    public void setProjDmndBillingControlCategory( @Nullable final String projDmndBillingControlCategory )
    {
        rememberChangedField("ProjDmndBillingControlCategory", this.projDmndBillingControlCategory);
        this.projDmndBillingControlCategory = projDmndBillingControlCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRequestedDeliveryOrg</b>
     * </p>
     *
     * @param projDmndRequestedDeliveryOrg
     *            Delivery Organization from Which a Resource is Required
     */
    public void setProjDmndRequestedDeliveryOrg( @Nullable final String projDmndRequestedDeliveryOrg )
    {
        rememberChangedField("ProjDmndRequestedDeliveryOrg", this.projDmndRequestedDeliveryOrg);
        this.projDmndRequestedDeliveryOrg = projDmndRequestedDeliveryOrg;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandResource";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectDemandWorkUUID", getProjectDemandWorkUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectDemandWorkUUID", getProjectDemandWorkUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("CostCenter", getCostCenter());
        values.put("ActivityType", getActivityType());
        values.put("ProjDmndAssgmtStatus", getProjDmndAssgmtStatus());
        values.put("ProjectElementWorkItem", getProjectElementWorkItem());
        values.put("ProjDmndBillingControlCategory", getProjDmndBillingControlCategory());
        values.put("ProjDmndRequestedDeliveryOrg", getProjDmndRequestedDeliveryOrg());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectDemandWorkUUID") ) {
                final Object value = values.remove("ProjectDemandWorkUUID");
                if( (value == null) || (!value.equals(getProjectDemandWorkUUID())) ) {
                    setProjectDemandWorkUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ActivityType") ) {
                final Object value = values.remove("ActivityType");
                if( (value == null) || (!value.equals(getActivityType())) ) {
                    setActivityType(((String) value));
                }
            }
            if( values.containsKey("ProjDmndAssgmtStatus") ) {
                final Object value = values.remove("ProjDmndAssgmtStatus");
                if( (value == null) || (!value.equals(getProjDmndAssgmtStatus())) ) {
                    setProjDmndAssgmtStatus(((String) value));
                }
            }
            if( values.containsKey("ProjectElementWorkItem") ) {
                final Object value = values.remove("ProjectElementWorkItem");
                if( (value == null) || (!value.equals(getProjectElementWorkItem())) ) {
                    setProjectElementWorkItem(((String) value));
                }
            }
            if( values.containsKey("ProjDmndBillingControlCategory") ) {
                final Object value = values.remove("ProjDmndBillingControlCategory");
                if( (value == null) || (!value.equals(getProjDmndBillingControlCategory())) ) {
                    setProjDmndBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRequestedDeliveryOrg") ) {
                final Object value = values.remove("ProjDmndRequestedDeliveryOrg");
                if( (value == null) || (!value.equals(getProjDmndRequestedDeliveryOrg())) ) {
                    setProjDmndRequestedDeliveryOrg(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ResourceAssignment") ) {
                final Object value = (values).remove("to_ResourceAssignment");
                if( value instanceof Iterable ) {
                    if( toResourceAssignment == null ) {
                        toResourceAssignment = Lists.newArrayList();
                    } else {
                        toResourceAssignment = Lists.newArrayList(toResourceAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjDmndResourceAssignment entity;
                        if( toResourceAssignment.size() > i ) {
                            entity = toResourceAssignment.get(i);
                        } else {
                            entity = new ProjDmndResourceAssignment();
                            toResourceAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ResourceRequest") ) {
                final Object value = (values).remove("to_ResourceRequest");
                if( value instanceof Iterable ) {
                    if( toResourceRequest == null ) {
                        toResourceRequest = Lists.newArrayList();
                    } else {
                        toResourceRequest = Lists.newArrayList(toResourceRequest);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectDemandResourceRequest entity;
                        if( toResourceRequest.size() > i ) {
                            entity = toResourceRequest.get(i);
                        } else {
                            entity = new ProjectDemandResourceRequest();
                            toResourceRequest.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjectDemandResourceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandResourceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandResourceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandResourceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        if( toResourceAssignment != null ) {
            (values).put("to_ResourceAssignment", toResourceAssignment);
        }
        if( toResourceRequest != null ) {
            (values).put("to_ResourceRequest", toResourceRequest);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjectDemandResource</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResource</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Fetches the <b>ProjDmndResourceAssignment</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ResourceAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjDmndResourceAssignment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndResourceAssignment> fetchResourceAssignment()
    {
        return fetchFieldAsList("to_ResourceAssignment", ProjDmndResourceAssignment.class);
    }

    /**
     * Retrieval of associated <b>ProjDmndResourceAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceAssignment</b>.
     * <p>
     * If the navigation property <b>to_ResourceAssignment</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjDmndResourceAssignment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndResourceAssignment> getResourceAssignmentOrFetch()
    {
        if( toResourceAssignment == null ) {
            toResourceAssignment = fetchResourceAssignment();
        }
        return toResourceAssignment;
    }

    /**
     * Retrieval of associated <b>ProjDmndResourceAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResource</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceAssignment</b> is already loaded, the result
     *         will contain the <b>ProjDmndResourceAssignment</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjDmndResourceAssignment>> getResourceAssignmentIfPresent()
    {
        return Option.of(toResourceAssignment);
    }

    /**
     * Overwrites the list of associated <b>ProjDmndResourceAssignment</b> entities for the loaded navigation property
     * <b>to_ResourceAssignment</b>.
     * <p>
     * If the navigation property <b>to_ResourceAssignment</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjDmndResourceAssignment</b> entities.
     */
    public void setResourceAssignment( @Nonnull final List<ProjDmndResourceAssignment> value )
    {
        if( toResourceAssignment == null ) {
            toResourceAssignment = Lists.newArrayList();
        }
        toResourceAssignment.clear();
        toResourceAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjDmndResourceAssignment</b> entities. This corresponds to the OData
     * navigation property <b>to_ResourceAssignment</b>.
     * <p>
     * If the navigation property <b>to_ResourceAssignment</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjDmndResourceAssignment</b> entities.
     */
    public void addResourceAssignment( ProjDmndResourceAssignment... entity )
    {
        if( toResourceAssignment == null ) {
            toResourceAssignment = Lists.newArrayList();
        }
        toResourceAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProjectDemandResourceRequest</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ResourceRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjectDemandResourceRequest</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectDemandResourceRequest> fetchResourceRequest()
    {
        return fetchFieldAsList("to_ResourceRequest", ProjectDemandResourceRequest.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandResourceRequest</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceRequest</b>.
     * <p>
     * If the navigation property <b>to_ResourceRequest</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandResourceRequest</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectDemandResourceRequest> getResourceRequestOrFetch()
    {
        if( toResourceRequest == null ) {
            toResourceRequest = fetchResourceRequest();
        }
        return toResourceRequest;
    }

    /**
     * Retrieval of associated <b>ProjectDemandResourceRequest</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceRequest</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResource</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceRequest</b> is already loaded, the result will
     *         contain the <b>ProjectDemandResourceRequest</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectDemandResourceRequest>> getResourceRequestIfPresent()
    {
        return Option.of(toResourceRequest);
    }

    /**
     * Overwrites the list of associated <b>ProjectDemandResourceRequest</b> entities for the loaded navigation property
     * <b>to_ResourceRequest</b>.
     * <p>
     * If the navigation property <b>to_ResourceRequest</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjectDemandResourceRequest</b> entities.
     */
    public void setResourceRequest( @Nonnull final List<ProjectDemandResourceRequest> value )
    {
        if( toResourceRequest == null ) {
            toResourceRequest = Lists.newArrayList();
        }
        toResourceRequest.clear();
        toResourceRequest.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectDemandResourceRequest</b> entities. This corresponds to the
     * OData navigation property <b>to_ResourceRequest</b>.
     * <p>
     * If the navigation property <b>to_ResourceRequest</b> of a queried <b>ProjectDemandResource</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjectDemandResourceRequest</b> entities.
     */
    public void addResourceRequest( ProjectDemandResourceRequest... entity )
    {
        if( toResourceRequest == null ) {
            toResourceRequest = Lists.newArrayList();
        }
        toResourceRequest.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandResource instances.
     *
     */
    public final static class ProjectDemandResourceBuilder
    {

        private ProjectDemand toRoot;
        private List<ProjDmndResourceAssignment> toResourceAssignment = Lists.newArrayList();
        private List<ProjectDemandResourceRequest> toResourceRequest = Lists.newArrayList();

        private ProjectDemandResource.ProjectDemandResourceBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjectDemandResource</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandResource with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResource.ProjectDemandResourceBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

        private ProjectDemandResource.ProjectDemandResourceBuilder toResourceAssignment(
            final List<ProjDmndResourceAssignment> value )
        {
            toResourceAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceAssignment</b> for <b>ProjectDemandResource</b> to multiple
         * <b>ProjDmndResourceAssignment</b>.
         *
         * @param value
         *            The ProjDmndResourceAssignments to build this ProjectDemandResource with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResource.ProjectDemandResourceBuilder resourceAssignment(
            ProjDmndResourceAssignment... value )
        {
            return toResourceAssignment(Lists.newArrayList(value));
        }

        private ProjectDemandResource.ProjectDemandResourceBuilder toResourceRequest(
            final List<ProjectDemandResourceRequest> value )
        {
            toResourceRequest.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceRequest</b> for <b>ProjectDemandResource</b> to multiple
         * <b>ProjectDemandResourceRequest</b>.
         *
         * @param value
         *            The ProjectDemandResourceRequests to build this ProjectDemandResource with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResource.ProjectDemandResourceBuilder resourceRequest(
            ProjectDemandResourceRequest... value )
        {
            return toResourceRequest(Lists.newArrayList(value));
        }

    }

}
