/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandResourceRequestField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceRequestLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceRequestOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandResourceRequestSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Request
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemandResourceRequest_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandResourceRequest extends VdmEntity<ProjectDemandResourceRequest>
{

    /**
     * Selector for all available fields of ProjectDemandResourceRequest.
     *
     */
    public final static ProjectDemandResourceRequestSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndResourceRequestUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Request
     */
    @Key
    @SerializedName( "ProjDmndResourceRequestUUID" )
    @JsonProperty( "ProjDmndResourceRequestUUID" )
    @Nullable
    @ODataField( odataName = "ProjDmndResourceRequestUUID" )
    private UUID projDmndResourceRequestUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndResourceRequestUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<UUID> PROJ_DMND_RESOURCE_REQUEST_UUID =
        new ProjectDemandResourceRequestField<UUID>("ProjDmndResourceRequestUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @return Global Identification of a Resource Demand
     */
    @SerializedName( "ProjectDemandWorkUUID" )
    @JsonProperty( "ProjectDemandWorkUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandWorkUUID" )
    private UUID projectDemandWorkUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandWorkUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<UUID> PROJECT_DEMAND_WORK_UUID =
        new ProjectDemandResourceRequestField<UUID>("ProjectDemandWorkUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandResourceRequestField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestedResource</b>
     * </p>
     *
     * @return Personnel Number of a Resource
     */
    @SerializedName( "ProjectDemandRequestedResource" )
    @JsonProperty( "ProjectDemandRequestedResource" )
    @Nullable
    @ODataField( odataName = "ProjectDemandRequestedResource" )
    private String projectDemandRequestedResource;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandRequestedResource</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> PROJECT_DEMAND_REQUESTED_RESOURCE =
        new ProjectDemandResourceRequestField<String>("ProjectDemandRequestedResource");
    /**
     * Constraints: Not nullable, Maximum length: 1000
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndStfngInstructionText</b>
     * </p>
     *
     * @return Staffing Instruction for a Resource Demand
     */
    @SerializedName( "ProjDmndStfngInstructionText" )
    @JsonProperty( "ProjDmndStfngInstructionText" )
    @Nullable
    @ODataField( odataName = "ProjDmndStfngInstructionText" )
    private String projDmndStfngInstructionText;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndStfngInstructionText</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> PROJ_DMND_STFNG_INSTRUCTION_TEXT =
        new ProjectDemandResourceRequestField<String>("ProjDmndStfngInstructionText");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqWorkAssgmtOID</b>
     * </p>
     *
     * @return Work Assignment ID (SAP One Domain Model)
     */
    @SerializedName( "ProjDmndRsceReqWorkAssgmtOID" )
    @JsonProperty( "ProjDmndRsceReqWorkAssgmtOID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqWorkAssgmtOID" )
    private String projDmndRsceReqWorkAssgmtOID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqWorkAssgmtOID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> PROJ_DMND_RSCE_REQ_WORK_ASSGMT_OID =
        new ProjectDemandResourceRequestField<String>("ProjDmndRsceReqWorkAssgmtOID");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqWrkfrcPersonOID</b>
     * </p>
     *
     * @return Workforce Person ID (SAP One Domain Model)
     */
    @SerializedName( "ProjDmndRsceReqWrkfrcPersonOID" )
    @JsonProperty( "ProjDmndRsceReqWrkfrcPersonOID" )
    @Nullable
    @ODataField( odataName = "ProjDmndRsceReqWrkfrcPersonOID" )
    private String projDmndRsceReqWrkfrcPersonOID;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqWrkfrcPersonOID</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> PROJ_DMND_RSCE_REQ_WRKFRC_PERSON_OID =
        new ProjectDemandResourceRequestField<String>("ProjDmndRsceReqWrkfrcPersonOID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqStartDate</b>
     * </p>
     *
     * @return Start Date of the Demand
     */
    @SerializedName( "ProjDmndRsceReqStartDate" )
    @JsonProperty( "ProjDmndRsceReqStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceReqStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceReqStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqStartDate</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<LocalDateTime> PROJ_DMND_RSCE_REQ_START_DATE =
        new ProjectDemandResourceRequestField<LocalDateTime>("ProjDmndRsceReqStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqEndDate</b>
     * </p>
     *
     * @return End Date of the Demand
     */
    @SerializedName( "ProjDmndRsceReqEndDate" )
    @JsonProperty( "ProjDmndRsceReqEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjDmndRsceReqEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projDmndRsceReqEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjDmndRsceReqEndDate</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<LocalDateTime> PROJ_DMND_RSCE_REQ_END_DATE =
        new ProjectDemandResourceRequestField<LocalDateTime>("ProjDmndRsceReqEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> CREATED_BY_USER =
        new ProjectDemandResourceRequestField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<ZonedDateTime> CREATION_DATE_TIME =
        new ProjectDemandResourceRequestField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<String> LAST_CHANGED_BY_USER =
        new ProjectDemandResourceRequestField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProjectDemandResourceRequestField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProjectDemandResourceRequestField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_Work</b> for <b>ProjectDemandResourceRequest</b> to single
     * <b>ProjectDemandResource</b>.
     *
     */
    @SerializedName( "to_Work" )
    @JsonProperty( "to_Work" )
    @ODataField( odataName = "to_Work" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandResource toWork;
    /**
     * Navigation property <b>to_ProjDmndRsceReqDistr</b> for <b>ProjectDemandResourceRequest</b> to multiple
     * <b>ProjDmndRsceReqDistribution</b>.
     *
     */
    @SerializedName( "to_ProjDmndRsceReqDistr" )
    @JsonProperty( "to_ProjDmndRsceReqDistr" )
    @ODataField( odataName = "to_ProjDmndRsceReqDistr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjDmndRsceReqDistribution> toProjDmndRsceReqDistr;
    /**
     * Navigation property <b>to_Root</b> for <b>ProjectDemandResourceRequest</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Use with available fluent helpers to apply the <b>to_Work</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandResourceRequestOneToOneLink<ProjectDemandResource> TO_WORK =
        new ProjectDemandResourceRequestOneToOneLink<ProjectDemandResource>("to_Work");
    /**
     * Use with available fluent helpers to apply the <b>to_ProjDmndRsceReqDistr</b> navigation property to query
     * operations.
     *
     */
    public final static ProjectDemandResourceRequestLink<ProjDmndRsceReqDistribution> TO_PROJ_DMND_RSCE_REQ_DISTR =
        new ProjectDemandResourceRequestLink<ProjDmndRsceReqDistribution>("to_ProjDmndRsceReqDistr");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandResourceRequestOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjectDemandResourceRequestOneToOneLink<ProjectDemand>("to_Root");

    @Nonnull
    @Override
    public Class<ProjectDemandResourceRequest> getType()
    {
        return ProjectDemandResourceRequest.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndResourceRequestUUID</b>
     * </p>
     *
     * @param projDmndResourceRequestUUID
     *            Global Identification of a Resource Request
     */
    public void setProjDmndResourceRequestUUID( @Nullable final UUID projDmndResourceRequestUUID )
    {
        rememberChangedField("ProjDmndResourceRequestUUID", this.projDmndResourceRequestUUID);
        this.projDmndResourceRequestUUID = projDmndResourceRequestUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandWorkUUID</b>
     * </p>
     *
     * @param projectDemandWorkUUID
     *            Global Identification of a Resource Demand
     */
    public void setProjectDemandWorkUUID( @Nullable final UUID projectDemandWorkUUID )
    {
        rememberChangedField("ProjectDemandWorkUUID", this.projectDemandWorkUUID);
        this.projectDemandWorkUUID = projectDemandWorkUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandRequestedResource</b>
     * </p>
     *
     * @param projectDemandRequestedResource
     *            Personnel Number of a Resource
     */
    public void setProjectDemandRequestedResource( @Nullable final String projectDemandRequestedResource )
    {
        rememberChangedField("ProjectDemandRequestedResource", this.projectDemandRequestedResource);
        this.projectDemandRequestedResource = projectDemandRequestedResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1000
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndStfngInstructionText</b>
     * </p>
     *
     * @param projDmndStfngInstructionText
     *            Staffing Instruction for a Resource Demand
     */
    public void setProjDmndStfngInstructionText( @Nullable final String projDmndStfngInstructionText )
    {
        rememberChangedField("ProjDmndStfngInstructionText", this.projDmndStfngInstructionText);
        this.projDmndStfngInstructionText = projDmndStfngInstructionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqWorkAssgmtOID</b>
     * </p>
     *
     * @param projDmndRsceReqWorkAssgmtOID
     *            Work Assignment ID (SAP One Domain Model)
     */
    public void setProjDmndRsceReqWorkAssgmtOID( @Nullable final String projDmndRsceReqWorkAssgmtOID )
    {
        rememberChangedField("ProjDmndRsceReqWorkAssgmtOID", this.projDmndRsceReqWorkAssgmtOID);
        this.projDmndRsceReqWorkAssgmtOID = projDmndRsceReqWorkAssgmtOID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqWrkfrcPersonOID</b>
     * </p>
     *
     * @param projDmndRsceReqWrkfrcPersonOID
     *            Workforce Person ID (SAP One Domain Model)
     */
    public void setProjDmndRsceReqWrkfrcPersonOID( @Nullable final String projDmndRsceReqWrkfrcPersonOID )
    {
        rememberChangedField("ProjDmndRsceReqWrkfrcPersonOID", this.projDmndRsceReqWrkfrcPersonOID);
        this.projDmndRsceReqWrkfrcPersonOID = projDmndRsceReqWrkfrcPersonOID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqStartDate</b>
     * </p>
     *
     * @param projDmndRsceReqStartDate
     *            Start Date of the Demand
     */
    public void setProjDmndRsceReqStartDate( @Nullable final LocalDateTime projDmndRsceReqStartDate )
    {
        rememberChangedField("ProjDmndRsceReqStartDate", this.projDmndRsceReqStartDate);
        this.projDmndRsceReqStartDate = projDmndRsceReqStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjDmndRsceReqEndDate</b>
     * </p>
     *
     * @param projDmndRsceReqEndDate
     *            End Date of the Demand
     */
    public void setProjDmndRsceReqEndDate( @Nullable final LocalDateTime projDmndRsceReqEndDate )
    {
        rememberChangedField("ProjDmndRsceReqEndDate", this.projDmndRsceReqEndDate);
        this.projDmndRsceReqEndDate = projDmndRsceReqEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandResourceRequest";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjDmndResourceRequestUUID", getProjDmndResourceRequestUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjDmndResourceRequestUUID", getProjDmndResourceRequestUUID());
        values.put("ProjectDemandWorkUUID", getProjectDemandWorkUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("ProjectDemandRequestedResource", getProjectDemandRequestedResource());
        values.put("ProjDmndStfngInstructionText", getProjDmndStfngInstructionText());
        values.put("ProjDmndRsceReqWorkAssgmtOID", getProjDmndRsceReqWorkAssgmtOID());
        values.put("ProjDmndRsceReqWrkfrcPersonOID", getProjDmndRsceReqWrkfrcPersonOID());
        values.put("ProjDmndRsceReqStartDate", getProjDmndRsceReqStartDate());
        values.put("ProjDmndRsceReqEndDate", getProjDmndRsceReqEndDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjDmndResourceRequestUUID") ) {
                final Object value = values.remove("ProjDmndResourceRequestUUID");
                if( (value == null) || (!value.equals(getProjDmndResourceRequestUUID())) ) {
                    setProjDmndResourceRequestUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandWorkUUID") ) {
                final Object value = values.remove("ProjectDemandWorkUUID");
                if( (value == null) || (!value.equals(getProjectDemandWorkUUID())) ) {
                    setProjectDemandWorkUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandRequestedResource") ) {
                final Object value = values.remove("ProjectDemandRequestedResource");
                if( (value == null) || (!value.equals(getProjectDemandRequestedResource())) ) {
                    setProjectDemandRequestedResource(((String) value));
                }
            }
            if( values.containsKey("ProjDmndStfngInstructionText") ) {
                final Object value = values.remove("ProjDmndStfngInstructionText");
                if( (value == null) || (!value.equals(getProjDmndStfngInstructionText())) ) {
                    setProjDmndStfngInstructionText(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqWorkAssgmtOID") ) {
                final Object value = values.remove("ProjDmndRsceReqWorkAssgmtOID");
                if( (value == null) || (!value.equals(getProjDmndRsceReqWorkAssgmtOID())) ) {
                    setProjDmndRsceReqWorkAssgmtOID(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqWrkfrcPersonOID") ) {
                final Object value = values.remove("ProjDmndRsceReqWrkfrcPersonOID");
                if( (value == null) || (!value.equals(getProjDmndRsceReqWrkfrcPersonOID())) ) {
                    setProjDmndRsceReqWrkfrcPersonOID(((String) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqStartDate") ) {
                final Object value = values.remove("ProjDmndRsceReqStartDate");
                if( (value == null) || (!value.equals(getProjDmndRsceReqStartDate())) ) {
                    setProjDmndRsceReqStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjDmndRsceReqEndDate") ) {
                final Object value = values.remove("ProjDmndRsceReqEndDate");
                if( (value == null) || (!value.equals(getProjDmndRsceReqEndDate())) ) {
                    setProjDmndRsceReqEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Work") ) {
                final Object value = (values).remove("to_Work");
                if( value instanceof Map ) {
                    if( toWork == null ) {
                        toWork = new ProjectDemandResource();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWork.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProjDmndRsceReqDistr") ) {
                final Object value = (values).remove("to_ProjDmndRsceReqDistr");
                if( value instanceof Iterable ) {
                    if( toProjDmndRsceReqDistr == null ) {
                        toProjDmndRsceReqDistr = Lists.newArrayList();
                    } else {
                        toProjDmndRsceReqDistr = Lists.newArrayList(toProjDmndRsceReqDistr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjDmndRsceReqDistribution entity;
                        if( toProjDmndRsceReqDistr.size() > i ) {
                            entity = toProjDmndRsceReqDistr.get(i);
                        } else {
                            entity = new ProjDmndRsceReqDistribution();
                            toProjDmndRsceReqDistr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectDemandResourceRequestField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandResourceRequestField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandResourceRequestField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandResourceRequestField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWork != null ) {
            (values).put("to_Work", toWork);
        }
        if( toProjDmndRsceReqDistr != null ) {
            (values).put("to_ProjDmndRsceReqDistr", toProjDmndRsceReqDistr);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemandResource</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Work</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandResource</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource fetchWork()
    {
        return fetchFieldAsSingle("to_Work", ProjectDemandResource.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property <b>to_Work</b> of a queried <b>ProjectDemandResourceRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandResource</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandResource getWorkOrFetch()
    {
        if( toWork == null ) {
            toWork = fetchWork();
        }
        return toWork;
    }

    /**
     * Retrieval of associated <b>ProjectDemandResource</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Work</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResourceRequest</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Work</b> is already loaded, the result will contain the
     *         <b>ProjectDemandResource</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<ProjectDemandResource> getWorkIfPresent()
    {
        return Option.of(toWork);
    }

    /**
     * Overwrites the associated <b>ProjectDemandResource</b> entity for the loaded navigation property <b>to_Work</b>.
     *
     * @param value
     *            New <b>ProjectDemandResource</b> entity.
     */
    public void setWork( final ProjectDemandResource value )
    {
        toWork = value;
    }

    /**
     * Fetches the <b>ProjDmndRsceReqDistribution</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ProjDmndRsceReqDistr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjDmndRsceReqDistribution</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndRsceReqDistribution> fetchProjDmndRsceReqDistr()
    {
        return fetchFieldAsList("to_ProjDmndRsceReqDistr", ProjDmndRsceReqDistribution.class);
    }

    /**
     * Retrieval of associated <b>ProjDmndRsceReqDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProjDmndRsceReqDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndRsceReqDistr</b> of a queried <b>ProjectDemandResourceRequest</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjDmndRsceReqDistribution</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjDmndRsceReqDistribution> getProjDmndRsceReqDistrOrFetch()
    {
        if( toProjDmndRsceReqDistr == null ) {
            toProjDmndRsceReqDistr = fetchProjDmndRsceReqDistr();
        }
        return toProjDmndRsceReqDistr;
    }

    /**
     * Retrieval of associated <b>ProjDmndRsceReqDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProjDmndRsceReqDistr</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResourceRequest</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProjDmndRsceReqDistr</b> is already loaded, the result
     *         will contain the <b>ProjDmndRsceReqDistribution</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjDmndRsceReqDistribution>> getProjDmndRsceReqDistrIfPresent()
    {
        return Option.of(toProjDmndRsceReqDistr);
    }

    /**
     * Overwrites the list of associated <b>ProjDmndRsceReqDistribution</b> entities for the loaded navigation property
     * <b>to_ProjDmndRsceReqDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndRsceReqDistr</b> of a queried <b>ProjectDemandResourceRequest</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjDmndRsceReqDistribution</b> entities.
     */
    public void setProjDmndRsceReqDistr( @Nonnull final List<ProjDmndRsceReqDistribution> value )
    {
        if( toProjDmndRsceReqDistr == null ) {
            toProjDmndRsceReqDistr = Lists.newArrayList();
        }
        toProjDmndRsceReqDistr.clear();
        toProjDmndRsceReqDistr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjDmndRsceReqDistribution</b> entities. This corresponds to the
     * OData navigation property <b>to_ProjDmndRsceReqDistr</b>.
     * <p>
     * If the navigation property <b>to_ProjDmndRsceReqDistr</b> of a queried <b>ProjectDemandResourceRequest</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjDmndRsceReqDistribution</b> entities.
     */
    public void addProjDmndRsceReqDistr( ProjDmndRsceReqDistribution... entity )
    {
        if( toProjDmndRsceReqDistr == null ) {
            toProjDmndRsceReqDistr = Lists.newArrayList();
        }
        toProjDmndRsceReqDistr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjectDemandResourceRequest</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandResourceRequest</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandResourceRequest instances.
     *
     */
    public final static class ProjectDemandResourceRequestBuilder
    {

        private ProjectDemandResource toWork;
        private List<ProjDmndRsceReqDistribution> toProjDmndRsceReqDistr = Lists.newArrayList();
        private ProjectDemand toRoot;

        private ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder toWork(
            final ProjectDemandResource value )
        {
            toWork = value;
            return this;
        }

        /**
         * Navigation property <b>to_Work</b> for <b>ProjectDemandResourceRequest</b> to single
         * <b>ProjectDemandResource</b>.
         *
         * @param value
         *            The ProjectDemandResource to build this ProjectDemandResourceRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder work(
            final ProjectDemandResource value )
        {
            return toWork(value);
        }

        private ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder toProjDmndRsceReqDistr(
            final List<ProjDmndRsceReqDistribution> value )
        {
            toProjDmndRsceReqDistr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProjDmndRsceReqDistr</b> for <b>ProjectDemandResourceRequest</b> to multiple
         * <b>ProjDmndRsceReqDistribution</b>.
         *
         * @param value
         *            The ProjDmndRsceReqDistributions to build this ProjectDemandResourceRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder projDmndRsceReqDistr(
            ProjDmndRsceReqDistribution... value )
        {
            return toProjDmndRsceReqDistr(Lists.newArrayList(value));
        }

        private ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjectDemandResourceRequest</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandResourceRequest with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandResourceRequest.ProjectDemandResourceRequestBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

    }

}
