/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandServiceSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService ProjectDemandService}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ProjectDemandServiceByKeyFluentHelper
    extends
    FluentHelperByKey<ProjectDemandServiceByKeyFluentHelper, ProjectDemandService, ProjectDemandServiceSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     * ProjectDemandService} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProjectDemandService}
     * @param projectDemandServiceUUID
     *            Global Identification for Service Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProjectDemandService}
     */
    public ProjectDemandServiceByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID projectDemandServiceUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectDemandServiceUUID", projectDemandServiceUUID);
    }

    @Override
    @Nonnull
    protected Class<ProjectDemandService> getEntityClass()
    {
        return ProjectDemandService.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
