/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandServiceSupplyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandServiceSupplyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandServiceSupplySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Supply Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProjectDemandServiceSupply_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectDemandServiceSupply extends VdmEntity<ProjectDemandServiceSupply>
{

    /**
     * Selector for all available fields of ProjectDemandServiceSupply.
     *
     */
    public final static ProjectDemandServiceSupplySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandServiceSupplyUUID</b>
     * </p>
     *
     * @return Global Identification for Service Supply
     */
    @Key
    @SerializedName( "ProjectDemandServiceSupplyUUID" )
    @JsonProperty( "ProjectDemandServiceSupplyUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandServiceSupplyUUID" )
    private UUID projectDemandServiceSupplyUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandServiceSupplyUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyField<UUID> PROJECT_DEMAND_SERVICE_SUPPLY_UUID =
        new ProjectDemandServiceSupplyField<UUID>("ProjectDemandServiceSupplyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandServiceUUID</b>
     * </p>
     *
     * @return Global Identification for Service Demand
     */
    @SerializedName( "ProjectDemandServiceUUID" )
    @JsonProperty( "ProjectDemandServiceUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandServiceUUID" )
    private UUID projectDemandServiceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandServiceUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyField<UUID> PROJECT_DEMAND_SERVICE_UUID =
        new ProjectDemandServiceSupplyField<UUID>("ProjectDemandServiceUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @return Global Identification of a Project Demand
     */
    @SerializedName( "ProjectDemandUUID" )
    @JsonProperty( "ProjectDemandUUID" )
    @Nullable
    @ODataField( odataName = "ProjectDemandUUID" )
    private UUID projectDemandUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDemandUUID</b> field to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyField<UUID> PROJECT_DEMAND_UUID =
        new ProjectDemandServiceSupplyField<UUID>("ProjectDemandUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyField<String> PURCHASE_REQUISITION =
        new ProjectDemandServiceSupplyField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Purchase Requisition Item Number
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyField<String> PURCHASE_REQUISITION_ITEM =
        new ProjectDemandServiceSupplyField<String>("PurchaseRequisitionItem");
    /**
     * Navigation property <b>to_Service</b> for <b>ProjectDemandServiceSupply</b> to single
     * <b>ProjectDemandService</b>.
     *
     */
    @SerializedName( "to_Service" )
    @JsonProperty( "to_Service" )
    @ODataField( odataName = "to_Service" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemandService toService;
    /**
     * Navigation property <b>to_Root</b> for <b>ProjectDemandServiceSupply</b> to single <b>ProjectDemand</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectDemand toRoot;
    /**
     * Use with available fluent helpers to apply the <b>to_Service</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyOneToOneLink<ProjectDemandService> TO_SERVICE =
        new ProjectDemandServiceSupplyOneToOneLink<ProjectDemandService>("to_Service");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static ProjectDemandServiceSupplyOneToOneLink<ProjectDemand> TO_ROOT =
        new ProjectDemandServiceSupplyOneToOneLink<ProjectDemand>("to_Root");

    @Nonnull
    @Override
    public Class<ProjectDemandServiceSupply> getType()
    {
        return ProjectDemandServiceSupply.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandServiceSupplyUUID</b>
     * </p>
     *
     * @param projectDemandServiceSupplyUUID
     *            Global Identification for Service Supply
     */
    public void setProjectDemandServiceSupplyUUID( @Nullable final UUID projectDemandServiceSupplyUUID )
    {
        rememberChangedField("ProjectDemandServiceSupplyUUID", this.projectDemandServiceSupplyUUID);
        this.projectDemandServiceSupplyUUID = projectDemandServiceSupplyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandServiceUUID</b>
     * </p>
     *
     * @param projectDemandServiceUUID
     *            Global Identification for Service Demand
     */
    public void setProjectDemandServiceUUID( @Nullable final UUID projectDemandServiceUUID )
    {
        rememberChangedField("ProjectDemandServiceUUID", this.projectDemandServiceUUID);
        this.projectDemandServiceUUID = projectDemandServiceUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemandUUID</b>
     * </p>
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     */
    public void setProjectDemandUUID( @Nullable final UUID projectDemandUUID )
    {
        rememberChangedField("ProjectDemandUUID", this.projectDemandUUID);
        this.projectDemandUUID = projectDemandUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Purchase Requisition Item Number
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProjectDemandServiceSupply";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectDemandServiceSupplyUUID", getProjectDemandServiceSupplyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectDemandServiceSupplyUUID", getProjectDemandServiceSupplyUUID());
        values.put("ProjectDemandServiceUUID", getProjectDemandServiceUUID());
        values.put("ProjectDemandUUID", getProjectDemandUUID());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectDemandServiceSupplyUUID") ) {
                final Object value = values.remove("ProjectDemandServiceSupplyUUID");
                if( (value == null) || (!value.equals(getProjectDemandServiceSupplyUUID())) ) {
                    setProjectDemandServiceSupplyUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandServiceUUID") ) {
                final Object value = values.remove("ProjectDemandServiceUUID");
                if( (value == null) || (!value.equals(getProjectDemandServiceUUID())) ) {
                    setProjectDemandServiceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectDemandUUID") ) {
                final Object value = values.remove("ProjectDemandUUID");
                if( (value == null) || (!value.equals(getProjectDemandUUID())) ) {
                    setProjectDemandUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Service") ) {
                final Object value = (values).remove("to_Service");
                if( value instanceof Map ) {
                    if( toService == null ) {
                        toService = new ProjectDemandService();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toService.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new ProjectDemand();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectDemandServiceSupplyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProjectDemandServiceSupplyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectDemandServiceSupplyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectDemandServiceSupplyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toService != null ) {
            (values).put("to_Service", toService);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectDemandService</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Service</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemandService</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandService fetchService()
    {
        return fetchFieldAsSingle("to_Service", ProjectDemandService.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemandService</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Service</b>.
     * <p>
     * If the navigation property <b>to_Service</b> of a queried <b>ProjectDemandServiceSupply</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemandService</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemandService getServiceOrFetch()
    {
        if( toService == null ) {
            toService = fetchService();
        }
        return toService;
    }

    /**
     * Retrieval of associated <b>ProjectDemandService</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Service</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandServiceSupply</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Service</b> is already loaded, the result will contain
     *         the <b>ProjectDemandService</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectDemandService> getServiceIfPresent()
    {
        return Option.of(toService);
    }

    /**
     * Overwrites the associated <b>ProjectDemandService</b> entity for the loaded navigation property
     * <b>to_Service</b>.
     *
     * @param value
     *            New <b>ProjectDemandService</b> entity.
     */
    public void setService( final ProjectDemandService value )
    {
        toService = value;
    }

    /**
     * Fetches the <b>ProjectDemand</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectDemand</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", ProjectDemand.class);
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>ProjectDemandServiceSupply</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectDemand</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectDemand getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>ProjectDemand</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectDemandServiceSupply</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>ProjectDemand</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProjectDemand> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>ProjectDemand</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>ProjectDemand</b> entity.
     */
    public void setRoot( final ProjectDemand value )
    {
        toRoot = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectDemandServiceSupply instances.
     *
     */
    public final static class ProjectDemandServiceSupplyBuilder
    {

        private ProjectDemandService toService;
        private ProjectDemand toRoot;

        private ProjectDemandServiceSupply.ProjectDemandServiceSupplyBuilder toService(
            final ProjectDemandService value )
        {
            toService = value;
            return this;
        }

        /**
         * Navigation property <b>to_Service</b> for <b>ProjectDemandServiceSupply</b> to single
         * <b>ProjectDemandService</b>.
         *
         * @param value
         *            The ProjectDemandService to build this ProjectDemandServiceSupply with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandServiceSupply.ProjectDemandServiceSupplyBuilder service( final ProjectDemandService value )
        {
            return toService(value);
        }

        private ProjectDemandServiceSupply.ProjectDemandServiceSupplyBuilder toRoot( final ProjectDemand value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>ProjectDemandServiceSupply</b> to single <b>ProjectDemand</b>.
         *
         * @param value
         *            The ProjectDemand to build this ProjectDemandServiceSupply with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectDemandServiceSupply.ProjectDemandServiceSupplyBuilder root( final ProjectDemand value )
        {
            return toRoot(value);
        }

    }

}
