/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable.ProjectDemandServiceSupplySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
 * ProjectDemandServiceSupply} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProjectDemandServiceSupplyByKeyFluentHelper
    extends
    FluentHelperByKey<ProjectDemandServiceSupplyByKeyFluentHelper, ProjectDemandServiceSupply, ProjectDemandServiceSupplySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     * ProjectDemandServiceSupply} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProjectDemandServiceSupply}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProjectDemandServiceSupply}
     * @param projectDemandServiceSupplyUUID
     *            Global Identification for Service Supply
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProjectDemandServiceSupplyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID projectDemandServiceSupplyUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectDemandServiceSupplyUUID", projectDemandServiceSupplyUUID);
    }

    @Override
    @Nonnull
    protected Class<ProjectDemandServiceSupply> getEntityClass()
    {
        return ProjectDemandServiceSupply.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
