/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProjectDemandServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService ProjectDemandService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProjectDemandServiceBatch
    extends
    BatchFluentHelperBasic<ProjectDemandServiceBatch, ProjectDemandServiceBatchChangeSet>
    implements
    ProjectDemandServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProjectDemandServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProjectDemandServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProjectDemandServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProjectDemandServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProjectDemandServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProjectDemandServiceBatchChangeSet(this, service);
    }

}
