/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply;

/**
 * Implementation of the {@link ProjectDemandServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService ProjectDemandService}.
 *
 */
public class DefaultProjectDemandServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProjectDemandServiceBatch, ProjectDemandServiceBatchChangeSet>
    implements
    ProjectDemandServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService service;

    @SuppressWarnings( "deprecation" )
    DefaultProjectDemandServiceBatchChangeSet(
        @Nonnull final DefaultProjectDemandServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProjectDemandServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjDmndExpenseDistr(
        @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr )
    {
        return addRequestUpdate(service::updateProjDmndExpenseDistr, projDmndExpenseDistr);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjDmndExpenseDistr(
        @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr )
    {
        return addRequestDelete(service::deleteProjDmndExpenseDistr, projDmndExpenseDistr);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet createProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return addRequestCreate(service::createProjDmndResourceAssignment, projDmndResourceAssignment);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return addRequestUpdate(service::updateProjDmndResourceAssignment, projDmndResourceAssignment);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return addRequestDelete(service::deleteProjDmndResourceAssignment, projDmndResourceAssignment);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjDmndRsceAssgmtDistr(
        @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr )
    {
        return addRequestUpdate(service::updateProjDmndRsceAssgmtDistr, projDmndRsceAssgmtDistr);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjDmndRsceAssgmtDistr(
        @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr )
    {
        return addRequestDelete(service::deleteProjDmndRsceAssgmtDistr, projDmndRsceAssgmtDistr);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjDmndRsceReqDistribution(
        @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution )
    {
        return addRequestUpdate(service::updateProjDmndRsceReqDistribution, projDmndRsceReqDistribution);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjDmndRsceReqDistribution(
        @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution )
    {
        return addRequestDelete(service::deleteProjDmndRsceReqDistribution, projDmndRsceReqDistribution);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet createProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return addRequestCreate(service::createProjectDemand, projectDemand);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return addRequestUpdate(service::updateProjectDemand, projectDemand);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return addRequestDelete(service::deleteProjectDemand, projectDemand);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet createProjectDemandExpense(
        @Nonnull final ProjectDemandExpense projectDemandExpense )
    {
        return addRequestCreate(service::createProjectDemandExpense, projectDemandExpense);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandExpense(
        @Nonnull final ProjectDemandExpense projectDemandExpense )
    {
        return addRequestUpdate(service::updateProjectDemandExpense, projectDemandExpense);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandMaterial(
        @Nonnull final ProjectDemandMaterial projectDemandMaterial )
    {
        return addRequestUpdate(service::updateProjectDemandMaterial, projectDemandMaterial);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandMaterialSupply(
        @Nonnull final ProjectDemandMaterialSupply projectDemandMaterialSupply )
    {
        return addRequestUpdate(service::updateProjectDemandMaterialSupply, projectDemandMaterialSupply);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet createProjectDemandResource(
        @Nonnull final ProjectDemandResource projectDemandResource )
    {
        return addRequestCreate(service::createProjectDemandResource, projectDemandResource);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandResource(
        @Nonnull final ProjectDemandResource projectDemandResource )
    {
        return addRequestUpdate(service::updateProjectDemandResource, projectDemandResource);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet createProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return addRequestCreate(service::createProjectDemandResourceRequest, projectDemandResourceRequest);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return addRequestUpdate(service::updateProjectDemandResourceRequest, projectDemandResourceRequest);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet deleteProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return addRequestDelete(service::deleteProjectDemandResourceRequest, projectDemandResourceRequest);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandService(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService projectDemandService )
    {
        return addRequestUpdate(service::updateProjectDemandService, projectDemandService);
    }

    @Nonnull
    @Override
    public ProjectDemandServiceBatchChangeSet updateProjectDemandServiceSupply(
        @Nonnull final ProjectDemandServiceSupply projectDemandServiceSupply )
    {
        return addRequestUpdate(service::updateProjectDemandServiceSupply, projectDemandServiceSupply);
    }

}
