/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService ProjectDemandService}.
 *
 */
public interface ProjectDemandServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProjectDemandServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProjectDemandServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entity and save it to the S/4HANA system.
     *
     * @param projDmndExpenseDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *            ProjDmndExpenseDistr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjDmndExpenseDistr( @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entity in the S/4HANA system.
     *
     * @param projDmndExpenseDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *            ProjDmndExpenseDistr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        deleteProjDmndExpenseDistr( @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity and save it to the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        createProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity and save it to the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity in the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        deleteProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entity and save it to the S/4HANA system.
     *
     * @param projDmndRsceAssgmtDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *            ProjDmndRsceAssgmtDistr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjDmndRsceAssgmtDistr( @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entity in the S/4HANA system.
     *
     * @param projDmndRsceAssgmtDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *            ProjDmndRsceAssgmtDistr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        deleteProjDmndRsceAssgmtDistr( @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entity and save it to the S/4HANA system.
     *
     * @param projDmndRsceReqDistribution
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *            ProjDmndRsceReqDistribution} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjDmndRsceReqDistribution( @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entity in the S/4HANA system.
     *
     * @param projDmndRsceReqDistribution
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *            ProjDmndRsceReqDistribution} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        deleteProjDmndRsceReqDistribution( @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity and save it to the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet createProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity and save it to the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet updateProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity in the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet deleteProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entity and save it to the S/4HANA system.
     *
     * @param projectDemandExpense
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *            ProjectDemandExpense} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        createProjectDemandExpense( @Nonnull final ProjectDemandExpense projectDemandExpense );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entity and save it to the S/4HANA system.
     *
     * @param projectDemandExpense
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *            ProjectDemandExpense} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandExpense( @Nonnull final ProjectDemandExpense projectDemandExpense );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     * ProjectDemandMaterial} entity and save it to the S/4HANA system.
     *
     * @param projectDemandMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     *            ProjectDemandMaterial} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandMaterial( @Nonnull final ProjectDemandMaterial projectDemandMaterial );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     * ProjectDemandMaterialSupply} entity and save it to the S/4HANA system.
     *
     * @param projectDemandMaterialSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     *            ProjectDemandMaterialSupply} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandMaterialSupply( @Nonnull final ProjectDemandMaterialSupply projectDemandMaterialSupply );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *            ProjectDemandResource} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        createProjectDemandResource( @Nonnull final ProjectDemandResource projectDemandResource );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *            ProjectDemandResource} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandResource( @Nonnull final ProjectDemandResource projectDemandResource );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        createProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity in the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        deleteProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     * ProjectDemandService} entity and save it to the S/4HANA system.
     *
     * @param projectDemandService
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     *            ProjectDemandService} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandService( @Nonnull final ProjectDemandService projectDemandService );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     * ProjectDemandServiceSupply} entity and save it to the S/4HANA system.
     *
     * @param projectDemandServiceSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     *            ProjectDemandServiceSupply} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceBatchChangeSet
        updateProjectDemandServiceSupply( @Nonnull final ProjectDemandServiceSupply projectDemandServiceSupply );

}
