/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr ProjDmndExpenseDistr}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndExpenseDistrField
 * ProjDmndExpenseDistrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndExpenseDistrLink
 * ProjDmndExpenseDistrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTRIBUTION_UUID
 * PROJ_DMND_EXPN_DISTRIBUTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJECT_DEMAND_EXPENSE_UUID
 * PROJECT_DEMAND_EXPENSE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_REFERENCED_PLAN_DATA_UUID
 * PROJ_DMND_REFERENCED_PLAN_DATA_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_PERIOD_VAL
 * PROJ_DMND_EXPN_DISTR_PERIOD_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_YEAR_VAL
 * PROJ_DMND_EXPN_DISTR_YEAR_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_AMOUNT
 * PROJ_DMND_EXPN_DISTR_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_REVENUE_AMT
 * PROJ_DMND_EXPN_DISTR_REVENUE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#REFERENCED_OBJECT_UUID
 * REFERENCED_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_AMOUNT_CRCY
 * PROJ_DMND_EXPN_DISTR_AMOUNT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#PROJ_DMND_EXPN_DISTR_REVN_AMT_CRCY
 * PROJ_DMND_EXPN_DISTR_REVN_AMT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#TO_ROOT
 * TO_ROOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr#TO_PROJECT_DEMAND_EXPENSE
 * TO_PROJECT_DEMAND_EXPENSE}</li>
 * </ul>
 *
 */
public interface ProjDmndExpenseDistrSelectable extends EntitySelectable<ProjDmndExpenseDistr>
{

}
