/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
 * ProjDmndResourceAssignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndResourceAssignmentField
 * ProjDmndResourceAssignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndResourceAssignmentLink
 * ProjDmndResourceAssignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT_UUID
 * PROJ_DMND_RSCE_ASSGMT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJECT_DEMAND_WORK_UUID
 * PROJECT_DEMAND_WORK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT
 * PROJ_DMND_RSCE_ASSGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT_QUANTITY
 * PROJ_DMND_RSCE_ASSGMT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT_QUANTITY_UNIT
 * PROJ_DMND_RSCE_ASSGMT_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJECT_DEMAND_SUPPLY_IDENTIFIER
 * PROJECT_DEMAND_SUPPLY_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJECT_DEMAND_SUPPLY_DELIVERY_ORG
 * PROJECT_DEMAND_SUPPLY_DELIVERY_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJECT_DEMAND_SOURCE_OF_SUPPLY
 * PROJECT_DEMAND_SOURCE_OF_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_ASSGMT_LAST_UPDATE_SOURCE
 * PROJ_ASSGMT_LAST_UPDATE_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_WORK_ASSGMT_OID
 * PROJ_DMND_RSCE_WORK_ASSGMT_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_WRKFRC_PERSON_OID
 * PROJ_DMND_RSCE_WRKFRC_PERSON_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT_START_DATE
 * PROJ_DMND_RSCE_ASSGMT_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#PROJ_DMND_RSCE_ASSGMT_END_DATE
 * PROJ_DMND_RSCE_ASSGMT_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#TO_ASSGMT_DISTRIBUTION
 * TO_ASSGMT_DISTRIBUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#TO_ROOT
 * TO_ROOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment#TO_WORK
 * TO_WORK}</li>
 * </ul>
 *
 */
public interface ProjDmndResourceAssignmentSelectable extends EntitySelectable<ProjDmndResourceAssignment>
{

}
