/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
 * ProjDmndRsceAssgmtDistr}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndRsceAssgmtDistrField
 * ProjDmndRsceAssgmtDistrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndRsceAssgmtDistrLink
 * ProjDmndRsceAssgmtDistrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_UUID
 * PROJ_DMND_RSCE_ASSGMT_DISTR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_UUID
 * PROJ_DMND_RSCE_ASSGMT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_YEAR_VAL
 * PROJ_DMND_RSCE_ASSGMT_DISTR_YEAR_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_PERD_VAL
 * PROJ_DMND_RSCE_ASSGMT_DISTR_PERD_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_QTY
 * PROJ_DMND_RSCE_ASSGMT_DISTR_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_QTY_UNIT
 * PROJ_DMND_RSCE_ASSGMT_DISTR_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_DISTR_PERD_AMT
 * PROJ_DMND_RSCE_DISTR_PERD_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_DISTR_PERD_AMT_CUR
 * PROJ_DMND_RSCE_DISTR_PERD_AMT_CUR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_DISTR_REVENUE_AMT
 * PROJ_DMND_RSCE_DISTR_REVENUE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_DISTR_REVENUE_AMT_CUR
 * PROJ_DMND_RSCE_DISTR_REVENUE_AMT_CUR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_STRT_DTE
 * PROJ_DMND_RSCE_ASSGMT_DISTR_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_ASSGMT_DISTR_END_DTE
 * PROJ_DMND_RSCE_ASSGMT_DISTR_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#PROJ_DMND_RSCE_DISTR_IS_NOT_SUPPLIED
 * PROJ_DMND_RSCE_DISTR_IS_NOT_SUPPLIED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#TO_ASSIGNMENT
 * TO_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr#TO_ROOT
 * TO_ROOT}</li>
 * </ul>
 *
 */
public interface ProjDmndRsceAssgmtDistrSelectable extends EntitySelectable<ProjDmndRsceAssgmtDistr>
{

}
