/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
 * ProjDmndRsceReqDistribution}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjDmndRsceReqDistributionField
 * ProjDmndRsceReqDistributionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjDmndRsceReqDistributionLink
 * ProjDmndRsceReqDistributionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_UUID
 * PROJ_DMND_RSCE_REQ_DISTR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RESOURCE_REQUEST_UUID
 * PROJ_DMND_RESOURCE_REQUEST_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_YEAR_VAL
 * PROJ_DMND_RSCE_REQ_DISTR_YEAR_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_PERD_VAL
 * PROJ_DMND_RSCE_REQ_DISTR_PERD_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_QUANTITY
 * PROJ_DMND_RSCE_REQ_DISTR_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_QTY_UNIT
 * PROJ_DMND_RSCE_REQ_DISTR_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT
 * PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT_CUR
 * PROJ_DMND_RSCE_REQ_DISTR_PERD_AMT_CUR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_REVENUE_AMT
 * PROJ_DMND_RSCE_REQ_DISTR_REVENUE_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_REVN_AMT_CUR
 * PROJ_DMND_RSCE_REQ_DISTR_REVN_AMT_CUR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_REFERENCED_PLAN_DATA_UUID
 * PROJ_DMND_REFERENCED_PLAN_DATA_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_START_DATE
 * PROJ_DMND_RSCE_REQ_DISTR_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#PROJ_DMND_RSCE_REQ_DISTR_END_DATE
 * PROJ_DMND_RSCE_REQ_DISTR_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#TO_ROOT
 * TO_ROOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution#TO_PROJ_DMND_RSCE_REQ
 * TO_PROJ_DMND_RSCE_REQ}</li>
 * </ul>
 *
 */
public interface ProjDmndRsceReqDistributionSelectable extends EntitySelectable<ProjDmndRsceReqDistribution>
{

}
