/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
 * ProjectDemandResourceRequest}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandResourceRequestField
 * ProjectDemandResourceRequestField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceRequestLink
 * ProjectDemandResourceRequestLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_RESOURCE_REQUEST_UUID
 * PROJ_DMND_RESOURCE_REQUEST_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJECT_DEMAND_WORK_UUID
 * PROJECT_DEMAND_WORK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJECT_DEMAND_REQUESTED_RESOURCE
 * PROJECT_DEMAND_REQUESTED_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_STFNG_INSTRUCTION_TEXT
 * PROJ_DMND_STFNG_INSTRUCTION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_RSCE_REQ_WORK_ASSGMT_OID
 * PROJ_DMND_RSCE_REQ_WORK_ASSGMT_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_RSCE_REQ_WRKFRC_PERSON_OID
 * PROJ_DMND_RSCE_REQ_WRKFRC_PERSON_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_RSCE_REQ_START_DATE
 * PROJ_DMND_RSCE_REQ_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#PROJ_DMND_RSCE_REQ_END_DATE
 * PROJ_DMND_RSCE_REQ_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#TO_WORK
 * TO_WORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#TO_PROJ_DMND_RSCE_REQ_DISTR
 * TO_PROJ_DMND_RSCE_REQ_DISTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest#TO_ROOT
 * TO_ROOT}</li>
 * </ul>
 *
 */
public interface ProjectDemandResourceRequestSelectable extends EntitySelectable<ProjectDemandResourceRequest>
{

}
