/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
 * ProjectDemandResource}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandResourceField
 * ProjectDemandResourceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandResourceLink
 * ProjectDemandResourceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJECT_DEMAND_WORK_UUID
 * PROJECT_DEMAND_WORK_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#ACTIVITY_TYPE
 * ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJ_DMND_ASSGMT_STATUS
 * PROJ_DMND_ASSGMT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJECT_ELEMENT_WORK_ITEM
 * PROJECT_ELEMENT_WORK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJ_DMND_BILLING_CONTROL_CATEGORY
 * PROJ_DMND_BILLING_CONTROL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#PROJ_DMND_REQUESTED_DELIVERY_ORG
 * PROJ_DMND_REQUESTED_DELIVERY_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#TO_ROOT
 * TO_ROOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#TO_RESOURCE_ASSIGNMENT
 * TO_RESOURCE_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource#TO_RESOURCE_REQUEST
 * TO_RESOURCE_REQUEST}</li>
 * </ul>
 *
 */
public interface ProjectDemandResourceSelectable extends EntitySelectable<ProjectDemandResource>
{

}
