/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService ProjectDemandService}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandServiceField
 * ProjectDemandServiceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandServiceLink
 * ProjectDemandServiceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PROJECT_DEMAND_SERVICE_UUID
 * PROJECT_DEMAND_SERVICE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PURCHASING_INFO_RECORD
 * PURCHASING_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#MATERIAL_PLANNED_DELIVERY_DURN
 * MATERIAL_PLANNED_DELIVERY_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#SCHED_LINE_STSC_DELIVERY_DATE
 * SCHED_LINE_STSC_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#IS_PUR_ORDER_ALLWD_FOR_INB_DELIV
 * IS_PUR_ORDER_ALLWD_FOR_INB_DELIV}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#GOODS_RECEIPT_AMOUNT
 * GOODS_RECEIPT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#INVOICE_RECEIPT_AMOUNT
 * INVOICE_RECEIPT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#OPEN_QUANTITY
 * OPEN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#ORDERED_QUANTITY
 * ORDERED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#SCHEDULE_LINE_DELIVERY_DATE
 * SCHEDULE_LINE_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#STILL_TO_BE_DELIVERED_QUANTITY
 * STILL_TO_BE_DELIVERED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#NET_VALUE_AMOUNT_IN_DOC_CURRENCY
 * NET_VALUE_AMOUNT_IN_DOC_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#TO_ROOT_TP
 * TO_ROOT_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService#TO_SERVICE_SUPPLY
 * TO_SERVICE_SUPPLY}</li>
 * </ul>
 *
 */
public interface ProjectDemandServiceSelectable extends EntitySelectable<ProjectDemandService>
{

}
